"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var validator = _joi["default"].object().keys({
  smtpHost: _joi["default"].string(),
  smtpPort: _joi["default"].string(),
  smtpPassword: _joi["default"].string(),
  smtpUsername: _joi["default"].string(),
  smtpFrom: _joi["default"].string(),
  smtpTo: _joi["default"].string(),
  mailSmtp: _joi["default"]["boolean"]()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, _req$body, smtpHost, smtpPort, smtpPassword, smtpUsername, smtpFrom, smtpTo, mailSmtp, smtpCredentials, pendingQueries;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          console.log("companyId", companyId);
          _req$body = req.body, smtpHost = _req$body.smtpHost, smtpPort = _req$body.smtpPort, smtpPassword = _req$body.smtpPassword, smtpUsername = _req$body.smtpUsername, smtpFrom = _req$body.smtpFrom, smtpTo = _req$body.smtpTo, mailSmtp = _req$body.mailSmtp;
          if (mailSmtp) {
            _context.next = 10;
            break;
          }
          _context.next = 7;
          return db.MetaData.findOneAndUpdate({
            name: "mailSmtp",
            companyId: companyId
          }, {
            value: false
          }, {
            upsert: true,
            "new": true,
            setDefaultsOnInsert: true
          });
        case 7:
          return _context.abrupt("return", res.status(200).send({
            Success: true,
            message: 'Smtp Configuration Updated Successfully!'
          }));
        case 10:
          smtpCredentials = {
            smtpHost: smtpHost,
            smtpPort: smtpPort,
            smtpPassword: smtpPassword,
            smtpUsername: smtpUsername,
            smtpFrom: smtpFrom,
            smtpTo: smtpTo,
            mailSmtp: mailSmtp
          };
          pendingQueries = [];
          Object.entries(smtpCredentials).forEach(function (_ref2) {
            var _ref3 = (0, _slicedToArray2["default"])(_ref2, 2),
              name = _ref3[0],
              value = _ref3[1];
            console.log({
              name: name,
              value: value
            });
            var metaData = db.MetaData.findOneAndUpdate({
              name: name,
              companyId: companyId
            }, {
              value: value
            }, {
              upsert: true,
              "new": true,
              setDefaultsOnInsert: true
            });
            pendingQueries.push(metaData);
          });
          _context.next = 15;
          return Promise.all(pendingQueries);
        case 15:
          return _context.abrupt("return", res.status(200).send({
            Success: true,
            message: 'Smtp Configuration Updated Successfully!'
          }));
        case 16:
          _context.next = 22;
          break;
        case 18:
          _context.prev = 18;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 22:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 18]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-CSTM"), (0, _permission.permission)('Settings', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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