"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _crypto = _interopRequireDefault(require("../../crypto"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  apikey: _joi["default"].string().required()
});

/**
 * @api {post} /api/v1/settings/virus-total virus-total
 * @apiName virus-total
 * @apiGroup Settings
 * @apiDescription Upload Virus Total key
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}   apikey        apiKey of virus total
 * 
 * @apiSuccess {Boolean} Success       true
 * @apiSuccess {String}  Message       Virus-total apikey updated successfully
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * {
 *           "Success": true,
 *           "Message": "Virus-total apikey updated successfully"
 * }
 * 
 * @apiError {Boolean} Success             false
 * @apiError {Array}   messages            "\"apikey\" is not allowed to be empty"
 * 
 * @apiSuccessExample Error-Response:
 *       HTTP/1.1 400 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *               "\"apikey\" is not allowed to be empty"
 *           ]
 *       }
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var apikey, companyId, metadata;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          apikey = req.body.apikey;
          companyId = req.user.companyId;
          _context.next = 5;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'virus-total'
          });
        case 5:
          metadata = _context.sent;
          if (!metadata) {
            _context.next = 17;
            break;
          }
          _context.t0 = db.MetaData;
          _context.t1 = {
            _id: metadata._id
          };
          _context.next = 11;
          return _crypto["default"].encrypt(apikey);
        case 11:
          _context.t2 = _context.sent;
          _context.t3 = {
            value: _context.t2
          };
          _context.next = 15;
          return _context.t0.updateOne.call(_context.t0, _context.t1, _context.t3);
        case 15:
          _context.next = 25;
          break;
        case 17:
          _context.t4 = db.MetaData;
          _context.t5 = companyId;
          _context.next = 21;
          return _crypto["default"].encrypt(apikey);
        case 21:
          _context.t6 = _context.sent;
          _context.t7 = {
            companyId: _context.t5,
            name: 'virus-total',
            value: _context.t6
          };
          _context.next = 25;
          return _context.t4.create.call(_context.t4, _context.t7);
        case 25:
          return _context.abrupt("return", res.status(200).send({
            Success: true,
            message: 'Virus-total apikey updated successfully'
          }));
        case 28:
          _context.prev = 28;
          _context.t8 = _context["catch"](0);
          console.log('error', _context.t8);
          next(_context.t8);
        case 32:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 28]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _permission.permission)('Settings', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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