"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _functions = require("../../functions");
var _auditLog = _interopRequireDefault(require("../../service/audit-log"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _validator = require("../../middlewares/validator");
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var templates;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          // const { name, headerContent, bodyContent, footerContent, bgColor, logo } = req.body;
          // const companyId = req.user.companyId;
          templates = [{
            name: 'Acknowledgment E-Mail',
            logo: 'Tpirlogo.png',
            bodyContent: '<p>Dear ${userName},</p><p><br>Thank You for reporting a suspicious email.</p><p>&nbsp;</p><p>The email was received at <strong>${date}</strong>.From: <strong>${from}</strong><br>Subject: <strong>${subject}</strong><br>&nbsp;</p><p><br>It has been forwaded to SOC Team for further review. Your actions are helping the organization to keep the network and our data safe!<br>&nbsp;</p><p><br>Thanks,<br>TPIR Team</p>',
            headerContent: '<h2><strong>Mail Reported Successfully!</strong></h2><p>The mail will be reviewed by the SOC team.</p>',
            footerContent: '<p>*If you did not make this request, there is no action required.</p><p>For any queries, please contact <a href="mailto:%20support@tpir.threatcop.com">support@tpir.threatcop.com</a></p>',
            bgColor: '#2c5596',
            companyId: null,
            description: 'This email is sent when a user reports a suspicious email.'
          }, {
            name: 'SOC Notification E-mail',
            logo: 'Tpirlogo.png',
            description: 'This email is sent to SOC when a user reports a suspicious email.',
            bodyContent: '<p>Hi ,<br>Kindly review a mail reported by an employee.</p><p>&nbsp;</p><p>The email was received at <strong>${date}.</strong><br>To: <strong>${to}</strong><br>From: <strong>${from}</strong><br>Subject: <strong>${subject}</strong></p><p><br><br>Please review the mail and take appropiate actions from dashboard. Please find attached header and body.</p><p><br><br>Thanks,<br>TPIR Team</p>',
            headerContent: '<h2><strong>Suspicious Mail Reported&nbsp;</strong></h2><p>An employee discovered a suspicious mail and reported it.</p>',
            footerContent: '<p>*If you did not make this request, there is no action required.</p><p>For any queries, please contact <a href="mailto:%20support@tpir.threatcop.com">support@tpir.threatcop.com</a></p>',
            bgColor: '#2c5596',
            companyId: null
          }, {
            name: 'Admin Action E-mail',
            logo: 'Tpirlogo.png',
            description: 'This email is sent when admin takes a action on email reported by user.',
            bodyContent: "<p>Dear ${name},&nbsp;</p><p>Thank you for promptly bringing the email to our attention. We have analyzed the mail and result can be found below-</p><p>&nbsp;</p><p>&nbsp;Result : <strong>${status}&nbsp;</strong></p><p>&nbsp;</p><p>${safeMessage}='The original email you reported can be found as an attachment in this email.</p><p>We thank you for your contributions in developing a cyber secure work environment.'</p><p>${spamMessage}='It could be an advertisement or uninteresting junk mail and it is recommended to ignore such mails. Necessary action is being taken SOC team to block the sender and no further action is required from your end.</p><p>We thank you for your contributions in developing a cyber secure work environment.'</p><p>${threatMessage}='Necessary preventive action is also being taken by SOC team to block the threat. The email is already deleted from your inbox and needs no further action from your end.</p><p>We thank you for your contributions in developing a cyber secure work environment.'</p><p><strong>Reported Mail Details :&nbsp;</strong></p><p>The email was received at <strong>${date}</strong>.&nbsp;</p><p>From: <strong>${from}</strong>&nbsp;</p><p>Subject: <strong>${subject}</strong>&nbsp;</p><p>&nbsp;</p><p>Thanks, TPIR Team</p>",
            headerContent: '<h2>Mail Report&nbsp;</h2><p>The mail has been reviewed by the SOC team.</p>',
            footerContent: '<p>*If you did not make this request, there is no action required.</p><p>For any queries, please contact <a href="mailto:%20support@tpir.threatcop.com">support@tpir.threatcop.com</a></p>',
            bgColor: '#2c5596',
            companyId: null
          }, {
            name: 'Result Notification Other Reporters E-mail',
            logo: 'Tpirlogo.png',
            description: 'This email is sent to other reporters when an admin takes an action on a reported mail.',
            bodyContent: '<p>Dear ${name},&nbsp;</p><p>A mail was reported by an employee, Our SOC Team promptly investigated the matter.&nbsp;</p><p>After careful assessment, the reported email was found to be <strong>${result}</strong> and has been <strong>${status}.</strong>&nbsp;</p><p>&nbsp;</p><p><strong>Reported Mail Details :&nbsp;</strong></p><p>Date: <strong>${date}</strong>.&nbsp;</p><p>From: <strong>${from}</strong>&nbsp;</p><p>Subject: <strong>${subject}</strong>&nbsp;</p><p>&nbsp;</p><p>Thanks, TPIR Team</p>',
            headerContent: '<h2>Suspicious Mail ${status}</h2><p>A suspicious mail was ${status} by SOC Team.</p>',
            footerContent: '<p>*If you did not make this request, there is no action required.</p><p>For any queries, please contact <a href="mailto:%20support@tpir.threatcop.com">support@tpir.threatcop.com</a></p>',
            bgColor: '#2c5596',
            companyId: null
          }];
          _context.next = 4;
          return db.Template.insertMany(templates);
        case 4:
          res.status(200).json({
            success: true,
            message: 'template added successfully'
          });
          _context.next = 11;
          break;
        case 7:
          _context.prev = 7;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 11:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 7]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, _strategy.checkCompanyValidityStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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