"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireWildcard(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _functions = require("../../functions");
var _auditLog = _interopRequireDefault(require("../../service/audit-log"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _validator = require("../../middlewares/validator");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var templateName, companyId, template, customTemplate, defaultTemplate;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          templateName = req.query.templateName;
          companyId = req.user.companyId;
          template = '';
          _context.next = 6;
          return db.Template.findOne({
            name: templateName,
            companyId: companyId
          });
        case 6:
          customTemplate = _context.sent;
          if (!customTemplate) {
            _context.next = 11;
            break;
          }
          template = customTemplate;
          _context.next = 17;
          break;
        case 11:
          _context.next = 13;
          return db.Template.findOne({
            name: templateName,
            companyId: null
          });
        case 13:
          defaultTemplate = _context.sent;
          if (defaultTemplate) {
            _context.next = 16;
            break;
          }
          throw new RequestError('Default Template Not Found!');
        case 16:
          template = defaultTemplate;
        case 17:
          res.status(200).json({
            success: true,
            template: template
          });
          _context.next = 24;
          break;
        case 20:
          _context.prev = 20;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 24:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 20]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, (0, _featureBlocker["default"])('TPIR-CET'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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