"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireWildcard(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _path = _interopRequireDefault(require("path"));
var _multer = _interopRequireDefault(require("multer"));
var _fs = _interopRequireDefault(require("fs"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _validator = require("../../middlewares/validator");
var _file = require("googleapis/build/src/apis/file");
var _scanAndUploadFile = require("../../middlewares/scanAndUploadFile");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
var FileType = require('file-type');
var sharp = require('sharp');
var templateLogoPath = _path["default"].join(_path["default"].dirname(require.main.filename), 'public', 'templateLogo');
var ALLOWED_MIME_TYPES = ['image/png', 'image/jpeg'];
var ALLOWED_EXTENSIONS = ['.png', '.jpg', '.jpeg'];
var storage = _multer["default"].diskStorage({
  destination: function destination(req, file, cb) {
    cb(null, templateLogoPath);
  },
  filename: function filename(req, file, cb) {
    var templateName = req.body.templateName.replace(/\s/g, '');
    var ts = Date.now();
    var fileName = "".concat(req.user.companyId, "_").concat(templateName, "_").concat(ts).concat(_path["default"].extname(file.originalname)).trim();
    cb(null, fileName);
  }
});
var fileFilter = function fileFilter(req, file, cb) {
  if (ALLOWED_MIME_TYPES.includes(file.mimetype)) {
    cb(null, true);
  } else {
    cb(new RequestError('Only PNG or JPG image files are allowed'), false);
  }
};
var uploadAttachment = (0, _multer["default"])({
  storage: storage,
  limits: {
    fileSize: 10485760
  },
  fileFilter: fileFilter
});
var validateRealFileType = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(filePath) {
    var fileType;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.next = 2;
          return FileType.fromFile(filePath);
        case 2:
          fileType = _context.sent;
          if (!(!fileType || !ALLOWED_MIME_TYPES.includes(fileType.mime))) {
            _context.next = 5;
            break;
          }
          throw new RequestError('Uploaded file is not a valid PNG or JPG image');
        case 5:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return function validateRealFileType(_x) {
    return _ref.apply(this, arguments);
  };
}();
var controller = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(req, res, next) {
    var _req$body, templateName, _req$body$headerConte, headerContent, _req$body$bodyContent, bodyContent, _req$body$footerConte, footerContent, _req$body$bgColor, bgColor, _req$body$setDefault, setDefault, companyId, logo, ext, buffer, defaultTemplate, template, filePath, customTemplate;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _req$body = req.body, templateName = _req$body.templateName, _req$body$headerConte = _req$body.headerContent, headerContent = _req$body$headerConte === void 0 ? '' : _req$body$headerConte, _req$body$bodyContent = _req$body.bodyContent, bodyContent = _req$body$bodyContent === void 0 ? '' : _req$body$bodyContent, _req$body$footerConte = _req$body.footerContent, footerContent = _req$body$footerConte === void 0 ? '' : _req$body$footerConte, _req$body$bgColor = _req$body.bgColor, bgColor = _req$body$bgColor === void 0 ? '' : _req$body$bgColor, _req$body$setDefault = _req$body.setDefault, setDefault = _req$body$setDefault === void 0 ? false : _req$body$setDefault;
          companyId = req.user.companyId;
          logo = req.file ? req.file.filename : null;
          if (!req.file) {
            _context2.next = 15;
            break;
          }
          ext = _path["default"].extname(req.file.originalname).toLowerCase();
          if (ALLOWED_EXTENSIONS.includes(ext)) {
            _context2.next = 8;
            break;
          }
          throw new RequestError('Only PNG or JPG file extensions allowed');
        case 8:
          _context2.next = 10;
          return validateRealFileType(req.file.path);
        case 10:
          _context2.next = 12;
          return sharp(req.file.path).rotate().toFormat(ext === '.png' ? 'png' : 'jpeg').toBuffer();
        case 12:
          buffer = _context2.sent;
          _context2.next = 15;
          return _fs["default"].promises.writeFile(req.file.path, buffer);
        case 15:
          _context2.next = 17;
          return db.Template.findOne({
            name: templateName
          });
        case 17:
          defaultTemplate = _context2.sent;
          if (defaultTemplate) {
            _context2.next = 20;
            break;
          }
          throw new RequestError('Default Template Not Found!');
        case 20:
          if (!(setDefault == 'true')) {
            _context2.next = 40;
            break;
          }
          _context2.next = 23;
          return db.Template.findOne({
            name: templateName,
            companyId: companyId
          });
        case 23:
          template = _context2.sent;
          if (!(template && template.logo !== 'Tpirlogo.png' && template.logo !== null && template.logo !== 'null')) {
            _context2.next = 29;
            break;
          }
          filePath = _path["default"].join(appRoot, 'public', 'templateLogo', template.logo);
          _fs["default"].unlink(filePath, function (err) {
            if (err) {
              console.error('Error deleting the Logo:', err);
            } else {
              console.log('Logo deleted successfully.');
            }
          });
          _context2.next = 37;
          break;
        case 29:
          if (!(template && (template.logo == null || template.logo == 'null'))) {
            _context2.next = 35;
            break;
          }
          _context2.next = 32;
          return db.Template.deleteOne({
            name: templateName,
            companyId: companyId
          });
        case 32:
          return _context2.abrupt("return", res.status(200).json({
            success: true,
            message: 'Default Template Set Successfully!'
          }));
        case 35:
          if (template) {
            _context2.next = 37;
            break;
          }
          return _context2.abrupt("return", res.status(200).json({
            success: true,
            message: 'Default template already set!'
          }));
        case 37:
          _context2.next = 39;
          return db.Template.deleteOne({
            name: templateName,
            companyId: companyId
          });
        case 39:
          return _context2.abrupt("return", res.status(200).json({
            success: true,
            message: 'Default Template Set Successfully!'
          }));
        case 40:
          _context2.next = 42;
          return db.Template.findOne({
            name: templateName,
            companyId: companyId
          });
        case 42:
          customTemplate = _context2.sent;
          if (!customTemplate) {
            _context2.next = 54;
            break;
          }
          customTemplate.name = templateName;
          customTemplate.headerContent = headerContent;
          customTemplate.bodyContent = bodyContent;
          customTemplate.footerContent = footerContent;
          customTemplate.bgColor = bgColor;
          customTemplate.logo = logo != null ? logo : req.body.logo == null || req.body.logo == 'null' ? null : req.body.logo;
          _context2.next = 52;
          return customTemplate.save();
        case 52:
          _context2.next = 56;
          break;
        case 54:
          _context2.next = 56;
          return db.Template.create({
            name: templateName,
            description: defaultTemplate.description,
            headerContent: headerContent,
            bodyContent: bodyContent,
            footerContent: footerContent,
            bgColor: bgColor,
            companyId: companyId,
            logo: logo != null ? logo : defaultTemplate.logo
          });
        case 56:
          res.status(200).json({
            success: true,
            message: 'Template Updated Successfully!'
          });
          _context2.next = 63;
          break;
        case 59:
          _context2.prev = 59;
          _context2.t0 = _context2["catch"](0);
          console.log(_context2.t0);
          next(_context2.t0);
        case 63:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 59]]);
  }));
  return function controller(_x2, _x3, _x4) {
    return _ref2.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(_strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-CET"), _strategy.checkCompanyValidityStrategy, uploadAttachment.single('logo'), _scanAndUploadFile.scanFile, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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