"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _validator = require("../../middlewares/validator");
var _processGroups = _interopRequireDefault(require("../../service/process-groups"));
var validator = _joi["default"].object().keys({
  domainId: _joi["default"].string().hex().length(24).required(),
  groupName: _joi["default"].string().optional()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, domainId, _req$body$groupName, groupName, companyId, domain, groups;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, domainId = _req$body.domainId, _req$body$groupName = _req$body.groupName, groupName = _req$body$groupName === void 0 ? null : _req$body$groupName;
          companyId = req.user.companyId;
          _context.next = 5;
          return db.Domain.findOne({
            _id: domainId,
            companyId: companyId,
            deletedAt: null
          });
        case 5:
          domain = _context.sent;
          if (domain) {
            _context.next = 8;
            break;
          }
          throw new RequestError('Domain Not Found!');
        case 8:
          if (!(domain && !domain.isVerified)) {
            _context.next = 10;
            break;
          }
          throw new RequestError('Domain is not verified', 400);
        case 10:
          if (!(domain && domain.isVerified && !domain.isCredential)) {
            _context.next = 12;
            break;
          }
          throw new RequestError('Credentials are not uploaded', 400);
        case 12:
          _context.next = 14;
          return _processGroups["default"].process(companyId, domainId, domain.domainType, groupName);
        case 14:
          groups = _context.sent;
          res.status(200).json({
            success: true,
            groups: groups
          });
          _context.next = 22;
          break;
        case 18:
          _context.prev = 18;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 22:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 18]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(_strategy.jwtStrategy, (0, _permission.permission)('Domain', 'Read'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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