"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var validator = _joi["default"].object().keys({
  action: _joi["default"].string().required(),
  selectedUsers: _joi["default"].array().required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _$set, _req$body, action, selectedUsers, companyId, activeUsers, userLimit, usersThatCanbeActivatedCount, usersActivationArray;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, action = _req$body.action, selectedUsers = _req$body.selectedUsers;
          companyId = req.user.companyId;
          if (!(action == 'activate')) {
            _context.next = 18;
            break;
          }
          _context.next = 6;
          return db.User.countDocuments({
            deletedAt: null,
            isActive: true,
            companyId: companyId
          });
        case 6:
          activeUsers = _context.sent;
          _context.next = 9;
          return db.MetaData.findOne({
            name: "userLimit",
            companyId: companyId
          });
        case 9:
          userLimit = _context.sent;
          if (+userLimit.value > activeUsers) {
            _context.next = 12;
            break;
          }
          throw new RequestError("User Limit Exceeded! Only ".concat(+userLimit.value, " user(s) can be activated as per your license!"), 403);
        case 12:
          usersThatCanbeActivatedCount = +userLimit.value - activeUsers;
          console.log({
            usersThatCanbeActivatedCount: usersThatCanbeActivatedCount
          });
          if (!(usersThatCanbeActivatedCount > 0)) {
            _context.next = 18;
            break;
          }
          usersActivationArray = selectedUsers.slice(0, usersThatCanbeActivatedCount);
          _context.next = 18;
          return db.User.updateMany({
            _id: {
              $in: usersActivationArray
            }
          }, {
            $set: {
              isActive: true
            }
          });
        case 18:
          if (!(action == 'deactivate')) {
            _context.next = 21;
            break;
          }
          _context.next = 21;
          return db.User.updateMany({
            _id: {
              $in: selectedUsers
            }
          }, {
            $set: {
              isActive: false
            }
          });
        case 21:
          if (!(action == 'delete')) {
            _context.next = 24;
            break;
          }
          _context.next = 24;
          return db.User.updateMany({
            _id: {
              $in: selectedUsers
            }
          }, {
            $set: (_$set = {
              isActive: false,
              companyId: null,
              domainId: null,
              groupId: null,
              groupName: null,
              subDomainGroupId: null
            }, (0, _defineProperty2["default"])(_$set, "isActive", false), (0, _defineProperty2["default"])(_$set, "deletedAt", new Date()), _$set)
          });
        case 24:
          return _context.abrupt("return", res.status(200).send({
            Success: true
          }));
        case 27:
          _context.prev = 27;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 31:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 27]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(_strategy.jwtStrategy, (0, _permission.permission)('Users', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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