"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _permission = require("../../middlewares/permission");
var _processUser = _interopRequireDefault(require("../../service/process-user"));
var _credentials = _interopRequireDefault(require("../../service/credentials"));
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _updateSyncingStatusGroups = require("../../service/update-syncing-status-groups");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var validator = _joi["default"].object().keys({
  domainId: _joi["default"].string().hex().length(24).required(),
  groups: _joi["default"].array().allow(null)
});

/**
 * @api {get} /api/v1/users/sync-user?domainId=63b676c744ed3b8a723865971 sync-user
 * @apiName sync-user
 * @apiGroup users
 * @apiDescription Syncing Of domain's users
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery   {String}   domainId      id of the domain whose users has to be synced
 * 
 * @apiSuccess {Boolean} success             true
 * @apiSuccess {Array}   messages            "syncing start successfully"
 * 
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *      {
 *          "success": true,
 *          "message": "syncing start successfully"
 *      }
 * 
 * @apiError (400) {Boolean} success-1             false
 * @apiError (400) {Array}   messages-1            "invalid domain recieved"
 * 
 * @apiErrorExample Error-Response:
 *       HTTP/1.1 400 Not Found
 *    {
 *      "success":   false,
 *      "messages" : "invalid domain recieved"
 *    }
 * 
 * @apiError (400) {Boolean} success-2             false
 * @apiError (400) {Array}   messages-2            "Domain Credentials not uploaded properly please upload and try again.""
 * 
 * @apiErrorExample Error-Response:
 *       HTTP/1.1 400 Not Found
 *      {
 *      "success":   false,
 *      "messages" : "Domain Credentials not uploaded properly please upload and try again."
 *      }
 * 
 * @apiError (400) {Boolean} success             false
 * @apiError (400) {Array}   messages            "Domain type not define"
 * 
 * @apiErrorExample Error-Response:
 *       HTTP/1.1 400 Not Found
 *      {
 *      "success":   false,
 *      "messages" : "Domain type not define"
 *      }
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(req, res, next) {
    var _req$body, domainId, groups, companyId, isTacEnabled, domain, creds, isExchange, i, _groupName, group, _subDomainGroups, isAnyGroupInSyncingState, subDomainGroups, p, _p, results, _group;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _req$body = req.body, domainId = _req$body.domainId, groups = _req$body.groups;
          console.log("-------groups-------", groups);
          companyId = req.user.companyId;
          _context2.prev = 3;
          _context2.next = 6;
          return db.Company.findOne({
            _id: companyId
          }).isTacEnabled;
        case 6:
          isTacEnabled = _context2.sent;
          if (!isTacEnabled) {
            _context2.next = 9;
            break;
          }
          throw new RequestError("The users can be synced via TA!");
        case 9:
          _context2.next = 11;
          return db.Domain.findOne({
            _id: domainId,
            companyId: companyId,
            deletedAt: null
          });
        case 11:
          domain = _context2.sent;
          if (domain) {
            _context2.next = 14;
            break;
          }
          throw new RequestError("Domain does not exist!");
        case 14:
          if (!(domain && domain.isCredential)) {
            _context2.next = 18;
            break;
          }
          _context2.next = 17;
          return _credentials["default"].getCredentials(companyId, domainId);
        case 17:
          creds = _context2.sent;
        case 18:
          isExchange = domain.domainTypeForOutlook === 'EXCHANGE';
          if (!groups) {
            _context2.next = 32;
            break;
          }
          i = 0;
        case 21:
          if (!(i < groups.length)) {
            _context2.next = 32;
            break;
          }
          _groupName = isExchange ? "".concat(groups[i].label, "-Exchange") : groups[i].label;
          _context2.next = 25;
          return db.Group.findOne({
            groupName: _groupName,
            groupId: groups[i].value,
            companyId: companyId,
            domainId: domainId,
            deletedAt: null
          });
        case 25:
          group = _context2.sent;
          if (group) {
            _context2.next = 29;
            break;
          }
          _context2.next = 29;
          return db.Group.create(_objectSpread(_objectSpread({}, groups[i]), {}, {
            companyId: companyId,
            domainId: domainId,
            groupName: _groupName,
            type: "Admin",
            groupId: groups[i].value
          }));
        case 29:
          i++;
          _context2.next = 21;
          break;
        case 32:
          if (domain) {
            _context2.next = 34;
            break;
          }
          throw new RequestError('invalid domain recieved');
        case 34:
          if (!(domain.domainType == 'Gsuite' || domain.domainType == 'Outlook')) {
            _context2.next = 72;
            break;
          }
          if (!domain.isCredential) {
            _context2.next = 69;
            break;
          }
          _context2.next = 38;
          return db.Domain.updateOne({
            _id: domainId
          }, {
            isSyncingUser: true,
            syncStartAt: new Date()
          });
        case 38:
          _context2.next = 40;
          return db.Group.find({
            isSyncingUsers: true,
            companyId: companyId,
            deletedAt: null
          });
        case 40:
          isAnyGroupInSyncingState = _context2.sent;
          if (!isAnyGroupInSyncingState.length) {
            _context2.next = 43;
            break;
          }
          throw new RequestError("Syncing already in progress kindly wait until syncing is complete!");
        case 43:
          _context2.next = 45;
          return db.SubDomainGroup.find({
            domainId: domain._id,
            companyId: companyId
          }, {
            _id: 1,
            groupName: 1
          });
        case 45:
          subDomainGroups = _context2.sent;
          subDomainGroups = (_subDomainGroups = subDomainGroups) === null || _subDomainGroups === void 0 ? void 0 : _subDomainGroups.map(function (group) {
            return group.groupName;
          });
          _context2.next = 49;
          return db.Group.updateOne({
            groupName: "all-users-tpir",
            isDefaultGroup: true,
            companyId: companyId,
            deletedAt: null
          }, {
            $set: {
              isSyncingUsers: true
            }
          });
        case 49:
          if (!(groups && groups.length > 0)) {
            _context2.next = 56;
            break;
          }
          _p = groups.map( /*#__PURE__*/function () {
            var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(group) {
              var _groupName2, grp;
              return _regenerator["default"].wrap(function _callee$(_context) {
                while (1) switch (_context.prev = _context.next) {
                  case 0:
                    _context.prev = 0;
                    _groupName2 = isExchange ? "".concat(group.label, "-Exchange") : group.label;
                    _context.next = 4;
                    return db.Group.findOne({
                      groupName: _groupName2,
                      groupId: group.value,
                      companyId: companyId,
                      deletedAt: null
                    });
                  case 4:
                    grp = _context.sent;
                    if (grp) {
                      _context.next = 7;
                      break;
                    }
                    throw new Error("Group not found: ".concat(_groupName2));
                  case 7:
                    _context.next = 9;
                    return db.Group.updateOne({
                      _id: grp._id
                    }, {
                      $set: {
                        isSyncingUsers: true
                      }
                    });
                  case 9:
                    _context.next = 11;
                    return _processUser["default"].process(companyId, domainId, domain.domainName, subDomainGroups, domain.domainType, false, domain.domainTypeForOutlook === 'EXCHANGE', grp, creds, false,
                    // isMirrorSync
                    null,
                    // allUsersGroupId
                    new Date(),
                    // syncTs
                    0 // pageIndex
                    );
                  case 11:
                    return _context.abrupt("return", {
                      status: 'fulfilled',
                      groupId: grp._id
                    });
                  case 14:
                    _context.prev = 14;
                    _context.t0 = _context["catch"](0);
                    console.error("Error processing group ".concat(groupName, ":"), _context.t0);
                    _context.next = 19;
                    return db.Group.updateMany({
                      companyId: companyId,
                      isSyncingUsers: true
                    }, {
                      $set: {
                        isSyncingUsers: false
                      }
                    });
                  case 19:
                    _context.next = 21;
                    return db.Group.updateOne({
                      groupId: group.value,
                      companyId: companyId
                    }, {
                      $set: {
                        isSyncingUsers: false
                      }
                    });
                  case 21:
                    throw _context.t0;
                  case 22:
                  case "end":
                    return _context.stop();
                }
              }, _callee, null, [[0, 14]]);
            }));
            return function (_x4) {
              return _ref2.apply(this, arguments);
            };
          }());
          _context2.next = 53;
          return Promise.allSettled(_p);
        case 53:
          results = _context2.sent;
          _context2.next = 67;
          break;
        case 56:
          _context2.next = 58;
          return db.Group.findOne({
            groupName: "all-users-tpir",
            companyId: companyId,
            isDefaultGroup: true
          });
        case 58:
          _group = _context2.sent;
          if (!_group) {
            _context2.next = 66;
            break;
          }
          _context2.next = 62;
          return _processUser["default"].process(companyId, domainId, domain.domainName, subDomainGroups, domain.domainType, false, domain.domainTypeForOutlook === 'EXCHANGE', _group, creds, false,
          // isMirrorSync
          null,
          // allUsersGroupId
          new Date(),
          // syncTs
          0 // pageIndex
          );
        case 62:
          _context2.next = 64;
          return db.Domain.updateOne({
            _id: domainId
          }, {
            lastAllUsersSyncAt: new Date()
          });
        case 64:
          _context2.next = 67;
          break;
        case 66:
          console.warn("⚠️ Default group not found for company:", companyId);
        case 67:
          _context2.next = 70;
          break;
        case 69:
          throw new RequestError('Domain Credentials not uploaded properly please upload and try again.');
        case 70:
          _context2.next = 73;
          break;
        case 72:
          throw new RequestError('Domain type not define');
        case 73:
          return _context2.abrupt("return", res.status(200).send({
            Success: true,
            message: 'syncing start successfully'
          }));
        case 76:
          _context2.prev = 76;
          _context2.t0 = _context2["catch"](3);
          _context2.next = 80;
          return db.Group.updateMany({
            companyId: companyId,
            isSyncingUsers: true
          }, {
            $set: {
              isSyncingUsers: false
            }
          });
        case 80:
          _context2.next = 82;
          return db.Domain.updateOne({
            _id: domainId
          }, {
            isSyncingUser: false,
            syncStartAt: new Date()
          });
        case 82:
          next(_context2.t0);
        case 83:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[3, 76]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, _strategy.checkTaConnectionStrategy, _strategy.checkCompanyValidityStrategy, _strategy.checkLicenseStrategy, (0, _permission.permission)('Users', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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