"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _multer = _interopRequireDefault(require("multer"));
var _csvParser = _interopRequireDefault(require("csv-parser"));
var _express = _interopRequireDefault(require("express"));
var _kue = require("../../kue");
var _scanAndUploadFile = require("../../middlewares/scanAndUploadFile");
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var csvPathDir = _path["default"].join(_path["default"].dirname(require.main.filename), "Content", "csv");
var storage = _multer["default"].diskStorage({
  destination: function destination(req, file, cb) {
    cb(null, csvPathDir);
  },
  filename: function filename(req, file, cb) {
    cb(null, file.originalname);
  }
});
function determineDomainType(domain) {
  if (domain.domainType === "Outlook") {
    return domain.domainTypeForOutlook === "EXCHANGE" ? "Exchange" : "Outlook";
  }
  return domain.domainType === "Gsuite" ? "Gsuite" : "";
}
var upload = (0, _multer["default"])({
  storage: storage
});
var BATCH_SIZE = 1000; // Define your batch size here

// Function to validate a CSV row
function checkForValidRow(row) {
  return row && row.email && row.email.includes("@") && row.name && /^[a-zA-Z ]+$/.test(row.name);
}

// Function to create batches of users
function createBatches(users) {
  var batches = [];
  for (var i = 0; i < users.length; i += BATCH_SIZE) {
    batches.push(users.slice(i, i + BATCH_SIZE));
  }
  return batches;
}

// Process rows to create jobs for deactivation and activation
var processRows = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(rows, domainType, domain, companyId, groupId) {
    var addUsers, groups, _iterator, _step, row, addUsersBatches, addUsersBatchesLength, isAnyUserUploadedInCurrentGroup;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          addUsers = [];
          _context.next = 3;
          return db.SubDomainGroup.find({
            domainId: domain._id
          });
        case 3:
          groups = _context.sent;
          groups = groups.map(function (group) {
            return group.groupName;
          });
          _iterator = _createForOfIteratorHelper(rows);
          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              row = _step.value;
              if (row.email.match(/@(.+)$/)[1].trim().toLowerCase() === domain.domainName || row.email.match(/([^@]+)@(?:[^.]+\.)?(.+\..+)/)[2].trim().toLowerCase() === domain.domainName || groups.includes(row.email.split("@")[1].toLowerCase())) {
                addUsers.push(row);
              }
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
          ;
          addUsersBatches = createBatches(addUsers);
          addUsersBatchesLength = addUsersBatches.length;
          if (!addUsersBatches.length) {
            _context.next = 18;
            break;
          }
          _context.next = 13;
          return db.Group.updateOne({
            _id: groupId,
            companyId: companyId,
            deletedAt: null
          }, {
            $set: {
              isSyncingUsers: true
            }
          });
        case 13:
          _context.next = 15;
          return db.Group.updateOne({
            groupName: "all-users-tpir",
            isDefaultGroup: true,
            companyId: companyId,
            deletedAt: null
          }, {
            $set: {
              isSyncingUsers: true
            }
          });
        case 15:
          addUsersBatches.forEach(function (batch) {
            addUsersBatchesLength--;
            _kue.queue.create('sync-users-csv', {
              users: batch,
              domain: domain,
              domainType: domainType,
              companyId: companyId,
              groupId: groupId,
              isLast: addUsersBatchesLength == 0 ? true : false
            }).removeOnComplete(true).priority('high').save();
          });
          _context.next = 24;
          break;
        case 18:
          _context.next = 20;
          return db.User.countDocuments({
            companyId: companyId,
            groups: {
              $in: [groupId]
            }
          });
        case 20:
          isAnyUserUploadedInCurrentGroup = _context.sent;
          if (isAnyUserUploadedInCurrentGroup) {
            _context.next = 24;
            break;
          }
          _context.next = 24;
          return db.Group.deleteOne({
            _id: groupId,
            isDefaultGroup: false,
            companyId: companyId
          });
        case 24:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return function processRows(_x, _x2, _x3, _x4, _x5) {
    return _ref.apply(this, arguments);
  };
}();

// Controller function to handle CSV upload and processing
var controller = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee6(req, res, next) {
    var _req$body, domainId, groupId, companyId, domain, group, isAnyGroupInSyncingState, countOfUsersInGroup, domainType, file, csvReadStream, rows, userLimit, userLimitMessenger, addedUsersCount, remainingLimit, usersCountInCsv, showExceededUsersInCsvThanRemaningLimitError, showAccessError;
    return _regenerator["default"].wrap(function _callee6$(_context6) {
      while (1) switch (_context6.prev = _context6.next) {
        case 0:
          _req$body = req.body, domainId = _req$body.domainId, groupId = _req$body.groupId;
          companyId = req.user.companyId;
          _context6.prev = 2;
          _context6.next = 5;
          return db.Domain.findOne({
            _id: domainId,
            companyId: companyId,
            deletedAt: null
          });
        case 5:
          domain = _context6.sent;
          if (domain) {
            _context6.next = 8;
            break;
          }
          throw new Error("Domain does not exist!");
        case 8:
          _context6.next = 10;
          return db.Group.findOne({
            _id: groupId,
            companyId: companyId,
            deletedAt: null
          });
        case 10:
          group = _context6.sent;
          if (group) {
            _context6.next = 13;
            break;
          }
          throw new Error("Group does not exist!");
        case 13:
          _context6.next = 15;
          return db.Group.find({
            isSyncingUsers: true,
            companyId: companyId,
            deletedAt: null
          });
        case 15:
          isAnyGroupInSyncingState = _context6.sent;
          if (!isAnyGroupInSyncingState.length) {
            _context6.next = 18;
            break;
          }
          throw new RequestError("Syncing already in progress kindly wait until syncing is complete!");
        case 18:
          _context6.next = 20;
          return db.User.countDocuments({
            companyId: companyId,
            groups: {
              $in: [groupId]
            },
            deletedAt: null
          });
        case 20:
          countOfUsersInGroup = _context6.sent;
          domainType = determineDomainType(domain);
          file = req.file;
          csvReadStream = _fs["default"].createReadStream(file.path);
          rows = [];
          _context6.next = 27;
          return db.MetaData.findOne({
            companyId: companyId,
            name: "userLimit"
          });
        case 27:
          userLimit = _context6.sent.value;
          _context6.next = 30;
          return db.MetaData.findOne({
            companyId: companyId,
            name: "userLimitMessenger"
          });
        case 30:
          userLimitMessenger = _context6.sent.value;
          _context6.next = 33;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null
          });
        case 33:
          addedUsersCount = _context6.sent;
          remainingLimit = Math.max(0, parseInt(userLimit) + parseInt(userLimitMessenger) - addedUsersCount);
          usersCountInCsv = 0;
          console.log({
            addedUsersCount: addedUsersCount,
            remainingLimit: remainingLimit
          });
          showExceededUsersInCsvThanRemaningLimitError = false;
          showAccessError = {
            email: false,
            messenger: false
          };
          csvReadStream.pipe((0, _csvParser["default"])()).on("headers", /*#__PURE__*/function () {
            var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(headers) {
              var requiredHeaders, extraHeaders, missingHeaders;
              return _regenerator["default"].wrap(function _callee2$(_context2) {
                while (1) switch (_context2.prev = _context2.next) {
                  case 0:
                    requiredHeaders = ["name", "email", "phoneNumber"];
                    extraHeaders = headers.filter(function (header) {
                      return !requiredHeaders.includes(header);
                    });
                    missingHeaders = requiredHeaders.filter(function (header) {
                      return !headers.includes(header);
                    });
                    if (missingHeaders.length > 0) {
                      csvReadStream.destroy();
                      next(new RequestError("Missing required columns: ".concat(missingHeaders.join(", "))));
                    }
                    if (!(extraHeaders.length > 0)) {
                      _context2.next = 10;
                      break;
                    }
                    csvReadStream.destroy();
                    if (countOfUsersInGroup) {
                      _context2.next = 9;
                      break;
                    }
                    _context2.next = 9;
                    return db.Group.deleteOne({
                      _id: groupId,
                      companyId: companyId,
                      isDefaultGroup: false
                    });
                  case 9:
                    next(new RequestError("Unexpected columns found: ".concat(extraHeaders.join(", "), ". Only \"name\", \"email\", and \"phoneNumber\" are allowed.")));
                  case 10:
                  case "end":
                    return _context2.stop();
                }
              }, _callee2);
            }));
            return function (_x9) {
              return _ref3.apply(this, arguments);
            };
          }()).on("data", /*#__PURE__*/function () {
            var _ref4 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(row) {
              return _regenerator["default"].wrap(function _callee3$(_context3) {
                while (1) switch (_context3.prev = _context3.next) {
                  case 0:
                    console.log({
                      usersCountInCsv: usersCountInCsv,
                      remainingLimit: remainingLimit,
                      row: row
                    });
                    usersCountInCsv++;
                    if (usersCountInCsv > remainingLimit) {
                      // csvReadStream.destroy();  // Stop reading the file
                      // next(new RequestError("The number of users in the CSV exceeds your maximum user license limit. Please remove some users from your CSV or upgrade your license.",429));
                      showExceededUsersInCsvThanRemaningLimitError = true;
                    }
                    if (checkForValidRow(row)) {
                      rows.push({
                        name: row.name,
                        email: row.email.trim().toLowerCase(),
                        phoneNumber: row.phoneNumber
                      });
                    }
                  case 4:
                  case "end":
                    return _context3.stop();
                }
              }, _callee3);
            }));
            return function (_x10) {
              return _ref4.apply(this, arguments);
            };
          }()).on("end", /*#__PURE__*/(0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee5() {
            var allUsersGroup, checkAccessLimit;
            return _regenerator["default"].wrap(function _callee5$(_context5) {
              while (1) switch (_context5.prev = _context5.next) {
                case 0:
                  _context5.prev = 0;
                  _fs["default"].unlink(file.path, function (err) {
                    if (err) console.error("Error deleting the uploaded CSV file:", err);
                  });
                  _context5.next = 4;
                  return db.Group.findOne({
                    groupName: "all-users-tpir",
                    isDefaultGroup: true,
                    companyId: companyId,
                    deletedAt: null
                  });
                case 4:
                  allUsersGroup = _context5.sent;
                  _context5.next = 7;
                  return processRows(rows, domainType, domain, companyId, groupId);
                case 7:
                  checkAccessLimit = /*#__PURE__*/function () {
                    var _ref6 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(group, accessType, limit, errorKey) {
                      var userCount;
                      return _regenerator["default"].wrap(function _callee4$(_context4) {
                        while (1) switch (_context4.prev = _context4.next) {
                          case 0:
                            if (!group[accessType]) {
                              _context4.next = 5;
                              break;
                            }
                            _context4.next = 3;
                            return db.User.countDocuments({
                              companyId: companyId,
                              deletedAt: null,
                              groups: {
                                $in: [group._id]
                              }
                            });
                          case 3:
                            userCount = _context4.sent;
                            if (userCount >= limit) showAccessError[errorKey] = true;
                          case 5:
                          case "end":
                            return _context4.stop();
                        }
                      }, _callee4);
                    }));
                    return function checkAccessLimit(_x11, _x12, _x13, _x14) {
                      return _ref6.apply(this, arguments);
                    };
                  }();
                  _context5.next = 10;
                  return Promise.all([checkAccessLimit(group, "emailAccess", userLimit, "email"), checkAccessLimit(group, "messengerAccess", userLimitMessenger, "messenger"), checkAccessLimit(allUsersGroup, "emailAccess", userLimit, "email"), checkAccessLimit(allUsersGroup, "messengerAccess", userLimitMessenger, "messenger")]);
                case 10:
                  res.status(200).json({
                    message: "CSV file successfully processed.",
                    showExceededUsersInCsvThanRemaningLimitError: showExceededUsersInCsvThanRemaningLimitError,
                    showAccessError: showAccessError
                  });
                  _context5.next = 19;
                  break;
                case 13:
                  _context5.prev = 13;
                  _context5.t0 = _context5["catch"](0);
                  if (countOfUsersInGroup) {
                    _context5.next = 18;
                    break;
                  }
                  _context5.next = 18;
                  return db.Group.deleteOne({
                    _id: groupId,
                    companyId: companyId,
                    isDefaultGroup: false
                  });
                case 18:
                  next(new RequestError(_context5.t0));
                case 19:
                case "end":
                  return _context5.stop();
              }
            }, _callee5, null, [[0, 13]]);
          })));
          _context6.next = 49;
          break;
        case 42:
          _context6.prev = 42;
          _context6.t0 = _context6["catch"](2);
          console.error(_context6.t0);
          if (countOfUsersInGroup) {
            _context6.next = 48;
            break;
          }
          _context6.next = 48;
          return db.Group.deleteOne({
            _id: groupId,
            companyId: companyId,
            isDefaultGroup: false
          });
        case 48:
          next(new RequestError(_context6.t0));
        case 49:
        case "end":
          return _context6.stop();
      }
    }, _callee6, null, [[2, 42]]);
  }));
  return function controller(_x6, _x7, _x8) {
    return _ref2.apply(this, arguments);
  };
}();

// Function to determine domain type
var apiRouter = _express["default"].Router();
apiRouter.route("/").post(_strategy.jwtStrategy, _strategy.checkCompanyValidityStrategy, _strategy.checkTaConnectionStrategy, (0, _permission.permission)("Users", "Write"), upload.single("csvFile"), _scanAndUploadFile.scanFile, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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