"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _permission = require("../../middlewares/permission");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var validator = _joi["default"].object().keys({
  userId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/v1/users/user-enable-disable user-enable-disable
 * @apiName user-enable-disable
 * @apiGroup users
 * @apiDescription Enabling or disabling a particular user's mailbox check
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}    userId      id of users has to be synced
 * 
 * @apiSuccess {Boolean}  Status      true
 * @apiSuccess {Array}    Message     "User deleted successfully"
 * 
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *      {
 *          "Status": true,
 *          "Message": "User deleted successfully"
 *      }
 * 
 * @apiError (400) {Boolean} success             false
 * @apiError (400) {Array}   messages            "Invalid user recieved"
 * 
 * @apiErrorExample Error-Response:
 *       HTTP/1.1 400 Not Found
 *      {
 *      "success":   false,
 *      "messages" : "Invalid user recieved"
 *      }
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var userId, user;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          userId = req.query.userId;
          _context.next = 4;
          return db.User.findOne({
            _id: userId,
            deletedAt: null
          });
        case 4:
          user = _context.sent;
          if (user) {
            _context.next = 7;
            break;
          }
          throw new RequestError('Invalid user recieved');
        case 7:
          _context.next = 9;
          return db.User.deleteOne({
            _id: user._id
          });
        case 9:
          return _context.abrupt("return", res.status(200).send({
            Success: true,
            message: 'User deleted successfully'
          }));
        case 12:
          _context.prev = 12;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 16:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 12]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/')["delete"](_strategy.jwtStrategy, (0, _permission.permission)('Users', 'Delete'), _strategy.checkTaConnectionStrategy, (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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