"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _permission = require("../../middlewares/permission");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  messengerStatus: _joi["default"]["boolean"]().required(),
  userId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/v1/users/user-enable-disable user-enable-disable
 * @apiName user-enable-disable
 * @apiGroup users
 * @apiDescription Enabling or disabling a particular user's mailbox check
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {Boolean}   status      status of the user
 * @apiBody   {String}    userId      id of users has to be synced
 * 
 * @apiSuccess {Boolean}  Status      true
 * @apiSuccess {Array}    Message     "status changed successfully"
 * 
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *      {
 *          "Status": true,
 *          "Message": "status changed successfully"
 *      }
 * 
 * @apiError (400) {Boolean} success             false
 * @apiError (400) {Array}   messages            "Invalid user recieved"
 * 
 * @apiErrorExample Error-Response:
 *       HTTP/1.1 400 Not Found
 *      {
 *      "success":   false,
 *      "messages" : "Invalid user recieved"
 *      }
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, userId, messengerStatus, user, checkGroupsOfCompanyWithMessengerAccess, userGroups;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, userId = _req$body.userId, messengerStatus = _req$body.messengerStatus;
          _context.next = 4;
          return db.User.findById(userId);
        case 4:
          user = _context.sent;
          if (user) {
            _context.next = 7;
            break;
          }
          throw new RequestError('Invalid user recieved');
        case 7:
          if (user.groups.length) {
            _context.next = 9;
            break;
          }
          throw new RequestError('User does not belong to any group with messenger access in company!');
        case 9:
          if (!messengerStatus) {
            _context.next = 22;
            break;
          }
          _context.next = 12;
          return db.Group.find({
            companyId: user.companyId,
            deletedAt: null,
            messengerAccess: true
          }).select('_id');
        case 12:
          checkGroupsOfCompanyWithMessengerAccess = _context.sent;
          checkGroupsOfCompanyWithMessengerAccess = checkGroupsOfCompanyWithMessengerAccess.map(function (group) {
            return group._id.toString();
          });
          userGroups = user.groups.map(function (group) {
            return group._id.toString();
          });
          if (!userGroups.some(function (group) {
            return checkGroupsOfCompanyWithMessengerAccess.includes(group);
          })) {
            _context.next = 21;
            break;
          }
          _context.next = 18;
          return db.User.updateOne({
            _id: user._id
          }, {
            isActiveMessenger: messengerStatus
          });
        case 18:
          return _context.abrupt("return", res.status(200).send({
            Success: true,
            message: 'status changed successfully'
          }));
        case 21:
          throw new RequestError('User does not belong to any group with messenger access in company!');
        case 22:
          _context.next = 24;
          return db.User.updateOne({
            _id: user._id
          }, {
            isActiveMessenger: messengerStatus
          });
        case 24:
          return _context.abrupt("return", res.status(200).send({
            Success: true,
            message: 'status changed successfully'
          }));
        case 27:
          _context.prev = 27;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 31:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 27]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, _strategy.checkCompanyValidityStrategy, (0, _permission.permission)('Users', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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