"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _permission = require("../../middlewares/permission");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  status: _joi["default"]["boolean"]().required(),
  userId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/v1/users/user-enable-disable user-enable-disable
 * @apiName user-enable-disable
 * @apiGroup users
 * @apiDescription Enabling or disabling a particular user's mailbox check
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {Boolean}   status      status of the user
 * @apiBody   {String}    userId      id of users has to be synced
 * 
 * @apiSuccess {Boolean}  Status      true
 * @apiSuccess {Array}    Message     "status changed successfully"
 * 
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *      {
 *          "Status": true,
 *          "Message": "status changed successfully"
 *      }
 * 
 * @apiError (400) {Boolean} success             false
 * @apiError (400) {Array}   messages            "Invalid user recieved"
 * 
 * @apiErrorExample Error-Response:
 *       HTTP/1.1 400 Not Found
 *      {
 *      "success":   false,
 *      "messages" : "Invalid user recieved"
 *      }
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, userId, status, user, checkGroupsOfCompanyWithEmailAccess, userGroups;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, userId = _req$body.userId, status = _req$body.status;
          _context.next = 4;
          return db.User.findById(userId);
        case 4:
          user = _context.sent;
          if (user) {
            _context.next = 7;
            break;
          }
          throw new RequestError('Invalid user recieved');
        case 7:
          if (user.groups.length) {
            _context.next = 9;
            break;
          }
          throw new RequestError('User does not belong to any group with email access in company!');
        case 9:
          if (!status) {
            _context.next = 22;
            break;
          }
          _context.next = 12;
          return db.Group.find({
            companyId: user.companyId,
            deletedAt: null,
            emailAccess: true
          }).select('_id');
        case 12:
          checkGroupsOfCompanyWithEmailAccess = _context.sent;
          checkGroupsOfCompanyWithEmailAccess = checkGroupsOfCompanyWithEmailAccess.map(function (group) {
            return group._id.toString();
          });
          userGroups = user.groups.map(function (group) {
            return group._id.toString();
          });
          if (!userGroups.some(function (group) {
            return checkGroupsOfCompanyWithEmailAccess.includes(group);
          })) {
            _context.next = 21;
            break;
          }
          _context.next = 18;
          return db.User.updateOne({
            _id: user._id
          }, {
            isActive: status
          });
        case 18:
          return _context.abrupt("return", res.status(200).send({
            Success: true,
            message: 'status changed successfully'
          }));
        case 21:
          throw new RequestError('User does not belong to any group with email access in company!');
        case 22:
          console.log("userrrrr yaha to ni aa ra na aur status kya hain?", status);
          _context.next = 25;
          return db.User.updateOne({
            _id: user._id
          }, {
            isActive: status
          });
        case 25:
          return _context.abrupt("return", res.status(200).send({
            Success: true,
            message: 'statuc changed successfully'
          }));
        case 28:
          _context.prev = 28;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 32:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 28]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, _strategy.checkCompanyValidityStrategy, (0, _permission.permission)('Users', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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