"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _fs = _interopRequireDefault(require("fs"));
var _joi = _interopRequireDefault(require("joi"));
var _path = _interopRequireDefault(require("path"));
var _express = _interopRequireDefault(require("express"));
var _json2csv = require("json2csv");
var _config = _interopRequireDefault(require("../../config"));
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var validator = _joi["default"].object().keys({
  domainId: _joi["default"].string().hex().length(24).optional()
});
var fields = ['name', 'email', 'userId', 'status'];
var opts = {
  fields: fields
};

/**
 * @api {get} /api/v1/users/user-list-csv?domainId=63b676c744ed3b8a723865971 user-list-csv
 * @apiName user-list-csv
 * @apiGroup users
 * @apiDescription downloading user's list csv file of a particular domain or all-users-tpir
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery   {Boolean}   [domainId]   id of the domain 
 * 
 * @apiSuccess {Boolean}  Success       true
 * @apiSuccess {String}   fileName      name of the csv file
 * @apiSuccess {String}   url           url of the csv file
 * 
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *   {
 *       "Success": true,
 *       "fileName": "1675067639919.csv",
 *       "url": "https://new-stag.threatalertbutton.com/static/attachments/"
 *   }
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var domainId, companyId, condition, users, data, i;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          domainId = req.query.domainId;
          companyId = req.user.companyId;
          condition = {
            companyId: companyId,
            deletedAt: null
          };
          if (domainId) condition['domainId'] = domainId;
          _context.next = 7;
          return db.User.find(condition);
        case 7:
          users = _context.sent;
          data = [];
          for (i = 0; i < users.length; i++) {
            data.push({
              name: users[i].name,
              email: users[i].email,
              userId: users[i].userId,
              status: users[i].isActive ? 'Active' : 'InActive'
            });
          }
          (0, _json2csv.parseAsync)(data, opts).then(function (csv) {
            var fileName = "".concat(Date.now(), ".csv");
            var filePath = _path["default"].join(appRoot, 'public', 'attachments', fileName);
            _fs["default"].writeFile(filePath, csv, function (err) {
              if (err) {
                throw new RequestError(err);
              }
              return res.status(200).send({
                Success: true,
                fileName: fileName,
                url: "".concat(_config["default"].app.url, "/api/static/attachments/")
              });
            });
          })["catch"](function (err) {
            throw new RequestError(err);
          });
          _context.next = 17;
          break;
        case 13:
          _context.prev = 13;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 17:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 13]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, (0, _validator.validateBody)(validator), (0, _permission.permission)('Users', 'Write'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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