"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var validator = _joi["default"].object().keys({
  page: _joi["default"].number().min(0).required(),
  limit: _joi["default"].number().min(1).required(),
  domains: _joi["default"].array().optional(),
  group: _joi["default"].string().optional(),
  subDomainGroups: _joi["default"].array().optional(),
  search: _joi["default"].string().optional().allow(null).empty(''),
  status: _joi["default"].string().optional().allow(null).empty(''),
  isActiveEmail: _joi["default"].string().optional(),
  isActiveWhatsapp: _joi["default"].string().optional()
});

/**
 * @api {post} /api/v1/users/user-list?page=1&limit=10 user-list
 * @apiName user-list
 * @apiGroup users
 * @apiDescription Fetch the list of all-users-tpir
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery   {Number}   page          (Pagination) Required page of the events records
 * @apiQuery   {Number}   limit         (Pagination) Required limit of event records to be returned
 * @apiQuery   {String}   domainId      Id of the domain who users are to be fetched
 * @apiQuery   {String}   [search]      Search for a particulat user
 * 
 * @apiSuccess {String} Success             true
 * @apiSuccess {Array}  users               list of all-users-tpir
 * @apiSuccess {Number} count               count of users
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * {
 *           "Success": true,
 *           "users": [
 *               {
 *                   "_id": "63d0efab032f943fc31e4ebe",
 *                   "name": "admintab",
 *                   "email": "admintab@kdmarc.com",
 *                   "userId": "193848ac-8363-482d-8578-2574b51c7d7d",
 *                   "domainId": "63d0eaaa032f943fc31e4ea2",
 *                   "companyId": "63d0ea61032f943fc31e4e80",
 *                   "isActive": true,
 *                   "emailType": "Outlook",
 *                   "deletedAt": null,
 *                   "__v": 0,
 *                   "createdAt": "2023-01-25T09:00:27.105Z",
 *                   "updatedAt": "2023-01-25T09:00:27.105Z"
 *               }
 *               
 *           ],
 *           "count": 1
 *           }
 * 
 * @apiError {Boolean} Success             false
 * @apiError {Array}   messages            "\"reportedMailId\" is not allowed to be empty"
 * 
 * @apiSuccessExample Error-Response:
 *       HTTP/1.1 400 Not Found
 * 
 *      "success":   false,
 *      "messages" : "\"reportedMailId\" is not allowed to be empty"
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$query, page, limit, _req$query$search, search, isActiveEmail, isActiveWhatsapp, companyId, condition, regex, count, users, groupsWithEmailAccess, emailUserFilter, emailUsersCount, emailUsers, groupsWithMessengerAccess, whatsappUserFilter, whatsappUsersCount, whatsappUsers;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$query = req.query, page = _req$query.page, limit = _req$query.limit, _req$query$search = _req$query.search, search = _req$query$search === void 0 ? '' : _req$query$search, isActiveEmail = _req$query.isActiveEmail, isActiveWhatsapp = _req$query.isActiveWhatsapp;
          companyId = req.user.companyId;
          condition = {
            companyId: companyId,
            deletedAt: null
          };
          if (search && search.length) {
            regex = new RegExp(search, "i");
            condition['$or'] = [{
              name: regex
            }, {
              email: regex
            }];
          }
          // Add isActive and isActiveMessenger filters to the main condition if provided
          if (isActiveEmail === 'active') {
            condition.isActive = true;
          } else if (isActiveEmail === 'inactive') {
            condition.isActive = false;
          }
          if (isActiveWhatsapp === 'active') {
            condition.isActiveMessenger = true;
          } else if (isActiveWhatsapp === 'inactive') {
            condition.isActiveMessenger = false;
          }
          _context.next = 9;
          return db.User.countDocuments(condition);
        case 9:
          count = _context.sent;
          _context.next = 12;
          return db.User.aggregate([{
            $match: condition
          }, {
            $lookup: {
              from: "groups",
              localField: "groups",
              foreignField: "_id",
              as: "userGroups"
            }
          }, {
            $addFields: {
              belongToAGroupWithEmailAccess: {
                $anyElementTrue: "$userGroups.emailAccess"
              },
              belongToAGroupWithMessengerAccess: {
                $anyElementTrue: "$userGroups.messengerAccess"
              }
            }
          }, {
            $skip: (page - 1) * limit
          }, {
            $limit: parseInt(limit)
          }]);
        case 12:
          users = _context.sent;
          _context.next = 15;
          return db.Group.find({
            companyId: companyId,
            emailAccess: true,
            deletedAt: null
          });
        case 15:
          groupsWithEmailAccess = _context.sent;
          groupsWithEmailAccess = groupsWithEmailAccess.map(function (group) {
            return group._id;
          });

          // Prepare filter for email users
          emailUserFilter = _objectSpread(_objectSpread({}, condition), {}, {
            groups: {
              $in: groupsWithEmailAccess
            }
          });
          _context.next = 20;
          return db.User.countDocuments(emailUserFilter);
        case 20:
          emailUsersCount = _context.sent;
          _context.next = 23;
          return db.User.find(emailUserFilter).skip((page - 1) * limit).limit(limit);
        case 23:
          emailUsers = _context.sent;
          _context.next = 26;
          return db.Group.find({
            companyId: companyId,
            messengerAccess: true,
            deletedAt: null
          });
        case 26:
          groupsWithMessengerAccess = _context.sent;
          groupsWithMessengerAccess = groupsWithMessengerAccess.map(function (group) {
            return group._id;
          });

          // Prepare filter for whatsapp users
          whatsappUserFilter = _objectSpread(_objectSpread({}, condition), {}, {
            groups: {
              $in: groupsWithMessengerAccess
            }
          });
          _context.next = 31;
          return db.User.countDocuments(whatsappUserFilter);
        case 31:
          whatsappUsersCount = _context.sent;
          _context.next = 34;
          return db.User.find(whatsappUserFilter).skip((page - 1) * limit).limit(limit);
        case 34:
          whatsappUsers = _context.sent;
          return _context.abrupt("return", res.status(200).send({
            Success: true,
            users: users,
            count: count,
            emailUsers: emailUsers,
            emailUsersCount: emailUsersCount,
            whatsappUsers: whatsappUsers,
            whatsappUsersCount: whatsappUsersCount
          }));
        case 38:
          _context.prev = 38;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 42:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 38]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, (0, _permission.permission)('Users', 'Read'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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