"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var validator = _joi["default"].object().keys({
  email: _joi["default"].string().required(),
  page: _joi["default"].number().min(0).required(),
  limit: _joi["default"].number().min(1).required(),
  domainId: _joi["default"].string().hex().length(24).optional()
});

/**
 * @api {post} /api/v1/users/user-list?page=1&limit=10 user-list
 * @apiName user-list
 * @apiGroup users
 * @apiDescription Fetch the list of all-users-tpir
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery   {Number}   page          (Pagination) Required page of the events records
 * @apiQuery   {Number}   limit         (Pagination) Required limit of event records to be returned
 * @apiQuery   {String}   domainId      Id of the domain who users are to be fetched
 * @apiQuery   {String}   [search]      Search for a particulat user
 * 
 * @apiSuccess {String} Success             true
 * @apiSuccess {Array}  users               list of all-users-tpir
 * @apiSuccess {Number} count               count of users
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * {
 *           "Success": true,
 *           "users": [
 *               {
 *                   "_id": "63d0efab032f943fc31e4ebe",
 *                   "name": "admintab",
 *                   "email": "admintab@kdmarc.com",
 *                   "userId": "193848ac-8363-482d-8578-2574b51c7d7d",
 *                   "domainId": "63d0eaaa032f943fc31e4ea2",
 *                   "companyId": "63d0ea61032f943fc31e4e80",
 *                   "isActive": true,
 *                   "emailType": "Outlook",
 *                   "deletedAt": null,
 *                   "__v": 0,
 *                   "createdAt": "2023-01-25T09:00:27.105Z",
 *                   "updatedAt": "2023-01-25T09:00:27.105Z"
 *               }
 *               
 *           ],
 *           "count": 1
 *           }
 * 
 * @apiError {Boolean} Success             false
 * @apiError {Array}   messages            "\"reportedMailId\" is not allowed to be empty"
 * 
 * @apiSuccessExample Error-Response:
 *       HTTP/1.1 400 Not Found
 * 
 *      "success":   false,
 *      "messages" : "\"reportedMailId\" is not allowed to be empty"
 * 
 */
var getReportedMailsWithCount = function getReportedMailsWithCount(reportedMails) {
  var countsByDate = {};
  reportedMails.forEach(function (email) {
    var date = new Date(email.createdAt);
    if (!isValidDate(date)) {
      return; // Skip invalid dates
    }

    var formattedDate = date.toISOString().split('T')[0]; // Extracting date in 'YYYY-MM-DD' format

    if (countsByDate[formattedDate]) {
      countsByDate[formattedDate]++;
    } else {
      countsByDate[formattedDate] = 1;
    }
  });

  // Create a range of dates between the earliest and latest dates
  var earliestDate = new Date().setMonth(new Date().getMonth() - 3);
  var latestDate = new Date();
  var dateRange = getDateRange(earliestDate, latestDate);

  // Fill in missing dates with 0 counts immediately after the date with a record
  var result = {};
  var lastCountedDate = null;
  dateRange.forEach(function (date) {
    var formattedDate = date.toISOString().split('T')[0];
    result[formattedDate] = countsByDate[formattedDate] || 0;

    //   if (countsByDate[formattedDate] !== undefined) {
    //     lastCountedDate = formattedDate;
    //   } else if (lastCountedDate !== null) {
    //     result[formattedDate] = 0;
    //   }
  });

  var mails = Object.entries(result).map(function (_ref) {
    var _ref2 = (0, _slicedToArray2["default"])(_ref, 2),
      date = _ref2[0],
      count = _ref2[1];
    var unixTimestamp = new Date(date).getTime(); // Convert to Unix timestamp
    return [unixTimestamp, count];
  });
  var dates = Object.keys(result);
  var latestFormattedDate = dates[dates.length - 1];
  return {
    mails: mails,
    latestDate: latestFormattedDate
  };
};

// Helper function to check if a date is valid
function isValidDate(d) {
  return d instanceof Date && !isNaN(d);
}

// Helper function to get a range of dates between two dates
function getDateRange(startDate, endDate) {
  var dateRange = [];
  var currentDate = new Date(startDate);
  while (currentDate.toISOString().split('T')[0] <= endDate.toISOString().split('T')[0]) {
    dateRange.push(new Date(currentDate));
    currentDate.setDate(currentDate.getDate() + 1);
    ;
  }
  return dateRange;
}
var calculatePercentage = function calculatePercentage(deletedMails, totalMails) {
  if (totalMails !== 0) {
    return (deletedMails / totalMails * 100).toFixed(1);
  } else if (totalMails === 0) {
    return 0;
  } else {
    return 0;
  }
};
var controller = /*#__PURE__*/function () {
  var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, email, page, limit, phoneNumber, user, threeMonthsAgo, reportedMails, reportedMessages, TotalreportedMails, TotalRportedMessages, count, messengerCount, isAdmin, totalMails, deletedMails, trashedMails, recoveredMails, pendingMails, totalMessages, safeMessages, unsafeMessages, dubiousMessages, noAdminActionMessages, userStats, reportedMailsWithCount, reportedMessagesWithCount;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, email = _req$body.email, page = _req$body.page, limit = _req$body.limit, phoneNumber = _req$body.phoneNumber;
          if (!email) {
            _context.next = 6;
            break;
          }
          _context.next = 5;
          return db.User.findOne({
            email: email,
            companyId: req.user.companyId
          }).select('name email emailType isActive isActiveMessenger');
        case 5:
          user = _context.sent;
        case 6:
          if (!(!email && phoneNumber != null)) {
            _context.next = 10;
            break;
          }
          _context.next = 9;
          return db.User.findOne({
            phoneNumber: phoneNumber,
            companyId: req.user.companyId
          }).select('name email emailType isActive isActiveMessenger');
        case 9:
          user = _context.sent;
        case 10:
          if (user) {
            _context.next = 12;
            break;
          }
          throw new RequestError("User not found!");
        case 12:
          threeMonthsAgo = new Date();
          threeMonthsAgo.setMonth(threeMonthsAgo.getMonth() - 3);
          _context.next = 16;
          return db.ReportedMail.find({
            userId: user._id,
            companyId: req.user.companyId,
            createdAt: {
              $gte: threeMonthsAgo
            }
          }).sort({
            createdAt: -1
          }).select('from subject reporters createdAt isRecoveredEmail isTrashedEmail isDeletedEmail -_id').skip((page - 1) * limit).limit(limit);
        case 16:
          reportedMails = _context.sent;
          _context.next = 19;
          return db.whatsapp.find({
            userId: user._id,
            companyId: req.user.companyId,
            createdAt: {
              $gte: threeMonthsAgo
            }
          }).sort({
            createdAt: -1
          }).select('from phoneNumber sender createdAt status result messageSummary -_id').skip((page - 1) * limit).limit(limit);
        case 19:
          reportedMessages = _context.sent;
          _context.next = 22;
          return db.ReportedMail.find({
            userId: user._id,
            companyId: req.user.companyId,
            createdAt: {
              $gte: threeMonthsAgo
            }
          }).sort({
            createdAt: 1
          }).select('from subject reporters createdAt isRecoveredEmail isTrashedEmail isDeletedEmail -_id');
        case 22:
          TotalreportedMails = _context.sent;
          _context.next = 25;
          return db.whatsapp.find({
            userId: user._id,
            companyId: req.user.companyId,
            createdAt: {
              $gte: threeMonthsAgo
            }
          }).sort({
            createdAt: 1
          }).select('from phoneNumber sender createdAt status result messageSummary -_id');
        case 25:
          TotalRportedMessages = _context.sent;
          _context.next = 28;
          return db.ReportedMail.countDocuments({
            userId: user._id,
            companyId: req.user.companyId,
            createdAt: {
              $gte: threeMonthsAgo
            }
          });
        case 28:
          count = _context.sent;
          _context.next = 31;
          return db.whatsapp.countDocuments({
            userId: user._id,
            companyId: req.user.companyId,
            createdAt: {
              $gte: threeMonthsAgo
            }
          }).sort({
            createdAt: 1
          }).select('from phoneNumber sender createdAt status result messageSummary -_id');
        case 31:
          messengerCount = _context.sent;
          _context.next = 34;
          return db.Admin.findOne({
            email: email,
            companyId: req.user.companyId
          });
        case 34:
          isAdmin = _context.sent;
          _context.next = 37;
          return db.ReportedMail.countDocuments({
            userId: user._id,
            companyId: req.user.companyId
          });
        case 37:
          totalMails = _context.sent;
          _context.next = 40;
          return db.ReportedMail.countDocuments({
            userId: user._id,
            companyId: req.user.companyId,
            isDeletedEmail: true
          });
        case 40:
          deletedMails = _context.sent;
          _context.next = 43;
          return db.ReportedMail.countDocuments({
            userId: user._id,
            companyId: req.user.companyId,
            isTrashedEmail: true
          });
        case 43:
          trashedMails = _context.sent;
          _context.next = 46;
          return db.ReportedMail.countDocuments({
            userId: user._id,
            companyId: req.user.companyId,
            isRecoveredEmail: true
          });
        case 46:
          recoveredMails = _context.sent;
          _context.next = 49;
          return db.ReportedMail.countDocuments({
            userId: user._id,
            companyId: req.user.companyId,
            isDeletedEmail: false,
            isTrashedEmail: false,
            isRecoveredEmail: false
          });
        case 49:
          pendingMails = _context.sent;
          _context.next = 52;
          return db.whatsapp.countDocuments({
            userId: user._id,
            companyId: req.user.companyId
          });
        case 52:
          totalMessages = _context.sent;
          _context.next = 55;
          return db.whatsapp.countDocuments({
            userId: user._id,
            companyId: req.user.companyId,
            result: 'safe'
          });
        case 55:
          safeMessages = _context.sent;
          _context.next = 58;
          return db.whatsapp.countDocuments({
            userId: user._id,
            companyId: req.user.companyId,
            result: 'unsafe'
          });
        case 58:
          unsafeMessages = _context.sent;
          _context.next = 61;
          return db.whatsapp.countDocuments({
            userId: user._id,
            companyId: req.user.companyId,
            result: 'dubious'
          });
        case 61:
          dubiousMessages = _context.sent;
          _context.next = 64;
          return db.whatsapp.countDocuments({
            userId: user._id,
            companyId: req.user.companyId,
            result: 'No Action'
          });
        case 64:
          noAdminActionMessages = _context.sent;
          userStats = {};
          userStats.name = user.name;
          userStats.email = user.email;
          userStats.phoneNumber = user.phoneNumber;
          userStats.emailType = user.emailType;
          userStats.role = isAdmin ? 'Admin' : 'Member';
          userStats.isActive = user.isActive;
          userStats.totalMails = totalMails;
          userStats.deletedMails = deletedMails;
          userStats.trashedMails = trashedMails;
          userStats.recoveredMails = recoveredMails;
          userStats.pendingMails = pendingMails;
          userStats.score = deletedMails != 0 ? calculatePercentage(deletedMails, totalMails) : 0;
          userStats.messengerScore = unsafeMessages != 0 ? calculatePercentage(unsafeMessages, totalMessages) : 0;
          reportedMailsWithCount = reportedMails.length ? getReportedMailsWithCount(TotalreportedMails) : {
            mails: [],
            latestDate: ''
          };
          reportedMessagesWithCount = reportedMessages.length ? getReportedMailsWithCount(TotalRportedMessages) : {
            mails: [],
            latestDate: ''
          };
          userStats.reportedMailsWithCount = reportedMailsWithCount.mails;
          userStats.reportedMessagesWithCount = reportedMessagesWithCount.mails;
          userStats.lastActive = reportedMailsWithCount.latestDate == '' ? "No mail reported yet." : reportedMailsWithCount.latestDate;
          userStats.lastActiveMessenger = reportedMessagesWithCount.latestDate == '' ? "No message reported yet." : reportedMessagesWithCount.latestDate;
          userStats.safeMessages = safeMessages;
          userStats.unsafeMessages = unsafeMessages;
          userStats.totalMessages = totalMessages;
          userStats.dubiousMessages = dubiousMessages;
          userStats.noAdminActionMessages = noAdminActionMessages;
          userStats.isActiveMessenger = user.isActiveMessenger;
          return _context.abrupt("return", res.status(200).send({
            success: true,
            userStats: userStats,
            reportedMails: reportedMails,
            reportedMessages: reportedMessages,
            count: count,
            messengerCount: messengerCount
          }));
        case 94:
          _context.prev = 94;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 98:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 94]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref3.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-UAS"), _strategy.checkCompanyValidityStrategy, (0, _permission.permission)('Users', 'Read'),
// validateBody(validator),
controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJ2YWxpZGF0b3IiLCJKb2kiLCJvYmplY3QiLCJrZXlzIiwiZW1haWwiLCJzdHJpbmciLCJyZXF1aXJlZCIsInBhZ2UiLCJudW1iZXIiLCJtaW4iLCJsaW1pdCIsImRvbWFpbklkIiwiaGV4IiwibGVuZ3RoIiwib3B0aW9uYWwiLCJnZXRSZXBvcnRlZE1haWxzV2l0aENvdW50IiwicmVwb3J0ZWRNYWlscyIsImNvdW50c0J5RGF0ZSIsImZvckVhY2giLCJkYXRlIiwiRGF0ZSIsImNyZWF0ZWRBdCIsImlzVmFsaWREYXRlIiwiZm9ybWF0dGVkRGF0ZSIsInRvSVNPU3RyaW5nIiwic3BsaXQiLCJlYXJsaWVzdERhdGUiLCJzZXRNb250aCIsImdldE1vbnRoIiwibGF0ZXN0RGF0ZSIsImRhdGVSYW5nZSIsImdldERhdGVSYW5nZSIsInJlc3VsdCIsImxhc3RDb3VudGVkRGF0ZSIsIm1haWxzIiwiT2JqZWN0IiwiZW50cmllcyIsIm1hcCIsImNvdW50IiwidW5peFRpbWVzdGFtcCIsImdldFRpbWUiLCJkYXRlcyIsImxhdGVzdEZvcm1hdHRlZERhdGUiLCJkIiwiaXNOYU4iLCJzdGFydERhdGUiLCJlbmREYXRlIiwiY3VycmVudERhdGUiLCJwdXNoIiwic2V0RGF0ZSIsImdldERhdGUiLCJjYWxjdWxhdGVQZXJjZW50YWdlIiwiZGVsZXRlZE1haWxzIiwidG90YWxNYWlscyIsInRvRml4ZWQiLCJjb250cm9sbGVyIiwicmVxIiwicmVzIiwibmV4dCIsImJvZHkiLCJwaG9uZU51bWJlciIsImRiIiwiVXNlciIsImZpbmRPbmUiLCJjb21wYW55SWQiLCJ1c2VyIiwic2VsZWN0IiwiUmVxdWVzdEVycm9yIiwidGhyZWVNb250aHNBZ28iLCJSZXBvcnRlZE1haWwiLCJmaW5kIiwidXNlcklkIiwiX2lkIiwiJGd0ZSIsInNvcnQiLCJza2lwIiwid2hhdHNhcHAiLCJyZXBvcnRlZE1lc3NhZ2VzIiwiVG90YWxyZXBvcnRlZE1haWxzIiwiVG90YWxScG9ydGVkTWVzc2FnZXMiLCJjb3VudERvY3VtZW50cyIsIm1lc3NlbmdlckNvdW50IiwiQWRtaW4iLCJpc0FkbWluIiwiaXNEZWxldGVkRW1haWwiLCJpc1RyYXNoZWRFbWFpbCIsInRyYXNoZWRNYWlscyIsImlzUmVjb3ZlcmVkRW1haWwiLCJyZWNvdmVyZWRNYWlscyIsInBlbmRpbmdNYWlscyIsInRvdGFsTWVzc2FnZXMiLCJzYWZlTWVzc2FnZXMiLCJ1bnNhZmVNZXNzYWdlcyIsImR1YmlvdXNNZXNzYWdlcyIsIm5vQWRtaW5BY3Rpb25NZXNzYWdlcyIsInVzZXJTdGF0cyIsIm5hbWUiLCJlbWFpbFR5cGUiLCJyb2xlIiwiaXNBY3RpdmUiLCJzY29yZSIsIm1lc3NlbmdlclNjb3JlIiwicmVwb3J0ZWRNYWlsc1dpdGhDb3VudCIsInJlcG9ydGVkTWVzc2FnZXNXaXRoQ291bnQiLCJsYXN0QWN0aXZlIiwibGFzdEFjdGl2ZU1lc3NlbmdlciIsImlzQWN0aXZlTWVzc2VuZ2VyIiwic3RhdHVzIiwic2VuZCIsInN1Y2Nlc3MiLCJjb25zb2xlIiwibG9nIiwiYXBpUm91dGVyIiwiZXhwcmVzcyIsIlJvdXRlciIsInJvdXRlIiwicG9zdCIsImh0bWxzYW5pdGl6ZSIsImp3dFN0cmF0ZWd5IiwicmVzdHJpY3RGZWF0dXJlIiwiY2hlY2tDb21wYW55VmFsaWRpdHlTdHJhdGVneSIsInBlcm1pc3Npb24iXSwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvYXBpL3VzZXJzL3VzZXItcmVwb3J0LmpzIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBKb2kgZnJvbSAnam9pJztcbmltcG9ydCBleHByZXNzIGZyb20gJ2V4cHJlc3MnO1xuXG5pbXBvcnQgeyBjaGVja0NvbXBhbnlWYWxpZGl0eVN0cmF0ZWd5LCBqd3RTdHJhdGVneSB9IGZyb20gJy4uLy4uL21pZGRsZXdhcmVzL3N0cmF0ZWd5JztcbmltcG9ydCB7IHZhbGlkYXRlQm9keSB9IGZyb20gJy4uLy4uL21pZGRsZXdhcmVzL3ZhbGlkYXRvcic7XG5pbXBvcnQgeyBwZXJtaXNzaW9uIH0gZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvcGVybWlzc2lvbic7XG5pbXBvcnQgeyBodG1sc2FuaXRpemUgfSBmcm9tICcuLi8uLi9taWRkbGV3YXJlcy9zYW5pdGl6ZUh0bWwnO1xuaW1wb3J0IHJlc3RyaWN0RmVhdHVyZSBmcm9tICcuLi8uLi9taWRkbGV3YXJlcy9mZWF0dXJlQmxvY2tlcic7XG5cbmNvbnN0IHZhbGlkYXRvciA9IEpvaS5vYmplY3QoKS5rZXlzKHtcbiAgICBlbWFpbDogSm9pLnN0cmluZygpLnJlcXVpcmVkKCksXG4gICAgcGFnZTogSm9pLm51bWJlcigpLm1pbigwKS5yZXF1aXJlZCgpLFxuICAgIGxpbWl0OiBKb2kubnVtYmVyKCkubWluKDEpLnJlcXVpcmVkKCksXG4gICAgZG9tYWluSWQ6IEpvaS5zdHJpbmcoKS5oZXgoKS5sZW5ndGgoMjQpLm9wdGlvbmFsKCksXG5cbn0pO1xuXG4vKipcbiAqIEBhcGkge3Bvc3R9IC9hcGkvdjEvdXNlcnMvdXNlci1saXN0P3BhZ2U9MSZsaW1pdD0xMCB1c2VyLWxpc3RcbiAqIEBhcGlOYW1lIHVzZXItbGlzdFxuICogQGFwaUdyb3VwIHVzZXJzXG4gKiBAYXBpRGVzY3JpcHRpb24gRmV0Y2ggdGhlIGxpc3Qgb2YgYWxsLXVzZXJzLXRwaXJcbiAqIFxuICogQGFwaVZlcnNpb24gMS4wLjBcbiAqIFxuICogQGFwaVF1ZXJ5ICAge051bWJlcn0gICBwYWdlICAgICAgICAgIChQYWdpbmF0aW9uKSBSZXF1aXJlZCBwYWdlIG9mIHRoZSBldmVudHMgcmVjb3Jkc1xuICogQGFwaVF1ZXJ5ICAge051bWJlcn0gICBsaW1pdCAgICAgICAgIChQYWdpbmF0aW9uKSBSZXF1aXJlZCBsaW1pdCBvZiBldmVudCByZWNvcmRzIHRvIGJlIHJldHVybmVkXG4gKiBAYXBpUXVlcnkgICB7U3RyaW5nfSAgIGRvbWFpbklkICAgICAgSWQgb2YgdGhlIGRvbWFpbiB3aG8gdXNlcnMgYXJlIHRvIGJlIGZldGNoZWRcbiAqIEBhcGlRdWVyeSAgIHtTdHJpbmd9ICAgW3NlYXJjaF0gICAgICBTZWFyY2ggZm9yIGEgcGFydGljdWxhdCB1c2VyXG4gKiBcbiAqIEBhcGlTdWNjZXNzIHtTdHJpbmd9IFN1Y2Nlc3MgICAgICAgICAgICAgdHJ1ZVxuICogQGFwaVN1Y2Nlc3Mge0FycmF5fSAgdXNlcnMgICAgICAgICAgICAgICBsaXN0IG9mIGFsbC11c2Vycy10cGlyXG4gKiBAYXBpU3VjY2VzcyB7TnVtYmVyfSBjb3VudCAgICAgICAgICAgICAgIGNvdW50IG9mIHVzZXJzXG4gKiBcbiAqIEBhcGlTdWNjZXNzRXhhbXBsZSBTdWNjZXNzLVJlc3BvbnNlOlxuICogICAgICBIVFRQLzEuMSAyMDAgT0sgXG4gKiB7XG4gKiAgICAgICAgICAgXCJTdWNjZXNzXCI6IHRydWUsXG4gKiAgICAgICAgICAgXCJ1c2Vyc1wiOiBbXG4gKiAgICAgICAgICAgICAgIHtcbiAqICAgICAgICAgICAgICAgICAgIFwiX2lkXCI6IFwiNjNkMGVmYWIwMzJmOTQzZmMzMWU0ZWJlXCIsXG4gKiAgICAgICAgICAgICAgICAgICBcIm5hbWVcIjogXCJhZG1pbnRhYlwiLFxuICogICAgICAgICAgICAgICAgICAgXCJlbWFpbFwiOiBcImFkbWludGFiQGtkbWFyYy5jb21cIixcbiAqICAgICAgICAgICAgICAgICAgIFwidXNlcklkXCI6IFwiMTkzODQ4YWMtODM2My00ODJkLTg1NzgtMjU3NGI1MWM3ZDdkXCIsXG4gKiAgICAgICAgICAgICAgICAgICBcImRvbWFpbklkXCI6IFwiNjNkMGVhYWEwMzJmOTQzZmMzMWU0ZWEyXCIsXG4gKiAgICAgICAgICAgICAgICAgICBcImNvbXBhbnlJZFwiOiBcIjYzZDBlYTYxMDMyZjk0M2ZjMzFlNGU4MFwiLFxuICogICAgICAgICAgICAgICAgICAgXCJpc0FjdGl2ZVwiOiB0cnVlLFxuICogICAgICAgICAgICAgICAgICAgXCJlbWFpbFR5cGVcIjogXCJPdXRsb29rXCIsXG4gKiAgICAgICAgICAgICAgICAgICBcImRlbGV0ZWRBdFwiOiBudWxsLFxuICogICAgICAgICAgICAgICAgICAgXCJfX3ZcIjogMCxcbiAqICAgICAgICAgICAgICAgICAgIFwiY3JlYXRlZEF0XCI6IFwiMjAyMy0wMS0yNVQwOTowMDoyNy4xMDVaXCIsXG4gKiAgICAgICAgICAgICAgICAgICBcInVwZGF0ZWRBdFwiOiBcIjIwMjMtMDEtMjVUMDk6MDA6MjcuMTA1WlwiXG4gKiAgICAgICAgICAgICAgIH1cbiAqICAgICAgICAgICAgICAgXG4gKiAgICAgICAgICAgXSxcbiAqICAgICAgICAgICBcImNvdW50XCI6IDFcbiAqICAgICAgICAgICB9XG4gKiBcbiAqIEBhcGlFcnJvciB7Qm9vbGVhbn0gU3VjY2VzcyAgICAgICAgICAgICBmYWxzZVxuICogQGFwaUVycm9yIHtBcnJheX0gICBtZXNzYWdlcyAgICAgICAgICAgIFwiXFxcInJlcG9ydGVkTWFpbElkXFxcIiBpcyBub3QgYWxsb3dlZCB0byBiZSBlbXB0eVwiXG4gKiBcbiAqIEBhcGlTdWNjZXNzRXhhbXBsZSBFcnJvci1SZXNwb25zZTpcbiAqICAgICAgIEhUVFAvMS4xIDQwMCBOb3QgRm91bmRcbiAqIFxuICogICAgICBcInN1Y2Nlc3NcIjogICBmYWxzZSxcbiAqICAgICAgXCJtZXNzYWdlc1wiIDogXCJcXFwicmVwb3J0ZWRNYWlsSWRcXFwiIGlzIG5vdCBhbGxvd2VkIHRvIGJlIGVtcHR5XCJcbiAqIFxuICovXG5jb25zdCBnZXRSZXBvcnRlZE1haWxzV2l0aENvdW50ID0gKHJlcG9ydGVkTWFpbHMpID0+IHtcbiAgICBjb25zdCBjb3VudHNCeURhdGUgPSB7fTtcbiAgICByZXBvcnRlZE1haWxzLmZvckVhY2goZW1haWwgPT4ge1xuICAgICAgY29uc3QgZGF0ZSA9IG5ldyBEYXRlKGVtYWlsLmNyZWF0ZWRBdCk7XG4gICAgICBpZiAoIWlzVmFsaWREYXRlKGRhdGUpKSB7XG4gICAgICAgIHJldHVybjsgLy8gU2tpcCBpbnZhbGlkIGRhdGVzXG4gICAgICB9XG4gICAgICBjb25zdCBmb3JtYXR0ZWREYXRlID0gZGF0ZS50b0lTT1N0cmluZygpLnNwbGl0KCdUJylbMF07IC8vIEV4dHJhY3RpbmcgZGF0ZSBpbiAnWVlZWS1NTS1ERCcgZm9ybWF0XG4gIFxuICAgICAgaWYgKGNvdW50c0J5RGF0ZVtmb3JtYXR0ZWREYXRlXSkge1xuICAgICAgICBjb3VudHNCeURhdGVbZm9ybWF0dGVkRGF0ZV0rKztcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIGNvdW50c0J5RGF0ZVtmb3JtYXR0ZWREYXRlXSA9IDE7XG4gICAgICB9XG4gICAgfSk7XG5cbiAgICAvLyBDcmVhdGUgYSByYW5nZSBvZiBkYXRlcyBiZXR3ZWVuIHRoZSBlYXJsaWVzdCBhbmQgbGF0ZXN0IGRhdGVzXG4gICAgY29uc3QgZWFybGllc3REYXRlID0gbmV3IERhdGUoKS5zZXRNb250aChuZXcgRGF0ZSgpLmdldE1vbnRoKCkgLSAzKVxuICAgIGNvbnN0IGxhdGVzdERhdGUgPSBuZXcgRGF0ZSgpO1xuICAgIGNvbnN0IGRhdGVSYW5nZSA9IGdldERhdGVSYW5nZShlYXJsaWVzdERhdGUsIGxhdGVzdERhdGUpO1xuICBcbiAgICAvLyBGaWxsIGluIG1pc3NpbmcgZGF0ZXMgd2l0aCAwIGNvdW50cyBpbW1lZGlhdGVseSBhZnRlciB0aGUgZGF0ZSB3aXRoIGEgcmVjb3JkXG4gICAgY29uc3QgcmVzdWx0ID0ge307XG4gICAgbGV0IGxhc3RDb3VudGVkRGF0ZSA9IG51bGw7XG4gIFxuICAgIGRhdGVSYW5nZS5mb3JFYWNoKGRhdGUgPT4ge1xuICAgICAgY29uc3QgZm9ybWF0dGVkRGF0ZSA9IGRhdGUudG9JU09TdHJpbmcoKS5zcGxpdCgnVCcpWzBdO1xuICAgICAgcmVzdWx0W2Zvcm1hdHRlZERhdGVdID0gY291bnRzQnlEYXRlW2Zvcm1hdHRlZERhdGVdIHx8IDA7XG4gIFxuICAgIC8vICAgaWYgKGNvdW50c0J5RGF0ZVtmb3JtYXR0ZWREYXRlXSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgLy8gICAgIGxhc3RDb3VudGVkRGF0ZSA9IGZvcm1hdHRlZERhdGU7XG4gICAgLy8gICB9IGVsc2UgaWYgKGxhc3RDb3VudGVkRGF0ZSAhPT0gbnVsbCkge1xuICAgIC8vICAgICByZXN1bHRbZm9ybWF0dGVkRGF0ZV0gPSAwO1xuICAgIC8vICAgfVxuICAgIH0pO1xuICAgIGNvbnN0IG1haWxzID0gT2JqZWN0LmVudHJpZXMocmVzdWx0KS5tYXAoKFtkYXRlLCBjb3VudF0pID0+IHtcbiAgICAgIGNvbnN0IHVuaXhUaW1lc3RhbXAgPSBuZXcgRGF0ZShkYXRlKS5nZXRUaW1lKCk7IC8vIENvbnZlcnQgdG8gVW5peCB0aW1lc3RhbXBcbiAgICAgIHJldHVybiBbdW5peFRpbWVzdGFtcCwgY291bnRdO1xuICAgIH0pO1xuICBcbiAgICBjb25zdCBkYXRlcyA9IE9iamVjdC5rZXlzKHJlc3VsdCk7XG4gICAgY29uc3QgbGF0ZXN0Rm9ybWF0dGVkRGF0ZSA9IGRhdGVzW2RhdGVzLmxlbmd0aCAtIDFdO1xuICAgIHJldHVybiB7IG1haWxzLCBsYXRlc3REYXRlOiBsYXRlc3RGb3JtYXR0ZWREYXRlIH07XG4gIH1cbiAgXG4gIC8vIEhlbHBlciBmdW5jdGlvbiB0byBjaGVjayBpZiBhIGRhdGUgaXMgdmFsaWRcbiAgZnVuY3Rpb24gaXNWYWxpZERhdGUoZCkge1xuICAgIHJldHVybiBkIGluc3RhbmNlb2YgRGF0ZSAmJiAhaXNOYU4oZCk7XG4gIH1cbiAgXG4gIC8vIEhlbHBlciBmdW5jdGlvbiB0byBnZXQgYSByYW5nZSBvZiBkYXRlcyBiZXR3ZWVuIHR3byBkYXRlc1xuICBmdW5jdGlvbiBnZXREYXRlUmFuZ2Uoc3RhcnREYXRlLCBlbmREYXRlKSB7XG4gICAgY29uc3QgZGF0ZVJhbmdlID0gW107XG5cbiAgICBsZXQgY3VycmVudERhdGUgPSBuZXcgRGF0ZShzdGFydERhdGUpXG4gICAgd2hpbGUgKGN1cnJlbnREYXRlLnRvSVNPU3RyaW5nKCkuc3BsaXQoJ1QnKVswXSA8PSBlbmREYXRlLnRvSVNPU3RyaW5nKCkuc3BsaXQoJ1QnKVswXSkge1xuICAgICAgZGF0ZVJhbmdlLnB1c2gobmV3IERhdGUoY3VycmVudERhdGUpKTtcbiAgICAgIGN1cnJlbnREYXRlLnNldERhdGUoY3VycmVudERhdGUuZ2V0RGF0ZSgpICsgMSk7O1xuICAgIH1cbiAgICByZXR1cm4gZGF0ZVJhbmdlO1xuICB9XG5cbiAgY29uc3QgY2FsY3VsYXRlUGVyY2VudGFnZSA9IChkZWxldGVkTWFpbHMsIHRvdGFsTWFpbHMpID0+e1xuICAgICAgICBpZiAodG90YWxNYWlscyAhPT0gMCkge1xuICAgICAgICAgIHJldHVybiAoZGVsZXRlZE1haWxzIC8gdG90YWxNYWlscyAqIDEwMCkudG9GaXhlZCgxKTtcbiAgICAgICAgfSBlbHNlIGlmICh0b3RhbE1haWxzID09PSAwKSB7XG4gICAgICAgICAgICByZXR1cm4gMDtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIHJldHVybiAwO1xuICAgICAgICB9XG4gIH1cbiAgXG5cbmNvbnN0IGNvbnRyb2xsZXIgPSBhc3luYyAocmVxLCByZXMsIG5leHQpID0+IHtcbiAgICB0cnkge1xuICAgICAgICBjb25zdCB7IGVtYWlsLCBwYWdlLCBsaW1pdCwgcGhvbmVOdW1iZXIgfSA9IHJlcS5ib2R5XG4gICAgICAgIGxldCB1c2VyO1xuXG4gICAgICAgIGlmKGVtYWlsKSB1c2VyID0gYXdhaXQgZGIuVXNlci5maW5kT25lKHtlbWFpbCwgY29tcGFueUlkOiByZXEudXNlci5jb21wYW55SWR9KS5zZWxlY3QoJ25hbWUgZW1haWwgZW1haWxUeXBlIGlzQWN0aXZlIGlzQWN0aXZlTWVzc2VuZ2VyJyk7XG4gICAgICAgIGlmKCFlbWFpbCAmJiBwaG9uZU51bWJlciAhPSBudWxsKSB1c2VyID0gYXdhaXQgZGIuVXNlci5maW5kT25lKHtwaG9uZU51bWJlciwgY29tcGFueUlkOiByZXEudXNlci5jb21wYW55SWR9KS5zZWxlY3QoJ25hbWUgZW1haWwgZW1haWxUeXBlIGlzQWN0aXZlIGlzQWN0aXZlTWVzc2VuZ2VyJyk7XG5cbiAgICAgICAgaWYoIXVzZXIpIHRocm93IG5ldyBSZXF1ZXN0RXJyb3IoXCJVc2VyIG5vdCBmb3VuZCFcIilcblxuICAgICAgICBjb25zdCB0aHJlZU1vbnRoc0FnbyA9IG5ldyBEYXRlKCk7XG4gICAgICAgIHRocmVlTW9udGhzQWdvLnNldE1vbnRoKHRocmVlTW9udGhzQWdvLmdldE1vbnRoKCkgLSAzKTtcblxuICAgICAgICBjb25zdCByZXBvcnRlZE1haWxzID0gYXdhaXQgZGIuUmVwb3J0ZWRNYWlsLmZpbmQoe3VzZXJJZDp1c2VyLl9pZCwgY29tcGFueUlkOiByZXEudXNlci5jb21wYW55SWQsIGNyZWF0ZWRBdDp7ICRndGU6IHRocmVlTW9udGhzQWdvIH19KS5zb3J0KHsgY3JlYXRlZEF0OiAtMSB9KS5zZWxlY3QoJ2Zyb20gc3ViamVjdCByZXBvcnRlcnMgY3JlYXRlZEF0IGlzUmVjb3ZlcmVkRW1haWwgaXNUcmFzaGVkRW1haWwgaXNEZWxldGVkRW1haWwgLV9pZCcpXG4gICAgICAgIC5za2lwKChwYWdlLTEpKmxpbWl0KVxuICAgICAgICAubGltaXQobGltaXQpXG5cbiAgICAgICAgY29uc3QgcmVwb3J0ZWRNZXNzYWdlcyA9IGF3YWl0IGRiLndoYXRzYXBwLmZpbmQoe3VzZXJJZDp1c2VyLl9pZCwgY29tcGFueUlkOiByZXEudXNlci5jb21wYW55SWQsIGNyZWF0ZWRBdDp7ICRndGU6IHRocmVlTW9udGhzQWdvIH19KS5zb3J0KHsgY3JlYXRlZEF0OiAtMSB9KS5zZWxlY3QoJ2Zyb20gcGhvbmVOdW1iZXIgc2VuZGVyIGNyZWF0ZWRBdCBzdGF0dXMgcmVzdWx0IG1lc3NhZ2VTdW1tYXJ5IC1faWQnKVxuICAgICAgICAuc2tpcCgocGFnZS0xKSpsaW1pdClcbiAgICAgICAgLmxpbWl0KGxpbWl0KSAgICBcbiAgICAgICAgXG5cbiAgICAgICAgY29uc3QgVG90YWxyZXBvcnRlZE1haWxzID0gYXdhaXQgZGIuUmVwb3J0ZWRNYWlsLmZpbmQoe3VzZXJJZDp1c2VyLl9pZCwgY29tcGFueUlkOiByZXEudXNlci5jb21wYW55SWQsIGNyZWF0ZWRBdDp7ICRndGU6IHRocmVlTW9udGhzQWdvIH19KS5zb3J0KHsgY3JlYXRlZEF0OiAxIH0pLnNlbGVjdCgnZnJvbSBzdWJqZWN0IHJlcG9ydGVycyBjcmVhdGVkQXQgaXNSZWNvdmVyZWRFbWFpbCBpc1RyYXNoZWRFbWFpbCBpc0RlbGV0ZWRFbWFpbCAtX2lkJylcbiAgICAgICAgY29uc3QgVG90YWxScG9ydGVkTWVzc2FnZXMgPSBhd2FpdCBkYi53aGF0c2FwcC5maW5kKHt1c2VySWQ6dXNlci5faWQsIGNvbXBhbnlJZDogcmVxLnVzZXIuY29tcGFueUlkLCBjcmVhdGVkQXQ6eyAkZ3RlOiB0aHJlZU1vbnRoc0FnbyB9fSkuc29ydCh7IGNyZWF0ZWRBdDogMSB9KS5zZWxlY3QoJ2Zyb20gcGhvbmVOdW1iZXIgc2VuZGVyIGNyZWF0ZWRBdCBzdGF0dXMgcmVzdWx0IG1lc3NhZ2VTdW1tYXJ5IC1faWQnKVxuICAgICAgICBjb25zdCBjb3VudCA9IGF3YWl0IGRiLlJlcG9ydGVkTWFpbC5jb3VudERvY3VtZW50cyh7dXNlcklkOnVzZXIuX2lkLCBjb21wYW55SWQ6IHJlcS51c2VyLmNvbXBhbnlJZCwgY3JlYXRlZEF0OnsgJGd0ZTogdGhyZWVNb250aHNBZ28gfX0pXG4gICAgICAgIGNvbnN0IG1lc3NlbmdlckNvdW50ID0gYXdhaXQgZGIud2hhdHNhcHAuY291bnREb2N1bWVudHMoe3VzZXJJZDp1c2VyLl9pZCwgY29tcGFueUlkOiByZXEudXNlci5jb21wYW55SWQsIGNyZWF0ZWRBdDp7ICRndGU6IHRocmVlTW9udGhzQWdvIH19KS5zb3J0KHsgY3JlYXRlZEF0OiAxIH0pLnNlbGVjdCgnZnJvbSBwaG9uZU51bWJlciBzZW5kZXIgY3JlYXRlZEF0IHN0YXR1cyByZXN1bHQgbWVzc2FnZVN1bW1hcnkgLV9pZCcpXG4gICAgICAgIGNvbnN0IGlzQWRtaW4gPSBhd2FpdCBkYi5BZG1pbi5maW5kT25lKHtlbWFpbCwgY29tcGFueUlkOiByZXEudXNlci5jb21wYW55SWR9KVxuXG4gICAgICAgIGNvbnN0IHRvdGFsTWFpbHMgPSBhd2FpdCBkYi5SZXBvcnRlZE1haWwuY291bnREb2N1bWVudHMoeyB1c2VySWQ6dXNlci5faWQsIGNvbXBhbnlJZDogcmVxLnVzZXIuY29tcGFueUlkIH0pXG4gICAgICAgIGNvbnN0IGRlbGV0ZWRNYWlscyA9IGF3YWl0IGRiLlJlcG9ydGVkTWFpbC5jb3VudERvY3VtZW50cyh7IHVzZXJJZDp1c2VyLl9pZCwgY29tcGFueUlkOiByZXEudXNlci5jb21wYW55SWQsIGlzRGVsZXRlZEVtYWlsOiB0cnVlfSlcbiAgICAgICAgY29uc3QgdHJhc2hlZE1haWxzID0gYXdhaXQgZGIuUmVwb3J0ZWRNYWlsLmNvdW50RG9jdW1lbnRzKHsgdXNlcklkOnVzZXIuX2lkLCBjb21wYW55SWQ6IHJlcS51c2VyLmNvbXBhbnlJZCwgaXNUcmFzaGVkRW1haWw6IHRydWV9KVxuICAgICAgICBjb25zdCByZWNvdmVyZWRNYWlscyA9IGF3YWl0IGRiLlJlcG9ydGVkTWFpbC5jb3VudERvY3VtZW50cyh7IHVzZXJJZDp1c2VyLl9pZCwgY29tcGFueUlkOiByZXEudXNlci5jb21wYW55SWQsIGlzUmVjb3ZlcmVkRW1haWw6IHRydWV9KVxuICAgICAgICBjb25zdCBwZW5kaW5nTWFpbHMgPSBhd2FpdCBkYi5SZXBvcnRlZE1haWwuY291bnREb2N1bWVudHMoeyB1c2VySWQ6dXNlci5faWQsIGNvbXBhbnlJZDogcmVxLnVzZXIuY29tcGFueUlkLCBpc0RlbGV0ZWRFbWFpbDogZmFsc2UsIGlzVHJhc2hlZEVtYWlsOiBmYWxzZSwgaXNSZWNvdmVyZWRFbWFpbDogZmFsc2V9KVxuXG4gICAgICAgIGNvbnN0IHRvdGFsTWVzc2FnZXMgPSBhd2FpdCBkYi53aGF0c2FwcC5jb3VudERvY3VtZW50cyh7IHVzZXJJZDp1c2VyLl9pZCwgY29tcGFueUlkOiByZXEudXNlci5jb21wYW55SWQgfSlcbiAgICAgICAgY29uc3Qgc2FmZU1lc3NhZ2VzID0gYXdhaXQgZGIud2hhdHNhcHAuY291bnREb2N1bWVudHMoeyB1c2VySWQ6dXNlci5faWQsIGNvbXBhbnlJZDogcmVxLnVzZXIuY29tcGFueUlkLCByZXN1bHQ6ICdzYWZlJ30pXG4gICAgICAgIGNvbnN0IHVuc2FmZU1lc3NhZ2VzID0gYXdhaXQgZGIud2hhdHNhcHAuY291bnREb2N1bWVudHMoeyB1c2VySWQ6dXNlci5faWQsIGNvbXBhbnlJZDogcmVxLnVzZXIuY29tcGFueUlkLCByZXN1bHQ6ICd1bnNhZmUnfSlcbiAgICAgICAgY29uc3QgZHViaW91c01lc3NhZ2VzID0gYXdhaXQgZGIud2hhdHNhcHAuY291bnREb2N1bWVudHMoeyB1c2VySWQ6dXNlci5faWQsIGNvbXBhbnlJZDogcmVxLnVzZXIuY29tcGFueUlkLCByZXN1bHQ6ICdkdWJpb3VzJ30pXG4gICAgICAgIGNvbnN0IG5vQWRtaW5BY3Rpb25NZXNzYWdlcyA9IGF3YWl0IGRiLndoYXRzYXBwLmNvdW50RG9jdW1lbnRzKHsgdXNlcklkOnVzZXIuX2lkLCBjb21wYW55SWQ6IHJlcS51c2VyLmNvbXBhbnlJZCwgcmVzdWx0OiAnTm8gQWN0aW9uJ30pXG5cbiAgICAgICAgdmFyIHVzZXJTdGF0cyA9IHt9XG4gICAgICAgIHVzZXJTdGF0cy5uYW1lID0gdXNlci5uYW1lXG4gICAgICAgIHVzZXJTdGF0cy5lbWFpbCA9IHVzZXIuZW1haWxcbiAgICAgICAgdXNlclN0YXRzLnBob25lTnVtYmVyID0gdXNlci5waG9uZU51bWJlclxuICAgICAgICB1c2VyU3RhdHMuZW1haWxUeXBlID0gdXNlci5lbWFpbFR5cGUgXG4gICAgICAgIHVzZXJTdGF0cy5yb2xlID0gaXNBZG1pbiA/ICdBZG1pbicgOiAnTWVtYmVyJ1xuICAgICAgICB1c2VyU3RhdHMuaXNBY3RpdmUgPSB1c2VyLmlzQWN0aXZlIFxuICAgICAgICB1c2VyU3RhdHMudG90YWxNYWlscyA9IHRvdGFsTWFpbHNcbiAgICAgICAgdXNlclN0YXRzLmRlbGV0ZWRNYWlscyA9IGRlbGV0ZWRNYWlsc1xuICAgICAgICB1c2VyU3RhdHMudHJhc2hlZE1haWxzID0gdHJhc2hlZE1haWxzXG4gICAgICAgIHVzZXJTdGF0cy5yZWNvdmVyZWRNYWlscyA9IHJlY292ZXJlZE1haWxzXG4gICAgICAgIHVzZXJTdGF0cy5wZW5kaW5nTWFpbHMgPSBwZW5kaW5nTWFpbHNcbiAgICAgICAgdXNlclN0YXRzLnNjb3JlID0gZGVsZXRlZE1haWxzIT0gMCA/IGNhbGN1bGF0ZVBlcmNlbnRhZ2UoZGVsZXRlZE1haWxzICwgdG90YWxNYWlscykgOiAwXG4gICAgICAgIHVzZXJTdGF0cy5tZXNzZW5nZXJTY29yZSA9IHVuc2FmZU1lc3NhZ2VzIT0wID8gY2FsY3VsYXRlUGVyY2VudGFnZSh1bnNhZmVNZXNzYWdlcyAsIHRvdGFsTWVzc2FnZXMpIDogMFxuXG4gICAgICAgIGxldCByZXBvcnRlZE1haWxzV2l0aENvdW50ID0gcmVwb3J0ZWRNYWlscy5sZW5ndGggPyBnZXRSZXBvcnRlZE1haWxzV2l0aENvdW50KFRvdGFscmVwb3J0ZWRNYWlscykgOiB7bWFpbHM6W10sIGxhdGVzdERhdGU6Jyd9XG4gICAgICAgIGxldCByZXBvcnRlZE1lc3NhZ2VzV2l0aENvdW50ID0gcmVwb3J0ZWRNZXNzYWdlcy5sZW5ndGggPyBnZXRSZXBvcnRlZE1haWxzV2l0aENvdW50KFRvdGFsUnBvcnRlZE1lc3NhZ2VzKSA6IHttYWlsczpbXSwgbGF0ZXN0RGF0ZTonJ31cbiAgICAgICAgdXNlclN0YXRzLnJlcG9ydGVkTWFpbHNXaXRoQ291bnQgPSByZXBvcnRlZE1haWxzV2l0aENvdW50Lm1haWxzXG4gICAgICAgIHVzZXJTdGF0cy5yZXBvcnRlZE1lc3NhZ2VzV2l0aENvdW50ID0gcmVwb3J0ZWRNZXNzYWdlc1dpdGhDb3VudC5tYWlsc1xuXG4gICAgICAgIHVzZXJTdGF0cy5sYXN0QWN0aXZlID0gcmVwb3J0ZWRNYWlsc1dpdGhDb3VudC5sYXRlc3REYXRlID09ICcnID8gXCJObyBtYWlsIHJlcG9ydGVkIHlldC5cIiA6IHJlcG9ydGVkTWFpbHNXaXRoQ291bnQubGF0ZXN0RGF0ZVxuICAgICAgICB1c2VyU3RhdHMubGFzdEFjdGl2ZU1lc3NlbmdlciA9IHJlcG9ydGVkTWVzc2FnZXNXaXRoQ291bnQubGF0ZXN0RGF0ZSA9PSAnJyA/IFwiTm8gbWVzc2FnZSByZXBvcnRlZCB5ZXQuXCIgOiByZXBvcnRlZE1lc3NhZ2VzV2l0aENvdW50LmxhdGVzdERhdGVcblxuICAgICAgICB1c2VyU3RhdHMuc2FmZU1lc3NhZ2VzID0gc2FmZU1lc3NhZ2VzXG4gICAgICAgIHVzZXJTdGF0cy51bnNhZmVNZXNzYWdlcyA9IHVuc2FmZU1lc3NhZ2VzXG4gICAgICAgIHVzZXJTdGF0cy50b3RhbE1lc3NhZ2VzID0gdG90YWxNZXNzYWdlc1xuICAgICAgICB1c2VyU3RhdHMuZHViaW91c01lc3NhZ2VzID0gZHViaW91c01lc3NhZ2VzXG4gICAgICAgIHVzZXJTdGF0cy5ub0FkbWluQWN0aW9uTWVzc2FnZXMgPSBub0FkbWluQWN0aW9uTWVzc2FnZXNcbiAgICAgICAgdXNlclN0YXRzLmlzQWN0aXZlTWVzc2VuZ2VyID0gdXNlci5pc0FjdGl2ZU1lc3NlbmdlclxuXG4gICAgICAgIHJldHVybiByZXMuc3RhdHVzKDIwMCkuc2VuZCh7IHN1Y2Nlc3M6IHRydWUsIHVzZXJTdGF0cywgcmVwb3J0ZWRNYWlscywgcmVwb3J0ZWRNZXNzYWdlcywgY291bnQsIG1lc3NlbmdlckNvdW50IH0pXG5cbiAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgICBjb25zb2xlLmxvZygnZXJyb3InLCBlcnJvcik7XG4gICAgICAgIG5leHQoZXJyb3IpXG4gICAgfVxufVxuXG5jb25zdCBhcGlSb3V0ZXIgPSBleHByZXNzLlJvdXRlcigpO1xuXG5hcGlSb3V0ZXIucm91dGUoJy8nKS5wb3N0KGh0bWxzYW5pdGl6ZSgpLCBqd3RTdHJhdGVneSwgcmVzdHJpY3RGZWF0dXJlKFwiVFBJUi1VQVNcIiksIGNoZWNrQ29tcGFueVZhbGlkaXR5U3RyYXRlZ3ksIHBlcm1pc3Npb24oJ1VzZXJzJywgJ1JlYWQnKSwgXG4vLyB2YWxpZGF0ZUJvZHkodmFsaWRhdG9yKSxcbiBjb250cm9sbGVyKTtcbmV4cG9ydCBkZWZhdWx0IGFwaVJvdXRlcjsiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7QUFBQTtBQUNBO0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUVBLElBQU1BLFNBQVMsR0FBR0MsZUFBRyxDQUFDQyxNQUFNLEVBQUUsQ0FBQ0MsSUFBSSxDQUFDO0VBQ2hDQyxLQUFLLEVBQUVILGVBQUcsQ0FBQ0ksTUFBTSxFQUFFLENBQUNDLFFBQVEsRUFBRTtFQUM5QkMsSUFBSSxFQUFFTixlQUFHLENBQUNPLE1BQU0sRUFBRSxDQUFDQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUNILFFBQVEsRUFBRTtFQUNwQ0ksS0FBSyxFQUFFVCxlQUFHLENBQUNPLE1BQU0sRUFBRSxDQUFDQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUNILFFBQVEsRUFBRTtFQUNyQ0ssUUFBUSxFQUFFVixlQUFHLENBQUNJLE1BQU0sRUFBRSxDQUFDTyxHQUFHLEVBQUUsQ0FBQ0MsTUFBTSxDQUFDLEVBQUUsQ0FBQyxDQUFDQyxRQUFRO0FBRXBELENBQUMsQ0FBQzs7QUFFRjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxJQUFNQyx5QkFBeUIsR0FBRyxTQUE1QkEseUJBQXlCLENBQUlDLGFBQWEsRUFBSztFQUNqRCxJQUFNQyxZQUFZLEdBQUcsQ0FBQyxDQUFDO0VBQ3ZCRCxhQUFhLENBQUNFLE9BQU8sQ0FBQyxVQUFBZCxLQUFLLEVBQUk7SUFDN0IsSUFBTWUsSUFBSSxHQUFHLElBQUlDLElBQUksQ0FBQ2hCLEtBQUssQ0FBQ2lCLFNBQVMsQ0FBQztJQUN0QyxJQUFJLENBQUNDLFdBQVcsQ0FBQ0gsSUFBSSxDQUFDLEVBQUU7TUFDdEIsT0FBTyxDQUFDO0lBQ1Y7O0lBQ0EsSUFBTUksYUFBYSxHQUFHSixJQUFJLENBQUNLLFdBQVcsRUFBRSxDQUFDQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQzs7SUFFeEQsSUFBSVIsWUFBWSxDQUFDTSxhQUFhLENBQUMsRUFBRTtNQUMvQk4sWUFBWSxDQUFDTSxhQUFhLENBQUMsRUFBRTtJQUMvQixDQUFDLE1BQU07TUFDTE4sWUFBWSxDQUFDTSxhQUFhLENBQUMsR0FBRyxDQUFDO0lBQ2pDO0VBQ0YsQ0FBQyxDQUFDOztFQUVGO0VBQ0EsSUFBTUcsWUFBWSxHQUFHLElBQUlOLElBQUksRUFBRSxDQUFDTyxRQUFRLENBQUMsSUFBSVAsSUFBSSxFQUFFLENBQUNRLFFBQVEsRUFBRSxHQUFHLENBQUMsQ0FBQztFQUNuRSxJQUFNQyxVQUFVLEdBQUcsSUFBSVQsSUFBSSxFQUFFO0VBQzdCLElBQU1VLFNBQVMsR0FBR0MsWUFBWSxDQUFDTCxZQUFZLEVBQUVHLFVBQVUsQ0FBQzs7RUFFeEQ7RUFDQSxJQUFNRyxNQUFNLEdBQUcsQ0FBQyxDQUFDO0VBQ2pCLElBQUlDLGVBQWUsR0FBRyxJQUFJO0VBRTFCSCxTQUFTLENBQUNaLE9BQU8sQ0FBQyxVQUFBQyxJQUFJLEVBQUk7SUFDeEIsSUFBTUksYUFBYSxHQUFHSixJQUFJLENBQUNLLFdBQVcsRUFBRSxDQUFDQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ3RETyxNQUFNLENBQUNULGFBQWEsQ0FBQyxHQUFHTixZQUFZLENBQUNNLGFBQWEsQ0FBQyxJQUFJLENBQUM7O0lBRTFEO0lBQ0E7SUFDQTtJQUNBO0lBQ0E7RUFDQSxDQUFDLENBQUM7O0VBQ0YsSUFBTVcsS0FBSyxHQUFHQyxNQUFNLENBQUNDLE9BQU8sQ0FBQ0osTUFBTSxDQUFDLENBQUNLLEdBQUcsQ0FBQyxnQkFBbUI7SUFBQTtNQUFqQmxCLElBQUk7TUFBRW1CLEtBQUs7SUFDcEQsSUFBTUMsYUFBYSxHQUFHLElBQUluQixJQUFJLENBQUNELElBQUksQ0FBQyxDQUFDcUIsT0FBTyxFQUFFLENBQUMsQ0FBQztJQUNoRCxPQUFPLENBQUNELGFBQWEsRUFBRUQsS0FBSyxDQUFDO0VBQy9CLENBQUMsQ0FBQztFQUVGLElBQU1HLEtBQUssR0FBR04sTUFBTSxDQUFDaEMsSUFBSSxDQUFDNkIsTUFBTSxDQUFDO0VBQ2pDLElBQU1VLG1CQUFtQixHQUFHRCxLQUFLLENBQUNBLEtBQUssQ0FBQzVCLE1BQU0sR0FBRyxDQUFDLENBQUM7RUFDbkQsT0FBTztJQUFFcUIsS0FBSyxFQUFMQSxLQUFLO0lBQUVMLFVBQVUsRUFBRWE7RUFBb0IsQ0FBQztBQUNuRCxDQUFDOztBQUVEO0FBQ0EsU0FBU3BCLFdBQVcsQ0FBQ3FCLENBQUMsRUFBRTtFQUN0QixPQUFPQSxDQUFDLFlBQVl2QixJQUFJLElBQUksQ0FBQ3dCLEtBQUssQ0FBQ0QsQ0FBQyxDQUFDO0FBQ3ZDOztBQUVBO0FBQ0EsU0FBU1osWUFBWSxDQUFDYyxTQUFTLEVBQUVDLE9BQU8sRUFBRTtFQUN4QyxJQUFNaEIsU0FBUyxHQUFHLEVBQUU7RUFFcEIsSUFBSWlCLFdBQVcsR0FBRyxJQUFJM0IsSUFBSSxDQUFDeUIsU0FBUyxDQUFDO0VBQ3JDLE9BQU9FLFdBQVcsQ0FBQ3ZCLFdBQVcsRUFBRSxDQUFDQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUlxQixPQUFPLENBQUN0QixXQUFXLEVBQUUsQ0FBQ0MsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0lBQ3JGSyxTQUFTLENBQUNrQixJQUFJLENBQUMsSUFBSTVCLElBQUksQ0FBQzJCLFdBQVcsQ0FBQyxDQUFDO0lBQ3JDQSxXQUFXLENBQUNFLE9BQU8sQ0FBQ0YsV0FBVyxDQUFDRyxPQUFPLEVBQUUsR0FBRyxDQUFDLENBQUM7SUFBQztFQUNqRDtFQUNBLE9BQU9wQixTQUFTO0FBQ2xCO0FBRUEsSUFBTXFCLG1CQUFtQixHQUFHLFNBQXRCQSxtQkFBbUIsQ0FBSUMsWUFBWSxFQUFFQyxVQUFVLEVBQUk7RUFDbkQsSUFBSUEsVUFBVSxLQUFLLENBQUMsRUFBRTtJQUNwQixPQUFPLENBQUNELFlBQVksR0FBR0MsVUFBVSxHQUFHLEdBQUcsRUFBRUMsT0FBTyxDQUFDLENBQUMsQ0FBQztFQUNyRCxDQUFDLE1BQU0sSUFBSUQsVUFBVSxLQUFLLENBQUMsRUFBRTtJQUN6QixPQUFPLENBQUM7RUFDWixDQUFDLE1BQU07SUFDSCxPQUFPLENBQUM7RUFDWjtBQUNOLENBQUM7QUFHSCxJQUFNRSxVQUFVO0VBQUEsMEZBQUcsaUJBQU9DLEdBQUcsRUFBRUMsR0FBRyxFQUFFQyxJQUFJO0lBQUE7SUFBQTtNQUFBO1FBQUE7VUFBQTtVQUFBLFlBRVlGLEdBQUcsQ0FBQ0csSUFBSSxFQUE1Q3ZELEtBQUssYUFBTEEsS0FBSyxFQUFFRyxJQUFJLGFBQUpBLElBQUksRUFBRUcsS0FBSyxhQUFMQSxLQUFLLEVBQUVrRCxXQUFXLGFBQVhBLFdBQVc7VUFBQSxLQUdwQ3hELEtBQUs7WUFBQTtZQUFBO1VBQUE7VUFBQTtVQUFBLE9BQWV5RCxFQUFFLENBQUNDLElBQUksQ0FBQ0MsT0FBTyxDQUFDO1lBQUMzRCxLQUFLLEVBQUxBLEtBQUs7WUFBRTRELFNBQVMsRUFBRVIsR0FBRyxDQUFDUyxJQUFJLENBQUNEO1VBQVMsQ0FBQyxDQUFDLENBQUNFLE1BQU0sQ0FBQyxpREFBaUQsQ0FBQztRQUFBO1VBQTlIRCxJQUFJO1FBQUE7VUFBQSxNQUNYLENBQUM3RCxLQUFLLElBQUl3RCxXQUFXLElBQUksSUFBSTtZQUFBO1lBQUE7VUFBQTtVQUFBO1VBQUEsT0FBZUMsRUFBRSxDQUFDQyxJQUFJLENBQUNDLE9BQU8sQ0FBQztZQUFDSCxXQUFXLEVBQVhBLFdBQVc7WUFBRUksU0FBUyxFQUFFUixHQUFHLENBQUNTLElBQUksQ0FBQ0Q7VUFBUyxDQUFDLENBQUMsQ0FBQ0UsTUFBTSxDQUFDLGlEQUFpRCxDQUFDO1FBQUE7VUFBcElELElBQUk7UUFBQTtVQUFBLElBRWxDQSxJQUFJO1lBQUE7WUFBQTtVQUFBO1VBQUEsTUFBUSxJQUFJRSxZQUFZLENBQUMsaUJBQWlCLENBQUM7UUFBQTtVQUU3Q0MsY0FBYyxHQUFHLElBQUloRCxJQUFJLEVBQUU7VUFDakNnRCxjQUFjLENBQUN6QyxRQUFRLENBQUN5QyxjQUFjLENBQUN4QyxRQUFRLEVBQUUsR0FBRyxDQUFDLENBQUM7VUFBQztVQUFBLE9BRTNCaUMsRUFBRSxDQUFDUSxZQUFZLENBQUNDLElBQUksQ0FBQztZQUFDQyxNQUFNLEVBQUNOLElBQUksQ0FBQ08sR0FBRztZQUFFUixTQUFTLEVBQUVSLEdBQUcsQ0FBQ1MsSUFBSSxDQUFDRCxTQUFTO1lBQUUzQyxTQUFTLEVBQUM7Y0FBRW9ELElBQUksRUFBRUw7WUFBZTtVQUFDLENBQUMsQ0FBQyxDQUFDTSxJQUFJLENBQUM7WUFBRXJELFNBQVMsRUFBRSxDQUFDO1VBQUUsQ0FBQyxDQUFDLENBQUM2QyxNQUFNLENBQUMsc0ZBQXNGLENBQUMsQ0FDNVBTLElBQUksQ0FBQyxDQUFDcEUsSUFBSSxHQUFDLENBQUMsSUFBRUcsS0FBSyxDQUFDLENBQ3BCQSxLQUFLLENBQUNBLEtBQUssQ0FBQztRQUFBO1VBRlBNLGFBQWE7VUFBQTtVQUFBLE9BSVk2QyxFQUFFLENBQUNlLFFBQVEsQ0FBQ04sSUFBSSxDQUFDO1lBQUNDLE1BQU0sRUFBQ04sSUFBSSxDQUFDTyxHQUFHO1lBQUVSLFNBQVMsRUFBRVIsR0FBRyxDQUFDUyxJQUFJLENBQUNELFNBQVM7WUFBRTNDLFNBQVMsRUFBQztjQUFFb0QsSUFBSSxFQUFFTDtZQUFlO1VBQUMsQ0FBQyxDQUFDLENBQUNNLElBQUksQ0FBQztZQUFFckQsU0FBUyxFQUFFLENBQUM7VUFBRSxDQUFDLENBQUMsQ0FBQzZDLE1BQU0sQ0FBQyxxRUFBcUUsQ0FBQyxDQUMxT1MsSUFBSSxDQUFDLENBQUNwRSxJQUFJLEdBQUMsQ0FBQyxJQUFFRyxLQUFLLENBQUMsQ0FDcEJBLEtBQUssQ0FBQ0EsS0FBSyxDQUFDO1FBQUE7VUFGUG1FLGdCQUFnQjtVQUFBO1VBQUEsT0FLV2hCLEVBQUUsQ0FBQ1EsWUFBWSxDQUFDQyxJQUFJLENBQUM7WUFBQ0MsTUFBTSxFQUFDTixJQUFJLENBQUNPLEdBQUc7WUFBRVIsU0FBUyxFQUFFUixHQUFHLENBQUNTLElBQUksQ0FBQ0QsU0FBUztZQUFFM0MsU0FBUyxFQUFDO2NBQUVvRCxJQUFJLEVBQUVMO1lBQWU7VUFBQyxDQUFDLENBQUMsQ0FBQ00sSUFBSSxDQUFDO1lBQUVyRCxTQUFTLEVBQUU7VUFBRSxDQUFDLENBQUMsQ0FBQzZDLE1BQU0sQ0FBQyxzRkFBc0YsQ0FBQztRQUFBO1VBQTNQWSxrQkFBa0I7VUFBQTtVQUFBLE9BQ1dqQixFQUFFLENBQUNlLFFBQVEsQ0FBQ04sSUFBSSxDQUFDO1lBQUNDLE1BQU0sRUFBQ04sSUFBSSxDQUFDTyxHQUFHO1lBQUVSLFNBQVMsRUFBRVIsR0FBRyxDQUFDUyxJQUFJLENBQUNELFNBQVM7WUFBRTNDLFNBQVMsRUFBQztjQUFFb0QsSUFBSSxFQUFFTDtZQUFlO1VBQUMsQ0FBQyxDQUFDLENBQUNNLElBQUksQ0FBQztZQUFFckQsU0FBUyxFQUFFO1VBQUUsQ0FBQyxDQUFDLENBQUM2QyxNQUFNLENBQUMscUVBQXFFLENBQUM7UUFBQTtVQUF4T2Esb0JBQW9CO1VBQUE7VUFBQSxPQUNObEIsRUFBRSxDQUFDUSxZQUFZLENBQUNXLGNBQWMsQ0FBQztZQUFDVCxNQUFNLEVBQUNOLElBQUksQ0FBQ08sR0FBRztZQUFFUixTQUFTLEVBQUVSLEdBQUcsQ0FBQ1MsSUFBSSxDQUFDRCxTQUFTO1lBQUUzQyxTQUFTLEVBQUM7Y0FBRW9ELElBQUksRUFBRUw7WUFBZTtVQUFDLENBQUMsQ0FBQztRQUFBO1VBQWxJOUIsS0FBSztVQUFBO1VBQUEsT0FDa0J1QixFQUFFLENBQUNlLFFBQVEsQ0FBQ0ksY0FBYyxDQUFDO1lBQUNULE1BQU0sRUFBQ04sSUFBSSxDQUFDTyxHQUFHO1lBQUVSLFNBQVMsRUFBRVIsR0FBRyxDQUFDUyxJQUFJLENBQUNELFNBQVM7WUFBRTNDLFNBQVMsRUFBQztjQUFFb0QsSUFBSSxFQUFFTDtZQUFlO1VBQUMsQ0FBQyxDQUFDLENBQUNNLElBQUksQ0FBQztZQUFFckQsU0FBUyxFQUFFO1VBQUUsQ0FBQyxDQUFDLENBQUM2QyxNQUFNLENBQUMscUVBQXFFLENBQUM7UUFBQTtVQUE1T2UsY0FBYztVQUFBO1VBQUEsT0FDRXBCLEVBQUUsQ0FBQ3FCLEtBQUssQ0FBQ25CLE9BQU8sQ0FBQztZQUFDM0QsS0FBSyxFQUFMQSxLQUFLO1lBQUU0RCxTQUFTLEVBQUVSLEdBQUcsQ0FBQ1MsSUFBSSxDQUFDRDtVQUFTLENBQUMsQ0FBQztRQUFBO1VBQXhFbUIsT0FBTztVQUFBO1VBQUEsT0FFWXRCLEVBQUUsQ0FBQ1EsWUFBWSxDQUFDVyxjQUFjLENBQUM7WUFBRVQsTUFBTSxFQUFDTixJQUFJLENBQUNPLEdBQUc7WUFBRVIsU0FBUyxFQUFFUixHQUFHLENBQUNTLElBQUksQ0FBQ0Q7VUFBVSxDQUFDLENBQUM7UUFBQTtVQUFyR1gsVUFBVTtVQUFBO1VBQUEsT0FDV1EsRUFBRSxDQUFDUSxZQUFZLENBQUNXLGNBQWMsQ0FBQztZQUFFVCxNQUFNLEVBQUNOLElBQUksQ0FBQ08sR0FBRztZQUFFUixTQUFTLEVBQUVSLEdBQUcsQ0FBQ1MsSUFBSSxDQUFDRCxTQUFTO1lBQUVvQixjQUFjLEVBQUU7VUFBSSxDQUFDLENBQUM7UUFBQTtVQUE1SGhDLFlBQVk7VUFBQTtVQUFBLE9BQ1NTLEVBQUUsQ0FBQ1EsWUFBWSxDQUFDVyxjQUFjLENBQUM7WUFBRVQsTUFBTSxFQUFDTixJQUFJLENBQUNPLEdBQUc7WUFBRVIsU0FBUyxFQUFFUixHQUFHLENBQUNTLElBQUksQ0FBQ0QsU0FBUztZQUFFcUIsY0FBYyxFQUFFO1VBQUksQ0FBQyxDQUFDO1FBQUE7VUFBNUhDLFlBQVk7VUFBQTtVQUFBLE9BQ1d6QixFQUFFLENBQUNRLFlBQVksQ0FBQ1csY0FBYyxDQUFDO1lBQUVULE1BQU0sRUFBQ04sSUFBSSxDQUFDTyxHQUFHO1lBQUVSLFNBQVMsRUFBRVIsR0FBRyxDQUFDUyxJQUFJLENBQUNELFNBQVM7WUFBRXVCLGdCQUFnQixFQUFFO1VBQUksQ0FBQyxDQUFDO1FBQUE7VUFBaElDLGNBQWM7VUFBQTtVQUFBLE9BQ08zQixFQUFFLENBQUNRLFlBQVksQ0FBQ1csY0FBYyxDQUFDO1lBQUVULE1BQU0sRUFBQ04sSUFBSSxDQUFDTyxHQUFHO1lBQUVSLFNBQVMsRUFBRVIsR0FBRyxDQUFDUyxJQUFJLENBQUNELFNBQVM7WUFBRW9CLGNBQWMsRUFBRSxLQUFLO1lBQUVDLGNBQWMsRUFBRSxLQUFLO1lBQUVFLGdCQUFnQixFQUFFO1VBQUssQ0FBQyxDQUFDO1FBQUE7VUFBN0tFLFlBQVk7VUFBQTtVQUFBLE9BRVU1QixFQUFFLENBQUNlLFFBQVEsQ0FBQ0ksY0FBYyxDQUFDO1lBQUVULE1BQU0sRUFBQ04sSUFBSSxDQUFDTyxHQUFHO1lBQUVSLFNBQVMsRUFBRVIsR0FBRyxDQUFDUyxJQUFJLENBQUNEO1VBQVUsQ0FBQyxDQUFDO1FBQUE7VUFBcEcwQixhQUFhO1VBQUE7VUFBQSxPQUNRN0IsRUFBRSxDQUFDZSxRQUFRLENBQUNJLGNBQWMsQ0FBQztZQUFFVCxNQUFNLEVBQUNOLElBQUksQ0FBQ08sR0FBRztZQUFFUixTQUFTLEVBQUVSLEdBQUcsQ0FBQ1MsSUFBSSxDQUFDRCxTQUFTO1lBQUVoQyxNQUFNLEVBQUU7VUFBTSxDQUFDLENBQUM7UUFBQTtVQUFsSDJELFlBQVk7VUFBQTtVQUFBLE9BQ1c5QixFQUFFLENBQUNlLFFBQVEsQ0FBQ0ksY0FBYyxDQUFDO1lBQUVULE1BQU0sRUFBQ04sSUFBSSxDQUFDTyxHQUFHO1lBQUVSLFNBQVMsRUFBRVIsR0FBRyxDQUFDUyxJQUFJLENBQUNELFNBQVM7WUFBRWhDLE1BQU0sRUFBRTtVQUFRLENBQUMsQ0FBQztRQUFBO1VBQXRINEQsY0FBYztVQUFBO1VBQUEsT0FDVS9CLEVBQUUsQ0FBQ2UsUUFBUSxDQUFDSSxjQUFjLENBQUM7WUFBRVQsTUFBTSxFQUFDTixJQUFJLENBQUNPLEdBQUc7WUFBRVIsU0FBUyxFQUFFUixHQUFHLENBQUNTLElBQUksQ0FBQ0QsU0FBUztZQUFFaEMsTUFBTSxFQUFFO1VBQVMsQ0FBQyxDQUFDO1FBQUE7VUFBeEg2RCxlQUFlO1VBQUE7VUFBQSxPQUNlaEMsRUFBRSxDQUFDZSxRQUFRLENBQUNJLGNBQWMsQ0FBQztZQUFFVCxNQUFNLEVBQUNOLElBQUksQ0FBQ08sR0FBRztZQUFFUixTQUFTLEVBQUVSLEdBQUcsQ0FBQ1MsSUFBSSxDQUFDRCxTQUFTO1lBQUVoQyxNQUFNLEVBQUU7VUFBVyxDQUFDLENBQUM7UUFBQTtVQUFoSThELHFCQUFxQjtVQUV2QkMsU0FBUyxHQUFHLENBQUMsQ0FBQztVQUNsQkEsU0FBUyxDQUFDQyxJQUFJLEdBQUcvQixJQUFJLENBQUMrQixJQUFJO1VBQzFCRCxTQUFTLENBQUMzRixLQUFLLEdBQUc2RCxJQUFJLENBQUM3RCxLQUFLO1VBQzVCMkYsU0FBUyxDQUFDbkMsV0FBVyxHQUFHSyxJQUFJLENBQUNMLFdBQVc7VUFDeENtQyxTQUFTLENBQUNFLFNBQVMsR0FBR2hDLElBQUksQ0FBQ2dDLFNBQVM7VUFDcENGLFNBQVMsQ0FBQ0csSUFBSSxHQUFHZixPQUFPLEdBQUcsT0FBTyxHQUFHLFFBQVE7VUFDN0NZLFNBQVMsQ0FBQ0ksUUFBUSxHQUFHbEMsSUFBSSxDQUFDa0MsUUFBUTtVQUNsQ0osU0FBUyxDQUFDMUMsVUFBVSxHQUFHQSxVQUFVO1VBQ2pDMEMsU0FBUyxDQUFDM0MsWUFBWSxHQUFHQSxZQUFZO1VBQ3JDMkMsU0FBUyxDQUFDVCxZQUFZLEdBQUdBLFlBQVk7VUFDckNTLFNBQVMsQ0FBQ1AsY0FBYyxHQUFHQSxjQUFjO1VBQ3pDTyxTQUFTLENBQUNOLFlBQVksR0FBR0EsWUFBWTtVQUNyQ00sU0FBUyxDQUFDSyxLQUFLLEdBQUdoRCxZQUFZLElBQUcsQ0FBQyxHQUFHRCxtQkFBbUIsQ0FBQ0MsWUFBWSxFQUFHQyxVQUFVLENBQUMsR0FBRyxDQUFDO1VBQ3ZGMEMsU0FBUyxDQUFDTSxjQUFjLEdBQUdULGNBQWMsSUFBRSxDQUFDLEdBQUd6QyxtQkFBbUIsQ0FBQ3lDLGNBQWMsRUFBR0YsYUFBYSxDQUFDLEdBQUcsQ0FBQztVQUVsR1ksc0JBQXNCLEdBQUd0RixhQUFhLENBQUNILE1BQU0sR0FBR0UseUJBQXlCLENBQUMrRCxrQkFBa0IsQ0FBQyxHQUFHO1lBQUM1QyxLQUFLLEVBQUMsRUFBRTtZQUFFTCxVQUFVLEVBQUM7VUFBRSxDQUFDO1VBQ3pIMEUseUJBQXlCLEdBQUcxQixnQkFBZ0IsQ0FBQ2hFLE1BQU0sR0FBR0UseUJBQXlCLENBQUNnRSxvQkFBb0IsQ0FBQyxHQUFHO1lBQUM3QyxLQUFLLEVBQUMsRUFBRTtZQUFFTCxVQUFVLEVBQUM7VUFBRSxDQUFDO1VBQ3JJa0UsU0FBUyxDQUFDTyxzQkFBc0IsR0FBR0Esc0JBQXNCLENBQUNwRSxLQUFLO1VBQy9ENkQsU0FBUyxDQUFDUSx5QkFBeUIsR0FBR0EseUJBQXlCLENBQUNyRSxLQUFLO1VBRXJFNkQsU0FBUyxDQUFDUyxVQUFVLEdBQUdGLHNCQUFzQixDQUFDekUsVUFBVSxJQUFJLEVBQUUsR0FBRyx1QkFBdUIsR0FBR3lFLHNCQUFzQixDQUFDekUsVUFBVTtVQUM1SGtFLFNBQVMsQ0FBQ1UsbUJBQW1CLEdBQUdGLHlCQUF5QixDQUFDMUUsVUFBVSxJQUFJLEVBQUUsR0FBRywwQkFBMEIsR0FBRzBFLHlCQUF5QixDQUFDMUUsVUFBVTtVQUU5SWtFLFNBQVMsQ0FBQ0osWUFBWSxHQUFHQSxZQUFZO1VBQ3JDSSxTQUFTLENBQUNILGNBQWMsR0FBR0EsY0FBYztVQUN6Q0csU0FBUyxDQUFDTCxhQUFhLEdBQUdBLGFBQWE7VUFDdkNLLFNBQVMsQ0FBQ0YsZUFBZSxHQUFHQSxlQUFlO1VBQzNDRSxTQUFTLENBQUNELHFCQUFxQixHQUFHQSxxQkFBcUI7VUFDdkRDLFNBQVMsQ0FBQ1csaUJBQWlCLEdBQUd6QyxJQUFJLENBQUN5QyxpQkFBaUI7VUFBQSxpQ0FFN0NqRCxHQUFHLENBQUNrRCxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUNDLElBQUksQ0FBQztZQUFFQyxPQUFPLEVBQUUsSUFBSTtZQUFFZCxTQUFTLEVBQVRBLFNBQVM7WUFBRS9FLGFBQWEsRUFBYkEsYUFBYTtZQUFFNkQsZ0JBQWdCLEVBQWhCQSxnQkFBZ0I7WUFBRXZDLEtBQUssRUFBTEEsS0FBSztZQUFFMkMsY0FBYyxFQUFkQTtVQUFlLENBQUMsQ0FBQztRQUFBO1VBQUE7VUFBQTtVQUdqSDZCLE9BQU8sQ0FBQ0MsR0FBRyxDQUFDLE9BQU8sY0FBUTtVQUMzQnJELElBQUksYUFBTztRQUFBO1FBQUE7VUFBQTtNQUFBO0lBQUE7RUFBQSxDQUVsQjtFQUFBLGdCQTVFS0gsVUFBVTtJQUFBO0VBQUE7QUFBQSxHQTRFZjtBQUVELElBQU15RCxTQUFTLEdBQUdDLG1CQUFPLENBQUNDLE1BQU0sRUFBRTtBQUVsQ0YsU0FBUyxDQUFDRyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUNDLElBQUksQ0FBQyxJQUFBQywwQkFBWSxHQUFFLEVBQUVDLHFCQUFXLEVBQUUsSUFBQUMsMEJBQWUsRUFBQyxVQUFVLENBQUMsRUFBRUMsc0NBQTRCLEVBQUUsSUFBQUMsc0JBQVUsRUFBQyxPQUFPLEVBQUUsTUFBTSxDQUFDO0FBQzdJO0FBQ0NsRSxVQUFVLENBQUM7QUFBQyxlQUNFeUQsU0FBUztBQUFBIn0=