"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _nodeSchedule = _interopRequireDefault(require("node-schedule"));
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _processUser = _interopRequireDefault(require("../../service/process-user"));
var _sanitizer = require("../../middlewares/sanitizer");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _credentials = _interopRequireDefault(require("../../service/credentials"));
var _axios = _interopRequireDefault(require("axios"));
var validator = _joi["default"].object().keys({
  domainId: _joi["default"].string().hex().length(24).required(),
  minute: _joi["default"].number().required(),
  hour: _joi["default"].number().required(),
  isActive: _joi["default"]["boolean"]().required(),
  timeZone: _joi["default"].string().required(),
  days: _joi["default"].array().required()
});

// Mapping object for day names to numeric values
var dayMapping = {
  All: 0,
  Monday: 1,
  Tuesday: 2,
  Wednesday: 3,
  Thursday: 4,
  Friday: 5,
  Saturday: 6,
  Sunday: 0
};
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, domainId, isActive, days, hour, minute, timeZone;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _req$body = req.body, domainId = _req$body.domainId, isActive = _req$body.isActive, days = _req$body.days, hour = _req$body.hour, minute = _req$body.minute, timeZone = _req$body.timeZone;
          _context.prev = 1;
          // const domain = await db.Domain.findOne({_id: domainId, deletedAt: null});
          // if (domain) var companyId = domain["companyId"];
          // if (!domain)
          //   throw new RequestError(
          //     "Domain does not exist or wrong domain id passed!",
          //     404
          //   );
          // if (domain && !domain.isVerified)
          //   throw new RequestError("Domain is not verified", 400);
          // if (domain && domain.isVerified && !domain.isCredential)
          //   throw new RequestError("Credentials are not uploaded", 400);
          // if (
          //   domain &&
          //   domain.isVerified &&
          //   domain.isCredential &&
          //   domain.isSyncingUser
          // )
          //   throw new RequestError(
          //     `Syncing Already in Progress for ${domain.domainName}. Kindly wait until syncing is completed!`,
          //     400
          //   );
          // await db.Domain.updateOne(
          //   { _id: domainId },
          //   {
          //     isScheduledSyncing: {
          //       isActive,
          //       daysOfWeek: days,
          //       hour: hour,
          //       minute: minute,
          //       timeZone: timeZone,
          //     },
          //   }
          // );

          // if (!isActive) return res.status(200).send({ success: true });

          // const transformedDays = days
          //   .filter((day) => day !== "All")
          //   .map((day) => dayMapping[day]);
          // console.log({ transformedDays });

          // const rule = new schedule.RecurrenceRule();
          // rule.hour = hour;
          // rule.minute = minute;
          // rule.dayOfWeek = transformedDays;
          // rule.tz = timeZone;

          // const scheduledJob = schedule.scheduleJob(domainId, rule, async () => {
          //   let deactivateUsers = await db.User.updateMany(
          //     { domainId, companyId, userId: { $ne: null } },
          //     { $set: { deletedAt: new Date() } }
          //   );
          //   if (domain.domainType == "Gsuite" || domain.domainType == "Outlook") {
          //     await db.Domain.updateOne(
          //       {
          //         _id: domainId,
          //       },
          //       {
          //         isSyncingUser: true,
          //         syncStartAt: new Date(),
          //       }
          //     );
          //     const creds = await credentials.getCredentials(companyId, domainId);
          //     // console.log("credssssssssssssssssssssssss", creds);
          //     let subDomainGroupsFromDb = await db.SubDomainGroup.find({ domainId });
          //     let subDomainGroups = subDomainGroupsFromDb.map((val) => {
          //       return val.groupName;
          //     });
          //     let groups = await db.UserGroup.find({ domainId });

          //     if (groups.length) {
          //       for (const group of groups) {
          //         await processUser.process(
          //           companyId,
          //           domain._id,
          //           domain.domainName,
          //           subDomainGroups,
          //           domain.domainType,
          //           false,
          //           domain.domainTypeForOutlook == "EXCHANGE",
          //           group.value,
          //           group.label,
          //           creds
          //         );
          //       }
          //     } else {
          //       await processUser.process(
          //         companyId,
          //         domain._id,
          //         domain.domainName,
          //         subDomainGroups,
          //         domain.domainType,
          //         false,
          //         domain.domainTypeForOutlook == "EXCHANGE",
          //         null,
          //         null,
          //         creds
          //       );
          //     }
          //   } else {
          //     await db.Domain.updateOne(
          //       {
          //         _id: domainId,
          //       },
          //       {
          //         isSyncingUser: false,
          //         isSyncingUserError: true,
          //         isSyncingUserErrorFile: "Domain type not define",
          //       }
          //     );
          //     throw new RequestError("Domain type not define");
          //   }
          // });
          res.status(200).send({
            success: true
          });
          _context.next = 11;
          break;
        case 5:
          _context.prev = 5;
          _context.t0 = _context["catch"](1);
          _context.next = 9;
          return db.Domain.updateOne({
            _id: domainId
          }, {
            isSyncingUser: false,
            isSyncingUserError: true,
            isSyncingUserErrorFile: JSON.stringify(_context.t0)
          });
        case 9:
          console.log("error", _context.t0);
          next(_context.t0);
        case 11:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[1, 5]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route("/").post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, _strategy.checkTaConnectionStrategy, (0, _permission.permission)("Users", "Write"), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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