"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _functions = require("../../functions");
var _sendWhatsappMessage = _interopRequireDefault(require("../../service/send-whatsapp-message"));
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var validator = _joi["default"].object().keys({
  messageId: _joi["default"].string().hex().length(24).required(),
  action: _joi["default"].string().required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, messageId, action, reportedMessage, message, preferedLanguage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, messageId = _req$body.messageId, action = _req$body.action;
          _context.next = 4;
          return db.whatsapp.findById(messageId);
        case 4:
          reportedMessage = _context.sent;
          reportedMessage.status = action;
          _context.next = 8;
          return reportedMessage.save();
        case 8:
          message = (0, _functions.cleanText)(reportedMessage.message);
          _context.next = 11;
          return db.Company.findOne({
            _id: reportedMessage.companyId
          }).select("whatsappLanguage");
        case 11:
          preferedLanguage = _context.sent;
          _sendWhatsappMessage["default"].sendMessage(reportedMessage.phoneNumberId, reportedMessage.ticketId, reportedMessage.phoneNumber, message, action, 'action', preferedLanguage === null || preferedLanguage === void 0 ? void 0 : preferedLanguage.whatsappLanguage).then(function (result) {
            console.log("Sent Message to User ----->", result);
          })["catch"](function (error) {
            console.error("Error sending message to user", error.response.data);
          });
          return _context.abrupt("return", res.status(201).send({
            success: true,
            Message: "Successfully Updated Status!"
          }));
        case 16:
          _context.prev = 16;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          return _context.abrupt("return", next(new RequestError(_context.t0)));
        case 20:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 16]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-WA"), _strategy.checkCompanyValidityStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJ2YWxpZGF0b3IiLCJKb2kiLCJvYmplY3QiLCJrZXlzIiwibWVzc2FnZUlkIiwic3RyaW5nIiwiaGV4IiwibGVuZ3RoIiwicmVxdWlyZWQiLCJhY3Rpb24iLCJjb250cm9sbGVyIiwicmVxIiwicmVzIiwibmV4dCIsImJvZHkiLCJkYiIsIndoYXRzYXBwIiwiZmluZEJ5SWQiLCJyZXBvcnRlZE1lc3NhZ2UiLCJzdGF0dXMiLCJzYXZlIiwibWVzc2FnZSIsImNsZWFuVGV4dCIsIkNvbXBhbnkiLCJmaW5kT25lIiwiX2lkIiwiY29tcGFueUlkIiwic2VsZWN0IiwicHJlZmVyZWRMYW5ndWFnZSIsIndoYXRzQXBwIiwic2VuZE1lc3NhZ2UiLCJwaG9uZU51bWJlcklkIiwidGlja2V0SWQiLCJwaG9uZU51bWJlciIsIndoYXRzYXBwTGFuZ3VhZ2UiLCJ0aGVuIiwicmVzdWx0IiwiY29uc29sZSIsImxvZyIsImVycm9yIiwicmVzcG9uc2UiLCJkYXRhIiwic2VuZCIsInN1Y2Nlc3MiLCJNZXNzYWdlIiwiUmVxdWVzdEVycm9yIiwiYXBpUm91dGVyIiwiZXhwcmVzcyIsIlJvdXRlciIsInJvdXRlIiwicG9zdCIsImh0bWxzYW5pdGl6ZSIsInZhbGlkYXRlQm9keSIsImp3dFN0cmF0ZWd5IiwicmVzdHJpY3RGZWF0dXJlIiwiY2hlY2tDb21wYW55VmFsaWRpdHlTdHJhdGVneSJdLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9hcGkvd2hhdHNhcHAvYWN0aW9uLmpzIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBKb2kgZnJvbSAnam9pJztcbmltcG9ydCBleHByZXNzIGZyb20gJ2V4cHJlc3MnO1xuXG5pbXBvcnQgeyBzYW5pdGl6ZSB9IGZyb20gJy4uLy4uL21pZGRsZXdhcmVzL3Nhbml0aXplcic7XG5pbXBvcnQgeyBjaGVja0NvbXBhbnlWYWxpZGl0eVN0cmF0ZWd5LCBqd3RTdHJhdGVneSB9IGZyb20gJy4uLy4uL21pZGRsZXdhcmVzL3N0cmF0ZWd5JztcbmltcG9ydCB7IHZhbGlkYXRlQm9keSB9IGZyb20gJy4uLy4uL21pZGRsZXdhcmVzL3ZhbGlkYXRvcic7XG5pbXBvcnQgeyBjbGVhblRleHQgfSBmcm9tICcuLi8uLi9mdW5jdGlvbnMnO1xuXG5pbXBvcnQgd2hhdHNBcHAgZnJvbSAnLi4vLi4vc2VydmljZS9zZW5kLXdoYXRzYXBwLW1lc3NhZ2UnO1xuaW1wb3J0IHsgaHRtbHNhbml0aXplIH0gZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvc2FuaXRpemVIdG1sJztcbmltcG9ydCByZXN0cmljdEZlYXR1cmUgZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvZmVhdHVyZUJsb2NrZXInO1xuXG5jb25zdCB2YWxpZGF0b3IgPSBKb2kub2JqZWN0KCkua2V5cyh7XG4gICAgbWVzc2FnZUlkOiBKb2kuc3RyaW5nKCkuaGV4KCkubGVuZ3RoKDI0KS5yZXF1aXJlZCgpLFxuICAgIGFjdGlvbjogSm9pLnN0cmluZygpLnJlcXVpcmVkKClcbn0pO1xuXG5cbmxldCBjb250cm9sbGVyID0gYXN5bmMgKHJlcSwgcmVzLCBuZXh0KSA9PiB7XG4gICAgdHJ5IHtcbiAgICAgICAgY29uc3QgeyBtZXNzYWdlSWQsIGFjdGlvbiB9ID0gcmVxLmJvZHlcbiAgICAgICAgY29uc3QgcmVwb3J0ZWRNZXNzYWdlID0gYXdhaXQgZGIud2hhdHNhcHAuZmluZEJ5SWQobWVzc2FnZUlkKTtcbiAgICAgICAgcmVwb3J0ZWRNZXNzYWdlLnN0YXR1cyA9IGFjdGlvblxuICAgICAgICBhd2FpdCByZXBvcnRlZE1lc3NhZ2Uuc2F2ZSgpXG5cbiAgICAgICAgbGV0IG1lc3NhZ2UgPSBjbGVhblRleHQocmVwb3J0ZWRNZXNzYWdlLm1lc3NhZ2UpXG4gICAgICAgIGNvbnN0IHByZWZlcmVkTGFuZ3VhZ2UgPSBhd2FpdCBkYi5Db21wYW55LmZpbmRPbmUoeyBfaWQ6IHJlcG9ydGVkTWVzc2FnZS5jb21wYW55SWQgfSkuc2VsZWN0KFwid2hhdHNhcHBMYW5ndWFnZVwiKTtcbiAgICAgICAgd2hhdHNBcHAuc2VuZE1lc3NhZ2UocmVwb3J0ZWRNZXNzYWdlLnBob25lTnVtYmVySWQsIHJlcG9ydGVkTWVzc2FnZS50aWNrZXRJZCwgcmVwb3J0ZWRNZXNzYWdlLnBob25lTnVtYmVyLCBtZXNzYWdlLCBhY3Rpb24gLCAnYWN0aW9uJywgcHJlZmVyZWRMYW5ndWFnZT8ud2hhdHNhcHBMYW5ndWFnZSlcbiAgICAgICAgLnRoZW4oKHJlc3VsdCkgPT4geyBjb25zb2xlLmxvZyhcIlNlbnQgTWVzc2FnZSB0byBVc2VyIC0tLS0tPlwiLCByZXN1bHQpfSlcbiAgICAgICAgLmNhdGNoKChlcnJvcikgPT4geyBjb25zb2xlLmVycm9yKFwiRXJyb3Igc2VuZGluZyBtZXNzYWdlIHRvIHVzZXJcIixlcnJvci5yZXNwb25zZS5kYXRhKX0pO1xuXG4gICAgICAgIHJldHVybiByZXMuc3RhdHVzKDIwMSkuc2VuZCh7IHN1Y2Nlc3M6IHRydWUsIE1lc3NhZ2U6IFwiU3VjY2Vzc2Z1bGx5IFVwZGF0ZWQgU3RhdHVzIVwiIH0pXG5cbiAgICB9IGNhdGNoIChlcnJvcikgeyBcbiAgICAgICAgY29uc29sZS5sb2coZXJyb3IpO1xuICAgICAgICByZXR1cm4gbmV4dChuZXcgUmVxdWVzdEVycm9yKGVycm9yKSlcbiAgICB9XG59XG5jb25zdCBhcGlSb3V0ZXIgPSBleHByZXNzLlJvdXRlcigpO1xuYXBpUm91dGVyLnJvdXRlKCcvJykucG9zdChodG1sc2FuaXRpemUoKSwgIHZhbGlkYXRlQm9keSh2YWxpZGF0b3IpLCAgand0U3RyYXRlZ3ksIHJlc3RyaWN0RmVhdHVyZShcIlRQSVItV0FcIiksIGNoZWNrQ29tcGFueVZhbGlkaXR5U3RyYXRlZ3ksIGNvbnRyb2xsZXIpO1xuZXhwb3J0IGRlZmF1bHQgYXBpUm91dGVyO1xuXG4iXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUFBO0FBQ0E7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUVBO0FBQ0E7QUFDQTtBQUVBLElBQU1BLFNBQVMsR0FBR0MsZUFBRyxDQUFDQyxNQUFNLEVBQUUsQ0FBQ0MsSUFBSSxDQUFDO0VBQ2hDQyxTQUFTLEVBQUVILGVBQUcsQ0FBQ0ksTUFBTSxFQUFFLENBQUNDLEdBQUcsRUFBRSxDQUFDQyxNQUFNLENBQUMsRUFBRSxDQUFDLENBQUNDLFFBQVEsRUFBRTtFQUNuREMsTUFBTSxFQUFFUixlQUFHLENBQUNJLE1BQU0sRUFBRSxDQUFDRyxRQUFRO0FBQ2pDLENBQUMsQ0FBQztBQUdGLElBQUlFLFVBQVU7RUFBQSx5RkFBRyxpQkFBT0MsR0FBRyxFQUFFQyxHQUFHLEVBQUVDLElBQUk7SUFBQTtJQUFBO01BQUE7UUFBQTtVQUFBO1VBQUEsWUFFQUYsR0FBRyxDQUFDRyxJQUFJLEVBQTlCVixTQUFTLGFBQVRBLFNBQVMsRUFBRUssTUFBTSxhQUFOQSxNQUFNO1VBQUE7VUFBQSxPQUNLTSxFQUFFLENBQUNDLFFBQVEsQ0FBQ0MsUUFBUSxDQUFDYixTQUFTLENBQUM7UUFBQTtVQUF2RGMsZUFBZTtVQUNyQkEsZUFBZSxDQUFDQyxNQUFNLEdBQUdWLE1BQU07VUFBQTtVQUFBLE9BQ3pCUyxlQUFlLENBQUNFLElBQUksRUFBRTtRQUFBO1VBRXhCQyxPQUFPLEdBQUcsSUFBQUMsb0JBQVMsRUFBQ0osZUFBZSxDQUFDRyxPQUFPLENBQUM7VUFBQTtVQUFBLE9BQ2pCTixFQUFFLENBQUNRLE9BQU8sQ0FBQ0MsT0FBTyxDQUFDO1lBQUVDLEdBQUcsRUFBRVAsZUFBZSxDQUFDUTtVQUFVLENBQUMsQ0FBQyxDQUFDQyxNQUFNLENBQUMsa0JBQWtCLENBQUM7UUFBQTtVQUExR0MsZ0JBQWdCO1VBQ3RCQywrQkFBUSxDQUFDQyxXQUFXLENBQUNaLGVBQWUsQ0FBQ2EsYUFBYSxFQUFFYixlQUFlLENBQUNjLFFBQVEsRUFBRWQsZUFBZSxDQUFDZSxXQUFXLEVBQUVaLE9BQU8sRUFBRVosTUFBTSxFQUFHLFFBQVEsRUFBRW1CLGdCQUFnQixhQUFoQkEsZ0JBQWdCLHVCQUFoQkEsZ0JBQWdCLENBQUVNLGdCQUFnQixDQUFDLENBQ3pLQyxJQUFJLENBQUMsVUFBQ0MsTUFBTSxFQUFLO1lBQUVDLE9BQU8sQ0FBQ0MsR0FBRyxDQUFDLDZCQUE2QixFQUFFRixNQUFNLENBQUM7VUFBQSxDQUFDLENBQUMsU0FDbEUsQ0FBQyxVQUFDRyxLQUFLLEVBQUs7WUFBRUYsT0FBTyxDQUFDRSxLQUFLLENBQUMsK0JBQStCLEVBQUNBLEtBQUssQ0FBQ0MsUUFBUSxDQUFDQyxJQUFJLENBQUM7VUFBQSxDQUFDLENBQUM7VUFBQyxpQ0FFbEY3QixHQUFHLENBQUNPLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQ3VCLElBQUksQ0FBQztZQUFFQyxPQUFPLEVBQUUsSUFBSTtZQUFFQyxPQUFPLEVBQUU7VUFBK0IsQ0FBQyxDQUFDO1FBQUE7VUFBQTtVQUFBO1VBR3ZGUCxPQUFPLENBQUNDLEdBQUcsYUFBTztVQUFDLGlDQUNaekIsSUFBSSxDQUFDLElBQUlnQyxZQUFZLGFBQU8sQ0FBQztRQUFBO1FBQUE7VUFBQTtNQUFBO0lBQUE7RUFBQSxDQUUzQztFQUFBLGdCQW5CR25DLFVBQVU7SUFBQTtFQUFBO0FBQUEsR0FtQmI7QUFDRCxJQUFNb0MsU0FBUyxHQUFHQyxtQkFBTyxDQUFDQyxNQUFNLEVBQUU7QUFDbENGLFNBQVMsQ0FBQ0csS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDQyxJQUFJLENBQUMsSUFBQUMsMEJBQVksR0FBRSxFQUFHLElBQUFDLHVCQUFZLEVBQUNwRCxTQUFTLENBQUMsRUFBR3FELHFCQUFXLEVBQUUsSUFBQUMsMEJBQWUsRUFBQyxTQUFTLENBQUMsRUFBRUMsc0NBQTRCLEVBQUU3QyxVQUFVLENBQUM7QUFBQyxlQUN6SW9DLFNBQVM7QUFBQSJ9