"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var validator = _joi["default"].object().keys({
  action: _joi["default"].string().required(),
  selectedUsers: _joi["default"].array().required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _$set, _req$body, action, selectedUsers, companyId, activeUsers, userLimit, usersThatCanbeActivatedCount, usersActivationArray;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, action = _req$body.action, selectedUsers = _req$body.selectedUsers;
          companyId = req.user.companyId;
          if (!(action == 'activate')) {
            _context.next = 18;
            break;
          }
          _context.next = 6;
          return db.User.countDocuments({
            deletedAt: null,
            isActiveMessenger: true,
            companyId: companyId
          });
        case 6:
          activeUsers = _context.sent;
          _context.next = 9;
          return db.MetaData.findOne({
            name: "userLimitMessenger",
            companyId: companyId
          });
        case 9:
          userLimit = _context.sent;
          if (+userLimit.value > activeUsers) {
            _context.next = 12;
            break;
          }
          throw new RequestError("User Limit for messenger exceeded! Only ".concat(+userLimit.value, " user(s) can be activated as per your license!"), 403);
        case 12:
          usersThatCanbeActivatedCount = +userLimit.value - activeUsers;
          console.log({
            usersThatCanbeActivatedCount: usersThatCanbeActivatedCount
          });
          if (!(usersThatCanbeActivatedCount > 0)) {
            _context.next = 18;
            break;
          }
          usersActivationArray = selectedUsers.slice(0, usersThatCanbeActivatedCount);
          _context.next = 18;
          return db.User.updateMany({
            _id: {
              $in: usersActivationArray
            }
          }, {
            $set: {
              isActiveMessenger: true
            }
          });
        case 18:
          if (!(action == 'deactivate')) {
            _context.next = 21;
            break;
          }
          _context.next = 21;
          return db.User.updateMany({
            _id: {
              $in: selectedUsers
            }
          }, {
            $set: {
              isActiveMessenger: false
            }
          });
        case 21:
          if (!(action == 'delete')) {
            _context.next = 24;
            break;
          }
          _context.next = 24;
          return db.User.updateMany({
            _id: {
              $in: selectedUsers
            }
          }, {
            $set: (_$set = {
              isActive: false,
              companyId: null,
              domainId: null,
              groupId: null,
              groupName: null,
              phoneNumber: null,
              subDomainGroupId: null
            }, (0, _defineProperty2["default"])(_$set, "isActive", false), (0, _defineProperty2["default"])(_$set, "isActiveMessenger", false), (0, _defineProperty2["default"])(_$set, "deletedAt", new Date()), _$set)
          });
        case 24:
          return _context.abrupt("return", res.status(200).send({
            Success: true
          }));
        case 27:
          _context.prev = 27;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 31:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 27]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(_strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-WA"), _strategy.checkCompanyValidityStrategy, (0, _permission.permission)('Users', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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