"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var validator = _joi["default"].object().keys({
  page: _joi["default"].number().min(0).required(),
  limit: _joi["default"].number().min(1).required(),
  domains: _joi["default"].array().optional(),
  groups: _joi["default"].array().optional(),
  subDomainGroups: _joi["default"].array().optional(),
  search: _joi["default"].string().optional().allow(null).empty(''),
  status: _joi["default"].string().optional().allow(null).empty('')
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$query, domains, subDomainGroups, groups, page, limit, _req$query$search, search, _req$query$status, status, companyId, condition, selectedDomains, selectedGroups, selectedSubDomainGroups, regex, count, users;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$query = req.query, domains = _req$query.domains, subDomainGroups = _req$query.subDomainGroups, groups = _req$query.groups, page = _req$query.page, limit = _req$query.limit, _req$query$search = _req$query.search, search = _req$query$search === void 0 ? '' : _req$query$search, _req$query$status = _req$query.status, status = _req$query$status === void 0 ? false : _req$query$status;
          companyId = req.user.companyId;
          condition = {
            companyId: companyId,
            deletedAt: null,
            phoneNumber: {
              $ne: null
            }
          };
          if (!(domains && domains.length)) {
            _context.next = 9;
            break;
          }
          _context.next = 7;
          return db.Domain.find({
            companyId: companyId,
            domainName: {
              $in: domains === null || domains === void 0 ? void 0 : domains.map(function (domain) {
                return domain.split('#')[0];
              })
            },
            _id: {
              $in: domains === null || domains === void 0 ? void 0 : domains.map(function (domain) {
                return domain.split('#')[1];
              })
            },
            deletedAt: null
          }, {
            _id: 1
          });
        case 7:
          selectedDomains = _context.sent;
          condition['domainId'] = {
            $in: selectedDomains.map(function (domain) {
              return domain._id;
            })
          };
        case 9:
          if (!(groups && groups.length)) {
            _context.next = 14;
            break;
          }
          _context.next = 12;
          return db.UserGroup.find({
            companyId: companyId,
            label: {
              $in: groups
            }
          }, {
            _id: 0,
            value: 1
          });
        case 12:
          selectedGroups = _context.sent;
          condition['groupId'] = {
            $in: selectedGroups.map(function (group) {
              return group.value;
            })
          };
        case 14:
          if (!(subDomainGroups && subDomainGroups.length)) {
            _context.next = 19;
            break;
          }
          _context.next = 17;
          return db.SubDomainGroup.find({
            companyId: companyId,
            groupName: {
              $in: subDomainGroups
            }
          }, {
            _id: 1
          });
        case 17:
          selectedSubDomainGroups = _context.sent;
          condition['subDomainGroupId'] = {
            $in: selectedSubDomainGroups.map(function (subDomainGroup) {
              return subDomainGroup._id;
            })
          };
        case 19:
          if (status != '-1') status == 'Active' ? condition['isActiveMessenger'] = true : condition["isActiveMessenger"] = false;
          if (search && search.length) {
            regex = new RegExp(search, "i");
            condition['$or'] = [{
              name: regex
            }
            // { phoneNumber: search }
            ];
          }
          _context.next = 23;
          return db.User.countDocuments(condition);
        case 23:
          count = _context.sent;
          _context.next = 26;
          return db.User.find(condition).skip((page - 1) * limit).limit(limit);
        case 26:
          users = _context.sent;
          return _context.abrupt("return", res.status(200).send({
            Success: true,
            users: users,
            count: count
          }));
        case 30:
          _context.prev = 30;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 34:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 30]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-WA"), (0, _permission.permission)('Users', 'Read'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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