"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _strategy = require("../../middlewares/strategy");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var validator = _joi["default"].object({
  reportedMessageId: _joi["default"].string().hex().length(24).required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var reportedMessageId, companyId, message, filePath;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          reportedMessageId = req.query.reportedMessageId;
          companyId = req.user.companyId;
          _context.next = 5;
          return db.whatsapp.findOne({
            _id: reportedMessageId,
            companyId: companyId,
            deletedAt: null
          });
        case 5:
          message = _context.sent;
          if (!(message && message.fileName)) {
            _context.next = 12;
            break;
          }
          filePath = _path["default"].join(appRoot, 'Content', 'whatsappImages', message.fileName);
          console.log({
            filePath: filePath
          });
          // Read the image file
          _fs["default"].readFile(filePath, function (err, data) {
            if (err) {
              return res.status(200).json({
                success: 'true',
                message: message
              });
            }

            // Convert the image to base64
            var base64Image = "data:image/jpeg;base64,".concat(data.toString('base64'));
            message = _objectSpread(_objectSpread({}, message.toObject()), {}, {
              image: base64Image
            });

            // Send the base64 string as the response
            return res.status(200).json({
              message: message
            });
          });
          _context.next = 13;
          break;
        case 12:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: message
          }));
        case 13:
          _context.next = 19;
          break;
        case 15:
          _context.prev = 15;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 19:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 15]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route("/").get((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-WA"), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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