"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$query, _req$query$page, page, _req$query$limit, limit, _req$query$search, search, companyId, condition, regex, count, messages;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$query = req.query, _req$query$page = _req$query.page, page = _req$query$page === void 0 ? 1 : _req$query$page, _req$query$limit = _req$query.limit, limit = _req$query$limit === void 0 ? 10 : _req$query$limit, _req$query$search = _req$query.search, search = _req$query$search === void 0 ? "" : _req$query$search;
          companyId = req.user.companyId;
          condition = {
            companyId: companyId,
            deletedAt: null
          };
          if (search && search.length) {
            regex = new RegExp(search, "i");
            condition['$or'] = [{
              from: regex
            }, {
              sender: regex
            }];
          }
          _context.next = 7;
          return db.whatsapp.countDocuments(condition);
        case 7:
          count = _context.sent;
          _context.next = 10;
          return db.whatsapp.find(condition).sort({
            'createdAt': -1
          }).skip((page - 1) * limit).limit(limit);
        case 10:
          messages = _context.sent;
          res.status(200).json({
            success: true,
            messages: messages,
            count: count
          });
          _context.next = 18;
          break;
        case 14:
          _context.prev = 14;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 18:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 14]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-WA"), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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