"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, dailyReportedMessagesPromise, topUrlsPromise, whatsappReportedPromise, topReportersPromise, topSendersPromise, recentUnsafePromise, messagesReportedCountPromise, whatsappUsersCountPromise, safeMessagesCountPromise, unsafeMessagesCountPromise, dubiousMessagesCountPromise, _yield$Promise$all, _yield$Promise$all2, dailyReportedMessages, topUrls, whatsappReported, topReporters, topSenders, messagesReportedCount, whatsappUsersCount, recentUnsafeMessages, safeMessagesCount, unsafeMessagesCount, dubiousMessagesCount;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          dailyReportedMessagesPromise = db.whatsapp.aggregate([{
            $match: {
              companyId: companyId
            }
          }, {
            $group: {
              _id: {
                $dateToString: {
                  format: "%Y-%m-%d",
                  date: "$createdAt"
                }
              },
              count: {
                $sum: 1
              }
            }
          }, {
            $project: {
              createdAt: '$_id',
              count: 1,
              _id: 0
            }
          }, {
            $sort: {
              createdAt: 1
            }
          }]).then(function (reportedMessage) {
            return reportedMessage.map(function (message) {
              var unixTimestamp = new Date(message.createdAt).getTime();
              return [unixTimestamp, message.count];
            });
          });
          topUrlsPromise = db.Url.find({
            score: {
              $gt: 0
            },
            reportedMailId: null,
            whatsappMessageId: {
              $ne: null
            },
            companyId: companyId
          }).select("url score").populate({
            path: "whatsappMessageId",
            select: "from phoneNumber score"
          }).sort({
            score: -1
          }).limit(5);
          whatsappReportedPromise = db.whatsapp.find({
            companyId: companyId,
            deletedAt: null
          }).select('from phoneNumber').sort({
            'createdAt': -1
          }).limit(5);
          topReportersPromise = db.whatsapp.aggregate([{
            $match: {
              companyId: companyId
            }
          }, {
            $group: {
              _id: {
                phoneNumber: "$phoneNumber",
                name: "$from"
              },
              count: {
                $sum: 1
              }
            }
          }, {
            $sort: {
              count: -1
            }
          }, {
            $limit: 5
          }, {
            $project: {
              _id: 0,
              phoneNumber: "$_id.phoneNumber",
              name: "$_id.name",
              count: 1
            }
          }]);
          topSendersPromise = db.whatsapp.aggregate([{
            $match: {
              companyId: companyId
            }
          }, {
            $group: {
              _id: {
                sender: "$sender"
              },
              count: {
                $sum: 1
              }
            }
          }, {
            $sort: {
              count: -1
            }
          }, {
            $limit: 5
          }, {
            $project: {
              _id: 0,
              sender: "$_id.sender",
              count: 1
            }
          }]);
          recentUnsafePromise = db.whatsapp.find({
            companyId: companyId,
            result: "unsafe"
          });
          messagesReportedCountPromise = db.whatsapp.countDocuments({
            companyId: companyId
          });
          whatsappUsersCountPromise = db.User.countDocuments({
            companyId: companyId,
            phoneNumber: {
              $ne: null
            }
          });
          safeMessagesCountPromise = db.whatsapp.countDocuments({
            companyId: companyId,
            result: "safe"
          });
          unsafeMessagesCountPromise = db.whatsapp.countDocuments({
            companyId: companyId,
            result: "unsafe"
          });
          dubiousMessagesCountPromise = db.whatsapp.countDocuments({
            companyId: companyId,
            result: "dubious"
          }); // Execute all promises concurrently
          _context.next = 15;
          return Promise.all([dailyReportedMessagesPromise, topUrlsPromise, whatsappReportedPromise, topReportersPromise, topSendersPromise, messagesReportedCountPromise, whatsappUsersCountPromise, recentUnsafePromise, safeMessagesCountPromise, unsafeMessagesCountPromise, dubiousMessagesCountPromise]);
        case 15:
          _yield$Promise$all = _context.sent;
          _yield$Promise$all2 = (0, _slicedToArray2["default"])(_yield$Promise$all, 11);
          dailyReportedMessages = _yield$Promise$all2[0];
          topUrls = _yield$Promise$all2[1];
          whatsappReported = _yield$Promise$all2[2];
          topReporters = _yield$Promise$all2[3];
          topSenders = _yield$Promise$all2[4];
          messagesReportedCount = _yield$Promise$all2[5];
          whatsappUsersCount = _yield$Promise$all2[6];
          recentUnsafeMessages = _yield$Promise$all2[7];
          safeMessagesCount = _yield$Promise$all2[8];
          unsafeMessagesCount = _yield$Promise$all2[9];
          dubiousMessagesCount = _yield$Promise$all2[10];
          // Combine results into a single response
          res.status(200).json({
            success: true,
            dailyReportedMessages: dailyReportedMessages,
            topUrls: topUrls,
            whatsappReported: whatsappReported,
            topReporters: topReporters,
            topSenders: topSenders,
            messagesReportedCount: messagesReportedCount,
            whatsappUsersCount: whatsappUsersCount,
            recentUnsafeMessages: recentUnsafeMessages,
            safeMessagesCount: safeMessagesCount,
            unsafeMessagesCount: unsafeMessagesCount,
            dubiousMessagesCount: dubiousMessagesCount
          });
          _context.next = 35;
          break;
        case 31:
          _context.prev = 31;
          _context.t0 = _context["catch"](0);
          console.error(_context.t0);
          next(_context.t0);
        case 35:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 31]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizer.sanitize)(), _strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-WA"), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJjb250cm9sbGVyIiwicmVxIiwicmVzIiwibmV4dCIsImNvbXBhbnlJZCIsInVzZXIiLCJkYWlseVJlcG9ydGVkTWVzc2FnZXNQcm9taXNlIiwiZGIiLCJ3aGF0c2FwcCIsImFnZ3JlZ2F0ZSIsIiRtYXRjaCIsIiRncm91cCIsIl9pZCIsIiRkYXRlVG9TdHJpbmciLCJmb3JtYXQiLCJkYXRlIiwiY291bnQiLCIkc3VtIiwiJHByb2plY3QiLCJjcmVhdGVkQXQiLCIkc29ydCIsInRoZW4iLCJyZXBvcnRlZE1lc3NhZ2UiLCJtYXAiLCJtZXNzYWdlIiwidW5peFRpbWVzdGFtcCIsIkRhdGUiLCJnZXRUaW1lIiwidG9wVXJsc1Byb21pc2UiLCJVcmwiLCJmaW5kIiwic2NvcmUiLCIkZ3QiLCJyZXBvcnRlZE1haWxJZCIsIndoYXRzYXBwTWVzc2FnZUlkIiwiJG5lIiwic2VsZWN0IiwicG9wdWxhdGUiLCJwYXRoIiwic29ydCIsImxpbWl0Iiwid2hhdHNhcHBSZXBvcnRlZFByb21pc2UiLCJkZWxldGVkQXQiLCJ0b3BSZXBvcnRlcnNQcm9taXNlIiwicGhvbmVOdW1iZXIiLCJuYW1lIiwiJGxpbWl0IiwidG9wU2VuZGVyc1Byb21pc2UiLCJzZW5kZXIiLCJyZWNlbnRVbnNhZmVQcm9taXNlIiwicmVzdWx0IiwibWVzc2FnZXNSZXBvcnRlZENvdW50UHJvbWlzZSIsImNvdW50RG9jdW1lbnRzIiwid2hhdHNhcHBVc2Vyc0NvdW50UHJvbWlzZSIsIlVzZXIiLCJzYWZlTWVzc2FnZXNDb3VudFByb21pc2UiLCJ1bnNhZmVNZXNzYWdlc0NvdW50UHJvbWlzZSIsImR1YmlvdXNNZXNzYWdlc0NvdW50UHJvbWlzZSIsIlByb21pc2UiLCJhbGwiLCJkYWlseVJlcG9ydGVkTWVzc2FnZXMiLCJ0b3BVcmxzIiwid2hhdHNhcHBSZXBvcnRlZCIsInRvcFJlcG9ydGVycyIsInRvcFNlbmRlcnMiLCJtZXNzYWdlc1JlcG9ydGVkQ291bnQiLCJ3aGF0c2FwcFVzZXJzQ291bnQiLCJyZWNlbnRVbnNhZmVNZXNzYWdlcyIsInNhZmVNZXNzYWdlc0NvdW50IiwidW5zYWZlTWVzc2FnZXNDb3VudCIsImR1YmlvdXNNZXNzYWdlc0NvdW50Iiwic3RhdHVzIiwianNvbiIsInN1Y2Nlc3MiLCJjb25zb2xlIiwiZXJyb3IiLCJhcGlSb3V0ZXIiLCJleHByZXNzIiwiUm91dGVyIiwicm91dGUiLCJnZXQiLCJzYW5pdGl6ZSIsImp3dFN0cmF0ZWd5IiwicmVzdHJpY3RGZWF0dXJlIl0sInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2FwaS93aGF0c2FwcC9vdmVydmlldy5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgZXhwcmVzcyBmcm9tICdleHByZXNzJztcbmltcG9ydCB7IHNhbml0aXplIH0gZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvc2FuaXRpemVyJztcbmltcG9ydCB7IGNoZWNrQ29tcGFueVZhbGlkaXR5U3RyYXRlZ3ksIGp3dFN0cmF0ZWd5IH0gZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvc3RyYXRlZ3knO1xuaW1wb3J0IHJlc3RyaWN0RmVhdHVyZSBmcm9tICcuLi8uLi9taWRkbGV3YXJlcy9mZWF0dXJlQmxvY2tlcic7XG5cbmxldCBjb250cm9sbGVyID0gYXN5bmMgKHJlcSwgcmVzLCBuZXh0KSA9PiB7XG4gICAgdHJ5IHtcbiAgICAgICAgY29uc3QgY29tcGFueUlkID0gcmVxLnVzZXIuY29tcGFueUlkO1xuXG4gICAgICAgIGNvbnN0IGRhaWx5UmVwb3J0ZWRNZXNzYWdlc1Byb21pc2UgPSBkYi53aGF0c2FwcC5hZ2dyZWdhdGUoW1xuICAgICAgICAgICAgeyAkbWF0Y2g6IHsgY29tcGFueUlkIH0gfSxcbiAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAkZ3JvdXA6IHtcbiAgICAgICAgICAgICAgICAgICAgX2lkOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAkZGF0ZVRvU3RyaW5nOiB7IGZvcm1hdDogXCIlWS0lbS0lZFwiLCBkYXRlOiBcIiRjcmVhdGVkQXRcIiB9XG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIGNvdW50OiB7ICRzdW06IDEgfVxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgJHByb2plY3Q6IHtcbiAgICAgICAgICAgICAgICAgICAgY3JlYXRlZEF0OiAnJF9pZCcsXG4gICAgICAgICAgICAgICAgICAgIGNvdW50OiAxLFxuICAgICAgICAgICAgICAgICAgICBfaWQ6IDBcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgeyAkc29ydDogeyBjcmVhdGVkQXQ6IDEgfSB9XG4gICAgICAgIF0pLnRoZW4ocmVwb3J0ZWRNZXNzYWdlID0+IHJlcG9ydGVkTWVzc2FnZS5tYXAobWVzc2FnZSA9PiB7XG4gICAgICAgICAgICBjb25zdCB1bml4VGltZXN0YW1wID0gbmV3IERhdGUobWVzc2FnZS5jcmVhdGVkQXQpLmdldFRpbWUoKTtcbiAgICAgICAgICAgIHJldHVybiBbdW5peFRpbWVzdGFtcCwgbWVzc2FnZS5jb3VudF07XG4gICAgICAgIH0pKTtcblxuICAgICAgICBjb25zdCB0b3BVcmxzUHJvbWlzZSA9IGRiLlVybC5maW5kKHtcbiAgICAgICAgICAgIHNjb3JlOiB7ICRndDogMCB9LFxuICAgICAgICAgICAgcmVwb3J0ZWRNYWlsSWQ6IG51bGwsXG4gICAgICAgICAgICB3aGF0c2FwcE1lc3NhZ2VJZDogeyAkbmU6IG51bGwgfSxcbiAgICAgICAgICAgIGNvbXBhbnlJZDogY29tcGFueUlkXG4gICAgICAgIH0pXG4gICAgICAgIC5zZWxlY3QoXCJ1cmwgc2NvcmVcIilcbiAgICAgICAgLnBvcHVsYXRlKHtcbiAgICAgICAgICAgIHBhdGg6IFwid2hhdHNhcHBNZXNzYWdlSWRcIixcbiAgICAgICAgICAgIHNlbGVjdDogXCJmcm9tIHBob25lTnVtYmVyIHNjb3JlXCJcbiAgICAgICAgfSlcbiAgICAgICAgLnNvcnQoeyBzY29yZTogLTEgfSlcbiAgICAgICAgLmxpbWl0KDUpO1xuXG4gICAgICAgIGNvbnN0IHdoYXRzYXBwUmVwb3J0ZWRQcm9taXNlID0gZGIud2hhdHNhcHAuZmluZCh7XG4gICAgICAgICAgICBjb21wYW55SWQsXG4gICAgICAgICAgICBkZWxldGVkQXQ6IG51bGwsXG4gICAgICAgIH0pXG4gICAgICAgIC5zZWxlY3QoJ2Zyb20gcGhvbmVOdW1iZXInKVxuICAgICAgICAuc29ydCh7J2NyZWF0ZWRBdCc6IC0xfSlcbiAgICAgICAgLmxpbWl0KDUpO1xuXG4gICAgICAgIGNvbnN0IHRvcFJlcG9ydGVyc1Byb21pc2UgPSBkYi53aGF0c2FwcC5hZ2dyZWdhdGUoW1xuICAgICAgICAgICAgeyAkbWF0Y2g6IHsgY29tcGFueUlkIH0gfSxcbiAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAkZ3JvdXA6IHtcbiAgICAgICAgICAgICAgICAgICAgX2lkOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICBwaG9uZU51bWJlcjogXCIkcGhvbmVOdW1iZXJcIixcbiAgICAgICAgICAgICAgICAgICAgICAgIG5hbWU6IFwiJGZyb21cIlxuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICBjb3VudDogeyAkc3VtOiAxIH1cbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgeyAkc29ydDogeyBjb3VudDogLTEgfSB9LFxuICAgICAgICAgICAgeyAkbGltaXQ6IDUgfSxcbiAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAkcHJvamVjdDoge1xuICAgICAgICAgICAgICAgICAgICBfaWQ6IDAsXG4gICAgICAgICAgICAgICAgICAgIHBob25lTnVtYmVyOiBcIiRfaWQucGhvbmVOdW1iZXJcIixcbiAgICAgICAgICAgICAgICAgICAgbmFtZTogXCIkX2lkLm5hbWVcIixcbiAgICAgICAgICAgICAgICAgICAgY291bnQ6IDFcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgIF0pO1xuXG4gICAgICAgIGNvbnN0IHRvcFNlbmRlcnNQcm9taXNlID0gZGIud2hhdHNhcHAuYWdncmVnYXRlKFtcbiAgICAgICAgICAgIHsgJG1hdGNoOiB7IGNvbXBhbnlJZCB9IH0sXG4gICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgJGdyb3VwOiB7XG4gICAgICAgICAgICAgICAgICAgIF9pZDoge1xuICAgICAgICAgICAgICAgICAgICAgICAgc2VuZGVyOiBcIiRzZW5kZXJcIixcbiAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgY291bnQ6IHsgJHN1bTogMSB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIHsgJHNvcnQ6IHsgY291bnQ6IC0xIH0gfSxcbiAgICAgICAgICAgIHsgJGxpbWl0OiA1IH0sXG4gICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgJHByb2plY3Q6IHtcbiAgICAgICAgICAgICAgICAgICAgX2lkOiAwLFxuICAgICAgICAgICAgICAgICAgICBzZW5kZXI6IFwiJF9pZC5zZW5kZXJcIixcbiAgICAgICAgICAgICAgICAgICAgY291bnQ6IDFcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgIF0pO1xuXG4gICAgICAgIGNvbnN0IHJlY2VudFVuc2FmZVByb21pc2UgPSBkYi53aGF0c2FwcC5maW5kKHtjb21wYW55SWQsIHJlc3VsdDpcInVuc2FmZVwifSlcblxuICAgICAgICBjb25zdCBtZXNzYWdlc1JlcG9ydGVkQ291bnRQcm9taXNlID0gZGIud2hhdHNhcHAuY291bnREb2N1bWVudHMoe2NvbXBhbnlJZH0pXG4gICAgICAgIGNvbnN0IHdoYXRzYXBwVXNlcnNDb3VudFByb21pc2UgPSBkYi5Vc2VyLmNvdW50RG9jdW1lbnRzKHtjb21wYW55SWQsIHBob25lTnVtYmVyOiB7ICRuZTogbnVsbH19KVxuXG4gICAgICAgIGNvbnN0IHNhZmVNZXNzYWdlc0NvdW50UHJvbWlzZSA9IGRiLndoYXRzYXBwLmNvdW50RG9jdW1lbnRzKHtjb21wYW55SWQsIHJlc3VsdDpcInNhZmVcIn0pXG4gICAgICAgIGNvbnN0IHVuc2FmZU1lc3NhZ2VzQ291bnRQcm9taXNlID0gZGIud2hhdHNhcHAuY291bnREb2N1bWVudHMoe2NvbXBhbnlJZCwgcmVzdWx0OlwidW5zYWZlXCJ9KVxuICAgICAgICBjb25zdCBkdWJpb3VzTWVzc2FnZXNDb3VudFByb21pc2UgPSBkYi53aGF0c2FwcC5jb3VudERvY3VtZW50cyh7Y29tcGFueUlkLCByZXN1bHQ6XCJkdWJpb3VzXCJ9KVxuXG5cbiAgICAgICAgLy8gRXhlY3V0ZSBhbGwgcHJvbWlzZXMgY29uY3VycmVudGx5XG4gICAgICAgIGNvbnN0IFtkYWlseVJlcG9ydGVkTWVzc2FnZXMsIHRvcFVybHMsIHdoYXRzYXBwUmVwb3J0ZWQsIHRvcFJlcG9ydGVycywgdG9wU2VuZGVycywgbWVzc2FnZXNSZXBvcnRlZENvdW50LCB3aGF0c2FwcFVzZXJzQ291bnQsIHJlY2VudFVuc2FmZU1lc3NhZ2VzLCBzYWZlTWVzc2FnZXNDb3VudCwgdW5zYWZlTWVzc2FnZXNDb3VudCwgZHViaW91c01lc3NhZ2VzQ291bnQgXSA9IGF3YWl0IFByb21pc2UuYWxsKFtcbiAgICAgICAgICAgIGRhaWx5UmVwb3J0ZWRNZXNzYWdlc1Byb21pc2UsXG4gICAgICAgICAgICB0b3BVcmxzUHJvbWlzZSxcbiAgICAgICAgICAgIHdoYXRzYXBwUmVwb3J0ZWRQcm9taXNlLFxuICAgICAgICAgICAgdG9wUmVwb3J0ZXJzUHJvbWlzZSxcbiAgICAgICAgICAgIHRvcFNlbmRlcnNQcm9taXNlLFxuICAgICAgICAgICAgbWVzc2FnZXNSZXBvcnRlZENvdW50UHJvbWlzZSxcbiAgICAgICAgICAgIHdoYXRzYXBwVXNlcnNDb3VudFByb21pc2UsXG4gICAgICAgICAgICByZWNlbnRVbnNhZmVQcm9taXNlLFxuICAgICAgICAgICAgc2FmZU1lc3NhZ2VzQ291bnRQcm9taXNlLFxuICAgICAgICAgICAgdW5zYWZlTWVzc2FnZXNDb3VudFByb21pc2UsXG4gICAgICAgICAgICBkdWJpb3VzTWVzc2FnZXNDb3VudFByb21pc2VcbiAgICAgICAgXSk7XG5cblxuICAgICAgICAvLyBDb21iaW5lIHJlc3VsdHMgaW50byBhIHNpbmdsZSByZXNwb25zZVxuICAgICAgICByZXMuc3RhdHVzKDIwMCkuanNvbih7XG4gICAgICAgICAgICBzdWNjZXNzOiB0cnVlLFxuICAgICAgICAgICAgZGFpbHlSZXBvcnRlZE1lc3NhZ2VzLFxuICAgICAgICAgICAgdG9wVXJscyxcbiAgICAgICAgICAgIHdoYXRzYXBwUmVwb3J0ZWQsXG4gICAgICAgICAgICB0b3BSZXBvcnRlcnMsXG4gICAgICAgICAgICB0b3BTZW5kZXJzLFxuICAgICAgICAgICAgbWVzc2FnZXNSZXBvcnRlZENvdW50LFxuICAgICAgICAgICAgd2hhdHNhcHBVc2Vyc0NvdW50LFxuICAgICAgICAgICAgcmVjZW50VW5zYWZlTWVzc2FnZXMsXG4gICAgICAgICAgICBzYWZlTWVzc2FnZXNDb3VudCxcbiAgICAgICAgICAgIHVuc2FmZU1lc3NhZ2VzQ291bnQsXG4gICAgICAgICAgICBkdWJpb3VzTWVzc2FnZXNDb3VudFxuICAgICAgICB9KTtcblxuICAgIH0gY2F0Y2ggKGVycikge1xuICAgICAgICBjb25zb2xlLmVycm9yKGVycik7XG4gICAgICAgIG5leHQoZXJyKTtcbiAgICB9XG59XG5cbmNvbnN0IGFwaVJvdXRlciA9IGV4cHJlc3MuUm91dGVyKCk7XG5hcGlSb3V0ZXIucm91dGUoJy8nKS5nZXQoc2FuaXRpemUoKSwgand0U3RyYXRlZ3ksIHJlc3RyaWN0RmVhdHVyZShcIlRQSVItV0FcIiksIGNvbnRyb2xsZXIpO1xuZXhwb3J0IGRlZmF1bHQgYXBpUm91dGVyO1xuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFFQSxJQUFJQSxVQUFVO0VBQUEseUZBQUcsaUJBQU9DLEdBQUcsRUFBRUMsR0FBRyxFQUFFQyxJQUFJO0lBQUE7SUFBQTtNQUFBO1FBQUE7VUFBQTtVQUV4QkMsU0FBUyxHQUFHSCxHQUFHLENBQUNJLElBQUksQ0FBQ0QsU0FBUztVQUU5QkUsNEJBQTRCLEdBQUdDLEVBQUUsQ0FBQ0MsUUFBUSxDQUFDQyxTQUFTLENBQUMsQ0FDdkQ7WUFBRUMsTUFBTSxFQUFFO2NBQUVOLFNBQVMsRUFBVEE7WUFBVTtVQUFFLENBQUMsRUFDekI7WUFDSU8sTUFBTSxFQUFFO2NBQ0pDLEdBQUcsRUFBRTtnQkFDREMsYUFBYSxFQUFFO2tCQUFFQyxNQUFNLEVBQUUsVUFBVTtrQkFBRUMsSUFBSSxFQUFFO2dCQUFhO2NBQzVELENBQUM7Y0FDREMsS0FBSyxFQUFFO2dCQUFFQyxJQUFJLEVBQUU7Y0FBRTtZQUNyQjtVQUNKLENBQUMsRUFDRDtZQUNJQyxRQUFRLEVBQUU7Y0FDTkMsU0FBUyxFQUFFLE1BQU07Y0FDakJILEtBQUssRUFBRSxDQUFDO2NBQ1JKLEdBQUcsRUFBRTtZQUNUO1VBQ0osQ0FBQyxFQUNEO1lBQUVRLEtBQUssRUFBRTtjQUFFRCxTQUFTLEVBQUU7WUFBRTtVQUFFLENBQUMsQ0FDOUIsQ0FBQyxDQUFDRSxJQUFJLENBQUMsVUFBQUMsZUFBZTtZQUFBLE9BQUlBLGVBQWUsQ0FBQ0MsR0FBRyxDQUFDLFVBQUFDLE9BQU8sRUFBSTtjQUN0RCxJQUFNQyxhQUFhLEdBQUcsSUFBSUMsSUFBSSxDQUFDRixPQUFPLENBQUNMLFNBQVMsQ0FBQyxDQUFDUSxPQUFPLEVBQUU7Y0FDM0QsT0FBTyxDQUFDRixhQUFhLEVBQUVELE9BQU8sQ0FBQ1IsS0FBSyxDQUFDO1lBQ3pDLENBQUMsQ0FBQztVQUFBLEVBQUM7VUFFR1ksY0FBYyxHQUFHckIsRUFBRSxDQUFDc0IsR0FBRyxDQUFDQyxJQUFJLENBQUM7WUFDL0JDLEtBQUssRUFBRTtjQUFFQyxHQUFHLEVBQUU7WUFBRSxDQUFDO1lBQ2pCQyxjQUFjLEVBQUUsSUFBSTtZQUNwQkMsaUJBQWlCLEVBQUU7Y0FBRUMsR0FBRyxFQUFFO1lBQUssQ0FBQztZQUNoQy9CLFNBQVMsRUFBRUE7VUFDZixDQUFDLENBQUMsQ0FDRGdDLE1BQU0sQ0FBQyxXQUFXLENBQUMsQ0FDbkJDLFFBQVEsQ0FBQztZQUNOQyxJQUFJLEVBQUUsbUJBQW1CO1lBQ3pCRixNQUFNLEVBQUU7VUFDWixDQUFDLENBQUMsQ0FDREcsSUFBSSxDQUFDO1lBQUVSLEtBQUssRUFBRSxDQUFDO1VBQUUsQ0FBQyxDQUFDLENBQ25CUyxLQUFLLENBQUMsQ0FBQyxDQUFDO1VBRUhDLHVCQUF1QixHQUFHbEMsRUFBRSxDQUFDQyxRQUFRLENBQUNzQixJQUFJLENBQUM7WUFDN0MxQixTQUFTLEVBQVRBLFNBQVM7WUFDVHNDLFNBQVMsRUFBRTtVQUNmLENBQUMsQ0FBQyxDQUNETixNQUFNLENBQUMsa0JBQWtCLENBQUMsQ0FDMUJHLElBQUksQ0FBQztZQUFDLFdBQVcsRUFBRSxDQUFDO1VBQUMsQ0FBQyxDQUFDLENBQ3ZCQyxLQUFLLENBQUMsQ0FBQyxDQUFDO1VBRUhHLG1CQUFtQixHQUFHcEMsRUFBRSxDQUFDQyxRQUFRLENBQUNDLFNBQVMsQ0FBQyxDQUM5QztZQUFFQyxNQUFNLEVBQUU7Y0FBRU4sU0FBUyxFQUFUQTtZQUFVO1VBQUUsQ0FBQyxFQUN6QjtZQUNJTyxNQUFNLEVBQUU7Y0FDSkMsR0FBRyxFQUFFO2dCQUNEZ0MsV0FBVyxFQUFFLGNBQWM7Z0JBQzNCQyxJQUFJLEVBQUU7Y0FDVixDQUFDO2NBQ0Q3QixLQUFLLEVBQUU7Z0JBQUVDLElBQUksRUFBRTtjQUFFO1lBQ3JCO1VBQ0osQ0FBQyxFQUNEO1lBQUVHLEtBQUssRUFBRTtjQUFFSixLQUFLLEVBQUUsQ0FBQztZQUFFO1VBQUUsQ0FBQyxFQUN4QjtZQUFFOEIsTUFBTSxFQUFFO1VBQUUsQ0FBQyxFQUNiO1lBQ0k1QixRQUFRLEVBQUU7Y0FDTk4sR0FBRyxFQUFFLENBQUM7Y0FDTmdDLFdBQVcsRUFBRSxrQkFBa0I7Y0FDL0JDLElBQUksRUFBRSxXQUFXO2NBQ2pCN0IsS0FBSyxFQUFFO1lBQ1g7VUFDSixDQUFDLENBQ0osQ0FBQztVQUVJK0IsaUJBQWlCLEdBQUd4QyxFQUFFLENBQUNDLFFBQVEsQ0FBQ0MsU0FBUyxDQUFDLENBQzVDO1lBQUVDLE1BQU0sRUFBRTtjQUFFTixTQUFTLEVBQVRBO1lBQVU7VUFBRSxDQUFDLEVBQ3pCO1lBQ0lPLE1BQU0sRUFBRTtjQUNKQyxHQUFHLEVBQUU7Z0JBQ0RvQyxNQUFNLEVBQUU7Y0FDWixDQUFDO2NBQ0RoQyxLQUFLLEVBQUU7Z0JBQUVDLElBQUksRUFBRTtjQUFFO1lBQ3JCO1VBQ0osQ0FBQyxFQUNEO1lBQUVHLEtBQUssRUFBRTtjQUFFSixLQUFLLEVBQUUsQ0FBQztZQUFFO1VBQUUsQ0FBQyxFQUN4QjtZQUFFOEIsTUFBTSxFQUFFO1VBQUUsQ0FBQyxFQUNiO1lBQ0k1QixRQUFRLEVBQUU7Y0FDTk4sR0FBRyxFQUFFLENBQUM7Y0FDTm9DLE1BQU0sRUFBRSxhQUFhO2NBQ3JCaEMsS0FBSyxFQUFFO1lBQ1g7VUFDSixDQUFDLENBQ0osQ0FBQztVQUVJaUMsbUJBQW1CLEdBQUcxQyxFQUFFLENBQUNDLFFBQVEsQ0FBQ3NCLElBQUksQ0FBQztZQUFDMUIsU0FBUyxFQUFUQSxTQUFTO1lBQUU4QyxNQUFNLEVBQUM7VUFBUSxDQUFDLENBQUM7VUFFcEVDLDRCQUE0QixHQUFHNUMsRUFBRSxDQUFDQyxRQUFRLENBQUM0QyxjQUFjLENBQUM7WUFBQ2hELFNBQVMsRUFBVEE7VUFBUyxDQUFDLENBQUM7VUFDdEVpRCx5QkFBeUIsR0FBRzlDLEVBQUUsQ0FBQytDLElBQUksQ0FBQ0YsY0FBYyxDQUFDO1lBQUNoRCxTQUFTLEVBQVRBLFNBQVM7WUFBRXdDLFdBQVcsRUFBRTtjQUFFVCxHQUFHLEVBQUU7WUFBSTtVQUFDLENBQUMsQ0FBQztVQUUxRm9CLHdCQUF3QixHQUFHaEQsRUFBRSxDQUFDQyxRQUFRLENBQUM0QyxjQUFjLENBQUM7WUFBQ2hELFNBQVMsRUFBVEEsU0FBUztZQUFFOEMsTUFBTSxFQUFDO1VBQU0sQ0FBQyxDQUFDO1VBQ2pGTSwwQkFBMEIsR0FBR2pELEVBQUUsQ0FBQ0MsUUFBUSxDQUFDNEMsY0FBYyxDQUFDO1lBQUNoRCxTQUFTLEVBQVRBLFNBQVM7WUFBRThDLE1BQU0sRUFBQztVQUFRLENBQUMsQ0FBQztVQUNyRk8sMkJBQTJCLEdBQUdsRCxFQUFFLENBQUNDLFFBQVEsQ0FBQzRDLGNBQWMsQ0FBQztZQUFDaEQsU0FBUyxFQUFUQSxTQUFTO1lBQUU4QyxNQUFNLEVBQUM7VUFBUyxDQUFDLENBQUMsRUFHN0Y7VUFBQTtVQUFBLE9BQzJOUSxPQUFPLENBQUNDLEdBQUcsQ0FBQyxDQUNuT3JELDRCQUE0QixFQUM1QnNCLGNBQWMsRUFDZGEsdUJBQXVCLEVBQ3ZCRSxtQkFBbUIsRUFDbkJJLGlCQUFpQixFQUNqQkksNEJBQTRCLEVBQzVCRSx5QkFBeUIsRUFDekJKLG1CQUFtQixFQUNuQk0sd0JBQXdCLEVBQ3hCQywwQkFBMEIsRUFDMUJDLDJCQUEyQixDQUM5QixDQUFDO1FBQUE7VUFBQTtVQUFBO1VBWktHLHFCQUFxQjtVQUFFQyxPQUFPO1VBQUVDLGdCQUFnQjtVQUFFQyxZQUFZO1VBQUVDLFVBQVU7VUFBRUMscUJBQXFCO1VBQUVDLGtCQUFrQjtVQUFFQyxvQkFBb0I7VUFBRUMsaUJBQWlCO1VBQUVDLG1CQUFtQjtVQUFFQyxvQkFBb0I7VUFlaE47VUFDQXBFLEdBQUcsQ0FBQ3FFLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQ0MsSUFBSSxDQUFDO1lBQ2pCQyxPQUFPLEVBQUUsSUFBSTtZQUNiYixxQkFBcUIsRUFBckJBLHFCQUFxQjtZQUNyQkMsT0FBTyxFQUFQQSxPQUFPO1lBQ1BDLGdCQUFnQixFQUFoQkEsZ0JBQWdCO1lBQ2hCQyxZQUFZLEVBQVpBLFlBQVk7WUFDWkMsVUFBVSxFQUFWQSxVQUFVO1lBQ1ZDLHFCQUFxQixFQUFyQkEscUJBQXFCO1lBQ3JCQyxrQkFBa0IsRUFBbEJBLGtCQUFrQjtZQUNsQkMsb0JBQW9CLEVBQXBCQSxvQkFBb0I7WUFDcEJDLGlCQUFpQixFQUFqQkEsaUJBQWlCO1lBQ2pCQyxtQkFBbUIsRUFBbkJBLG1CQUFtQjtZQUNuQkMsb0JBQW9CLEVBQXBCQTtVQUNKLENBQUMsQ0FBQztVQUFDO1VBQUE7UUFBQTtVQUFBO1VBQUE7VUFHSEksT0FBTyxDQUFDQyxLQUFLLGFBQUs7VUFDbEJ4RSxJQUFJLGFBQUs7UUFBQztRQUFBO1VBQUE7TUFBQTtJQUFBO0VBQUEsQ0FFakI7RUFBQSxnQkEzSUdILFVBQVU7SUFBQTtFQUFBO0FBQUEsR0EySWI7QUFFRCxJQUFNNEUsU0FBUyxHQUFHQyxtQkFBTyxDQUFDQyxNQUFNLEVBQUU7QUFDbENGLFNBQVMsQ0FBQ0csS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDQyxHQUFHLENBQUMsSUFBQUMsbUJBQVEsR0FBRSxFQUFFQyxxQkFBVyxFQUFFLElBQUFDLDBCQUFlLEVBQUMsU0FBUyxDQUFDLEVBQUVuRixVQUFVLENBQUM7QUFBQyxlQUMzRTRFLFNBQVM7QUFBQSJ9