"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _multer = _interopRequireDefault(require("multer"));
var _csvParser = _interopRequireDefault(require("csv-parser"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _strategy = require("../../middlewares/strategy");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _permission = require("../../middlewares/permission");
var _kue = require("../../kue");
var _phone = require("phone");
var batchSize = 2;
var csvPathDir = _path["default"].join(_path["default"].dirname(require.main.filename), "Content", "csv");
var storage = _multer["default"].diskStorage({
  destination: function destination(req, file, cb) {
    cb(null, csvPathDir);
  },
  filename: function filename(req, file, cb) {
    cb(null, file.originalname);
  }
});
var upload = (0, _multer["default"])({
  storage: storage
});
function checkForValidRow(row) {
  var isValid = true;
  isValid = isValid && row && row.country_code && row.phone_number && (0, _phone.phone)(row.country_code + row.phone_number).isValid;
  isValid = isValid && row && row.name && /^[a-zA-Z ]+$/.test(row.name);
  isValid && row && row.status && (row.status.toLowerCase().trim() === "true" || row.status.toLowerCase().trim() === "false");
  return isValid;
}
function processDeactivationBatch(users, companyId, callback) {
  if (users.length == 0) return callback();
  var batch = users.splice(0, batchSize);
  _kue.queue.create('whatsapp-user-save', {
    users: batch,
    companyId: companyId
  }).removeOnComplete(true).priority('high').save(function () {
    if (users.length > 0) {
      processDeactivationBatch(users, companyId, callback);
    } else {
      callback();
    }
  });
}
function processActivationBatch(users, companyId) {
  if (users.length == 0) return;
  var batch = users.splice(0, batchSize);
  _kue.queue.create('whatsapp-user-save', {
    users: batch,
    companyId: companyId
  }).removeOnComplete(true).priority('high').save(function () {
    if (users.length > 0) {
      processActivationBatch(users, companyId);
    }
  });
}
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(req, res, next) {
    var companyId, file, csvReadStream, csvStream, falseUsers, trueUsers;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          companyId = req.user.companyId;
          if (companyId) {
            _context2.next = 4;
            break;
          }
          throw new RequestError("Company not found!");
        case 4:
          file = req.file;
          csvReadStream = _fs["default"].createReadStream(file.path);
          csvStream = (0, _csvParser["default"])();
          falseUsers = [];
          trueUsers = [];
          csvReadStream.pipe(csvStream).on("data", /*#__PURE__*/function () {
            var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(row) {
              return _regenerator["default"].wrap(function _callee$(_context) {
                while (1) switch (_context.prev = _context.next) {
                  case 0:
                    try {
                      if (row != {} && row.name.length != 0 && row.status.length != 0 && row.country_code.length != 0 && row.phone_number.length != 0 && checkForValidRow(row)) {
                        if (row.status.toLowerCase() == 'false') falseUsers.push(row);else if (row.status.toLowerCase() == 'true') trueUsers.push(row);
                      }
                    } catch (error) {}
                  case 1:
                  case "end":
                    return _context.stop();
                }
              }, _callee);
            }));
            return function (_x4) {
              return _ref2.apply(this, arguments);
            };
          }()).on("end", function () {
            processDeactivationBatch(falseUsers, companyId, function () {
              processActivationBatch(trueUsers, companyId);
            });
            _fs["default"].existsSync(file.path, function (exists) {
              if (exists) {
                _fs["default"].unlink(file.path, function (deleteErr) {
                  if (deleteErr) {
                    console.error("Error deleting the uploaded CSV file:", deleteErr);
                  }
                });
              }
            });
            console.log("Read stream is closed...");
          }).on("error", function (err) {
            _fs["default"].unlink(file.path, function (deleteErr) {
              if (deleteErr) {
                console.error("Error deleting the uploaded CSV file:", deleteErr);
              }
            });
          });
          return _context2.abrupt("return", res.status(200).send({
            success: true,
            message: "Contacts will be synced shortly!"
          }));
        case 13:
          _context2.prev = 13;
          _context2.t0 = _context2["catch"](0);
          console.log(_context2.t0);
          next(_context2.t0);
        case 17:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 13]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route("/").post((0, _sanitizeHtml.htmlsanitize)(),
// validateBody(validator), 
_strategy.jwtStrategy, (0, _permission.permission)("Users", "Write"), upload.single("csvFile"), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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