"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = {
  /**
   * Stores the name of Application which can be used 
   * throughout the application. 
   */
  name: process.env.APP_NAME || "TPIR",
  /**
   * Stores the port number on which the application will
   * listen to the requests
   */
  port: process.env.APP_PORT || 8000,
  /**
   * Stores the secret text which will be used while generating 
   * hash keys
   */
  secret: process.env.APP_SECRET || 'NodeJSProject',
  /**
   * Stores app url which can be used as base url
   */
  url: process.env.APP_URL || 'http://localhost:8080',
  /**
   * Stores app url which can be used as base url
   */
  GCTX_KEY: process.env.GCTX_KEY || '',
  /**
   * Stores store url which can be used as base url
   */

  adminURL: process.env.ADMIN_URL || 'http://localhost:6969',
  /**
   * Stores store url which can be used as base url
   */

  type: process.env.APP_TYPE
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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