"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _isURL = _interopRequireDefault(require("validator/lib/isURL"));
var _httpsProxyAgent = require("https-proxy-agent");
var _httpProxyAgent = require("http-proxy-agent");
var cfg = {
  useProxy: process.env.USE_PROXY ? ['true', 'True', 'TRUE', '1'].includes(process.env.USE_PROXY) ? true : false : false,
  proxyUrl: process.env.PROXY_URL ? (0, _isURL["default"])(process.env.PROXY_URL) ? process.env.PROXY_URL : '' : undefined,
  // undefined instead of null, because it's null by default
  proxyAgent: undefined,
  enableForNodeMailer: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_NODEMAILER ? ['true', 'True', 'TRUE', '1'].includes(process.env.PROXY_FOR_NODEMAILER) ? true : false : false),
  enableForMicrosoftGraph: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_MICROSOFT_GRAPH ? ['true', 'True', 'TRUE', '1'].includes(process.env.ENABLE_PROXY_FOR_MICROSOFT_GRAPH) ? true : false : false),
  enableForTA: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_TA ? ['true', 'True', 'TRUE', '1'].includes(process.env.ENABLE_PROXY_FOR_TA) ? true : false : false),
  enableForCM: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_CM ? ['true', 'True', 'TRUE', '1'].includes(process.env.ENABLE_PROXY_FOR_CM) ? true : false : false),
  enableForThreatCop: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_THREATCOP ? ['true', 'True', 'TRUE', '1'].includes(process.env.ENABLE_PROXY_FOR_THREATCOP) ? true : false : false),
  enableForVirusTotal: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_VIRUSTOTAL ? ['true', 'True', 'TRUE', '1'].includes(process.env.ENABLE_PROXY_FOR_VIRUSTOTAL) ? true : false : false),
  enableForGoogleAPIs: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_GOOGLE_APIS ? ['true', 'True', 'TRUE', '1'].includes(process.env.ENABLE_PROXY_FOR_GOOGLE_APIS) ? true : false : false),
  enableForIpLocation: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_IPLOCATION ? ['true', 'True', 'TRUE', '1'].includes(process.env.ENABLE_PROXY_FOR_IPLOCATION) ? true : false : false)
};
if (!cfg.useProxy) {
  console.info("config.proxy: Proxy is disabled. To enable, set process.env.USE_PROXY to any of these ['true', 'True', 'TRUE', '1'].");
} else {
  if (!cfg.proxyUrl) {
    console.error("config.proxy: Proxy is enabled, but proxyUrl doesn't exist. Set process.env.PROXY_URL to a valid URL.");
  } else {
    // both are valid
    // set proxyAgent
    if (cfg.proxyUrl.startsWith('https://')) cfg.proxyAgent = new _httpsProxyAgent.HttpsProxyAgent(cfg.proxyUrl);else if (cfg.proxyUrl.startsWith('http://')) cfg.proxyAgent = new _httpProxyAgent.HttpProxyAgent(cfg.proxyUrl);else console.error("config.proxy: Proxy URL must start with 'http://' or 'https://'.");
    console.info('config.proxy: Proxy is ready.');
  }
}
var _default = cfg;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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