"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _nodeSchedule = _interopRequireDefault(require("node-schedule"));
var _processUser = _interopRequireDefault(require("./service/process-user"));
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var convertTimeToUtc = function convertTimeToUtc(hour, minute, timeZone) {
  var localTime = _momentTimezone["default"].tz({
    hour: hour,
    minute: minute
  }, timeZone);
  var utcDate = localTime.utc().toISOString();
  return utcDate;
};
var syncUsers = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(domain, domainId, companyId) {
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          return _context2.abrupt("return", new Promise( /*#__PURE__*/function () {
            var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(resolve, reject) {
              var deactivateUsers;
              return _regenerator["default"].wrap(function _callee$(_context) {
                while (1) switch (_context.prev = _context.next) {
                  case 0:
                    _context.prev = 0;
                    _context.next = 3;
                    return db.User.updateMany({
                      domainId: domainId,
                      companyId: companyId,
                      userId: {
                        $ne: null
                      }
                    }, {
                      $set: {
                        deletedAt: new Date()
                      }
                    });
                  case 3:
                    deactivateUsers = _context.sent;
                    if (!(domain.domainType == 'Gsuite' || domain.domainType == 'Outlook')) {
                      _context.next = 12;
                      break;
                    }
                    _context.next = 7;
                    return db.Domain.updateOne({
                      _id: domainId
                    }, {
                      isSyncingUser: true,
                      syncStartAt: new Date()
                    });
                  case 7:
                    _context.next = 9;
                    return _processUser["default"].process(companyId, domainId, domain.domainType, false, domain.domainTypeForOutlook == 'EXCHANGE');
                  case 9:
                    resolve(true);
                    _context.next = 16;
                    break;
                  case 12:
                    console.log('Domain type not define');
                    _context.next = 15;
                    return db.Domain.updateOne({
                      _id: domainId
                    }, {
                      isSyncingUser: false,
                      isSyncingUserErrorFile: "Error from scheduling user-sync",
                      isSyncingUserError: true
                    });
                  case 15:
                    reject(false);
                  case 16:
                    _context.next = 23;
                    break;
                  case 18:
                    _context.prev = 18;
                    _context.t0 = _context["catch"](0);
                    _context.next = 22;
                    return db.Domain.updateOne({
                      _id: domainId
                    }, {
                      isSyncingUser: false,
                      isSyncingUserErrorFile: "Error from scheduling user-sync",
                      isSyncingUserError: true
                    });
                  case 22:
                    reject(_context.t0);
                  case 23:
                  case "end":
                    return _context.stop();
                }
              }, _callee, null, [[0, 18]]);
            }));
            return function (_x4, _x5) {
              return _ref2.apply(this, arguments);
            };
          }()));
        case 1:
        case "end":
          return _context2.stop();
      }
    }, _callee2);
  }));
  return function syncUsers(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var scheduleLostCrons = function scheduleLostCrons(domain, domainId, companyId, hour, minute, transformedDays, timeZone) {
  return new Promise( /*#__PURE__*/function () {
    var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(resolve, reject) {
      var rule;
      return _regenerator["default"].wrap(function _callee4$(_context4) {
        while (1) switch (_context4.prev = _context4.next) {
          case 0:
            _context4.prev = 0;
            rule = new _nodeSchedule["default"].RecurrenceRule();
            rule.hour = hour;
            rule.minute = minute;
            rule.dayOfWeek = transformedDays;
            rule.tz = timeZone;
            _nodeSchedule["default"].scheduleJob("".concat(domainId), rule, /*#__PURE__*/(0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3() {
              var deactivateUsers;
              return _regenerator["default"].wrap(function _callee3$(_context3) {
                while (1) switch (_context3.prev = _context3.next) {
                  case 0:
                    _context3.next = 2;
                    return db.User.updateMany({
                      domainId: domainId,
                      companyId: companyId,
                      userId: {
                        $ne: null
                      }
                    }, {
                      $set: {
                        deletedAt: new Date()
                      }
                    });
                  case 2:
                    deactivateUsers = _context3.sent;
                    if (!(domain.domainType == 'Gsuite' || domain.domainType == 'Outlook')) {
                      _context3.next = 10;
                      break;
                    }
                    _context3.next = 6;
                    return db.Domain.updateOne({
                      _id: domainId
                    }, {
                      isSyncingUser: true,
                      syncStartAt: new Date()
                    });
                  case 6:
                    _context3.next = 8;
                    return _processUser["default"].process(companyId, domainId, domain.domainType, false, domain.domainTypeForOutlook == 'EXCHANGE');
                  case 8:
                    _context3.next = 13;
                    break;
                  case 10:
                    _context3.next = 12;
                    return db.Domain.updateOne({
                      _id: domainId
                    }, {
                      isSyncingUser: false,
                      isSyncingUserErrorFile: "Error from scheduling user-sync",
                      isSyncingUserError: true
                    });
                  case 12:
                    console.log('Domain type not define');
                  case 13:
                  case "end":
                    return _context3.stop();
                }
              }, _callee3);
            })));
            resolve(true);
            _context4.next = 16;
            break;
          case 10:
            _context4.prev = 10;
            _context4.t0 = _context4["catch"](0);
            _context4.next = 14;
            return db.Domain.updateOne({
              _id: domainId
            }, (0, _defineProperty2["default"])({
              isSyncingUser: false,
              isSyncingUserError: "Error from scheduling user-sync"
            }, "isSyncingUserError", true));
          case 14:
            console.log('Some error occured recreating jobs');
            reject(_context4.t0);
          case 16:
          case "end":
            return _context4.stop();
        }
      }, _callee4, null, [[0, 10]]);
    }));
    return function (_x6, _x7) {
      return _ref3.apply(this, arguments);
    };
  }());
};
var logScheduledJobs = function logScheduledJobs() {
  var jobs = _nodeSchedule["default"].scheduledJobs;
  console.log('\nCurrently Scheduled Jobs:\n');
  if (Object.keys(jobs).length === 0) {
    console.log('No scheduled jobs found.\n');
    return;
  }
  Object.entries(jobs).forEach(function (_ref5) {
    var _ref6 = (0, _slicedToArray2["default"])(_ref5, 2),
      jobName = _ref6[0],
      job = _ref6[1];
    console.log("Job Name: ".concat(jobName));
    console.log("Next Run At: ".concat(job.nextInvocation(), "\n"));
  });
};
var cronJob = {
  init: function init() {
    // cronJob.execute();
    logScheduledJobs();
  },
  execute: function execute() {
    return (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee5() {
      return _regenerator["default"].wrap(function _callee5$(_context5) {
        while (1) switch (_context5.prev = _context5.next) {
          case 0:
            try {
              // const domains = await db.Domain.find({ 'isScheduledSyncing.isActive': true, deletedAt: null })
              // const dayMapping = { "All": 0, "Monday": 1, "Tuesday": 2, "Wednesday": 3, "Thursday": 4, "Friday": 5, "Saturday": 6, "Sunday": 0 };
              // for (let i = 0; i < domains.length; i++) {

              //     let domain = domains[i]
              //     let hour = domain.isScheduledSyncing.hour
              //     let minute = domain.isScheduledSyncing.minute
              //     let days = domain.isScheduledSyncing.daysOfWeek
              //     let timeZone = domain.isScheduledSyncing.timeZone
              //     let domainId = domain._id
              //     let companyId = domain.companyId

              //     const transformedDays = days.filter(day => day !== "All").map(day => dayMapping[day]);

              //     let convertedTime = new Date(convertTimeToUtc(hour, minute, timeZone))
              //     let todayDay = new Date().getDay()

              //     if (transformedDays.includes(todayDay)) {
              //         const currentTime = new Date()
              //         const lastSynced = domain.syncStartAt
              //         const setSyncTime = convertedTime
              //         if (lastSynced < setSyncTime && setSyncTime < currentTime) {
              //             await syncUsers(domain, domainId, companyId)
              //         }
              //     }

              //     await scheduleLostCrons(domain, domainId, companyId, hour, minute, transformedDays, timeZone)
              // }
              // console.log("\x1b[32mCronJob:\x1b[0m", 'Successfully retrieved and set cron!')
            } catch (error) {
              console.log(error);
              console.error('\x1b[31mCronJob:\x1b[0m', 'something went wrong with recreating cron');
            }
          case 1:
          case "end":
            return _context5.stop();
        }
      }, _callee5);
    }))();
  }
};
var _default = cronJob; // console.log(domain)
// const rule = new schedule.RecurrenceRule();
// rule.hour = hour;
// rule.minute = minute;
// rule.dayOfWeek= transformedDays
// rule.tz = timeZone;
// const scheduledJob = schedule.scheduleJob(domainId, rule, async () => {
//     let deactivateUsers = await db.User.updateMany(
//         { domainId, userId: { $ne: null } },
//         { $set: { deletedAt: new Date() } }
//     );
//     if(domain.domainType == 'Gsuite' || domain.domainType == 'Outlook'){
//             await db.Domain.updateOne({
//                 _id: domainId
//             }, {
//                 isSyncingUser: true,
//                 syncStartAt: new Date()
//             })
//             await processUser.process(companyId, domainId, domain.domainType, domain.domainTypeForOutlook=='EXCHANGE');
//     } else {
//         throw new RequestError('Domain type not define');
//     }
// });
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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