"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.whatsappResultTemplate = exports.whatsappAffirmTemplate = exports.whatsappActionTemplate = exports.updateReportedMailCache = exports.tryParseJSON = exports.randomString = exports.gracefullyShutdown = exports.get_end_point_name = exports.getReportedMailFromCache = exports.cleanText = exports.cleanDictionaryAndSpecialChars = exports.cacheReportedMail = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _zlib = _interopRequireDefault(require("zlib"));
var _languageService = _interopRequireDefault(require("./service/languageService"));
var words = require('an-array-of-english-words');
var messages = {
  finalAnalysisMessage: {
    english: function english(ticketId, result) {
      return "*Security Update: Final Analysis of Your Reported Message*. \n\nTicket ID - ".concat(ticketId, "\n\nThank you for your vigilance. After analyzing the message, our system flagged it as *").concat(result, "*. However, we take extra measures to ensure that you\u2019re fully protected, so our security team has reviewed the message again to provide an additional layer of analysis.\n\nBased on their review, they have marked the message as *").concat(result, "*. We always prioritize your security and appreciate your help in maintaining a safe environment.\n\n`Thank you for the commitment to online safety.`");
    },
    indonesian: function indonesian(ticketId, result) {
      return "*Pembaruan Keamanan: Analisis Akhir dari Pesan yang Anda Laporkan*. \n\nTiket ID - ".concat(ticketId, "\n\nTerima kasih atas kewaspadaan Anda. Setelah menganalisis pesan, sistem kami menandainya sebagai *").concat(result, "*. Namun, kami mengambil langkah ekstra untuk memastikan Anda sepenuhnya terlindungi, jadi tim keamanan kami telah meninjau pesan tersebut lagi.\n\nBerdasarkan peninjauan mereka, pesan tersebut ditandai sebagai *").concat(result, "*. Kami selalu mengutamakan keamanan Anda dan menghargai bantuan Anda dalam menjaga lingkungan yang aman.\n\n`Terima kasih atas komitmen Anda terhadap keamanan online.`");
    },
    arabic: function arabic(ticketId, result) {
      return "*\u062A\u062D\u062F\u064A\u062B \u0623\u0645\u0646\u064A: \u0627\u0644\u062A\u062D\u0644\u064A\u0644 \u0627\u0644\u0646\u0647\u0627\u0626\u064A \u0644\u0631\u0633\u0627\u0644\u062A\u0643 \u0627\u0644\u0645\u064F\u0628\u0644\u0651\u064E\u063A \u0639\u0646\u0647\u0627*. \n\n\u0645\u0639\u0631\u0641 \u0627\u0644\u062A\u0630\u0643\u0631\u0629 - ".concat(ticketId, "\n\n\u0634\u0643\u0631\u064B\u0627 \u0644\u064A\u0642\u0638\u062A\u0643. \u0628\u0639\u062F \u062A\u062D\u0644\u064A\u0644 \u0627\u0644\u0631\u0633\u0627\u0644\u0629\u060C \u0623\u0634\u0627\u0631 \u0646\u0638\u0627\u0645\u0646\u0627 \u0625\u0644\u0649 \u0623\u0646\u0647\u0627 *").concat(result, "*. \u0648\u0645\u0639 \u0630\u0644\u0643\u060C \u0646\u062A\u062E\u0630 \u062A\u062F\u0627\u0628\u064A\u0631 \u0625\u0636\u0627\u0641\u064A\u0629 \u0644\u0636\u0645\u0627\u0646 \u062D\u0645\u0627\u064A\u062A\u0643 \u0627\u0644\u0643\u0627\u0645\u0644\u0629\u060C \u0644\u0630\u0627 \u0631\u0627\u062C\u0639 \u0641\u0631\u064A\u0642 \u0627\u0644\u0623\u0645\u0627\u0646 \u0627\u0644\u0631\u0633\u0627\u0644\u0629 \u0645\u0631\u0629 \u0623\u062E\u0631\u0649.\n\n\u0627\u0633\u062A\u0646\u0627\u062F\u064B\u0627 \u0625\u0644\u0649 \u0645\u0631\u0627\u062C\u0639\u062A\u0647\u0645\u060C \u062A\u0645 \u062A\u0635\u0646\u064A\u0641 \u0627\u0644\u0631\u0633\u0627\u0644\u0629 \u0639\u0644\u0649 \u0623\u0646\u0647\u0627 *").concat(result, "*. \u0646\u062D\u0646 \u0646\u0639\u0637\u064A \u0627\u0644\u0623\u0648\u0644\u0648\u064A\u0629 \u0644\u0623\u0645\u0646\u0643 \u0648\u0646\u0642\u062F\u0651\u0631 \u0645\u0633\u0627\u0639\u062F\u062A\u0643 \u0641\u064A \u0627\u0644\u062D\u0641\u0627\u0638 \u0639\u0644\u0649 \u0628\u064A\u0626\u0629 \u0622\u0645\u0646\u0629.\n\n`\u0634\u0643\u0631\u064B\u0627 \u0644\u0643 \u0639\u0644\u0649 \u0627\u0644\u062A\u0632\u0627\u0645\u0643 \u0628\u0627\u0644\u0633\u0644\u0627\u0645\u0629 \u0639\u0628\u0631 \u0627\u0644\u0625\u0646\u062A\u0631\u0646\u062A.`");
    },
    french: function french(ticketId, result) {
      return "*Mise \xE0 jour de s\xE9curit\xE9 : Analyse finale de votre message signal\xE9*. \n\nID du ticket - ".concat(ticketId, "\n\nMerci pour votre vigilance. Apr\xE8s avoir analys\xE9 le message, notre syst\xE8me l'a signal\xE9 comme *").concat(result, "*. Cependant, nous prenons des mesures suppl\xE9mentaires pour garantir votre s\xE9curit\xE9, c'est pourquoi notre \xE9quipe de s\xE9curit\xE9 a revu le message.\n\nSuite \xE0 leur examen, ils ont marqu\xE9 le message comme *").concat(result, "*. Nous priorisons toujours votre s\xE9curit\xE9 et appr\xE9cions votre aide pour maintenir un environnement s\xFBr.\n\n`Merci pour votre engagement envers la s\xE9curit\xE9 en ligne.`");
    },
    spanish: function spanish(ticketId, result) {
      return "*Actualizaci\xF3n de seguridad: An\xE1lisis final de su mensaje reportado*. \n\nID de ticket - ".concat(ticketId, "\n\nGracias por su vigilancia. Despu\xE9s de analizar el mensaje, nuestro sistema lo marc\xF3 como *").concat(result, "*. Sin embargo, tomamos medidas adicionales para garantizar su protecci\xF3n total, por lo que nuestro equipo de seguridad revis\xF3 el mensaje nuevamente.\n\nSeg\xFAn su revisi\xF3n, el mensaje ha sido marcado como *").concat(result, "*. Siempre priorizamos su seguridad y agradecemos su ayuda para mantener un entorno seguro.\n\n`Gracias por su compromiso con la seguridad en l\xEDnea.`");
    },
    german: function german(ticketId, result) {
      return "*Sicherheitsupdate: Endg\xFCltige Analyse Ihrer gemeldeten Nachricht*. \n\nTicket-ID - ".concat(ticketId, "\n\nVielen Dank f\xFCr Ihre Wachsamkeit. Nach der Analyse der Nachricht hat unser System sie als *").concat(result, "* gekennzeichnet. Wir ergreifen jedoch zus\xE4tzliche Ma\xDFnahmen, um Ihre vollst\xE4ndige Sicherheit zu gew\xE4hrleisten, daher hat unser Sicherheitsteam die Nachricht erneut \xFCberpr\xFCft.\n\nBasierend auf ihrer \xDCberpr\xFCfung wurde die Nachricht als *").concat(result, "* markiert. Wir priorisieren stets Ihre Sicherheit und sch\xE4tzen Ihre Hilfe bei der Aufrechterhaltung eines sicheren Umfelds.\n\n`Vielen Dank f\xFCr Ihr Engagement f\xFCr die Online-Sicherheit.`");
    },
    russian: function russian(ticketId, result) {
      return "*\u041E\u0431\u043D\u043E\u0432\u043B\u0435\u043D\u0438\u0435 \u0431\u0435\u0437\u043E\u043F\u0430\u0441\u043D\u043E\u0441\u0442\u0438: \u043E\u043A\u043E\u043D\u0447\u0430\u0442\u0435\u043B\u044C\u043D\u044B\u0439 \u0430\u043D\u0430\u043B\u0438\u0437 \u0432\u0430\u0448\u0435\u0433\u043E \u0441\u043E\u043E\u0431\u0449\u0435\u043D\u0438\u044F*. \n\n\u041D\u043E\u043C\u0435\u0440 \u0437\u0430\u044F\u0432\u043A\u0438 - ".concat(ticketId, "\n\n\u0421\u043F\u0430\u0441\u0438\u0431\u043E \u0437\u0430 \u0432\u0430\u0448\u0443 \u0431\u0434\u0438\u0442\u0435\u043B\u044C\u043D\u043E\u0441\u0442\u044C. \u041F\u043E\u0441\u043B\u0435 \u0430\u043D\u0430\u043B\u0438\u0437\u0430 \u0441\u043E\u043E\u0431\u0449\u0435\u043D\u0438\u0435 \u0431\u044B\u043B\u043E \u043F\u043E\u043C\u0435\u0447\u0435\u043D\u043E \u0441\u0438\u0441\u0442\u0435\u043C\u043E\u0439 \u043A\u0430\u043A *").concat(result, "*. \u0422\u0435\u043C \u043D\u0435 \u043C\u0435\u043D\u0435\u0435, \u043C\u044B \u043F\u0440\u0435\u0434\u043F\u0440\u0438\u043D\u0438\u043C\u0430\u0435\u043C \u0434\u043E\u043F\u043E\u043B\u043D\u0438\u0442\u0435\u043B\u044C\u043D\u044B\u0435 \u043C\u0435\u0440\u044B \u0434\u043B\u044F \u0432\u0430\u0448\u0435\u0439 \u043F\u043E\u043B\u043D\u043E\u0439 \u0437\u0430\u0449\u0438\u0442\u044B, \u043F\u043E\u044D\u0442\u043E\u043C\u0443 \u043D\u0430\u0448\u0430 \u0441\u043B\u0443\u0436\u0431\u0430 \u0431\u0435\u0437\u043E\u043F\u0430\u0441\u043D\u043E\u0441\u0442\u0438 \u043F\u043E\u0432\u0442\u043E\u0440\u043D\u043E \u0435\u0433\u043E \u043F\u0440\u043E\u0432\u0435\u0440\u0438\u043B\u0430.\n\n\u041F\u043E \u0440\u0435\u0437\u0443\u043B\u044C\u0442\u0430\u0442\u0430\u043C \u043F\u043E\u0432\u0442\u043E\u0440\u043D\u043E\u0439 \u043F\u0440\u043E\u0432\u0435\u0440\u043A\u0438 \u0441\u043E\u043E\u0431\u0449\u0435\u043D\u0438\u0435 \u043F\u043E\u043C\u0435\u0447\u0435\u043D\u043E \u043A\u0430\u043A *").concat(result, "*. \u041C\u044B \u0432\u0441\u0435\u0433\u0434\u0430 \u0441\u0442\u0430\u0432\u0438\u043C \u0432\u0430\u0448\u0443 \u0431\u0435\u0437\u043E\u043F\u0430\u0441\u043D\u043E\u0441\u0442\u044C \u0432 \u043F\u0440\u0438\u043E\u0440\u0438\u0442\u0435\u0442 \u0438 \u0431\u043B\u0430\u0433\u043E\u0434\u0430\u0440\u0438\u043C \u0437\u0430 \u043F\u043E\u043C\u043E\u0449\u044C \u0432 \u043F\u043E\u0434\u0434\u0435\u0440\u0436\u0430\u043D\u0438\u0438 \u0431\u0435\u0437\u043E\u043F\u0430\u0441\u043D\u043E\u0439 \u0441\u0440\u0435\u0434\u044B.\n\n`\u0421\u043F\u0430\u0441\u0438\u0431\u043E \u0437\u0430 \u0432\u0430\u0448\u0443 \u043F\u0440\u0438\u0432\u0435\u0440\u0436\u0435\u043D\u043D\u043E\u0441\u0442\u044C \u043E\u043D\u043B\u0430\u0439\u043D-\u0431\u0435\u0437\u043E\u043F\u0430\u0441\u043D\u043E\u0441\u0442\u0438.`");
    },
    chinese_simplified: function chinese_simplified(ticketId, result) {
      return "*\u5B89\u5168\u66F4\u65B0\uFF1A\u60A8\u4E3E\u62A5\u4FE1\u606F\u7684\u6700\u7EC8\u5206\u6790\u7ED3\u679C*. \n\n\u5DE5\u5355\u7F16\u53F7 - ".concat(ticketId, "\n\n\u611F\u8C22\u60A8\u7684\u8B66\u89C9\u3002\u7ECF\u8FC7\u5206\u6790\uFF0C\u6211\u4EEC\u7684\u7CFB\u7EDF\u5C06\u8BE5\u6D88\u606F\u6807\u8BB0\u4E3A *").concat(result, "*\u3002\u4E3A\u786E\u4FDD\u60A8\u7684\u5168\u9762\u5B89\u5168\uFF0C\u6211\u4EEC\u7684\u5B89\u5168\u56E2\u961F\u5BF9\u8BE5\u6D88\u606F\u8FDB\u884C\u4E86\u518D\u6B21\u5BA1\u6838\u3002\n\n\u4ED6\u4EEC\u5C06\u8BE5\u6D88\u606F\u6807\u8BB0\u4E3A *").concat(result, "*\u3002\u6211\u4EEC\u59CB\u7EC8\u5C06\u60A8\u7684\u5B89\u5168\u7F6E\u4E8E\u9996\u4F4D\uFF0C\u611F\u8C22\u60A8\u4E3A\u7EF4\u62A4\u5B89\u5168\u73AF\u5883\u6240\u505A\u7684\u8D21\u732E\u3002\n\n`\u611F\u8C22\u60A8\u5BF9\u7F51\u7EDC\u5B89\u5168\u7684\u627F\u8BFA\u3002`");
    },
    chinese_traditional: function chinese_traditional(ticketId, result) {
      return "*\u5B89\u5168\u66F4\u65B0\uFF1A\u60A8\u6AA2\u8209\u8A0A\u606F\u7684\u6700\u7D42\u5206\u6790\u7D50\u679C*. \n\n\u5DE5\u55AE\u7DE8\u865F - ".concat(ticketId, "\n\n\u611F\u8B1D\u60A8\u7684\u8B66\u89BA\u3002\u6211\u5011\u7684\u7CFB\u7D71\u5728\u5206\u6790\u5F8C\u5C07\u6B64\u8A0A\u606F\u6A19\u8A18\u70BA *").concat(result, "*\u3002\u70BA\u4E86\u78BA\u4FDD\u60A8\u7684\u5B89\u5168\uFF0C\u6211\u5011\u7684\u5B89\u5168\u5718\u968A\u518D\u6B21\u5BE9\u67E5\u4E86\u8A72\u8A0A\u606F\u3002\n\n\u6839\u64DA\u5BE9\u67E5\u7D50\u679C\uFF0C\u6B64\u8A0A\u606F\u88AB\u6A19\u8A18\u70BA *").concat(result, "*\u3002\u6211\u5011\u59CB\u7D42\u512A\u5148\u8003\u616E\u60A8\u7684\u5B89\u5168\uFF0C\u611F\u8B1D\u60A8\u5354\u52A9\u7DAD\u8B77\u5B89\u5168\u7684\u7DB2\u7D61\u74B0\u5883\u3002\n\n`\u611F\u8B1D\u60A8\u5C0D\u7DB2\u7D61\u5B89\u5168\u7684\u627F\u8AFE\u3002`");
    },
    japanese: function japanese(ticketId, result) {
      return "*\u30BB\u30AD\u30E5\u30EA\u30C6\u30A3\u66F4\u65B0\uFF1A\u5831\u544A\u3055\u308C\u305F\u30E1\u30C3\u30BB\u30FC\u30B8\u306E\u6700\u7D42\u5206\u6790*. \n\n\u30C1\u30B1\u30C3\u30C8ID - ".concat(ticketId, "\n\n\u3054\u5831\u544A\u3042\u308A\u304C\u3068\u3046\u3054\u3056\u3044\u307E\u3059\u3002\u5206\u6790\u306E\u7D50\u679C\u3001\u30B7\u30B9\u30C6\u30E0\u306F\u3053\u306E\u30E1\u30C3\u30BB\u30FC\u30B8\u3092 *").concat(result, "* \u3068\u5224\u5B9A\u3057\u307E\u3057\u305F\u3002\u66F4\u306A\u308B\u5B89\u5168\u6027\u3092\u78BA\u4FDD\u3059\u308B\u305F\u3081\u3001\u30BB\u30AD\u30E5\u30EA\u30C6\u30A3\u30C1\u30FC\u30E0\u304C\u518D\u5EA6\u78BA\u8A8D\u3092\u884C\u3044\u307E\u3057\u305F\u3002\n\n\u305D\u306E\u7D50\u679C\u3001\u30E1\u30C3\u30BB\u30FC\u30B8\u306F *").concat(result, "* \u3068\u6700\u7D42\u5224\u5B9A\u3055\u308C\u307E\u3057\u305F\u3002\u79C1\u305F\u3061\u306F\u5E38\u306B\u304A\u5BA2\u69D8\u306E\u5B89\u5168\u3092\u6700\u512A\u5148\u3068\u3057\u3001\u5B89\u5168\u306A\u74B0\u5883\u3092\u7DAD\u6301\u3059\u308B\u305F\u3081\u306E\u3054\u5354\u529B\u306B\u611F\u8B1D\u3044\u305F\u3057\u307E\u3059\u3002\n\n`\u30AA\u30F3\u30E9\u30A4\u30F3\u30BB\u30AD\u30E5\u30EA\u30C6\u30A3\u3078\u306E\u3054\u5354\u529B\u3042\u308A\u304C\u3068\u3046\u3054\u3056\u3044\u307E\u3059\u3002`");
    },
    korean: function korean(ticketId, result) {
      return "*\uBCF4\uC548 \uC5C5\uB370\uC774\uD2B8: \uC2E0\uACE0\uB41C \uBA54\uC2DC\uC9C0\uC758 \uCD5C\uC885 \uBD84\uC11D \uACB0\uACFC*. \n\n\uD2F0\uCF13 ID - ".concat(ticketId, "\n\n\uACBD\uACC4\uB97C \uC720\uC9C0\uD574 \uC8FC\uC154\uC11C \uAC10\uC0AC\uD569\uB2C8\uB2E4. \uBA54\uC2DC\uC9C0\uB97C \uBD84\uC11D\uD55C \uACB0\uACFC, \uC2DC\uC2A4\uD15C\uC740 \uC774\uB97C *").concat(result, "*\uB85C \uD45C\uC2DC\uD588\uC2B5\uB2C8\uB2E4. \uADF8\uB7EC\uB098 \uADC0\uD558\uC758 \uC644\uC804\uD55C \uBCF4\uD638\uB97C \uC704\uD574 \uBCF4\uC548\uD300\uC774 \uBA54\uC2DC\uC9C0\uB97C \uB2E4\uC2DC \uAC80\uD1A0\uD588\uC2B5\uB2C8\uB2E4.\n\n\uAC80\uD1A0 \uACB0\uACFC, \uD574\uB2F9 \uBA54\uC2DC\uC9C0\uB294 *").concat(result, "*\uB85C \uD310\uB2E8\uB418\uC5C8\uC2B5\uB2C8\uB2E4. \uC6B0\uB9AC\uB294 \uD56D\uC0C1 \uADC0\uD558\uC758 \uBCF4\uC548\uC744 \uCD5C\uC6B0\uC120\uC73C\uB85C \uD558\uBA70 \uC548\uC804\uD55C \uD658\uACBD \uC720\uC9C0\uB97C \uC704\uD55C \uB3C4\uC6C0\uC5D0 \uAC10\uC0AC\uB4DC\uB9BD\uB2C8\uB2E4.\n\n`\uC628\uB77C\uC778 \uC548\uC804\uC5D0 \uB300\uD55C \uD5CC\uC2E0\uC5D0 \uAC10\uC0AC\uB4DC\uB9BD\uB2C8\uB2E4.`");
    }
  }
};
var get_end_point_name = function get_end_point_name(filename) {
  return filename.split('/')[filename.split('/').length ? filename.split('/').length - 1 : filename].split('.')[0];
};
exports.get_end_point_name = get_end_point_name;
var randomString = function randomString(len, charSet) {
  charSet = charSet || 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
  var randomString = '';
  for (var i = 0; i < len; i++) {
    var randomPoz = Math.floor(Math.random() * charSet.length);
    randomString += charSet.substring(randomPoz, randomPoz + 1);
  }
  return randomString;
};
exports.randomString = randomString;
var cleanDictionaryAndSpecialChars = function cleanDictionaryAndSpecialChars(text) {
  var dictionary = new Set(words);
  var wordArray = text.split(/\s+/);
  // Remove punctuation from each word and filter out non-dictionary words
  var filteredWords = wordArray.filter(function (word) {
    // Remove punctuation
    var cleanWord = word.replace(/[.,/#!$%^&?*;:{}=\-_`~()]/g, "").toLowerCase();
    // Check if the cleaned word is in the dictionary
    return dictionary.has(cleanWord);
  });
  var filteredDictionaryWords = filteredWords.join(' ');
  filteredDictionaryWords.replace(/\\r\\n|\\n|\\r|\\t/g, ' ');
  var finalText = filteredDictionaryWords.replace(/\s+/g, ' ').trim();
  return finalText;
};
exports.cleanDictionaryAndSpecialChars = cleanDictionaryAndSpecialChars;
var cleanText = function cleanText(text) {
  text = text.replace(/(\r\n|\n|\r)/gm, '');
  text = text.replace(/\t/g, '');
  text = text.replace(/ {5,}/g, '    ');
  if (text.length >= 1024) {
    text = text.substring(0, 928) + '...';
  }
  console.log("length---", text.length);
  return text;
};
exports.cleanText = cleanText;
var cacheReportedMail = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(reportedEmail) {
    var reportedMailBuffer, reportedMailString, _cacheReportedMail;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          reportedMailBuffer = _zlib["default"].deflateSync(JSON.stringify(reportedEmail));
          reportedMailString = reportedMailBuffer.toString('base64');
          _context.next = 5;
          return redisClient.set(reportedEmail._id.toString(), JSON.stringify(reportedMailString), 'EX', 60);
        case 5:
          _cacheReportedMail = _context.sent;
          _context.next = 8;
          return redisClient.expire(reportedEmail._id.toString(), 1200);
        case 8:
          console.log("--------------Successfully Cached Reported Mail------------------", reportedEmail._id);
          _context.next = 15;
          break;
        case 11:
          _context.prev = 11;
          _context.t0 = _context["catch"](0);
          console.log('-----------Error Saving Reported Mail----------', _context.t0);
          return _context.abrupt("return", _context.t0);
        case 15:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 11]]);
  }));
  return function cacheReportedMail(_x) {
    return _ref.apply(this, arguments);
  };
}();
exports.cacheReportedMail = cacheReportedMail;
var getReportedMailFromCache = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(reportedMailId) {
    var reportedMail, decompressedReportedMailBuffer, decompressedReportedMailString;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _context2.next = 3;
          return redisClient.get(reportedMailId);
        case 3:
          reportedMail = _context2.sent;
          if (!reportedMail) {
            _context2.next = 11;
            break;
          }
          decompressedReportedMailBuffer = _zlib["default"].inflateSync(Buffer.from(reportedMail, 'base64'));
          decompressedReportedMailString = JSON.parse(decompressedReportedMailBuffer.toString('utf8'));
          console.log("--------------Successfully Fetched Reported Mail From Cache------------------", reportedMailId);
          return _context2.abrupt("return", decompressedReportedMailString);
        case 11:
          return _context2.abrupt("return", null);
        case 12:
          _context2.next = 18;
          break;
        case 14:
          _context2.prev = 14;
          _context2.t0 = _context2["catch"](0);
          console.log('-----------Error Fetching Reported Mail----------', _context2.t0);
          return _context2.abrupt("return", _context2.t0);
        case 18:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 14]]);
  }));
  return function getReportedMailFromCache(_x2) {
    return _ref2.apply(this, arguments);
  };
}();
exports.getReportedMailFromCache = getReportedMailFromCache;
var updateReportedMailCache = /*#__PURE__*/function () {
  var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(reportedMailId, field) {
    var reportedMail, decompressedBuffer, decompressedString, key, compressedBuffer, compressedString;
    return _regenerator["default"].wrap(function _callee3$(_context3) {
      while (1) switch (_context3.prev = _context3.next) {
        case 0:
          _context3.prev = 0;
          _context3.next = 3;
          return redisClient.get(reportedMailId);
        case 3:
          reportedMail = _context3.sent;
          if (!reportedMail) {
            _context3.next = 15;
            break;
          }
          decompressedBuffer = _zlib["default"].inflateSync(Buffer.from(reportedMail, 'base64'));
          decompressedString = JSON.parse(decompressedBuffer.toString('utf8'));
          for (key in field) {
            decompressedString[key] = field[key];
          }
          compressedBuffer = _zlib["default"].deflateSync(JSON.stringify(decompressedString));
          compressedString = compressedBuffer.toString('base64');
          _context3.next = 12;
          return redisClient.set(reportedMailId, compressedString);
        case 12:
          _context3.next = 14;
          return redisClient.expire(reportedMailId.toString(), 1200);
        case 14:
          return _context3.abrupt("return", true);
        case 15:
          _context3.next = 20;
          break;
        case 17:
          _context3.prev = 17;
          _context3.t0 = _context3["catch"](0);
          return _context3.abrupt("return", _context3.t0);
        case 20:
        case "end":
          return _context3.stop();
      }
    }, _callee3, null, [[0, 17]]);
  }));
  return function updateReportedMailCache(_x3, _x4) {
    return _ref3.apply(this, arguments);
  };
}();
exports.updateReportedMailCache = updateReportedMailCache;
var gracefullyShutdown = /*#__PURE__*/function () {
  var _ref4 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4() {
    var _yield$Promise$all, _yield$Promise$all2, globalRedisError, redisError, serverError, sequelizeError, hasError;
    return _regenerator["default"].wrap(function _callee4$(_context4) {
      while (1) switch (_context4.prev = _context4.next) {
        case 0:
          _context4.prev = 0;
          if (!calledOnce) {
            _context4.next = 3;
            break;
          }
          return _context4.abrupt("return");
        case 3:
          calledOnce = true;
          _context4.next = 6;
          return Promise.all([globalRedisGracefulShutdown(), redisGracefulShutdown(), serverGracefulShutdown(server), sequelizeGracefulShutdown()]);
        case 6:
          _yield$Promise$all = _context4.sent;
          _yield$Promise$all2 = (0, _slicedToArray2["default"])(_yield$Promise$all, 4);
          globalRedisError = _yield$Promise$all2[0];
          redisError = _yield$Promise$all2[1];
          serverError = _yield$Promise$all2[2];
          sequelizeError = _yield$Promise$all2[3];
          hasError = globalRedisError || redisError || serverError || sequelizeError;
          process.exit(hasError ? 1 : 0);
          _context4.next = 20;
          break;
        case 16:
          _context4.prev = 16;
          _context4.t0 = _context4["catch"](0);
          console.log("Graceful shut down error: ".concat(_context4.t0, " !"));
          process.exit(1);
        case 20:
        case "end":
          return _context4.stop();
      }
    }, _callee4, null, [[0, 16]]);
  }));
  return function gracefullyShutdown() {
    return _ref4.apply(this, arguments);
  };
}();

// async function handleResponse(message) {
//   try {
//      let parseMessage = JSON.parse(message)
//       if (Array.isArray(parseMessage)) {
//           console.log('Received JSON array:', message);
//           return 'Array'
//       }
//       else return 'String'
//   } catch (error) {
//       console.log('Received response is a string so handling the string directly as investigated content.',error);
//       return 'String'
//     }
// }
exports.gracefullyShutdown = gracefullyShutdown;
var tryParseJSON = function tryParseJSON(jsonString) {
  try {
    return JSON.parse(jsonString);
  } catch (error) {
    return false;
  }
};
exports.tryParseJSON = tryParseJSON;
function handleResponse(_x5) {
  return _handleResponse.apply(this, arguments);
}
function _handleResponse() {
  _handleResponse = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee6(message) {
    var parsedMessage;
    return _regenerator["default"].wrap(function _callee6$(_context6) {
      while (1) switch (_context6.prev = _context6.next) {
        case 0:
          parsedMessage = tryParseJSON(message);
          return _context6.abrupt("return", Array.isArray(parsedMessage) ? 'Array' : 'String');
        case 2:
        case "end":
          return _context6.stop();
      }
    }, _callee6);
  }));
  return _handleResponse.apply(this, arguments);
}
var whatsappResultTemplate = /*#__PURE__*/function () {
  var _ref5 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee5(message, ticketId, preferedLanguage) {
    var checkTypeOfMessage, formattedMessage, sender, overallResult, messageSummary, summary, _extractedMessage$, _messageArray$1$, _messageArray$1$2, _messageArray, extractedMessage, _messageArray$1$3, _messageArray$1$4, template;
    return _regenerator["default"].wrap(function _callee5$(_context5) {
      while (1) switch (_context5.prev = _context5.next) {
        case 0:
          _context5.next = 2;
          return handleResponse(message);
        case 2:
          checkTypeOfMessage = _context5.sent;
          console.log({
            checkTypeOfMessage: checkTypeOfMessage
          });
          formattedMessage = "";
          sender = ''; // let originalResponse = JSON.stringify(message);
          overallResult = '';
          messageSummary = '';
          summary = '';
          if (checkTypeOfMessage === 'Array') {
            _messageArray = JSON.parse(message);
            extractedMessage = _messageArray[0];
            if (extractedMessage.length == 1) messageSummary = extractedMessage[0]['Message Body'];else messageSummary = "Multiple Messages";
            console.log({
              djasmdkaslmldkasmlkdmsal: extractedMessage[0],
              gggg: extractedMessage[0]["Message Body"]
            });
            sender = (_extractedMessage$ = extractedMessage[0]) === null || _extractedMessage$ === void 0 ? void 0 : _extractedMessage$.Sender;
            overallResult = (_messageArray$1$ = _messageArray[1][0]) === null || _messageArray$1$ === void 0 ? void 0 : _messageArray$1$.decision;
            formattedMessage = extractedMessage.map(function (msg, index) {
              return "*Message ".concat(index + 1, ":*\n*Sender*: ").concat(msg === null || msg === void 0 ? void 0 : msg.Sender, "\n*Message Body:* ").concat(msg['Message Body'], "\n*Safety Parameter:* ").concat(msg['Safety Parameter'], "\n*Description:* ").concat(msg === null || msg === void 0 ? void 0 : msg.Description, "\n        ");
            }).join('\n\n');
            summary = (_messageArray$1$2 = _messageArray[1][0]) === null || _messageArray$1$2 === void 0 ? void 0 : _messageArray$1$2.summary;
          } else {
            formattedMessage = message;
            messageSummary = message;
            summary = (_messageArray$1$3 = messageArray[1][0]) === null || _messageArray$1$3 === void 0 ? void 0 : _messageArray$1$3.summary;
            overallResult = (_messageArray$1$4 = messageArray[1][0]) === null || _messageArray$1$4 === void 0 ? void 0 : _messageArray$1$4.decision;
          }

          // const template = `
          //     *Ticket Id* - ${ticketId} \n Please find the investigation report below.\n\n*Investigated Content* - \nSafety Parameter - ${overallResult}\n\n${summary}\n\n\`Thank you for the commitment to online safety.\`
          // `;
          _context5.next = 12;
          return (0, _languageService["default"])("investigation", preferedLanguage, {
            ticketId: ticketId,
            overallResult: overallResult,
            summary: summary
          });
        case 12:
          template = _context5.sent;
          return _context5.abrupt("return", {
            template: template,
            originalResponse: message,
            sender: sender,
            overallResult: overallResult,
            messageSummary: messageSummary
          });
        case 14:
        case "end":
          return _context5.stop();
      }
    }, _callee5);
  }));
  return function whatsappResultTemplate(_x6, _x7, _x8) {
    return _ref5.apply(this, arguments);
  };
}();

// export let whatsappActionTemplate = ( ticketId, result, preferedLanguage) =>{
//   return `*Security Update: Final Analysis of Your Reported Message*. \n\nTicket ID - ${ticketId}\n\nThank you for your vigilance. After analyzing the message, our system flagged it as *${result}*. However, we take extra measures to ensure that you’re fully protected, so our security team has reviewed the message again to provide an additional layer of analysis.\n\nBased on their review, they have marked the message as *${result}*. We always prioritize your security and appreciate your help in maintaining a safe environment.\n\n \`Thank you for the commitment to online safety.\``
// }
exports.whatsappResultTemplate = whatsappResultTemplate;
var whatsappActionTemplate = function whatsappActionTemplate(ticketId, result, preferedLanguage) {
  var language = typeof preferedLanguage === 'string' && preferedLanguage.length > 0 ? preferedLanguage.toLowerCase() : 'english';
  var lang = messages.finalAnalysisMessage[language] ? language : "english";
  return messages.finalAnalysisMessage[lang](ticketId, result);
};
exports.whatsappActionTemplate = whatsappActionTemplate;
var whatsappAffirmTemplate = function whatsappAffirmTemplate(ticketId, to) {
  return {
    messaging_product: "whatsapp",
    "type": "template",
    to: to,
    "text": {
      "body": "Do you like to process this text? if no, please crop the image accordingly and send again."
    },
    template: {
      namespace: "053243c9_c1ad_47da_9cc0_ae30508f0429",
      name: "affirm_template",
      language: {
        code: "en",
        policy: "deterministic"
      },
      components: [{
        "type": "body",
        "parameters": [{
          "type": "text",
          "text": ticketId
        }]
      }]
    }
  };
};
exports.whatsappAffirmTemplate = whatsappAffirmTemplate;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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