"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var features = [{
  name: "Custom Smtp",
  description: "Ability to add their custom SMTP to send notification emails.",
  category: "Notifications",
  type: "dynamic",
  featureCode: "TPIR-CSTM"
}, {
  name: "Email Alert to SOC Team for threat reports. Threshold configurable",
  description: "Send alerts to the SOC team when a mail is reported with configurable soc emails.",
  category: "Notifications",
  type: "dynamic",
  featureCode: "TPIR-EASOC"
}, {
  name: "Report Notification",
  description: "Notify users when a mail is reported.",
  category: "Notifications",
  type: "dynamic",
  featureCode: "TPIR-RN"
}, {
  name: "Notification to user on action taken on email",
  description: "Notify users about actions taken on reported emails.",
  category: "Notifications",
  type: "dynamic",
  featureCode: "TPIR-NACT"
}, {
  name: "Customisable Email Templates",
  description: "Provide customizable templates for notification emails.",
  category: "Notifications",
  type: "dynamic",
  featureCode: "TPIR-CET"
}, {
  name: "View Reported Email",
  description: "Ability to view reported email.",
  category: "Analytics",
  type: "dynamic",
  featureCode: "TPIR-VRE"
}, {
  name: "View Reported Email Body",
  description: "Ability to view reported email.",
  category: "Analytics",
  type: "dynamic",
  featureCode: "TPIR-VREB"
}, {
  name: "Header analysis",
  description: "Analyze email headers for metadata and potential threats.",
  category: "Analytics",
  type: "dynamic",
  featureCode: "TPIR-HA"
}, {
  name: "SPF, DKIM, DMARC check-pass",
  description: "Check and validate SPF, DKIM, and DMARC records to ensure email authenticity.",
  category: "Analytics",
  type: "dynamic",
  featureCode: "TPIR-SDD"
}, {
  name: "IP Reputation Check",
  description: "Check the reputation of the sending IP address to detect potential spam or malicious sources.",
  category: "Analytics",
  type: "dynamic",
  featureCode: "TPIR-IPRC"
}, {
  name: "Sender Domain Reputation Check",
  description: "Check the reputation of the sender’s domain to identify potential phishing or spam sources.",
  category: "Analytics",
  type: "dynamic",
  featureCode: "TPIR-SDRC"
}, {
  name: "DNS blackhole list",
  description: "Check if the sender’s domain or IP address is on a DNS blackhole list.",
  category: "Analytics",
  type: "dynamic",
  featureCode: "TPIR-DBL"
}, {
  name: "User Awareness Score (Based on suspicious email reporting)",
  description: "Calculate a score based on user reports of suspicious emails to evaluate their awareness level.",
  category: "Analytics",
  type: "dynamic",
  featureCode: "TPIR-UAS"
}, {
  name: "Download raw email",
  description: "Allow users to download raw email headers for further analysis.",
  category: "Analytics",
  type: "dynamic",
  featureCode: "TPIR-DRH"
}, {
  name: "Spam Score to reported email",
  description: "Assign a spam score to reported emails to help identify potential spam.",
  category: "Scanner",
  type: "dynamic",
  featureCode: "TPIR-SSRE"
}, {
  name: "Email content scan",
  description: "Scan email content for potential threats such as phishing or malware.",
  category: "Scanner",
  type: "dynamic",
  featureCode: "TPIR-ECS"
}, {
  name: "Advanced Attachment and URL/Link protection",
  description: "Protect against threats by scanning attachments and URLs/links in emails for malicious content.",
  category: "Scanner",
  type: "dynamic",
  featureCode: "TPIR-AALP"
}, {
  name: "View Attachment and URL/Links in reported email",
  description: "View Attachment and URL/Links in reported email with or without scanner",
  category: "Scanner",
  type: "dynamic",
  featureCode: "TPIR-VAUIR"
}, {
  name: "Hash comparison for malware detection",
  description: "Perform hash comparison on email attachments to detect known malware signatures.",
  category: "Scanner",
  type: "dynamic",
  featureCode: "TPIR-HCMD"
}, {
  name: "Who else (Who all within the organization received the mail)",
  description: "Identify other users within the organization who received the same email.",
  category: "Advanced Features",
  type: "dynamic",
  featureCode: "TPIR-WE"
}, {
  name: "Action (Restore / Trash / Deletion) of suspicious email for entire organization",
  description: "Take action on suspicious emails by restoring, trashing or deleting them across the organization.",
  category: "Advanced Features",
  type: "dynamic",
  featureCode: "TPIR-ARTD"
}, {
  name: "Find similar emails in the inbox",
  description: "Allow users to see similar emails in their inbox for easy identification of potential threats with same subject.",
  category: "Advanced Features",
  type: "dynamic",
  featureCode: "TPIR-FSEI"
}, {
  name: "Advanced search",
  description: "Provide an advanced search capability to quickly find specific emails or threats.",
  category: "Advanced Features",
  type: "dynamic",
  featureCode: "TPIR-ADVS"
}, {
  name: "Email Broadcast",
  description: "Broadcast a notification email to a group or entire organization for important alerts.",
  category: "Advanced Features",
  type: "dynamic",
  featureCode: "TPIR-EB"
}, {
  name: "TSAT",
  description: "Integration with TSAT for tracking and analyzing threat-related metrics.",
  category: "Integrations",
  type: "dynamic",
  featureCode: "TPIR-TSAT"
}, {
  name: "WhatsApp",
  description: "Generate and send reports via WhatsApp for quick notifications and updates.",
  category: "Reporting",
  type: "dynamic",
  featureCode: "TPIR-WA"
}];
var templates = [{
  name: 'Acknowledgment E-Mail',
  logo: 'Tpirlogo.png',
  bodyContent: '<p>Dear ${userName},</p><p><br>Thank You for reporting a suspicious email.</p><p>&nbsp;</p><p>The email was received at <strong>${date}</strong>.From: <strong>${from}</strong><br>Subject: <strong>${subject}</strong><br>&nbsp;</p><p><br>It has been forwaded to SOC Team for further review. Your actions are helping the organization to keep the network and our data safe!<br>&nbsp;</p><p><br>Thanks,<br>TPIR Team</p>',
  headerContent: '<h2><strong>Mail Reported Successfully!</strong></h2><p>The mail will be reviewed by the SOC team.</p>',
  footerContent: '<p>*If you did not make this request, there is no action required.</p><p>For any queries, please contact <a href="mailto:%20support@tpir.threatcop.com">support@tpir.threatcop.com</a></p>',
  bgColor: '#2c5596',
  companyId: null,
  description: 'This email is sent when a user reports a suspicious email.'
}, {
  name: 'SOC Notification E-mail',
  logo: 'Tpirlogo.png',
  description: 'This email is sent to SOC when a user reports a suspicious email.',
  bodyContent: '<p>Hi ,<br>Kindly review a mail reported by an employee.</p><p>&nbsp;</p><p>The email was received at <strong>${date}.</strong><br>To: <strong>${to}</strong><br>From: <strong>${from}</strong><br>Subject: <strong>${subject}</strong></p><p><br><br>Please review the mail and take appropiate actions from dashboard. Please find attached header and body.</p><p><br><br>Thanks,<br>TPIR Team</p>',
  headerContent: '<h2><strong>Suspicious Mail Reported&nbsp;</strong></h2><p>An employee discovered a suspicious mail and reported it.</p>',
  footerContent: '<p>*If you did not make this request, there is no action required.</p><p>For any queries, please contact <a href="mailto:%20support@tpir.threatcop.com">support@tpir.threatcop.com</a></p>',
  bgColor: '#2c5596',
  companyId: null
}, {
  name: 'Admin Action E-mail',
  logo: 'Tpirlogo.png',
  description: 'This email is sent when admin takes a action on email reported by user.',
  bodyContent: '<p>Dear ${name},&nbsp;</p><p>Thank you for promptly bringing the email to our attention. We have analyzed the mail and result can be found below-</p><p>&nbsp;</p><p>&nbsp;Result : <strong>${status}&nbsp;</strong></p><p>&nbsp;</p><p><strong>Reported Mail Details :&nbsp;</strong></p><p>The email was received at <strong>${date}</strong>.&nbsp;</p><p>From: <strong>${from}</strong>&nbsp;</p><p>Subject: <strong>${subject}</strong>&nbsp;</p><p>&nbsp;</p><p>Thanks, TPIR Team</p>',
  headerContent: '<h2>Mail Report&nbsp;</h2><p>The mail has been reviewed by the SOC team.</p>',
  footerContent: '<p>*If you did not make this request, there is no action required.</p><p>For any queries, please contact <a href="mailto:%20support@tpir.threatcop.com">support@tpir.threatcop.com</a></p>',
  bgColor: '#2c5596',
  companyId: null
}, {
  name: 'Result Notification Other Reporters E-mail',
  logo: 'Tpirlogo.png',
  description: 'This email is sent to other reporters when an admin takes an action on a reported mail.',
  bodyContent: '<p>Dear ${name},&nbsp;</p><p>A mail was reported by an employee, Our SOC Team promptly investigated the matter.&nbsp;</p><p>After careful assessment, the reported email was found to be <strong>${result}</strong> and has been <strong>${status}.</strong>&nbsp;</p><p>&nbsp;</p><p><strong>Reported Mail Details :&nbsp;</strong></p><p>Date: <strong>${date}</strong>.&nbsp;</p><p>From: <strong>${from}</strong>&nbsp;</p><p>Subject: <strong>${subject}</strong>&nbsp;</p><p>&nbsp;</p><p>Thanks, TPIR Team</p>',
  headerContent: '<h2>Suspicious Mail ${status}</h2><p>A suspicious mail was ${status} by SOC Team.</p>',
  footerContent: '<p>*If you did not make this request, there is no action required.</p><p>For any queries, please contact <a href="mailto:%20support@tpir.threatcop.com">support@tpir.threatcop.com</a></p>',
  bgColor: '#2c5596',
  companyId: null
}, {
  name: "Broadcast Email",
  logo: "Tpirlogo.png",
  description: "This email is sent to users when an admin broadcasts a particular email for awareness.",
  bodyContent: "<p>Dear Team,</p> <p>It has come to our attention that several employees have received a suspicious email from \"<b>${from}</b>\" with the subject \"<b>${subject}</b>\" Please DO NOT open any attachments or click any links. Delete the email immediately and report it to IT. See attached screenshot for reference.</p> <p>&nbsp;</p> <p>Stay vigilant and thank you for your cooperation.</p> <p>&nbsp;</p> <p>Thanks,</p> <p>TPIR Team</p>",
  headerContent: "<h2>Suspicious Email Warning</h2> <p>Important notice regarding a suspicious email circulating within the organization.</p>",
  footerContent: "<p>*If you did not make this request, there is no action required.</p><p>For any queries, please contact <a href=\"mailto:%20support@tpir.threatcop.com\">support@tpir.threatcop.com</a></p>",
  bgColor: "#2c5596",
  companyId: null
}];
var createPolicyData = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee() {
    var pol, actions, _i, _pol, policy, _iterator, _step, act;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          pol = ["Domain", "Emails", "Users", "IAM", "AdvancedSearch", "Settings"];
          actions = ["Read", "Write", "Delete"];
          _i = 0, _pol = pol;
        case 4:
          if (!(_i < _pol.length)) {
            _context.next = 26;
            break;
          }
          policy = _pol[_i];
          _iterator = _createForOfIteratorHelper(actions);
          _context.prev = 7;
          _iterator.s();
        case 9:
          if ((_step = _iterator.n()).done) {
            _context.next = 15;
            break;
          }
          act = _step.value;
          _context.next = 13;
          return db.Policy.create({
            name: "".concat(policy, "-").concat(act)
          });
        case 13:
          _context.next = 9;
          break;
        case 15:
          _context.next = 20;
          break;
        case 17:
          _context.prev = 17;
          _context.t0 = _context["catch"](7);
          _iterator.e(_context.t0);
        case 20:
          _context.prev = 20;
          _iterator.f();
          return _context.finish(20);
        case 23:
          _i++;
          _context.next = 4;
          break;
        case 26:
          _context.next = 31;
          break;
        case 28:
          _context.prev = 28;
          _context.t1 = _context["catch"](0);
          console.log(_context.t1);
        case 31:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 28], [7, 17, 20, 23]]);
  }));
  return function createPolicyData() {
    return _ref.apply(this, arguments);
  };
}();
var createDefaultRoles = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2() {
    var adminPolicyIds, adminDescription, memberPolicies, memberDescription, viewerPolicies, viewerDescription, Policies;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          adminPolicyIds = [];
          adminDescription = "An admin has full access to all functionalities, including creating, editing, and deleting content, managing user roles, and accessing all settings and configurations.";
          memberPolicies = [];
          memberDescription = "A member can view, create, and edit content but cannot manage user roles or access sensitive settings. Members have the ability to contribute to and modify existing resources.";
          viewerPolicies = [];
          viewerDescription = "A viewer has read-only access, allowing them to view content without the ability to make any changes or edits. Viewers cannot create, edit, or delete content.";
          _context2.next = 9;
          return db.Policy.find({});
        case 9:
          Policies = _context2.sent;
          if (Policies) {
            _context2.next = 12;
            break;
          }
          throw "Policies Not found";
        case 12:
          Policies.forEach(function (policy) {
            var suffix = policy.name.split('-')[1];
            var prefix = policy.name.split('-')[0];
            if (suffix == 'Read') {
              adminPolicyIds.push(policy._id.toHexString());
              memberPolicies.push(policy._id.toHexString());
              viewerPolicies.push(policy._id.toHexString());
            }
            if (suffix == 'Write') {
              if (['Domain', 'Emails', 'AdvancedSearch', 'Settings'].includes(prefix)) {
                memberPolicies.push(policy._id.toHexString());
              }
              adminPolicyIds.push(policy._id.toHexString());
            }
            if (suffix == 'Delete') {
              adminPolicyIds.push(policy._id.toHexString());
            }
          });

          // let companies = await db.Company.find({});
          // for (const company of companies) {
          _context2.next = 15;
          return db.Role.create({
            roleName: "admin",
            policyIds: adminPolicyIds,
            companyId: null,
            description: adminDescription,
            roleType: "Default"
          });
        case 15:
          _context2.next = 17;
          return db.Role.create({
            roleName: "member",
            policyIds: memberPolicies,
            companyId: null,
            description: memberDescription,
            roleType: "Default"
          });
        case 17:
          _context2.next = 19;
          return db.Role.create({
            roleName: "viewer",
            policyIds: viewerPolicies,
            companyId: null,
            description: viewerDescription,
            roleType: "Default"
          });
        case 19:
          _context2.next = 24;
          break;
        case 21:
          _context2.prev = 21;
          _context2.t0 = _context2["catch"](0);
          console.log(_context2.t0);
        case 24:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 21]]);
  }));
  return function createDefaultRoles() {
    return _ref2.apply(this, arguments);
  };
}();
var _default = {
  init: function () {
    var _init = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3() {
      var metaData;
      return _regenerator["default"].wrap(function _callee3$(_context3) {
        while (1) switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return db.MetaData.findOne({
              name: 'seeds'
            });
          case 2:
            metaData = _context3.sent;
            if (!metaData) {
              _context3.next = 7;
              break;
            }
            return _context3.abrupt("return", true);
          case 7:
            _context3.next = 9;
            return createPolicyData();
          case 9:
            _context3.next = 11;
            return createDefaultRoles();
          case 11:
            _context3.next = 13;
            return db.Template.insertMany(templates);
          case 13:
            _context3.next = 15;
            return db.Feature.insertMany(features);
          case 15:
            return _context3.abrupt("return", db.MetaData.create({
              name: 'seeds',
              value: true
            }));
          case 16:
          case "end":
            return _context3.stop();
        }
      }, _callee3);
    }));
    function init() {
      return _init.apply(this, arguments);
    }
    return init;
  }()
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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