"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("dotenv/config");
var _path = _interopRequireDefault(require("path"));
var _cors = _interopRequireDefault(require("cors"));
var _redis = require("redis");
var _helmet = _interopRequireDefault(require("helmet"));
var _morgan = _interopRequireDefault(require("morgan"));
var _express = _interopRequireDefault(require("express"));
var _winston = _interopRequireDefault(require("winston"));
var _passport = _interopRequireDefault(require("passport"));
var _mongoose = _interopRequireDefault(require("mongoose"));
var _bodyParser = _interopRequireDefault(require("body-parser"));
var _expressSession = _interopRequireDefault(require("express-session"));
var _cookieParser = _interopRequireDefault(require("cookie-parser"));
var _expressRateLimit = _interopRequireDefault(require("express-rate-limit"));
var _expressSanitizer = _interopRequireDefault(require("express-sanitizer"));
var _kue = _interopRequireDefault(require("./kue"));
var _config2 = _interopRequireDefault(require("./config"));
var _cronJob = _interopRequireDefault(require("./cronJob"));
var _api = require("./api");
var _policy = _interopRequireDefault(require("./iam-policy/policy"));
var _workerpool = _interopRequireDefault(require("./workerpool/workerpool"));
var _checkPort = _interopRequireDefault(require("./service/check-port"));
var _LogTransport = require("./s3logs/LogTransport");
var _scheduler = _interopRequireDefault(require("./utils/scheduler"));
require("./errors");
require("./models");
require("./passport");
var _decryptRequest = require("./service/decrypt-request");
var _featureBlocker = _interopRequireDefault(require("./middlewares/featureBlocker"));
var PORT = _config2["default"].app.port;
global.appRoot = _path["default"].resolve(__dirname);
global.redisClient = (0, _redis.createClient)({
  host: _config2["default"].redis.host,
  port: _config2["default"].redis.port,
  auth: _config2["default"].redis.password
});
try {
  var _logger = _winston["default"].createLogger({
    transports: [new _LogTransport.LogTransport({
      dirname: 'logs',
      filename: 'application-%DATE%.log',
      datePattern: 'YYYY-MM-DD-HH',
      zippedArchive: true,
      maxSize: '20m',
      maxFiles: '14d'
    })]
  });
  global.logger = _logger;
} catch (err) {
  console.log(err);
  global.logger = {
    info: function info() {}
  };
}
var app = (0, _express["default"])();
app.use((0, _cors["default"])({
  origin: _config2["default"].app.url,
  credentials: true
}));
app.use((0, _morgan["default"])('tiny'));
app.use(_express["default"].json({
  limit: '50mb'
}));
app.use(_express["default"].urlencoded({
  extended: true,
  limit: '50mb'
}));
app.use(_bodyParser["default"].json({
  limit: '50mb'
}));
app.use(_bodyParser["default"].urlencoded({
  extended: true,
  limit: '50mb'
}));
app.use((0, _cookieParser["default"])(_config2["default"].app.secret));
app.use((0, _expressSession["default"])({
  secret: _config2["default"].app.secret,
  resave: true,
  saveUninitialized: true
}));
app.use(_passport["default"].initialize());
app.use((0, _expressSanitizer["default"])());
app.use(_passport["default"].session());
app.use(_helmet["default"].contentSecurityPolicy({
  directives: {
    defaultSrc: ["'self'"],
    scriptSrc: ["'self'"],
    imgSrc: ["'self'", "data:", "https:", "https://stag-tpir.threatcop.com/"],
    styleSrc: ["'self'", "https:"],
    fontSrc: ["'self'", "https:", "data:"],
    objectSrc: ["'none'"],
    upgradeInsecureRequests: [],
    frameAncestors: ["'self'"]
  }
}));
// app.use(helmet.frameguard({ action: "sameorigin" })); // Blocks all iframes (Best security)

app.use(_helmet["default"].referrerPolicy({
  policy: "strict-origin-when-cross-origin"
}));
app.use(_helmet["default"].hidePoweredBy());
app.use(_helmet["default"].hsts({
  maxAge: 63072000,
  // Must be in seconds. This is 1 year.
  includeSubDomains: true,
  // Must be enabled to be approved by preload.
  preload: true // If you want to include your site in the HSTS preload list.
}));

var apiLimiter = (0, _expressRateLimit["default"])({
  windowMs: 1 * 60 * 1000,
  // 1 minutes
  max: 100,
  message: "Too many requests created from this IP, please try again after an minute"
});

/* Route handling */
app.use(apiLimiter);
app.use('/api/v1', _decryptRequest.decryptRequest);
app.use('/api/v1', _api.restRouter);
app.use('/api-doc', _express["default"]["static"]('./apidoc/'));
app.use('/api/static', _express["default"]["static"](_path["default"].join(__dirname, 'public')));
app.use('/', function (req, res, next) {
  next(new RequestError('Invalid route', 405));
});
app.use(function (error, req, res, next) {
  if (!(error instanceof RequestError)) {
    error = new RequestError('something went wrong', 500, error);
  }
  res.status(error.status || 500);
  res.json({
    success: false,
    messages: error.errorList
  });
});
/* database connection */
_mongoose["default"].connect(_config2["default"].db.connection, (0, _defineProperty2["default"])({
  useNewUrlParser: true,
  useUnifiedTopology: true,
  useCreateIndex: true
}, "useUnifiedTopology", true)).then( /*#__PURE__*/(0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee() {
  var spamassession;
  return _regenerator["default"].wrap(function _callee$(_context) {
    while (1) switch (_context.prev = _context.next) {
      case 0:
        _kue["default"].init();
        _policy["default"].init();
        _cronJob["default"].init();
        _workerpool["default"].init({
          maxWorkers: _config2["default"].worker.limit,
          workerType: _config2["default"].worker.type
        });
        _context.next = 6;
        return redisClient.connect();
      case 6:
        //await scheduler.init();;
        console.log("\x1b[32mDatabase:\x1b[0m", "Database connected successfully.");
        _context.next = 9;
        return (0, _checkPort["default"])(_config2["default"].spamassession.port, {
          host: _config2["default"].spamassession.host
        });
      case 9:
        spamassession = _context.sent;
        spamassession ? console.log("\x1b[32mSpamassession:\x1b[0m", 'Spamassession connected successfully') : console.error('\x1b[31mSpamassession:\x1b[0m', 'something went wrong with spamassession connection');
        logger.info("Server started!");
      case 12:
      case "end":
        return _context.stop();
    }
  }, _callee);
})))["catch"](function (err) {
  return console.log("Something went wrong Database connection.", err);
});

/* Start Listening service */
app.listen(PORT, function () {
  console.log("\x1b[32mServer:\x1b[0m", "Server is running at PORT ".concat(PORT));
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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