"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.queue = exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _fs = _interopRequireDefault(require("fs"));
var _kue = _interopRequireDefault(require("kue"));
var _path = _interopRequireDefault(require("path"));
var _spamc = _interopRequireDefault(require("spamc"));
var _getUrls = _interopRequireDefault(require("get-urls"));
var _parseDomains = _interopRequireDefault(require("parse-domains"));
var _config = _interopRequireDefault(require("./config"));
var _mailer = _interopRequireDefault(require("./mailer"));
var _upload_file = _interopRequireDefault(require("./Content/upload_file"));
var _parseEmail = _interopRequireDefault(require("./service/parse-email"));
var _workerpool = _interopRequireDefault(require("./workerpool/workerpool"));
var _axios = _interopRequireDefault(require("axios"));
var _credentials = _interopRequireDefault(require("./service/credentials"));
var _parseHeader = _interopRequireDefault(require("./service/parse-header"));
var _getVirusTotalkey = _interopRequireDefault(require("./service/get-virus-totalkey"));
var _resultUrlTotalvirus = _interopRequireDefault(require("./service/result-url-totalvirus"));
var _routeEmailTsat = _interopRequireDefault(require("./service/route-email-tsat"));
var _deceiptiveCheck = require("./service/deceiptive-check");
var _functions = require("./functions");
var _resultAttachmentTotalvirus = _interopRequireDefault(require("./service/result-attachment-totalvirus"));
var _processWhatsappMessage = _interopRequireDefault(require("./service/process-whatsapp-message"));
var _whatsapp = require("./service/whatsapp");
var _sendWhatsappMessage = _interopRequireDefault(require("./service/send-whatsapp-message"));
var _imageToText = _interopRequireDefault(require("./service/image-to-text"));
var _moveReportedEmailOutlook = _interopRequireDefault(require("./service/move-reported-email-outlook"));
var _mailActions = require("./service/mail-actions");
var _checkLanguage = _interopRequireDefault(require("./service/check-language"));
var _ScanAttachmentClamScan = _interopRequireDefault(require("./service/ScanAttachmentClamScan"));
var _updateMessageId = _interopRequireDefault(require("./service/update-messageId"));
var _broadcastMail = require("./service/broadcast-mail");
var _updateSyncingStatusGroups = require("./service/update-syncing-status-groups");
var _allowedFeatures = _interopRequireDefault(require("./service/allowed-features"));
var _outlookWebhookEmailServices = require("./service/outlook-webhook-email-services");
var _subscriptionService = require("./service/subscriptionService");
var _adSync = require("./utils/adSync");
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var queue = _kue["default"].createQueue({
  prefix: 'tpir-kue',
  redis: {
    host: _config["default"].redis.host,
    port: _config["default"].redis.port,
    auth: _config["default"].redis.password
  }
});
exports.queue = queue;
var spamc = new _spamc["default"](_config["default"].spamassession.host, _config["default"].spamassession.port, 10000);
queue.setMaxListeners(10000);
/*
const bannerTemplate = (msg) => `
    <!-- Threatcop Phishing-Alert Banner (auto-inserted) -->
    <table width="100%" cellspacing="0" cellpadding="0" style="border-collapse:collapse;margin:0 0 12px 0;font-family:'Segoe UI',Arial,sans-serif">
    <tr>
        <td style="background:#fff8e5;border-left:6px solid #ffa500;padding:12px 16px">
        <span style="font-size:14px;color:#323130">
            ⚠️ <strong>${msg}</strong>
        </span>
        </td>
    </tr>
    </table>
`;
*/
function formatResult(result) {
  var messages = result.split('\n').filter(function (line) {
    return line.trim() !== '';
  });
  var formatted = '';
  messages.forEach(function (msg, index) {
    formatted += "Message ".concat(index + 1, ":\n").concat(msg, "\n\n");
  });
  return formatted.trim();
}
var findAndUpdateUsers = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(data) {
    var companyId, domainId, email, emailType, userId, name, addedUsersSoFar, phoneNumber, remainingUsersCount, group, subDomainGroupId, syncTs, user, allUsersGroup, canBeActivate, canBeActivateMessenger, groupIdStr, allUsersGroupIdStr, uniqueGroupIdsStr;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          companyId = data.companyId, domainId = data.domainId, email = data.email, emailType = data.emailType, userId = data.userId, name = data.name, addedUsersSoFar = data.addedUsersSoFar, phoneNumber = data.phoneNumber, remainingUsersCount = data.remainingUsersCount, group = data.group, subDomainGroupId = data.subDomainGroupId, syncTs = data.syncTs;
          _context.prev = 1;
          user = null;
          _context.next = 5;
          return db.User.findOne({
            email: email,
            emailType: emailType,
            companyId: companyId
          });
        case 5:
          user = _context.sent;
          if (user) {
            _context.next = 10;
            break;
          }
          _context.next = 9;
          return db.User.findOne({
            email: null,
            phoneNumber: phoneNumber
          });
        case 9:
          user = _context.sent;
        case 10:
          //if a contact was created without api but using csv
          console.log({
            email: email,
            user: user,
            condition: addedUsersSoFar < remainingUsersCount
          });
          console.log({
            addedUsersSoFar: addedUsersSoFar,
            remainingUsersCount: remainingUsersCount
          });
          _context.next = 14;
          return db.Group.findOne({
            groupName: "all-users-tpir",
            companyId: companyId,
            isDefaultGroup: true,
            deletedAt: null
          });
        case 14:
          allUsersGroup = _context.sent;
          canBeActivate = (allUsersGroup.emailAccess || group.emailAccess) && addedUsersSoFar < remainingUsersCount;
          canBeActivateMessenger = (allUsersGroup.messengerAccess || group.messengerAccess) && addedUsersSoFar < remainingUsersCount;
          if (!user) {
            _context.next = 34;
            break;
          }
          user.name = name;
          user.email = email;
          user.domainId = domainId;
          user.companyId = companyId;
          // user.groups = { $addToSet:{ groups: group._id }};
          user.phoneNumber = phoneNumber;
          // user.groupName = groupName ? groupName : null;
          user.subDomainGroupId = subDomainGroupId ? subDomainGroupId : null;
          user.tacGroupId = null;
          //uploaded from csv and deleted                         //uploaded from api and deleted                                 (removed)uploaded from api but deactivated
          if ((user.userId == null && user.deletedAt !== null || user.userId !== null && user.deletedAt !== null) && addedUsersSoFar < remainingUsersCount) {
            console.log("user being activated", user.email, canBeActivate, canBeActivateMessenger);
            user.emailType = emailType;
            user.isActive = canBeActivate;
            user.isActiveMessenger = canBeActivateMessenger;
            user.deletedAt = null;
            addedUsersSoFar += 1;
          }
          console.log("groupppppp", group, !user.groups.includes(group._id));
          //ek group sync kara to us group ki id ni hogi aur allUser wale default group ki bhi id nhi hogi
          if (!user.groups.includes(group._id)) {
            user.groups.push(group._id);
          }
          if (!user.groups.includes(allUsersGroup._id)) {
            user.groups.push(allUsersGroup._id);
          }
          if (user.isADSynced && user.lastAdSeenAt !== syncTs) {
            user.lastAdSeenAt = syncTs;
          }
          _context.next = 32;
          return user.save();
        case 32:
          _context.next = 43;
          break;
        case 34:
          if (!(addedUsersSoFar < remainingUsersCount)) {
            _context.next = 43;
            break;
          }
          groupIdStr = group._id.toString();
          allUsersGroupIdStr = allUsersGroup._id.toString();
          uniqueGroupIdsStr = (0, _toConsumableArray2["default"])(new Set([groupIdStr, allUsersGroupIdStr]));
          console.log("user being added", email, canBeActivate, canBeActivateMessenger, uniqueGroupIdsStr);
          user = new db.User({
            companyId: companyId,
            domainId: domainId,
            email: email,
            emailType: emailType,
            isActive: canBeActivate,
            isActiveMessenger: canBeActivateMessenger,
            userId: userId,
            tacGroupId: null,
            tacIdentityKey: null,
            name: name,
            groups: uniqueGroupIdsStr,
            phoneNumber: phoneNumber,
            // groupName,
            subDomainGroupId: subDomainGroupId ? subDomainGroupId : null,
            lastAdSeenAt: syncTs,
            isADSynced: true
          });
          // activatedUsersSoFar = activatedUsersSoFar + (isActive ? 1 : 0);
          addedUsersSoFar = addedUsersSoFar + 1;
          _context.next = 43;
          return user.save();
        case 43:
          return _context.abrupt("return", addedUsersSoFar);
        case 46:
          _context.prev = 46;
          _context.t0 = _context["catch"](1);
          console.log(_context.t0);
          return _context.abrupt("return", addedUsersSoFar);
        case 50:
          _context.prev = 50;
          return _context.abrupt("return", addedUsersSoFar);
        case 53:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[1, 46, 50, 53]]);
  }));
  return function findAndUpdateUsers(_x) {
    return _ref.apply(this, arguments);
  };
}();
var findAndUpdateUsersWhatsapp = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(data) {
    var companyId, remainingUsersCount, activatedUsersSoFar, emailType, name, phoneNumber, status, isActive, user;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          companyId = data.companyId, remainingUsersCount = data.remainingUsersCount, activatedUsersSoFar = data.activatedUsersSoFar, emailType = data.emailType, name = data.name, phoneNumber = data.phoneNumber, status = data.status;
          isActive = activatedUsersSoFar < remainingUsersCount;
          _context2.next = 5;
          return db.User.findOne({
            phoneNumber: phoneNumber,
            companyId: companyId
          });
        case 5:
          user = _context2.sent;
          console.log({
            status: status,
            statusCheck: status.toLowerCase() == 'true',
            user: user
          });
          if (user) {
            user.name = name;
            user.phoneNumber = phoneNumber;
            user.isActiveMessenger = status.toLowerCase() == 'true' ? isActive : false;
            user.phoneNumber = phoneNumber;
            user.deletedAt = null; //user found is activated but now deactivating so reducing activatedUsersSoFar count
            activatedUsersSoFar = status.toLowerCase() == 'true' ? activatedUsersSoFar + (isActive ? 1 : 0) : user.isActiveMessenger ? activatedUsersSoFar - 1 : activatedUsersSoFar;
          } else {
            user = new db.User({
              companyId: companyId,
              emailType: emailType,
              isActiveMessenger: status ? isActive : false,
              name: name,
              phoneNumber: phoneNumber
            });
            activatedUsersSoFar = status.toLowerCase() == 'true' ? activatedUsersSoFar + (isActive ? 1 : 0) : activatedUsersSoFar;
          }
          _context2.next = 10;
          return user.save();
        case 10:
          return _context2.abrupt("return", activatedUsersSoFar);
        case 13:
          _context2.prev = 13;
          _context2.t0 = _context2["catch"](0);
          console.log(_context2.t0);
          return _context2.abrupt("return", activatedUsersSoFar);
        case 17:
          _context2.prev = 17;
          return _context2.abrupt("return", activatedUsersSoFar);
        case 20:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 13, 17, 20]]);
  }));
  return function findAndUpdateUsersWhatsapp(_x2) {
    return _ref2.apply(this, arguments);
  };
}();
var createRequestObjects = /*#__PURE__*/function () {
  var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(whoElses) {
    var requestArray, i, batch, j, request;
    return _regenerator["default"].wrap(function _callee3$(_context3) {
      while (1) switch (_context3.prev = _context3.next) {
        case 0:
          requestArray = [];
          for (i = 0; i < whoElses.length; i++) {
            batch = whoElses[i];
            requestArray[i] = [];
            for (j = 0; j < batch.length; j++) {
              request = {
                id: batch[j]._id,
                method: "GET",
                url: "/users/".concat(batch[j].to, "/messages?$select=id,parentFolderId&$filter=internetMessageId eq '").concat(encodeURIComponent(batch[j].internetMessageId), "' and from/emailAddress/address eq '").concat(batch[j].from, "'")
              };
              requestArray[i].push(request);
            }
          }
          return _context3.abrupt("return", requestArray);
        case 3:
        case "end":
          return _context3.stop();
      }
    }, _callee3);
  }));
  return function createRequestObjects(_x3) {
    return _ref3.apply(this, arguments);
  };
}();
var createRequestObjectMailAction = function createRequestObjectMailAction(whoElses, token, mailAction) {
  var requestArray = [];
  for (var i = 0; i < whoElses.length; i++) {
    var batch = whoElses[i];
    requestArray[i] = [];
    for (var j = 0; j < batch.length; j++) {
      var request = {};
      if (mailAction == 'Trashed') {
        var moveToTrashApi = "/users/".concat(batch[j].to, "/messages/").concat(batch[j].messageId, "/move");
        request = {
          id: batch[j]._id,
          method: 'POST',
          url: moveToTrashApi,
          headers: {
            "Authorization": "Bearer ".concat(token),
            "Content-Type": "application/json"
          },
          body: {
            "destinationId": "deleteditems"
          }
        };
      } else if (mailAction == 'Deleted') {
        var deleteApi = "/users/".concat(batch[j].to, "/messages/").concat(batch[j].messageId);
        request = {
          id: batch[j]._id,
          method: 'DELETE',
          url: deleteApi,
          headers: {
            "Authorization": "Bearer ".concat(token),
            "Content-Type": "application/json"
          }
        };
      } else {
        var folderId = batch ? batch[j].folderId ? batch[j].folderId : 'inbox' : 'inbox';
        var moveToInboxApi = "/users/".concat(batch[j].to, "/messages/").concat(batch[j].messageId, "/move");
        request = {
          id: batch[j]._id,
          method: 'POST',
          url: moveToInboxApi,
          headers: {
            "Authorization": "Bearer ".concat(token),
            "Content-Type": "application/json"
          },
          body: {
            "destinationId": folderId
          }
        };
      }
      requestArray[i].push(request);
    }
  }
  return requestArray;
};
var outlookBatchProcess = function outlookBatchProcess(requests, token) {
  return new Promise( /*#__PURE__*/function () {
    var _ref4 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(resolve, reject) {
      var data, axiosConfig, response, result;
      return _regenerator["default"].wrap(function _callee4$(_context4) {
        while (1) switch (_context4.prev = _context4.next) {
          case 0:
            data = {
              requests: requests
            };
            axiosConfig = _objectSpread({
              method: 'POST',
              url: 'https://graph.microsoft.com/v1.0/$batch/',
              headers: {
                "content-type": "application/json",
                authorization: "Bearer ".concat(token),
                Prefer: 'outlook.allow-unsafe-operations'
              },
              data: data
            }, _config["default"].proxy.enableForMicrosoftGraph && {
              httpAgent: _config["default"].proxy.proxyAgent,
              httpsAgent: _config["default"].proxy.proxyAgent
            });
            _context4.next = 4;
            return _axios["default"].request(axiosConfig);
          case 4:
            response = _context4.sent;
            result = response.data.responses;
            console.log(result[0].body);
            resolve(result);
          case 8:
          case "end":
            return _context4.stop();
        }
      }, _callee4);
    }));
    return function (_x4, _x5) {
      return _ref4.apply(this, arguments);
    };
  }());
};
var update = function update(mailBoxRequests, token, action) {
  return new Promise( /*#__PURE__*/function () {
    var _ref5 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee5(resolve, reject) {
      var mailBoxResponses, updatesArray, i, updateWhoElse;
      return _regenerator["default"].wrap(function _callee5$(_context5) {
        while (1) switch (_context5.prev = _context5.next) {
          case 0:
            _context5.prev = 0;
            mailBoxResponses = [];
            _context5.next = 4;
            return outlookBatchProcess(mailBoxRequests, token.access_token);
          case 4:
            mailBoxResponses = _context5.sent;
            updatesArray = [];
            for (i = 0; i < mailBoxResponses.length; i++) {
              if (mailBoxResponses[i] && mailBoxResponses[i].status == 200 && mailBoxResponses[i].body && mailBoxResponses[i].body.value.length && mailBoxResponses[i].body.value[0].id) {
                if (action) {
                  updatesArray.push({
                    updateOne: {
                      filter: {
                        _id: mailBoxResponses[i].id
                      },
                      update: {
                        messageId: mailBoxResponses[i].body.value[0].id
                      }
                    }
                  });
                } else {
                  updatesArray.push({
                    updateOne: {
                      filter: {
                        _id: mailBoxResponses[i].id
                      },
                      update: {
                        messageId: mailBoxResponses[i].body.value[0].id,
                        folderId: mailBoxResponses[i].body.value[0].parentFolderId
                      }
                    }
                  });
                }
              }
            }
            _context5.next = 9;
            return db.WhoElse.bulkWrite(updatesArray);
          case 9:
            updateWhoElse = _context5.sent;
            console.log({
              updateWhoElse: updateWhoElse
            });
            resolve(mailBoxResponses);
            _context5.next = 18;
            break;
          case 14:
            _context5.prev = 14;
            _context5.t0 = _context5["catch"](0);
            console.log(_context5.t0.response.data);
            resolve(false);
          case 18:
          case "end":
            return _context5.stop();
        }
      }, _callee5, null, [[0, 14]]);
    }));
    return function (_x6, _x7) {
      return _ref5.apply(this, arguments);
    };
  }());
};
var updateReportedMailIfEveryDomainCompleted = /*#__PURE__*/function () {
  var _ref6 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee6(reportedMailId, companyId) {
    var countTotalDomains, countCompletedDomains;
    return _regenerator["default"].wrap(function _callee6$(_context6) {
      while (1) switch (_context6.prev = _context6.next) {
        case 0:
          _context6.next = 2;
          return db.WhoElseMetaData.countDocuments({
            reportedMailId: reportedMailId,
            companyId: companyId
          });
        case 2:
          countTotalDomains = _context6.sent;
          _context6.next = 5;
          return db.WhoElseMetaData.countDocuments({
            reportedMailId: reportedMailId,
            companyId: companyId,
            isCompleted: true
          });
        case 5:
          countCompletedDomains = _context6.sent;
          if (!(countTotalDomains == countCompletedDomains)) {
            _context6.next = 12;
            break;
          }
          (0, _functions.updateReportedMailCache)(reportedMailId, {
            isWhoElseCompleted: true,
            isWhoElseProcessing: false
          });
          _context6.next = 10;
          return db.ReportedMail.updateOne({
            _id: reportedMailId,
            companyId: companyId
          }, {
            syncEndAt: new Date(),
            isWhoElseError: false,
            isWhoElseProcessing: false,
            isWhoElseErrorMessage: "",
            isWhoElseCompleted: true
          });
        case 10:
          _context6.next = 12;
          return db.WhoElseMetaData.deleteMany({
            reportedMailId: reportedMailId,
            companyId: companyId
          });
        case 12:
        case "end":
          return _context6.stop();
      }
    }, _callee6);
  }));
  return function updateReportedMailIfEveryDomainCompleted(_x8, _x9) {
    return _ref6.apply(this, arguments);
  };
}();
var updateReportedMailIfEveryDomainSimiliarSearchCompleted = /*#__PURE__*/function () {
  var _ref7 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee7(reportedMailId, companyId) {
    var countTotalDomains, countCompletedDomains;
    return _regenerator["default"].wrap(function _callee7$(_context7) {
      while (1) switch (_context7.prev = _context7.next) {
        case 0:
          _context7.next = 2;
          return db.SimiliarEmailMetdata.countDocuments({
            reportedMailId: reportedMailId,
            companyId: companyId
          });
        case 2:
          countTotalDomains = _context7.sent;
          _context7.next = 5;
          return db.SimiliarEmailMetdata.countDocuments({
            reportedMailId: reportedMailId,
            companyId: companyId,
            isCompleted: true
          });
        case 5:
          countCompletedDomains = _context7.sent;
          if (!(countTotalDomains == countCompletedDomains)) {
            _context7.next = 12;
            break;
          }
          (0, _functions.updateReportedMailCache)(reportedMailId, {
            isSimiliarEmailCompleted: true,
            isSimiliarEmailProcessing: false
          });
          _context7.next = 10;
          return db.ReportedMail.updateOne({
            _id: reportedMailId,
            companyId: companyId
          }, {
            syncEndAt: new Date(),
            isSimilarEmailError: false,
            isSimiliarEmailProcessing: false,
            isSimiliarEmailErrorMessage: "",
            isSimiliarEmailCompleted: true
          });
        case 10:
          _context7.next = 12;
          return db.SimiliarEmailMetdata.deleteMany({
            reportedMailId: reportedMailId,
            companyId: companyId
          });
        case 12:
        case "end":
          return _context7.stop();
      }
    }, _callee7);
  }));
  return function updateReportedMailIfEveryDomainSimiliarSearchCompleted(_x10, _x11) {
    return _ref7.apply(this, arguments);
  };
}();
var _default = {
  init: function init() {
    queue.process('outlook-user-save', /*#__PURE__*/function () {
      var _ref8 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee8(job, done) {
        var _job$data, users, domainId, companyId, _job$data$subDomainGr, subDomainGroups, isLast, isExchange, group, domainName, isMirrorSync, allUsersGroupId, syncTs, isFirstPage, userLimit, userLimitMessenger, addedUsersCount, remainingUsersCount, addedUsersSoFar, seenUserIds, i, user, domainExistsInSubDomainGroups, subDomainGroupId, domain, isValidPhoneNumber, isAnyUserUploadedInCurrentGroup;
        return _regenerator["default"].wrap(function _callee8$(_context8) {
          while (1) switch (_context8.prev = _context8.next) {
            case 0:
              console.log("job ka data", job.data);
              _job$data = job.data, users = _job$data.users, domainId = _job$data.domainId, companyId = _job$data.companyId, _job$data$subDomainGr = _job$data.subDomainGroups, subDomainGroups = _job$data$subDomainGr === void 0 ? [] : _job$data$subDomainGr, isLast = _job$data.isLast, isExchange = _job$data.isExchange, group = _job$data.group, domainName = _job$data.domainName, isMirrorSync = _job$data.isMirrorSync, allUsersGroupId = _job$data.allUsersGroupId, syncTs = _job$data.syncTs, isFirstPage = _job$data.isFirstPage;
              _context8.prev = 2;
              _context8.t0 = parseInt;
              _context8.next = 6;
              return db.MetaData.findOne({
                companyId: companyId,
                name: "userLimit"
              });
            case 6:
              _context8.t1 = _context8.sent.value;
              userLimit = (0, _context8.t0)(_context8.t1);
              console.log({
                userLimit: userLimit
              });
              _context8.t2 = parseInt;
              _context8.next = 12;
              return db.MetaData.findOne({
                companyId: companyId,
                name: "userLimitMessenger"
              });
            case 12:
              _context8.t3 = _context8.sent.value;
              userLimitMessenger = (0, _context8.t2)(_context8.t3);
              console.log({
                userLimitMessenger: userLimitMessenger
              });
              _context8.next = 17;
              return db.User.countDocuments({
                companyId: companyId,
                deletedAt: null
              });
            case 17:
              addedUsersCount = _context8.sent;
              console.log({
                addedUsersCount: addedUsersCount
              });
              remainingUsersCount = Math.max(0, userLimit + userLimitMessenger - addedUsersCount);
              console.log({
                add: userLimit + userLimitMessenger,
                remainingUsersCount: remainingUsersCount
              });
              addedUsersSoFar = 0; //we are not concluding the kue if remainingUserCount = 0 as if a user was already in a group and a new group
              //is synced in which a user was already there so the group have to be updated in user's document to associate it 
              //to that group too 
              console.log("users to be synced------------", {
                users: users
              });
              seenUserIds = [];
              if (!(isMirrorSync && isFirstPage)) {
                _context8.next = 27;
                break;
              }
              _context8.next = 27;
              return db.User.updateMany({
                companyId: companyId,
                domainId: domainId,
                groups: group._id
              }, {
                $set: {
                  lastAdSeenAt: null
                }
              });
            case 27:
              i = 0;
            case 28:
              if (!(i < users.length)) {
                _context8.next = 54;
                break;
              }
              user = users[i];
              domainExistsInSubDomainGroups = false;
              subDomainGroupId = null;
              console.log("".concat(user.displayName, "---------------------- ").concat(user.mail));
              if (!(user.mail && user.mail.length && user.displayName)) {
                _context8.next = 42;
                break;
              }
              subDomainGroupId;
              domain = user.mail.split('@')[1].toLowerCase();
              domainExistsInSubDomainGroups = subDomainGroups.includes(domain);
              if (domain == domainName) domainExistsInSubDomainGroups = true; //when domain is main domain
              _context8.next = 40;
              return db.SubDomainGroup.findOne({
                groupName: domain,
                domainId: domainId
              });
            case 40:
              subDomainGroupId = _context8.sent;
              console.log({
                domain: domain,
                domainExistsInSubDomainGroups: domainExistsInSubDomainGroups,
                subDomainGroupId: subDomainGroupId
              });
            case 42:
              if (!(user.mail && user.mail.length && user.displayName && domainExistsInSubDomainGroups)) {
                _context8.next = 51;
                break;
              }
              isValidPhoneNumber = false;
              console.log({
                isValidPhoneNumber: isValidPhoneNumber
              });
              console.log("addedUsersSoFar inside queue-------------------", addedUsersSoFar);
              _context8.next = 48;
              return findAndUpdateUsers({
                companyId: companyId,
                domainId: domainId,
                remainingUsersCount: remainingUsersCount,
                addedUsersSoFar: addedUsersSoFar,
                userId: user.id,
                email: user.mail,
                emailType: isExchange ? 'Exchange' : 'Outlook',
                name: user.displayName,
                group: group,
                phoneNumber: user === null || user === void 0 ? void 0 : user.mobilePhone,
                subDomainGroupId: subDomainGroupId,
                isLast: isLast,
                syncTs: syncTs
              });
            case 48:
              addedUsersSoFar = _context8.sent;
              _context8.next = 51;
              break;
            case 51:
              i++;
              _context8.next = 28;
              break;
            case 54:
              _context8.next = 61;
              break;
            case 56:
              _context8.prev = 56;
              _context8.t4 = _context8["catch"](2);
              _context8.next = 60;
              return (0, _updateSyncingStatusGroups.updateSyncingStatusOfGroups)(group._id, companyId);
            case 60:
              console.error(_context8.t4);
            case 61:
              _context8.prev = 61;
              if (!isLast) {
                _context8.next = 79;
                break;
              }
              if (!isMirrorSync) {
                _context8.next = 68;
                break;
              }
              _context8.next = 66;
              return (0, _adSync.cleanupMirrorGroup)({
                companyId: companyId,
                groupId: group._id,
                syncTs: syncTs
              });
            case 66:
              _context8.next = 68;
              return (0, _adSync.orphanSweepManualGroups)({
                companyId: companyId
              });
            case 68:
              _context8.next = 70;
              return (0, _updateSyncingStatusGroups.updateSyncingStatusOfGroups)(group._id, companyId);
            case 70:
              _context8.next = 72;
              return db.Domain.updateOne({
                _id: domainId
              }, {
                isSyncingUser: false,
                syncEndAt: new Date()
              });
            case 72:
              _context8.next = 74;
              return db.User.countDocuments({
                companyId: companyId,
                groups: {
                  $in: [group._id]
                }
              });
            case 74:
              isAnyUserUploadedInCurrentGroup = _context8.sent;
              console.log({
                isAnyUserUploadedInCurrentGroup: isAnyUserUploadedInCurrentGroup
              });
              if (isAnyUserUploadedInCurrentGroup) {
                _context8.next = 79;
                break;
              }
              _context8.next = 79;
              return db.Group.deleteOne({
                _id: group._id,
                isDefaultGroup: false,
                companyId: companyId
              });
            case 79:
              done();
              return _context8.finish(61);
            case 81:
            case "end":
              return _context8.stop();
          }
        }, _callee8, null, [[2, 56, 61, 81]]);
      }));
      return function (_x12, _x13) {
        return _ref8.apply(this, arguments);
      };
    }());
    queue.process('gsuite-user-save', /*#__PURE__*/function () {
      var _ref9 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee9(job, done) {
        var _job$data2, users, domainId, _job$data2$subDomainG, subDomainGroups, companyId, isLast, group, domainName, isMirrorSync, allUsersGroupId, syncTs, isFirstPage, userLimit, userLimitMessenger, addedUsersCount, remainingUsersCount, addedUsersSoFar, seenUserIds, i, user, domainExistsInSubDomainGroups, subDomainGroupId, _user$primaryEmail$sp, domain, _user$name$fullName, _user$name, _user$phones, isValidPhoneNumber, isAnyUserUploadedInCurrentGroup;
        return _regenerator["default"].wrap(function _callee9$(_context9) {
          while (1) switch (_context9.prev = _context9.next) {
            case 0:
              _job$data2 = job.data, users = _job$data2.users, domainId = _job$data2.domainId, _job$data2$subDomainG = _job$data2.subDomainGroups, subDomainGroups = _job$data2$subDomainG === void 0 ? [] : _job$data2$subDomainG, companyId = _job$data2.companyId, isLast = _job$data2.isLast, group = _job$data2.group, domainName = _job$data2.domainName, isMirrorSync = _job$data2.isMirrorSync, allUsersGroupId = _job$data2.allUsersGroupId, syncTs = _job$data2.syncTs, isFirstPage = _job$data2.isFirstPage;
              _context9.prev = 1;
              console.log("job ka data", job.data);

              // const userLimit = (await db.MetaData.findOne({ companyId, name: "userLimit"})).value;
              // const addedUsersCount = await db.User.countDocuments({ companyId, deletedAt: null });
              // const remainingUsersCount = Math.max(0, userLimit - addedUsersCount);
              // let addedUsersSoFar = 0;
              _context9.t0 = parseInt;
              _context9.next = 6;
              return db.MetaData.findOne({
                companyId: companyId,
                name: "userLimit"
              });
            case 6:
              _context9.t1 = _context9.sent.value;
              userLimit = (0, _context9.t0)(_context9.t1);
              console.log({
                userLimit: userLimit
              });
              _context9.t2 = parseInt;
              _context9.next = 12;
              return db.MetaData.findOne({
                companyId: companyId,
                name: "userLimitMessenger"
              });
            case 12:
              _context9.t3 = _context9.sent.value;
              userLimitMessenger = (0, _context9.t2)(_context9.t3);
              console.log({
                userLimitMessenger: userLimitMessenger
              });
              _context9.next = 17;
              return db.User.countDocuments({
                companyId: companyId,
                deletedAt: null
              });
            case 17:
              addedUsersCount = _context9.sent;
              console.log({
                addedUsersCount: addedUsersCount
              });
              remainingUsersCount = Math.max(0, userLimit + userLimitMessenger - addedUsersCount);
              console.log({
                add: userLimit + userLimitMessenger,
                remainingUsersCount: remainingUsersCount
              });
              addedUsersSoFar = 0;
              seenUserIds = [];
              if (!(isMirrorSync && isFirstPage)) {
                _context9.next = 26;
                break;
              }
              _context9.next = 26;
              return db.User.updateMany({
                companyId: companyId,
                domainId: domainId,
                groups: group._id
              }, {
                $set: {
                  lastAdSeenAt: null
                }
              });
            case 26:
              i = 0;
            case 27:
              if (!(i < users.length)) {
                _context9.next = 49;
                break;
              }
              user = users[i];
              domainExistsInSubDomainGroups = false;
              subDomainGroupId = null;
              if (!(user.primaryEmail && user.primaryEmail.length && user.isMailboxSetup)) {
                _context9.next = 38;
                break;
              }
              domain = (_user$primaryEmail$sp = user.primaryEmail.split('@')[1]) === null || _user$primaryEmail$sp === void 0 ? void 0 : _user$primaryEmail$sp.toLowerCase();
              domainExistsInSubDomainGroups = subDomainGroups.includes(domain);
              if (domain == domainName) domainExistsInSubDomainGroups = true;
              _context9.next = 37;
              return db.SubDomainGroup.findOne({
                groupName: domain,
                domainId: domainId
              });
            case 37:
              subDomainGroupId = _context9.sent;
            case 38:
              if (!(user.primaryEmail && user.primaryEmail.length && user.isMailboxSetup && domainExistsInSubDomainGroups)) {
                _context9.next = 45;
                break;
              }
              isValidPhoneNumber = false;
              _context9.next = 42;
              return findAndUpdateUsers({
                companyId: companyId,
                domainId: domainId,
                remainingUsersCount: remainingUsersCount,
                addedUsersSoFar: addedUsersSoFar,
                userId: user.id,
                emailType: 'Gsuite',
                email: user.primaryEmail,
                name: (_user$name$fullName = user === null || user === void 0 ? void 0 : (_user$name = user.name) === null || _user$name === void 0 ? void 0 : _user$name.fullName) !== null && _user$name$fullName !== void 0 ? _user$name$fullName : '',
                group: group,
                phoneNumber: user !== null && user !== void 0 && (_user$phones = user.phones) !== null && _user$phones !== void 0 && _user$phones.length ? user.phones[0].value : null,
                subDomainGroupId: subDomainGroupId,
                isLast: isLast,
                syncTs: syncTs
              });
            case 42:
              addedUsersSoFar = _context9.sent;
              _context9.next = 46;
              break;
            case 45:
              console.warn('invalid user details or not setup mail box', user);
            case 46:
              i++;
              _context9.next = 27;
              break;
            case 49:
              _context9.next = 56;
              break;
            case 51:
              _context9.prev = 51;
              _context9.t4 = _context9["catch"](1);
              console.log(_context9.t4);
              _context9.next = 56;
              return db.Domain.updateOne({
                _id: domainId
              }, {
                isSyncingUser: false,
                syncEndAt: new Date()
              });
            case 56:
              _context9.prev = 56;
              if (!isLast) {
                _context9.next = 74;
                break;
              }
              if (!isMirrorSync) {
                _context9.next = 63;
                break;
              }
              _context9.next = 61;
              return (0, _adSync.cleanupMirrorGroup)({
                companyId: companyId,
                groupId: group._id,
                syncTs: syncTs
              });
            case 61:
              _context9.next = 63;
              return (0, _adSync.orphanSweepManualGroups)({
                companyId: companyId
              });
            case 63:
              _context9.next = 65;
              return (0, _updateSyncingStatusGroups.updateSyncingStatusOfGroups)(group._id, companyId);
            case 65:
              _context9.next = 67;
              return db.Domain.updateOne({
                _id: domainId
              }, {
                isSyncingUser: false,
                syncEndAt: new Date()
              });
            case 67:
              _context9.next = 69;
              return db.User.countDocuments({
                companyId: companyId,
                groups: {
                  $in: [group._id]
                }
              });
            case 69:
              isAnyUserUploadedInCurrentGroup = _context9.sent;
              console.log({
                isAnyUserUploadedInCurrentGroup: isAnyUserUploadedInCurrentGroup
              });
              if (isAnyUserUploadedInCurrentGroup) {
                _context9.next = 74;
                break;
              }
              _context9.next = 74;
              return db.Group.deleteOne({
                _id: group._id,
                isDefaultGroup: false,
                companyId: companyId
              });
            case 74:
              done();
              return _context9.finish(56);
            case 76:
            case "end":
              return _context9.stop();
          }
        }, _callee9, null, [[1, 51, 56, 76]]);
      }));
      return function (_x14, _x15) {
        return _ref9.apply(this, arguments);
      };
    }()), queue.process('whatsapp-user-save', /*#__PURE__*/function () {
      var _ref10 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee10(job, done) {
        var _job$data3, users, companyId, userLimit, activatedUsersCount, remainingUsersCount, activatedUsersSoFar, i, _users$i$name, _users$i;
        return _regenerator["default"].wrap(function _callee10$(_context10) {
          while (1) switch (_context10.prev = _context10.next) {
            case 0:
              _context10.prev = 0;
              _job$data3 = job.data, users = _job$data3.users, companyId = _job$data3.companyId;
              _context10.next = 4;
              return db.MetaData.findOne({
                companyId: companyId,
                name: "userLimitMessenger"
              });
            case 4:
              userLimit = _context10.sent.value;
              _context10.next = 7;
              return db.User.countDocuments({
                companyId: companyId,
                deletedAt: null,
                isActiveMessenger: true
              });
            case 7:
              activatedUsersCount = _context10.sent;
              remainingUsersCount = Math.max(0, userLimit - activatedUsersCount);
              activatedUsersSoFar = 0;
              i = 0;
            case 11:
              if (!(i < users.length)) {
                _context10.next = 22;
                break;
              }
              if (!(users[i].name && users[i].name.length && users[i].country_code && users[i].country_code.length && users[i].phone_number && users[i].phone_number.length && users[i].status && users[i].status.length)) {
                _context10.next = 18;
                break;
              }
              _context10.next = 15;
              return findAndUpdateUsersWhatsapp({
                companyId: companyId,
                remainingUsersCount: remainingUsersCount,
                activatedUsersSoFar: activatedUsersSoFar,
                emailType: 'Messenger',
                name: (_users$i$name = (_users$i = users[i]) === null || _users$i === void 0 ? void 0 : _users$i.name) !== null && _users$i$name !== void 0 ? _users$i$name : '',
                phoneNumber: users[i].country_code.split('+')[1] + users[i].phone_number,
                status: users[i].status
              });
            case 15:
              activatedUsersSoFar = _context10.sent;
              _context10.next = 19;
              break;
            case 18:
              console.warn('invalid user details or not setup mail box', users[i]);
            case 19:
              i++;
              _context10.next = 11;
              break;
            case 22:
              _context10.next = 27;
              break;
            case 24:
              _context10.prev = 24;
              _context10.t0 = _context10["catch"](0);
              console.log(_context10.t0);
            case 27:
              _context10.prev = 27;
              done();
              return _context10.finish(27);
            case 30:
            case "end":
              return _context10.stop();
          }
        }, _callee10, null, [[0, 24, 27, 30]]);
      }));
      return function (_x16, _x17) {
        return _ref10.apply(this, arguments);
      };
    }()), queue.process('check-email-spam-or-not-event-outlook', /*#__PURE__*/function () {
      var _ref11 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee11(job, done) {
        var _job$data4, email, _job$data4$score, score, mailType, headerDetails, header, messageId, parseEml, from, fromName, to, toName, subject, mailId, mailRecievedTime, companyId, user;
        return _regenerator["default"].wrap(function _callee11$(_context11) {
          while (1) switch (_context11.prev = _context11.next) {
            case 0:
              _context11.prev = 0;
              _job$data4 = job.data, email = _job$data4.email, _job$data4$score = _job$data4.score, score = _job$data4$score === void 0 ? 0 : _job$data4$score, mailType = _job$data4.mailType, headerDetails = _job$data4.headerDetails, header = _job$data4.header;
              messageId = job.data.messageId;
              _context11.next = 5;
              return _parseEmail["default"].parseEml(header);
            case 5:
              parseEml = _context11.sent;
              if (!parseEml) {
                _context11.next = 28;
                break;
              }
              from = null, fromName = null, to = null, toName = null, companyId = null;
              if (!(parseEml.from && parseEml.from.length)) {
                _context11.next = 13;
                break;
              }
              from = parseEml.from[0].address;
              fromName = parseEml.from[0].name;
              _context11.next = 14;
              break;
            case 13:
              throw new RequestError('con\'t find from email');
            case 14:
              to = email;
              toName = "";
              subject = parseEml.subject;
              mailId = parseEml.messageId;
              mailRecievedTime = parseEml.receivedDate;
              _context11.next = 21;
              return db.User.findOne({
                email: to,
                emailType: mailType
              });
            case 21:
              user = _context11.sent;
              if (user) {
                companyId = user.companyId;
              }
              console.log({
                companyId: companyId
              });
              _context11.next = 26;
              return db.CheckEmailScoreEvent.create({
                from: from,
                fromName: fromName,
                to: to,
                toName: toName,
                subject: subject,
                mailId: mailId,
                headerDetails: headerDetails,
                messageId: messageId,
                mailRecievedTime: mailRecievedTime,
                companyId: companyId,
                score: score,
                mailType: mailType
              });
            case 26:
              _context11.next = 29;
              break;
            case 28:
              console.error('error in parsing eml');
            case 29:
              _context11.next = 34;
              break;
            case 31:
              _context11.prev = 31;
              _context11.t0 = _context11["catch"](0);
              console.log(_context11.t0);
            case 34:
              _context11.prev = 34;
              done();
              return _context11.finish(34);
            case 37:
            case "end":
              return _context11.stop();
          }
        }, _callee11, null, [[0, 31, 34, 37]]);
      }));
      return function (_x18, _x19) {
        return _ref11.apply(this, arguments);
      };
    }());
    queue.process('check-email-spam-or-not-event-gsuite', /*#__PURE__*/function () {
      var _ref12 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee12(job, done) {
        var _job$data5, email, _job$data5$score, score, mailType, headerDetails, mailBody, messageId, threadId, parseEml, from, fromName, to, toName, subject, mailId, mailRecievedTime, companyId, user;
        return _regenerator["default"].wrap(function _callee12$(_context12) {
          while (1) switch (_context12.prev = _context12.next) {
            case 0:
              _context12.prev = 0;
              _job$data5 = job.data, email = _job$data5.email, _job$data5$score = _job$data5.score, score = _job$data5$score === void 0 ? 0 : _job$data5$score, mailType = _job$data5.mailType, headerDetails = _job$data5.headerDetails, mailBody = _job$data5.mailBody, messageId = _job$data5.messageId, threadId = _job$data5.threadId;
              _context12.next = 4;
              return _parseEmail["default"].parseEml(mailBody);
            case 4:
              parseEml = _context12.sent;
              if (!parseEml) {
                _context12.next = 26;
                break;
              }
              from = null, fromName = null, to = null, toName = null, companyId = null;
              if (!(parseEml.from && parseEml.from.length)) {
                _context12.next = 12;
                break;
              }
              from = parseEml.from[0].address;
              fromName = parseEml.from[0].name;
              _context12.next = 13;
              break;
            case 12:
              throw new RequestError('con\'t find from email');
            case 13:
              to = email;
              toName = "";
              mailId = threadId;
              subject = parseEml.subject;
              mailRecievedTime = parseEml.receivedDate;
              _context12.next = 20;
              return db.User.findOne({
                email: to,
                emailType: mailType
              });
            case 20:
              user = _context12.sent;
              if (user) {
                companyId = user.companyId;
              }
              _context12.next = 24;
              return db.CheckEmailScoreEvent.create({
                from: from,
                fromName: fromName,
                to: to,
                toName: toName,
                subject: subject,
                mailId: mailId,
                headerDetails: headerDetails,
                messageId: messageId,
                mailRecievedTime: mailRecievedTime,
                companyId: companyId,
                score: score,
                mailType: mailType
              });
            case 24:
              _context12.next = 27;
              break;
            case 26:
              console.error('error in parsing eml');
            case 27:
              _context12.next = 32;
              break;
            case 29:
              _context12.prev = 29;
              _context12.t0 = _context12["catch"](0);
              console.log(_context12.t0);
            case 32:
              _context12.prev = 32;
              done();
              return _context12.finish(32);
            case 35:
            case "end":
              return _context12.stop();
          }
        }, _callee12, null, [[0, 29, 32, 35]]);
      }));
      return function (_x20, _x21) {
        return _ref12.apply(this, arguments);
      };
    }());
    queue.process('webhook-reported-email-outlook-collector', /*#__PURE__*/function () {
      var _ref13 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee13(job, done) {
        var _parsedEML$headers, _parsedEML$attachment, _job$data6, messageId, companyId, domainId, token, webhookRetrievalEmail, from, user, attachments, eml, parsedEML, internetMessageId, originalMessage, body, id, parentFolderId, mailAttachments;
        return _regenerator["default"].wrap(function _callee13$(_context13) {
          while (1) switch (_context13.prev = _context13.next) {
            case 0:
              _context13.prev = 0;
              _job$data6 = job.data, messageId = _job$data6.messageId, companyId = _job$data6.companyId, domainId = _job$data6.domainId, token = _job$data6.token, webhookRetrievalEmail = _job$data6.webhookRetrievalEmail, from = _job$data6.from, user = _job$data6.user;
              console.log("Processing webhook-reported-email-outlook-collector for message: ".concat(messageId));
              if (!(!messageId || !companyId || !domainId || !token || !webhookRetrievalEmail || !from || !user)) {
                _context13.next = 6;
                break;
              }
              console.error("Missing required data. Skipping queue processing.");
              return _context13.abrupt("return", done("Invalid job data"));
            case 6:
              _context13.prev = 6;
              _context13.next = 9;
              return (0, _outlookWebhookEmailServices.getAttachments)(webhookRetrievalEmail, messageId, token);
            case 9:
              attachments = _context13.sent;
              if (attachments.length) {
                _context13.next = 13;
                break;
              }
              console.warn("\u26A0\uFE0F No attachments found for message: ".concat(messageId));
              return _context13.abrupt("return", done());
            case 13:
              _context13.next = 15;
              return (0, _outlookWebhookEmailServices.getOriginalMessageDetails)(webhookRetrievalEmail, messageId, attachments[0].Id, token);
            case 15:
              eml = _context13.sent;
              if (eml) {
                _context13.next = 19;
                break;
              }
              console.error("Failed to fetch original EML content.");
              return _context13.abrupt("return", done("No valid EML content found"));
            case 19:
              _context13.next = 25;
              break;
            case 21:
              _context13.prev = 21;
              _context13.t0 = _context13["catch"](6);
              console.error("Error fetching email details: ".concat(_context13.t0.message));
              return _context13.abrupt("return", done(_context13.t0.message));
            case 25:
              _context13.next = 27;
              return _parseEmail["default"].parseHeader(eml);
            case 27:
              parsedEML = _context13.sent;
              internetMessageId = parsedEML === null || parsedEML === void 0 ? void 0 : (_parsedEML$headers = parsedEML.headers) === null || _parsedEML$headers === void 0 ? void 0 : _parsedEML$headers['message-id'];
              if (internetMessageId) {
                _context13.next = 32;
                break;
              }
              console.error("Failed to extract internetMessageId from parsed EML.");
              return _context13.abrupt("return", done("Missing internetMessageId"));
            case 32:
              _context13.next = 34;
              return (0, _subscriptionService.getMessageByInternetMessageId)(from, internetMessageId, token);
            case 34:
              originalMessage = _context13.sent;
              if (!(!originalMessage || !originalMessage.id)) {
                _context13.next = 38;
                break;
              }
              console.error("Failed to retrieve original message by internetMessageId.");
              return _context13.abrupt("return", done("Original message not found"));
            case 38:
              body = originalMessage.body, id = originalMessage.id, parentFolderId = originalMessage.parentFolderId;
              mailAttachments = (_parsedEML$attachment = parsedEML === null || parsedEML === void 0 ? void 0 : parsedEML.attachments) !== null && _parsedEML$attachment !== void 0 ? _parsedEML$attachment : [];
              if (!mailAttachments.length) {
                _context13.next = 44;
                break;
              }
              _context13.next = 43;
              return (0, _subscriptionService.formatMailAttachments)(mailAttachments);
            case 43:
              mailAttachments = _context13.sent;
            case 44:
              if (!(!id || !from || !user._id || !companyId || !domainId || !parentFolderId)) {
                _context13.next = 47;
                break;
              }
              console.error("Missing required data before queuing reported-email-outlook.");
              return _context13.abrupt("return", done("Incomplete data for email reporting"));
            case 47:
              queue.create('reported-email-outlook', {
                email: from,
                header: eml,
                body: (body === null || body === void 0 ? void 0 : body.content) || '',
                eml: eml,
                userId: user._id,
                userName: (user === null || user === void 0 ? void 0 : user.name) || '',
                domainId: domainId,
                companyId: companyId,
                messageId: id,
                internetMessageId: internetMessageId,
                attachments: mailAttachments,
                folderId: parentFolderId,
                spamScore: 0,
                isTsatMail: false
              }).priority('high').removeOnComplete(true).save(function (err) {
                if (err) {
                  console.error("Failed to enqueue reported-email-outlook:", err);
                  return done(err);
                }
                console.log("Successfully enqueued reported-email-outlook for message: ".concat(id));
                done();
              });
              _context13.next = 54;
              break;
            case 50:
              _context13.prev = 50;
              _context13.t1 = _context13["catch"](0);
              console.error("Error processing webhook-reported-email-outlook-collector:", _context13.t1.message);
              done(_context13.t1);
            case 54:
              _context13.prev = 54;
              done();
              return _context13.finish(54);
            case 57:
            case "end":
              return _context13.stop();
          }
        }, _callee13, null, [[0, 50, 54, 57], [6, 21]]);
      }));
      return function (_x22, _x23) {
        return _ref13.apply(this, arguments);
      };
    }());
    queue.process('reported-email-outlook', /*#__PURE__*/function () {
      var _ref14 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee14(job, done) {
        var _job$data7, email, header, body, attachments, userId, domainId, folderId, messageId, companyId, eml, internetMessageId, spamScore, userName, isTsatMail, parseEml, headerDetails, _parseEml$cc, _parseEml$bcc, from, fromName, to, toName, mailType, subject, mailId, mailRecievedTime, cc, bcc, otherTo, emailReported, document;
        return _regenerator["default"].wrap(function _callee14$(_context14) {
          while (1) switch (_context14.prev = _context14.next) {
            case 0:
              _job$data7 = job.data, email = _job$data7.email, header = _job$data7.header, body = _job$data7.body, attachments = _job$data7.attachments, userId = _job$data7.userId, domainId = _job$data7.domainId, folderId = _job$data7.folderId, messageId = _job$data7.messageId, companyId = _job$data7.companyId, eml = _job$data7.eml, internetMessageId = _job$data7.internetMessageId, spamScore = _job$data7.spamScore, userName = _job$data7.userName, isTsatMail = _job$data7.isTsatMail;
              _context14.prev = 1;
              _context14.next = 4;
              return _parseEmail["default"].parseEml(header);
            case 4:
              parseEml = _context14.sent;
              _context14.next = 7;
              return _parseHeader["default"].processHeader(header);
            case 7:
              headerDetails = _context14.sent;
              if (!parseEml) {
                _context14.next = 83;
                break;
              }
              from = null, fromName = null, to = null, toName = null, mailType = "Outlook", cc = [], bcc = [], otherTo = [];
              if (parseEml.from && parseEml.from.length) {
                from = parseEml.from[0].address;
                fromName = parseEml.from[0].name;
              }
              if (parseEml.to && parseEml.to.length) {
                otherTo = parseEml.to;
              }
              to = email.toLowerCase();
              toName = userName;
              subject = parseEml.subject;
              mailId = parseEml.messageId;
              mailRecievedTime = parseEml.receivedDate;
              cc = (_parseEml$cc = parseEml.cc) !== null && _parseEml$cc !== void 0 ? _parseEml$cc : parseEml.cc;
              bcc = (_parseEml$bcc = parseEml.bcc) !== null && _parseEml$bcc !== void 0 ? _parseEml$bcc : parseEml.bcc;
              if (isTsatMail) {
                _context14.next = 52;
                break;
              }
              _context14.t0 = db.ReportedMail;
              _context14.t1 = from;
              _context14.t2 = fromName;
              _context14.t3 = to;
              _context14.t4 = toName;
              _context14.t5 = subject;
              _context14.t6 = mailId;
              _context14.t7 = cc;
              _context14.t8 = folderId;
              _context14.t9 = bcc;
              _context14.t10 = otherTo;
              _context14.t11 = messageId;
              _context14.t12 = internetMessageId;
              _context14.t13 = mailRecievedTime;
              _context14.t14 = companyId;
              _context14.t15 = mailType;
              _context14.t16 = userId;
              _context14.next = 39;
              return (0, _allowedFeatures["default"])(companyId, "TPIR-SDD");
            case 39:
              if (!_context14.sent) {
                _context14.next = 43;
                break;
              }
              _context14.t17 = headerDetails;
              _context14.next = 44;
              break;
            case 43:
              _context14.t17 = null;
            case 44:
              _context14.t18 = _context14.t17;
              _context14.t19 = domainId;
              _context14.t20 = {
                from: _context14.t1,
                fromName: _context14.t2,
                to: _context14.t3,
                toName: _context14.t4,
                subject: _context14.t5,
                mailId: _context14.t6,
                cc: _context14.t7,
                reporterFolderId: _context14.t8,
                bcc: _context14.t9,
                otherTo: _context14.t10,
                messageId: _context14.t11,
                internetMessageId: _context14.t12,
                mailRecievedTime: _context14.t13,
                companyId: _context14.t14,
                mailType: _context14.t15,
                header: '',
                body: '',
                userId: _context14.t16,
                headerDetails: _context14.t18,
                domainId: _context14.t19,
                parsedHeader: ''
              };
              _context14.next = 49;
              return _context14.t0.create.call(_context14.t0, _context14.t20);
            case 49:
              emailReported = _context14.sent;
              document = {
                _id: emailReported._id,
                header: header,
                body: body,
                parsedHeader: parseEml
              };
              _upload_file["default"].uploadReportedMail(document);
            case 52:
              _context14.next = 54;
              return (0, _allowedFeatures["default"])(companyId, "TPIR-RN");
            case 54:
              if (!_context14.sent) {
                _context14.next = 56;
                break;
              }
              queue.create('send-reported-mail', {
                to: to,
                userName: userName,
                from: from,
                subject: subject,
                mailRecievedTime: mailRecievedTime,
                companyId: companyId
              }).removeOnComplete(true).priority('high').save();
            case 56:
              queue.create('upload-siem-logs', {
                to: to,
                from: from,
                subject: subject,
                mailRecievedTime: mailRecievedTime,
                companyId: companyId,
                internetMessageId: internetMessageId,
                spf: headerDetails === null || headerDetails === void 0 ? void 0 : headerDetails.spf,
                dkim: headerDetails === null || headerDetails === void 0 ? void 0 : headerDetails.dkim,
                dmarc: headerDetails === null || headerDetails === void 0 ? void 0 : headerDetails.dmarc,
                senderIp: headerDetails === null || headerDetails === void 0 ? void 0 : headerDetails.senderIp
              }).removeOnComplete(true).priority('high').save();
              _context14.next = 59;
              return (0, _allowedFeatures["default"])(companyId, "TPIR-EASOC");
            case 59:
              if (!_context14.sent) {
                _context14.next = 61;
                break;
              }
              queue.create('send-soc-mail', {
                to: to,
                from: from,
                subject: subject,
                mailRecievedTime: mailRecievedTime,
                header: header,
                body: body,
                companyId: companyId,
                eml: eml,
                attachment: attachments,
                isGsuite: false
              }).removeOnComplete(true).priority('high').save();
            case 61:
              if (isTsatMail) {
                _context14.next = 83;
                break;
              }
              _context14.next = 64;
              return (0, _allowedFeatures["default"])(companyId, "TPIR-SDRC");
            case 64:
              if (!_context14.sent) {
                _context14.next = 66;
                break;
              }
              queue.create('check-sender-domain-deceptive', {
                from: from,
                reportedMailId: emailReported._id
              }).removeOnComplete(true).priority('high').save();
            case 66:
              queue.create('email-language', {
                body: body,
                reportedMailId: emailReported._id
              }).removeOnComplete(true).priority('high').save();
              queue.create('report-email-score', {
                spamScore: spamScore,
                reportedMailId: emailReported._id
              }).removeOnComplete(true).priority('high').save();
              _context14.next = 70;
              return (0, _allowedFeatures["default"])(companyId, "TPIR-VAUIR");
            case 70:
              if (!_context14.sent) {
                _context14.next = 72;
                break;
              }
              queue.create('email-reported-url', {
                body: body,
                companyId: companyId,
                reportedMailId: emailReported._id
              }).removeOnComplete(true).priority('high').save();
            case 72:
              _context14.next = 74;
              return (0, _allowedFeatures["default"])(companyId, "TPIR-VAUIR");
            case 74:
              if (!_context14.sent) {
                _context14.next = 76;
                break;
              }
              queue.create('email-reported-attachments-outlook', {
                attachments: attachments,
                companyId: companyId,
                reportedMailId: emailReported._id
              }).removeOnComplete(true).priority('high').save();
            case 76:
              _context14.t21 = headerDetails !== null && headerDetails !== void 0 && headerDetails.senderIp;
              if (!_context14.t21) {
                _context14.next = 81;
                break;
              }
              _context14.next = 80;
              return (0, _allowedFeatures["default"])(companyId, "TPIR-DBL");
            case 80:
              _context14.t21 = _context14.sent;
            case 81:
              if (!_context14.t21) {
                _context14.next = 83;
                break;
              }
              queue.create('process-dnsbl', {
                reportedMailId: emailReported._id,
                senderIp: headerDetails.senderIp
              }).removeOnComplete(true).save();
            case 83:
              _context14.next = 88;
              break;
            case 85:
              _context14.prev = 85;
              _context14.t22 = _context14["catch"](1);
              console.log(_context14.t22);
            case 88:
              _context14.prev = 88;
              done();
              return _context14.finish(88);
            case 91:
            case "end":
              return _context14.stop();
          }
        }, _callee14, null, [[1, 85, 88, 91]]);
      }));
      return function (_x24, _x25) {
        return _ref14.apply(this, arguments);
      };
    }());
    queue.process('upload-siem-logs', /*#__PURE__*/function () {
      var _ref15 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee15(job, done) {
        var _job$data8, to, from, subject, mailRecievedTime, companyId, spf, dkim, dmarc, senderIp;
        return _regenerator["default"].wrap(function _callee15$(_context15) {
          while (1) switch (_context15.prev = _context15.next) {
            case 0:
              _job$data8 = job.data, to = _job$data8.to, from = _job$data8.from, subject = _job$data8.subject, mailRecievedTime = _job$data8.mailRecievedTime, companyId = _job$data8.companyId, spf = _job$data8.spf, dkim = _job$data8.dkim, dmarc = _job$data8.dmarc, senderIp = _job$data8.senderIp;
              _context15.prev = 1;
              _context15.next = 4;
              return _upload_file["default"].uploadSiemLogs(job.data, companyId);
            case 4:
              _context15.next = 10;
              break;
            case 6:
              _context15.prev = 6;
              _context15.t0 = _context15["catch"](1);
              console.log('Error Sending Reported Mail', _context15.t0);
              done();
            case 10:
              _context15.prev = 10;
              done();
              return _context15.finish(10);
            case 13:
            case "end":
              return _context15.stop();
          }
        }, _callee15, null, [[1, 6, 10, 13]]);
      }));
      return function (_x26, _x27) {
        return _ref15.apply(this, arguments);
      };
    }());
    queue.process('send-reported-mail', /*#__PURE__*/function () {
      var _ref16 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee16(job, done) {
        var _job$data9, to, from, userName, subject, mailRecievedTime, companyId;
        return _regenerator["default"].wrap(function _callee16$(_context16) {
          while (1) switch (_context16.prev = _context16.next) {
            case 0:
              _job$data9 = job.data, to = _job$data9.to, from = _job$data9.from, userName = _job$data9.userName, subject = _job$data9.subject, mailRecievedTime = _job$data9.mailRecievedTime, companyId = _job$data9.companyId;
              _context16.prev = 1;
              _context16.next = 4;
              return _mailer["default"].sendReportedMail(to, from, subject, mailRecievedTime, companyId, userName);
            case 4:
              _context16.next = 9;
              break;
            case 6:
              _context16.prev = 6;
              _context16.t0 = _context16["catch"](1);
              console.log('Error Sending Reported Mail', _context16.t0);
            case 9:
              _context16.prev = 9;
              done();
              return _context16.finish(9);
            case 12:
            case "end":
              return _context16.stop();
          }
        }, _callee16, null, [[1, 6, 9, 12]]);
      }));
      return function (_x28, _x29) {
        return _ref16.apply(this, arguments);
      };
    }());
    queue.process('route-email-tsat', /*#__PURE__*/function () {
      var _ref17 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee17(job, done) {
        var _job$data10, body, header, tsatUrl;
        return _regenerator["default"].wrap(function _callee17$(_context17) {
          while (1) switch (_context17.prev = _context17.next) {
            case 0:
              _job$data10 = job.data, body = _job$data10.body, header = _job$data10.header, tsatUrl = _job$data10.tsatUrl;
              _context17.prev = 1;
              _context17.next = 4;
              return _routeEmailTsat["default"].routeMail(job.data);
            case 4:
              _context17.next = 10;
              break;
            case 6:
              _context17.prev = 6;
              _context17.t0 = _context17["catch"](1);
              console.log('Error Sending Reported Mail', _context17.t0);
              done();
            case 10:
              _context17.prev = 10;
              done();
              return _context17.finish(10);
            case 13:
            case "end":
              return _context17.stop();
          }
        }, _callee17, null, [[1, 6, 10, 13]]);
      }));
      return function (_x30, _x31) {
        return _ref17.apply(this, arguments);
      };
    }());
    queue.process('send-soc-mail', /*#__PURE__*/function () {
      var _ref18 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee18(job, done) {
        var _job$data11, companyId, to, from, subject, mailRecievedTime, header, _job$data11$eml, eml, body, _job$data11$attachmen, attachment, _job$data11$filename, filename, _job$data11$mailBody, mailBody, isGsuite, isSocMail, i;
        return _regenerator["default"].wrap(function _callee18$(_context18) {
          while (1) switch (_context18.prev = _context18.next) {
            case 0:
              _job$data11 = job.data, companyId = _job$data11.companyId, to = _job$data11.to, from = _job$data11.from, subject = _job$data11.subject, mailRecievedTime = _job$data11.mailRecievedTime, header = _job$data11.header, _job$data11$eml = _job$data11.eml, eml = _job$data11$eml === void 0 ? '' : _job$data11$eml, body = _job$data11.body, _job$data11$attachmen = _job$data11.attachment, attachment = _job$data11$attachmen === void 0 ? false : _job$data11$attachmen, _job$data11$filename = _job$data11.filename, filename = _job$data11$filename === void 0 ? '' : _job$data11$filename, _job$data11$mailBody = _job$data11.mailBody, mailBody = _job$data11$mailBody === void 0 ? '' : _job$data11$mailBody, isGsuite = _job$data11.isGsuite;
              _context18.next = 3;
              return db.Company.findOne({
                _id: companyId,
                socEmail: {
                  $exists: true
                }
              });
            case 3:
              isSocMail = _context18.sent;
              console.log({
                isSocMail: isSocMail
              });
              if (isSocMail) {
                _context18.next = 9;
                break;
              }
              console.log('Mail Not Sent: SOC mail not added');
              done();
              return _context18.abrupt("return");
            case 9:
              try {
                for (i = 0; i < isSocMail.socEmail.length; i++) {
                  _mailer["default"].sendSocMail(to, from, subject, mailRecievedTime, header, body, eml, isSocMail.socEmail[i], attachment, filename, companyId, mailBody, isGsuite);
                }
              } catch (err) {
                console.log('Error Sending SOC Mail', err);
              } finally {
                done();
              }
            case 10:
            case "end":
              return _context18.stop();
          }
        }, _callee18);
      }));
      return function (_x32, _x33) {
        return _ref18.apply(this, arguments);
      };
    }());
    queue.process('check-sender-domain-deceptive', /*#__PURE__*/function () {
      var _ref19 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee19(job, done) {
        var _job$data12, reportedMailId, from, senderDomain, senderDomainDeceptive;
        return _regenerator["default"].wrap(function _callee19$(_context19) {
          while (1) switch (_context19.prev = _context19.next) {
            case 0:
              _job$data12 = job.data, reportedMailId = _job$data12.reportedMailId, from = _job$data12.from;
              _context19.prev = 1;
              senderDomain = from.split("@")[1];
              _context19.next = 5;
              return (0, _deceiptiveCheck.checkDeceptive)(senderDomain);
            case 5:
              senderDomainDeceptive = _context19.sent;
              _context19.next = 8;
              return db.ReportedMail.updateOne({
                _id: reportedMailId
              }, {
                senderDomain: senderDomain,
                senderDomainDeceptive: senderDomainDeceptive
              });
            case 8:
              _context19.next = 13;
              break;
            case 10:
              _context19.prev = 10;
              _context19.t0 = _context19["catch"](1);
              console.log(_context19.t0);
            case 13:
              _context19.prev = 13;
              done();
              return _context19.finish(13);
            case 16:
            case "end":
              return _context19.stop();
          }
        }, _callee19, null, [[1, 10, 13, 16]]);
      }));
      return function (_x34, _x35) {
        return _ref19.apply(this, arguments);
      };
    }());
    queue.process('email-language', /*#__PURE__*/function () {
      var _ref20 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee20(job, done) {
        var _job$data13, reportedMailId, body, languages;
        return _regenerator["default"].wrap(function _callee20$(_context20) {
          while (1) switch (_context20.prev = _context20.next) {
            case 0:
              _job$data13 = job.data, reportedMailId = _job$data13.reportedMailId, body = _job$data13.body;
              console.log('---------------------------LANG DETECT------------------------------------');
              _context20.prev = 2;
              _context20.next = 5;
              return _checkLanguage["default"].processText(body);
            case 5:
              languages = _context20.sent;
              (0, _functions.updateReportedMailCache)(reportedMailId, {
                languages: languages
              });
              _context20.next = 9;
              return db.ReportedMail.updateOne({
                _id: reportedMailId
              }, {
                languages: languages
              });
            case 9:
              _context20.next = 14;
              break;
            case 11:
              _context20.prev = 11;
              _context20.t0 = _context20["catch"](2);
              console.log(_context20.t0);
            case 14:
              _context20.prev = 14;
              done();
              return _context20.finish(14);
            case 17:
            case "end":
              return _context20.stop();
          }
        }, _callee20, null, [[2, 11, 14, 17]]);
      }));
      return function (_x36, _x37) {
        return _ref20.apply(this, arguments);
      };
    }());
    queue.process('reported-email-gsuite', /*#__PURE__*/function () {
      var _ref21 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee21(job, done) {
        var _job$data14, email, header, plainHeader, body, attachments, userId, domainId, messageId, threadId, companyId, internetMessageId, spamScore, userName, isTsatMail, mailBody, headerDetails, parseEml, _parseEml$cc2, _parseEml$bcc2, from, fromName, to, toName, mailType, subject, mailId, mailRecievedTime, cc, bcc, otherTo, emailReported, document;
        return _regenerator["default"].wrap(function _callee21$(_context21) {
          while (1) switch (_context21.prev = _context21.next) {
            case 0:
              _job$data14 = job.data, email = _job$data14.email, header = _job$data14.header, plainHeader = _job$data14.plainHeader, body = _job$data14.body, attachments = _job$data14.attachments, userId = _job$data14.userId, domainId = _job$data14.domainId, messageId = _job$data14.messageId, threadId = _job$data14.threadId, companyId = _job$data14.companyId, internetMessageId = _job$data14.internetMessageId, spamScore = _job$data14.spamScore, userName = _job$data14.userName, isTsatMail = _job$data14.isTsatMail, mailBody = _job$data14.mailBody;
              _context21.prev = 1;
              _context21.next = 4;
              return _parseHeader["default"].processHeader(header, false);
            case 4:
              headerDetails = _context21.sent;
              // const parseEml = await parseEmail.parseEml(header);
              parseEml = header;
              if (!parseEml) {
                _context21.next = 81;
                break;
              }
              from = null, fromName = null, to = null, toName = null, mailType = "Gsuite", cc = [], bcc = [], otherTo = [];
              if (parseEml.from && parseEml.from.length) {
                from = parseEml.from[0].address;
                fromName = parseEml.from[0].name;
              }
              if (parseEml.to && parseEml.to.length) {
                otherTo = parseEml.to;
              }
              to = email;
              toName = userName;
              mailId = threadId;
              subject = parseEml.subject;
              mailRecievedTime = parseEml.receivedDate;
              cc = (_parseEml$cc2 = parseEml.cc) !== null && _parseEml$cc2 !== void 0 ? _parseEml$cc2 : parseEml.cc;
              bcc = (_parseEml$bcc2 = parseEml.bcc) !== null && _parseEml$bcc2 !== void 0 ? _parseEml$bcc2 : parseEml.bcc;
              delete parseEml['attachments'];
              if (isTsatMail) {
                _context21.next = 50;
                break;
              }
              _context21.t0 = db.ReportedMail;
              _context21.t1 = from;
              _context21.t2 = fromName;
              _context21.t3 = to;
              _context21.t4 = toName;
              _context21.t5 = subject;
              _context21.t6 = mailId;
              _context21.t7 = cc;
              _context21.t8 = bcc;
              _context21.t9 = otherTo;
              _context21.t10 = messageId;
              _context21.t11 = mailRecievedTime;
              _context21.t12 = companyId;
              _context21.t13 = internetMessageId;
              _context21.t14 = mailType;
              _context21.t15 = userId;
              _context21.next = 37;
              return (0, _allowedFeatures["default"])(companyId, "TPIR-SDD");
            case 37:
              if (!_context21.sent) {
                _context21.next = 41;
                break;
              }
              _context21.t16 = headerDetails;
              _context21.next = 42;
              break;
            case 41:
              _context21.t16 = null;
            case 42:
              _context21.t17 = _context21.t16;
              _context21.t18 = domainId;
              _context21.t19 = {
                from: _context21.t1,
                fromName: _context21.t2,
                to: _context21.t3,
                toName: _context21.t4,
                subject: _context21.t5,
                mailId: _context21.t6,
                cc: _context21.t7,
                bcc: _context21.t8,
                otherTo: _context21.t9,
                messageId: _context21.t10,
                mailRecievedTime: _context21.t11,
                companyId: _context21.t12,
                internetMessageId: _context21.t13,
                mailType: _context21.t14,
                header: '',
                body: '',
                userId: _context21.t15,
                headerDetails: _context21.t17,
                domainId: _context21.t18,
                parsedHeader: ''
              };
              _context21.next = 47;
              return _context21.t0.create.call(_context21.t0, _context21.t19);
            case 47:
              emailReported = _context21.sent;
              document = {
                _id: emailReported._id,
                header: plainHeader,
                body: body,
                parsedHeader: parseEml
              };
              _upload_file["default"].uploadReportedMail(document);
            case 50:
              queue.create('upload-siem-logs', {
                to: to,
                from: from,
                subject: subject,
                mailRecievedTime: mailRecievedTime,
                companyId: companyId,
                internetMessageId: internetMessageId,
                spf: headerDetails === null || headerDetails === void 0 ? void 0 : headerDetails.spf,
                dkim: headerDetails === null || headerDetails === void 0 ? void 0 : headerDetails.dkim,
                dmarc: headerDetails === null || headerDetails === void 0 ? void 0 : headerDetails.dmarc,
                senderIp: headerDetails === null || headerDetails === void 0 ? void 0 : headerDetails.senderIp
              }).removeOnComplete(true).priority('high').save();
              _context21.next = 53;
              return (0, _allowedFeatures["default"])(companyId, "TPIR-RN");
            case 53:
              if (!_context21.sent) {
                _context21.next = 55;
                break;
              }
              queue.create('send-reported-mail', {
                to: to,
                from: from,
                userName: userName,
                subject: subject,
                mailRecievedTime: mailRecievedTime,
                companyId: companyId
              }).removeOnComplete(true).priority('high').save();
            case 55:
              _context21.next = 57;
              return (0, _allowedFeatures["default"])(companyId, "TPIR-EASOC");
            case 57:
              if (!_context21.sent) {
                _context21.next = 59;
                break;
              }
              queue.create('send-soc-mail', {
                to: to,
                from: from,
                subject: subject,
                mailRecievedTime: mailRecievedTime,
                header: header,
                body: body,
                // eml,
                companyId: companyId,
                mailBody: mailBody,
                isGsuite: true
              }).removeOnComplete(true).priority('high').save();
            case 59:
              if (isTsatMail) {
                _context21.next = 81;
                break;
              }
              _context21.next = 62;
              return (0, _allowedFeatures["default"])(companyId, "TPIR-SDRC");
            case 62:
              if (!_context21.sent) {
                _context21.next = 64;
                break;
              }
              queue.create('check-sender-domain-deceptive', {
                from: from,
                reportedMailId: emailReported._id
              }).removeOnComplete(true).priority('high').save();
            case 64:
              queue.create('email-language', {
                body: body,
                reportedMailId: emailReported._id
              }).removeOnComplete(true).priority('high').save();
              queue.create('report-email-score', {
                spamScore: spamScore,
                reportedMailId: emailReported._id
              }).removeOnComplete(true).priority('high').save();
              _context21.next = 68;
              return (0, _allowedFeatures["default"])(companyId, "TPIR-VAUIR");
            case 68:
              if (!_context21.sent) {
                _context21.next = 70;
                break;
              }
              queue.create('email-reported-url', {
                body: body,
                companyId: companyId,
                reportedMailId: emailReported._id
              }).removeOnComplete(true).priority('high').save();
            case 70:
              _context21.next = 72;
              return (0, _allowedFeatures["default"])(companyId, "TPIR-VAUIR");
            case 72:
              if (!_context21.sent) {
                _context21.next = 74;
                break;
              }
              queue.create('email-reported-attachments-gsuite', {
                attachments: attachments,
                companyId: companyId,
                reportedMailId: emailReported._id
              }).removeOnComplete(true).priority('high').save();
            case 74:
              _context21.t20 = headerDetails !== null && headerDetails !== void 0 && headerDetails.senderIp;
              if (!_context21.t20) {
                _context21.next = 79;
                break;
              }
              _context21.next = 78;
              return (0, _allowedFeatures["default"])(companyId, "TPIR-DBL");
            case 78:
              _context21.t20 = _context21.sent;
            case 79:
              if (!_context21.t20) {
                _context21.next = 81;
                break;
              }
              queue.create('process-dnsbl', {
                reportedMailId: emailReported._id,
                senderIp: headerDetails.senderIp
              }).removeOnComplete(true).save();
            case 81:
              _context21.next = 86;
              break;
            case 83:
              _context21.prev = 83;
              _context21.t21 = _context21["catch"](1);
              console.log("Kue error", _context21.t21);
            case 86:
              _context21.prev = 86;
              done();
              return _context21.finish(86);
            case 89:
            case "end":
              return _context21.stop();
          }
        }, _callee21, null, [[1, 83, 86, 89]]);
      }));
      return function (_x38, _x39) {
        return _ref21.apply(this, arguments);
      };
    }());
    queue.process('process-dnsbl', /*#__PURE__*/function () {
      var _ref22 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee23(job, done) {
        var _job$data15, reportedMailId, senderIp, workerPool;
        return _regenerator["default"].wrap(function _callee23$(_context23) {
          while (1) switch (_context23.prev = _context23.next) {
            case 0:
              console.log('processing dnsbl.....');
              _job$data15 = job.data, reportedMailId = _job$data15.reportedMailId, senderIp = _job$data15.senderIp;
              try {
                workerPool = _workerpool["default"].get();
                console.time(reportedMailId);
                workerPool.dnsbl({
                  senderIp: senderIp
                }).then( /*#__PURE__*/function () {
                  var _ref23 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee22(result) {
                    return _regenerator["default"].wrap(function _callee22$(_context22) {
                      while (1) switch (_context22.prev = _context22.next) {
                        case 0:
                          console.timeEnd(reportedMailId);
                          _context22.next = 3;
                          return db.ReportedMail.updateOne({
                            _id: reportedMailId
                          }, {
                            dnsbl: result['dnsbl']
                          });
                        case 3:
                        case "end":
                          return _context22.stop();
                      }
                    }, _callee22);
                  }));
                  return function (_x42) {
                    return _ref23.apply(this, arguments);
                  };
                }());
              } catch (err) {
                console.log(err);
              } finally {
                done();
              }
            case 3:
            case "end":
              return _context23.stop();
          }
        }, _callee23);
      }));
      return function (_x40, _x41) {
        return _ref22.apply(this, arguments);
      };
    }());
    queue.process('email-reported-url', /*#__PURE__*/function () {
      var _ref24 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee24(job, done) {
        var _job$data16, reportedMailId, whatsAppMessageId, body, companyId, urls, data, _iterator, _step, key, domain, deceptiveStatus;
        return _regenerator["default"].wrap(function _callee24$(_context24) {
          while (1) switch (_context24.prev = _context24.next) {
            case 0:
              _job$data16 = job.data, reportedMailId = _job$data16.reportedMailId, whatsAppMessageId = _job$data16.whatsAppMessageId, body = _job$data16.body, companyId = _job$data16.companyId;
              _context24.prev = 1;
              _context24.next = 4;
              return (0, _getUrls["default"])(body);
            case 4:
              urls = _context24.sent;
              console.log("urls-----", urls);
              data = [];
              _iterator = _createForOfIteratorHelper(urls);
              _context24.prev = 8;
              _iterator.s();
            case 10:
              if ((_step = _iterator.n()).done) {
                _context24.next = 23;
                break;
              }
              key = _step.value;
              _context24.next = 14;
              return (0, _parseDomains["default"])(key);
            case 14:
              domain = _context24.sent;
              deceptiveStatus = false;
              if (!(domain !== null && domain !== void 0 && domain.domain)) {
                _context24.next = 20;
                break;
              }
              _context24.next = 19;
              return (0, _deceiptiveCheck.checkDeceptive)(domain.domain);
            case 19:
              deceptiveStatus = _context24.sent;
            case 20:
              data.push({
                url: key,
                deceptiveStatus: deceptiveStatus,
                domain: domain,
                reportedMailId: reportedMailId ? reportedMailId : null,
                whatsappMessageId: whatsAppMessageId ? whatsAppMessageId : null,
                companyId: companyId
              });
            case 21:
              _context24.next = 10;
              break;
            case 23:
              _context24.next = 28;
              break;
            case 25:
              _context24.prev = 25;
              _context24.t0 = _context24["catch"](8);
              _iterator.e(_context24.t0);
            case 28:
              _context24.prev = 28;
              _iterator.f();
              return _context24.finish(28);
            case 31:
              _context24.next = 33;
              return db.Url.insertMany(data);
            case 33:
              _context24.next = 38;
              break;
            case 35:
              _context24.prev = 35;
              _context24.t1 = _context24["catch"](1);
              console.log(_context24.t1);
            case 38:
              _context24.prev = 38;
              done();
              return _context24.finish(38);
            case 41:
            case "end":
              return _context24.stop();
          }
        }, _callee24, null, [[1, 35, 38, 41], [8, 25, 28, 31]]);
      }));
      return function (_x43, _x44) {
        return _ref24.apply(this, arguments);
      };
    }());
    queue.process('email-reported-attachments-outlook', /*#__PURE__*/function () {
      var _ref25 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee25(job, done) {
        var _job$data17, reportedMailId, attachments, companyId, scanResult, attachmentToinsert, _iterator2, _step2, attachment, filemime, filename, filePath;
        return _regenerator["default"].wrap(function _callee25$(_context25) {
          while (1) switch (_context25.prev = _context25.next) {
            case 0:
              _job$data17 = job.data, reportedMailId = _job$data17.reportedMailId, attachments = _job$data17.attachments, companyId = _job$data17.companyId;
              _context25.prev = 1;
              console.log('find attachment length', attachments.length);
              scanResult = {
                isInfected: true,
                viruses: [],
                file: ""
              };
              if (!(attachments && attachments.length)) {
                _context25.next = 31;
                break;
              }
              attachmentToinsert = [];
              _iterator2 = _createForOfIteratorHelper(attachments);
              _context25.prev = 7;
              _iterator2.s();
            case 9:
              if ((_step2 = _iterator2.n()).done) {
                _context25.next = 21;
                break;
              }
              attachment = _step2.value;
              filemime = attachment.name.split('.')[attachment.name.split('.').length - 1];
              filename = Date.now() + '.' + filemime;
              filePath = _path["default"].join(appRoot, 'Content', 'MailAttachments', filename);
              _upload_file["default"].uploadReportedMailAttachments(reportedMailId, filePath, filename, attachment.ContentBytes, attachment.contentType);
              _context25.next = 17;
              return _ScanAttachmentClamScan["default"].scanFile(attachment.ContentBytes);
            case 17:
              scanResult = _context25.sent;
              attachmentToinsert.push({
                reportedMailId: reportedMailId,
                mimeType: filemime,
                fileName: filename,
                attachmentId: attachment.id,
                originalName: attachment.name,
                attachmentType: attachment.contentType,
                isInfected: scanResult.isInfected,
                viruses: scanResult.viruses,
                companyId: companyId
              });
              // queue.create('upload-attachments-s3',{
              // filename, content: attachment.ContentBytes, contentType: attachment.contentType
              // }).removeOnComplete(true).save()
            case 19:
              _context25.next = 9;
              break;
            case 21:
              _context25.next = 26;
              break;
            case 23:
              _context25.prev = 23;
              _context25.t0 = _context25["catch"](7);
              _iterator2.e(_context25.t0);
            case 26:
              _context25.prev = 26;
              _iterator2.f();
              return _context25.finish(26);
            case 29:
              _context25.next = 31;
              return db.Attachment.insertMany(attachmentToinsert);
            case 31:
              _context25.next = 36;
              break;
            case 33:
              _context25.prev = 33;
              _context25.t1 = _context25["catch"](1);
              console.log(_context25.t1);
            case 36:
              _context25.prev = 36;
              done();
              return _context25.finish(36);
            case 39:
            case "end":
              return _context25.stop();
          }
        }, _callee25, null, [[1, 33, 36, 39], [7, 23, 26, 29]]);
      }));
      return function (_x45, _x46) {
        return _ref25.apply(this, arguments);
      };
    }());
    queue.process('upload-attachments-s3', /*#__PURE__*/function () {
      var _ref26 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee26(job, done) {
        var _job$data18, filename, content, contentType;
        return _regenerator["default"].wrap(function _callee26$(_context26) {
          while (1) switch (_context26.prev = _context26.next) {
            case 0:
              try {
                _job$data18 = job.data, filename = _job$data18.filename, content = _job$data18.content, contentType = _job$data18.contentType;
                _upload_file["default"].upload_on_s3(filename);
              } catch (error) {
                console.log(err);
              } finally {
                done();
              }
            case 1:
            case "end":
              return _context26.stop();
          }
        }, _callee26);
      }));
      return function (_x47, _x48) {
        return _ref26.apply(this, arguments);
      };
    }());
    queue.process('email-reported-attachments-gsuite', /*#__PURE__*/function () {
      var _ref27 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee27(job, done) {
        var _job$data19, reportedMailId, attachments, companyId, attachment, i, filemime, filename, filePath;
        return _regenerator["default"].wrap(function _callee27$(_context27) {
          while (1) switch (_context27.prev = _context27.next) {
            case 0:
              _context27.prev = 0;
              _job$data19 = job.data, reportedMailId = _job$data19.reportedMailId, attachments = _job$data19.attachments, companyId = _job$data19.companyId;
              console.log('find attachment length', attachments.length);
              if (!(attachments && attachments.length)) {
                _context27.next = 18;
                break;
              }
              attachment = [];
              i = 0;
            case 6:
              if (!(i < attachments.length)) {
                _context27.next = 16;
                break;
              }
              filemime = attachments[i].fileName.split('.')[attachments[i].fileName.split('.').length - 1];
              filename = Date.now() + '.' + filemime;
              filePath = _path["default"].join(appRoot, 'Content', 'MailAttachments', filename);
              _context27.next = 12;
              return _upload_file["default"].uploadReportedMailAttachments(reportedMailId, filePath, filename, attachments[i].content, attachments[i].contentType);
            case 12:
              attachment.push({
                reportedMailId: reportedMailId,
                mimeType: filemime,
                fileName: filename,
                originalName: attachments[i].fileName,
                attachmentId: attachments[i].contentId,
                attachmentType: attachments[i].contentType,
                companyId: companyId
              });
              // queue.create('upload-attachments', {
              //     filename
              // }).delay(5000).removeOnComplete(true).save();
            case 13:
              i++;
              _context27.next = 6;
              break;
            case 16:
              _context27.next = 18;
              return db.Attachment.insertMany(attachment);
            case 18:
              _context27.next = 23;
              break;
            case 20:
              _context27.prev = 20;
              _context27.t0 = _context27["catch"](0);
              console.log("Error From attachments save", _context27.t0);
            case 23:
              _context27.prev = 23;
              done();
              return _context27.finish(23);
            case 26:
            case "end":
              return _context27.stop();
          }
        }, _callee27, null, [[0, 20, 23, 26]]);
      }));
      return function (_x49, _x50) {
        return _ref27.apply(this, arguments);
      };
    }());
    queue.process('upload-attachments', /*#__PURE__*/function () {
      var _ref28 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee28(job, done) {
        var filename;
        return _regenerator["default"].wrap(function _callee28$(_context28) {
          while (1) switch (_context28.prev = _context28.next) {
            case 0:
              try {
                filename = job.data.filename;
                _upload_file["default"].upload_on_s3(filename);
              } catch (error) {
                console.log(err);
              } finally {
                done();
              }
            case 1:
            case "end":
              return _context28.stop();
          }
        }, _callee28);
      }));
      return function (_x51, _x52) {
        return _ref28.apply(this, arguments);
      };
    }());
    queue.process('email-reported-who-else-outlook', /*#__PURE__*/function () {
      var _ref29 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee31(job, done) {
        var _job$data20, from, subject, reportedMailId, domainId, companyId, internetMessageId, mailAction, domain, _groupsWithEmailAcces, _yield$Credentials$ge, token, groupsWithEmailAccess, users, userLength, workerPool, batchRequests, totalUsers, processedUsers, _loop, i;
        return _regenerator["default"].wrap(function _callee31$(_context32) {
          while (1) switch (_context32.prev = _context32.next) {
            case 0:
              _job$data20 = job.data, from = _job$data20.from, subject = _job$data20.subject, reportedMailId = _job$data20.reportedMailId, domainId = _job$data20.domainId, companyId = _job$data20.companyId, internetMessageId = _job$data20.internetMessageId, mailAction = _job$data20.mailAction;
              _context32.next = 3;
              return db.Domain.findOne({
                _id: domainId,
                companyId: companyId,
                deletedAt: null
              });
            case 3:
              domain = _context32.sent;
              _context32.prev = 4;
              console.log({
                domain: domain
              });
              if (!domain) {
                _context32.next = 49;
                break;
              }
              if (!domain.isCredential) {
                _context32.next = 44;
                break;
              }
              _context32.next = 10;
              return _credentials["default"].getCredentials(companyId, domainId);
            case 10:
              _yield$Credentials$ge = _context32.sent;
              token = _yield$Credentials$ge.token;
              console.log(token);
              _context32.next = 15;
              return db.Group.find({
                companyId: companyId,
                deletedAt: null,
                emailAccess: true
              }).select('_id');
            case 15:
              groupsWithEmailAccess = _context32.sent;
              groupsWithEmailAccess = (_groupsWithEmailAcces = groupsWithEmailAccess) === null || _groupsWithEmailAcces === void 0 ? void 0 : _groupsWithEmailAcces.map(function (group) {
                return group._id;
              });
              _context32.next = 19;
              return db.User.find({
                domainId: domainId,
                companyId: companyId,
                isActive: true,
                groups: {
                  $in: groupsWithEmailAccess
                },
                deletedAt: null
              });
            case 19:
              users = _context32.sent;
              console.log({
                users: users
              });
              console.log('fount total user for whoelse', users.length);
              if (!(users.length > 0)) {
                _context32.next = 39;
                break;
              }
              userLength = users.length;
              workerPool = _workerpool["default"].get();
              console.time("total processing whoelse time ".concat(reportedMailId, "-").concat(domainId));
              batchRequests = [];
              totalUsers = userLength;
              processedUsers = 0;
              _loop = /*#__PURE__*/_regenerator["default"].mark(function _loop() {
                var isLast, batch;
                return _regenerator["default"].wrap(function _loop$(_context31) {
                  while (1) switch (_context31.prev = _context31.next) {
                    case 0:
                      isLast = i + 1 == userLength;
                      batchRequests.push({
                        index: i + 1,
                        token: token.access_token,
                        subject: subject,
                        from: from,
                        isLast: isLast,
                        reportedMailId: reportedMailId,
                        internetMessageId: internetMessageId,
                        domainId: domainId,
                        companyId: companyId,
                        name: users[i].name,
                        email: users[i].email,
                        userId: users[i].userId,
                        emailUserId: users[i]._id.toHexString()
                      });
                      if (batchRequests.length == 20) {
                        batch = (i + 1) / 20;
                        console.time("processing done whoelse batch - ".concat(batch, " - ").concat(reportedMailId, " - ").concat(domainId));
                        console.log("workerPool", workerPool);
                        workerPool.whoElseOutlook(batchRequests).then(function (mailResults) {
                          processedUsers = processedUsers + 20;
                          queue.create('outlook-who-else-event', {
                            mailResults: mailResults,
                            totalUsers: totalUsers,
                            processedUsers: processedUsers,
                            reportedMailId: reportedMailId,
                            mailAction: mailAction,
                            companyId: companyId,
                            domainId: domainId
                          }).removeOnComplete(true).priority('high').save();
                          console.timeEnd("processing done whoelse batch - ".concat(batch, " - ").concat(reportedMailId, " - ").concat(domainId));
                        })["catch"]( /*#__PURE__*/function () {
                          var _ref31 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee30(err) {
                            return _regenerator["default"].wrap(function _callee30$(_context30) {
                              while (1) switch (_context30.prev = _context30.next) {
                                case 0:
                                  processedUsers = processedUsers + 20;
                                  if (!(totalUsers == processedUsers)) {
                                    _context30.next = 5;
                                    break;
                                  }
                                  _context30.next = 4;
                                  return db.WhoElseMetaData.updateOne({
                                    reportedMailId: reportedMailId,
                                    companyId: companyId,
                                    domainId: domainId
                                  }, {
                                    isProcessing: false,
                                    isCompleted: true,
                                    isError: true,
                                    errorMessage: 'Error From Workerpool'
                                  });
                                case 4:
                                  updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId);
                                case 5:
                                  console.timeEnd("processing done whoelse batch - ".concat(batch, " - ").concat(reportedMailId, " - ").concat(domainId));
                                case 6:
                                case "end":
                                  return _context30.stop();
                              }
                            }, _callee30);
                          }));
                          return function (_x56) {
                            return _ref31.apply(this, arguments);
                          };
                        }());
                        batchRequests = [];
                      }
                    case 3:
                    case "end":
                      return _context31.stop();
                  }
                }, _loop);
              });
              i = 0;
            case 31:
              if (!(i < userLength)) {
                _context32.next = 36;
                break;
              }
              return _context32.delegateYield(_loop(), "t0", 33);
            case 33:
              i++;
              _context32.next = 31;
              break;
            case 36:
              if (batchRequests.length != 0) {
                console.time("processing done last whoelse batch ".concat(reportedMailId, "-").concat(domainId));
                workerPool.whoElseOutlook(batchRequests).then(function (mailResults) {
                  console.log({
                    mailResults: mailResults
                  });
                  processedUsers = processedUsers + batchRequests.length;
                  queue.create('outlook-who-else-event', {
                    mailResults: mailResults,
                    totalUsers: totalUsers,
                    processedUsers: processedUsers,
                    reportedMailId: reportedMailId,
                    mailAction: mailAction,
                    companyId: companyId,
                    domainId: domainId
                  }).removeOnComplete(true).priority('high').save();
                  console.timeEnd("processing done last whoelse batch ".concat(reportedMailId, "-").concat(domainId));
                })["catch"]( /*#__PURE__*/function () {
                  var _ref30 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee29(err) {
                    return _regenerator["default"].wrap(function _callee29$(_context29) {
                      while (1) switch (_context29.prev = _context29.next) {
                        case 0:
                          processedUsers = processedUsers + batchRequests.length;
                          if (!(totalUsers == processedUsers)) {
                            _context29.next = 4;
                            break;
                          }
                          _context29.next = 4;
                          return db.WhoElseMetaData.updateOne({
                            reportedMailId: reportedMailId,
                            companyId: companyId,
                            domainId: domainId
                          }, {
                            isProcessing: false,
                            isCompleted: true,
                            isError: true,
                            errorMessage: "Error From Workerpool"
                          });
                        case 4:
                          updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId);
                        case 5:
                        case "end":
                          return _context29.stop();
                      }
                    }, _callee29);
                  }));
                  return function (_x55) {
                    return _ref30.apply(this, arguments);
                  };
                }());
              }
              _context32.next = 42;
              break;
            case 39:
              _context32.next = 41;
              return db.WhoElseMetaData.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: true,
                errorMessage: "Domain Users not found"
              });
            case 41:
              updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId);
            case 42:
              _context32.next = 47;
              break;
            case 44:
              _context32.next = 46;
              return db.WhoElseMetaData.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: true,
                errorMessage: "Domain Credentials Not Found"
              });
            case 46:
              updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId);
            case 47:
              _context32.next = 52;
              break;
            case 49:
              _context32.next = 51;
              return db.WhoElseMetaData.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: true,
                errorMessage: "Domain Not Found"
              });
            case 51:
              updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId);
            case 52:
              _context32.next = 59;
              break;
            case 54:
              _context32.prev = 54;
              _context32.t1 = _context32["catch"](4);
              _context32.next = 58;
              return db.WhoElseMetaData.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: true,
                errorMessage: JSON.stringify(_context32.t1)
              });
            case 58:
              updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId);
            case 59:
              _context32.prev = 59;
              done();
              return _context32.finish(59);
            case 62:
            case "end":
              return _context32.stop();
          }
        }, _callee31, null, [[4, 54, 59, 62]]);
      }));
      return function (_x53, _x54) {
        return _ref29.apply(this, arguments);
      };
    }()), queue.process('email-reported-similiar-emails-outlook', /*#__PURE__*/function () {
      var _ref32 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee34(job, done) {
        var _job$data21, from, subject, reportedMailId, domainId, companyId, internetMessageId, domain, _groupsWithEmailAcces2, _yield$Credentials$ge2, token, groupsWithEmailAccess, users, userLength, workerPool, batchRequests, totalUsers, processedUsers, _loop2, i;
        return _regenerator["default"].wrap(function _callee34$(_context36) {
          while (1) switch (_context36.prev = _context36.next) {
            case 0:
              _job$data21 = job.data, from = _job$data21.from, subject = _job$data21.subject, reportedMailId = _job$data21.reportedMailId, domainId = _job$data21.domainId, companyId = _job$data21.companyId, internetMessageId = _job$data21.internetMessageId;
              _context36.next = 3;
              return db.Domain.findOne({
                _id: domainId,
                companyId: companyId,
                deletedAt: null
              });
            case 3:
              domain = _context36.sent;
              _context36.prev = 4;
              if (!domain) {
                _context36.next = 46;
                break;
              }
              if (!domain.isCredential) {
                _context36.next = 41;
                break;
              }
              _context36.next = 9;
              return _credentials["default"].getCredentials(companyId, domainId);
            case 9:
              _yield$Credentials$ge2 = _context36.sent;
              token = _yield$Credentials$ge2.token;
              _context36.next = 13;
              return db.Group.find({
                companyId: companyId,
                deletedAt: null,
                emailAccess: true
              }).select('_id');
            case 13:
              groupsWithEmailAccess = _context36.sent;
              groupsWithEmailAccess = (_groupsWithEmailAcces2 = groupsWithEmailAccess) === null || _groupsWithEmailAcces2 === void 0 ? void 0 : _groupsWithEmailAcces2.map(function (group) {
                return group._id;
              });
              _context36.next = 17;
              return db.User.find({
                domainId: domainId,
                companyId: companyId,
                isActive: true,
                groups: {
                  $in: groupsWithEmailAccess
                },
                deletedAt: null
              });
            case 17:
              users = _context36.sent;
              console.log('fount total user for similiar email', users.length);
              if (!(users.length > 0)) {
                _context36.next = 36;
                break;
              }
              userLength = users.length;
              workerPool = _workerpool["default"].get();
              console.time("total processing similiar email time ".concat(reportedMailId, "-").concat(domainId));
              batchRequests = [];
              totalUsers = userLength;
              processedUsers = 0;
              _loop2 = /*#__PURE__*/_regenerator["default"].mark(function _loop2() {
                var isLast, batch;
                return _regenerator["default"].wrap(function _loop2$(_context35) {
                  while (1) switch (_context35.prev = _context35.next) {
                    case 0:
                      isLast = i + 1 == userLength;
                      batchRequests.push({
                        index: i + 1,
                        token: token.access_token,
                        subject: subject,
                        from: from,
                        isLast: isLast,
                        reportedMailId: reportedMailId,
                        internetMessageId: internetMessageId,
                        domainId: domainId,
                        companyId: companyId,
                        name: users[i].name,
                        email: users[i].email,
                        userId: users[i].userId,
                        emailUserId: users[i]._id.toHexString()
                      });
                      console.log("batchRequests", batchRequests);
                      if (batchRequests.length == 20) {
                        batch = (i + 1) / 20;
                        console.time("processing done similiar email batch - ".concat(batch, " - ").concat(reportedMailId, " - ").concat(domainId));
                        console.log("workerPool", workerPool);
                        workerPool.similiarSearchOutlook(batchRequests).then(function (mailResults) {
                          processedUsers = processedUsers + 20;
                          queue.create('outlook-similiar-emails-event', {
                            mailResults: mailResults,
                            totalUsers: totalUsers,
                            processedUsers: processedUsers,
                            reportedMailId: reportedMailId,
                            companyId: companyId,
                            domainId: domainId
                          }).removeOnComplete(true).priority('high').save();
                          console.timeEnd("processing done similiar email batch - ".concat(batch, " - ").concat(reportedMailId, " - ").concat(domainId));
                        })["catch"]( /*#__PURE__*/function () {
                          var _ref34 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee33(err) {
                            return _regenerator["default"].wrap(function _callee33$(_context34) {
                              while (1) switch (_context34.prev = _context34.next) {
                                case 0:
                                  processedUsers = processedUsers + 20;
                                  if (!(totalUsers == processedUsers)) {
                                    _context34.next = 5;
                                    break;
                                  }
                                  _context34.next = 4;
                                  return db.SimiliarEmailMetdata.updateOne({
                                    reportedMailId: reportedMailId,
                                    companyId: companyId,
                                    domainId: domainId
                                  }, {
                                    isProcessing: false,
                                    isCompleted: true,
                                    isError: true,
                                    errorMessage: 'Error From Workerpool'
                                  });
                                case 4:
                                  updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
                                case 5:
                                  console.timeEnd("processing done similiar email batch - ".concat(batch, " - ").concat(reportedMailId, " - ").concat(domainId));
                                case 6:
                                case "end":
                                  return _context34.stop();
                              }
                            }, _callee33);
                          }));
                          return function (_x60) {
                            return _ref34.apply(this, arguments);
                          };
                        }());
                        batchRequests = [];
                      }
                    case 4:
                    case "end":
                      return _context35.stop();
                  }
                }, _loop2);
              });
              i = 0;
            case 28:
              if (!(i < userLength)) {
                _context36.next = 33;
                break;
              }
              return _context36.delegateYield(_loop2(), "t0", 30);
            case 30:
              i++;
              _context36.next = 28;
              break;
            case 33:
              if (batchRequests.length != 0) {
                console.time("processing done last whoelse batch ".concat(reportedMailId, "-").concat(domainId));
                workerPool.similiarSearchOutlook(batchRequests).then(function (mailResults) {
                  processedUsers = processedUsers + batchRequests.length;
                  queue.create('outlook-similiar-emails-event', {
                    mailResults: mailResults,
                    totalUsers: totalUsers,
                    processedUsers: processedUsers,
                    reportedMailId: reportedMailId,
                    companyId: companyId,
                    domainId: domainId
                  }).removeOnComplete(true).priority('high').save();
                  console.timeEnd("processing done last whoelse batch ".concat(reportedMailId, "-").concat(domainId));
                })["catch"]( /*#__PURE__*/function () {
                  var _ref33 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee32(err) {
                    return _regenerator["default"].wrap(function _callee32$(_context33) {
                      while (1) switch (_context33.prev = _context33.next) {
                        case 0:
                          processedUsers = processedUsers + batchRequests.length;
                          if (!(totalUsers == processedUsers)) {
                            _context33.next = 4;
                            break;
                          }
                          _context33.next = 4;
                          return db.SimiliarEmailMetdata.updateOne({
                            reportedMailId: reportedMailId,
                            companyId: companyId,
                            domainId: domainId
                          }, {
                            isProcessing: false,
                            isCompleted: true,
                            isError: true,
                            errorMessage: "Error From Workerpool"
                          });
                        case 4:
                          updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
                        case 5:
                        case "end":
                          return _context33.stop();
                      }
                    }, _callee32);
                  }));
                  return function (_x59) {
                    return _ref33.apply(this, arguments);
                  };
                }());
              }
              _context36.next = 39;
              break;
            case 36:
              _context36.next = 38;
              return db.SimiliarEmailMetdata.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: true,
                errorMessage: "Domain Users not found"
              });
            case 38:
              updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
            case 39:
              _context36.next = 44;
              break;
            case 41:
              _context36.next = 43;
              return db.SimiliarEmailMetdata.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: true,
                errorMessage: "Domain Credentials Not Found"
              });
            case 43:
              updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
            case 44:
              _context36.next = 49;
              break;
            case 46:
              _context36.next = 48;
              return db.SimiliarEmailMetdata.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: true,
                errorMessage: "Domain Not Found"
              });
            case 48:
              updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
            case 49:
              _context36.next = 57;
              break;
            case 51:
              _context36.prev = 51;
              _context36.t1 = _context36["catch"](4);
              console.log(_context36.t1);
              _context36.next = 56;
              return db.SimiliarEmailMetdata.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: true,
                errorMessage: JSON.stringify(_context36.t1)
              });
            case 56:
              updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
            case 57:
              _context36.prev = 57;
              done();
              return _context36.finish(57);
            case 60:
            case "end":
              return _context36.stop();
          }
        }, _callee34, null, [[4, 51, 57, 60]]);
      }));
      return function (_x57, _x58) {
        return _ref32.apply(this, arguments);
      };
    }()), queue.process('outlook-similiar-emails-event', /*#__PURE__*/function () {
      var _ref35 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee35(job, done) {
        var _job$data22, users, totalUsers, processedUsers, reportedMailId, mailAction, companyId, domainId, i, _update;
        return _regenerator["default"].wrap(function _callee35$(_context37) {
          while (1) switch (_context37.prev = _context37.next) {
            case 0:
              _job$data22 = job.data, users = _job$data22.mailResults, totalUsers = _job$data22.totalUsers, processedUsers = _job$data22.processedUsers, reportedMailId = _job$data22.reportedMailId, mailAction = _job$data22.mailAction, companyId = _job$data22.companyId, domainId = _job$data22.domainId;
              _context37.prev = 1;
              console.log(job.data);
              i = 0;
            case 4:
              if (!(i < users.length)) {
                _context37.next = 14;
                break;
              }
              console.log("".concat(users[i].email, " - ").concat(users[i].foundInInbox ? "\x1b[32mInbox\x1b[0m" : "\x1b[31mTrash\x1b[0m", " "));
              if (!(users[i].from.toLowerCase() == users[i].email.toLowerCase())) {
                _context37.next = 9;
                break;
              }
              console.log("".concat(users[i].email, " - This the sender of email, skipping this user  ").concat(users[i].foundInInbox ? "\x1b[32mInbox\x1b[0m" : "\x1b[31mTrash\x1b[0m", " "));
              return _context37.abrupt("continue", 11);
            case 9:
              _context37.next = 11;
              return db.SimiliarEmail.create({
                reportedMailId: users[i].reportedMailId,
                name: users[i].name,
                from: users[i].from,
                subject: users[i].subject,
                domainId: users[i].domainId,
                companyId: users[i].companyId,
                messageId: users[i].messageId,
                internetMessageId: users[i].internetMessageId,
                threadId: null,
                to: users[i].email,
                userId: users[i].emailUserId,
                isTrashed: users[i].foundInTrash ? true : false,
                folderId: users[i].folderId
              });
            case 11:
              i++;
              _context37.next = 4;
              break;
            case 14:
              if (!(totalUsers == processedUsers)) {
                _context37.next = 20;
                break;
              }
              _context37.next = 17;
              return db.SimiliarEmailMetdata.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: false,
                errorMessage: null
              });
            case 17:
              _update = _context37.sent;
              updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
              console.timeEnd("total processing similiar email time ".concat(reportedMailId, "-").concat(domainId));
            case 20:
              _context37.next = 28;
              break;
            case 22:
              _context37.prev = 22;
              _context37.t0 = _context37["catch"](1);
              _context37.next = 26;
              return db.SimiliarEmailMetdata.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: true,
                errorMessage: "outlook-similiar-emails-event"
              });
            case 26:
              updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
              console.log(_context37.t0);
            case 28:
              _context37.prev = 28;
              done();
              return _context37.finish(28);
            case 31:
            case "end":
              return _context37.stop();
          }
        }, _callee35, null, [[1, 22, 28, 31]]);
      }));
      return function (_x61, _x62) {
        return _ref35.apply(this, arguments);
      };
    }()), queue.process('outlook-who-else-event', /*#__PURE__*/function () {
      var _ref36 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee36(job, done) {
        var _job$data23, users, totalUsers, processedUsers, reportedMailId, mailAction, companyId, domainId, i, _update2;
        return _regenerator["default"].wrap(function _callee36$(_context38) {
          while (1) switch (_context38.prev = _context38.next) {
            case 0:
              _context38.prev = 0;
              _job$data23 = job.data, users = _job$data23.mailResults, totalUsers = _job$data23.totalUsers, processedUsers = _job$data23.processedUsers, reportedMailId = _job$data23.reportedMailId, mailAction = _job$data23.mailAction, companyId = _job$data23.companyId, domainId = _job$data23.domainId;
              console.log(job.data);
              /*const bannerMeta = await db.MetaData.findOne({ companyId, name: 'BannerMessage' });
              const hasBanner = !!(bannerMeta && bannerMeta.value);
              const isBannerInjected = await db.ReportedMail.findOne({
                  _id: reportedMailId,
                  companyId,
                  isBannerInjected: true
              });*/
              i = 0;
            case 4:
              if (!(i < users.length)) {
                _context38.next = 14;
                break;
              }
              console.log("".concat(users[i].email, " - ").concat(users[i].foundInInbox ? "\x1b[32mInbox\x1b[0m" : "\x1b[31mTrash\x1b[0m", " "));
              if (!(users[i].from.toLowerCase() == users[i].email.toLowerCase())) {
                _context38.next = 9;
                break;
              }
              console.log("".concat(users[i].email, " - This the sender of email, skipping this user  ").concat(users[i].foundInInbox ? "\x1b[32mInbox\x1b[0m" : "\x1b[31mTrash\x1b[0m", " "));
              return _context38.abrupt("continue", 11);
            case 9:
              _context38.next = 11;
              return db.WhoElse.create({
                reportedMailId: users[i].reportedMailId,
                name: users[i].name,
                from: users[i].from,
                subject: users[i].subject,
                domainId: users[i].domainId,
                companyId: users[i].companyId,
                messageId: users[i].messageId,
                internetMessageId: users[i].internetMessageId,
                threadId: null,
                to: users[i].email,
                whoelseMail: users[i].email,
                userId: users[i].emailUserId,
                isTrashed: users[i].foundInTrash ? true : false,
                folderId: users[i].folderId
              });
            case 11:
              i++;
              _context38.next = 4;
              break;
            case 14:
              if (!(totalUsers == processedUsers)) {
                _context38.next = 21;
                break;
              }
              _context38.next = 17;
              return db.WhoElseMetaData.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: false,
                errorMessage: null
              });
            case 17:
              _update2 = _context38.sent;
              updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId);
              if (mailAction) (0, _mailActions.callMailActionApi)(reportedMailId, mailAction);
              console.timeEnd("total processing whoelse time ".concat(reportedMailId, "-").concat(domainId));
            case 21:
              _context38.next = 26;
              break;
            case 23:
              _context38.prev = 23;
              _context38.t0 = _context38["catch"](0);
              console.log(_context38.t0);
            case 26:
              _context38.prev = 26;
              done();
              return _context38.finish(26);
            case 29:
            case "end":
              return _context38.stop();
          }
        }, _callee36, null, [[0, 23, 26, 29]]);
      }));
      return function (_x63, _x64) {
        return _ref36.apply(this, arguments);
      };
    }()), queue.process('email-reported-who-else-gsuite', /*#__PURE__*/function () {
      var _ref37 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee38(job, done) {
        var _job$data24, email, from, subject, reportedMailId, domainId, companyId, internetMessageId, mailAction, domain, _groupsWithEmailAcces3, _yield$Credentials$ge3, fileName, groupsWithEmailAccess, users, userLength, workerPool, _loop3, i;
        return _regenerator["default"].wrap(function _callee38$(_context41) {
          while (1) switch (_context41.prev = _context41.next) {
            case 0:
              console.log(job.data);
              _job$data24 = job.data, email = _job$data24.email, from = _job$data24.from, subject = _job$data24.subject, reportedMailId = _job$data24.reportedMailId, domainId = _job$data24.domainId, companyId = _job$data24.companyId, internetMessageId = _job$data24.internetMessageId, mailAction = _job$data24.mailAction;
              _context41.prev = 2;
              _context41.next = 5;
              return db.Domain.findOne({
                _id: domainId,
                companyId: companyId,
                deletedAt: null
              });
            case 5:
              domain = _context41.sent;
              if (!domain) {
                _context41.next = 43;
                break;
              }
              if (!domain.isCredential) {
                _context41.next = 38;
                break;
              }
              _context41.next = 10;
              return _credentials["default"].getCredentials(companyId, domainId);
            case 10:
              _yield$Credentials$ge3 = _context41.sent;
              fileName = _yield$Credentials$ge3.fileName;
              _context41.next = 14;
              return db.Group.find({
                companyId: companyId,
                deletedAt: null,
                emailAccess: true
              }).select('_id');
            case 14:
              groupsWithEmailAccess = _context41.sent;
              groupsWithEmailAccess = (_groupsWithEmailAcces3 = groupsWithEmailAccess) === null || _groupsWithEmailAcces3 === void 0 ? void 0 : _groupsWithEmailAcces3.map(function (group) {
                return group._id;
              });
              _context41.next = 18;
              return db.User.find({
                domainId: domainId,
                companyId: companyId,
                isActive: true,
                groups: {
                  $in: groupsWithEmailAccess
                },
                deletedAt: null
              });
            case 18:
              users = _context41.sent;
              console.log('fount total user for whoelse', users.length);
              if (!(users.length > 0)) {
                _context41.next = 33;
                break;
              }
              userLength = users.length;
              workerPool = _workerpool["default"].get();
              console.time("total processing whoelse time ".concat(reportedMailId, "-").concat(domainId));
              _loop3 = /*#__PURE__*/_regenerator["default"].mark(function _loop3() {
                var isLast;
                return _regenerator["default"].wrap(function _loop3$(_context40) {
                  while (1) switch (_context40.prev = _context40.next) {
                    case 0:
                      isLast = i + 1 == userLength;
                      console.time("processing done whoelse ".concat(users[i]._id.toHexString(), "-").concat(domainId));
                      workerPool.whoElseGsuite({
                        index: i + 1,
                        fileName: fileName,
                        subject: subject,
                        isLast: isLast,
                        from: from,
                        reportedMailId: reportedMailId,
                        internetMessageId: internetMessageId,
                        domainId: domainId,
                        companyId: companyId,
                        to: email,
                        name: users[i].name,
                        email: users[i].email,
                        userId: users[i].userId,
                        emailUserId: users[i]._id.toHexString()
                      }).then(function (data) {
                        queue.create('gsuite-who-else-event', {
                          data: data,
                          mailAction: mailAction
                        }).removeOnComplete(true).priority('high').save();
                        console.timeEnd("processing done whoelse ".concat(data.emailUserId, "-").concat(domainId));
                      })["catch"]( /*#__PURE__*/function () {
                        var _ref38 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee37(err) {
                          return _regenerator["default"].wrap(function _callee37$(_context39) {
                            while (1) switch (_context39.prev = _context39.next) {
                              case 0:
                                if (!isLast) {
                                  _context39.next = 5;
                                  break;
                                }
                                console.log('gsuite------------', err);
                                _context39.next = 4;
                                return db.WhoElseMetaData.updateOne({
                                  reportedMailId: reportedMailId,
                                  companyId: companyId,
                                  domainId: domainId
                                }, {
                                  isProcessing: false,
                                  isCompleted: true,
                                  isError: true,
                                  errorMessage: 'Error From Workerpool'
                                });
                              case 4:
                                updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId);
                              case 5:
                              case "end":
                                return _context39.stop();
                            }
                          }, _callee37);
                        }));
                        return function (_x67) {
                          return _ref38.apply(this, arguments);
                        };
                      }());
                    case 3:
                    case "end":
                      return _context40.stop();
                  }
                }, _loop3);
              });
              i = 0;
            case 26:
              if (!(i < userLength)) {
                _context41.next = 31;
                break;
              }
              return _context41.delegateYield(_loop3(), "t0", 28);
            case 28:
              i++;
              _context41.next = 26;
              break;
            case 31:
              _context41.next = 36;
              break;
            case 33:
              _context41.next = 35;
              return db.WhoElseMetaData.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: true,
                errorMessage: "Domain Users not found"
              });
            case 35:
              updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId);
            case 36:
              _context41.next = 41;
              break;
            case 38:
              _context41.next = 40;
              return db.WhoElseMetaData.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: true,
                errorMessage: "Domain Credentials not found"
              });
            case 40:
              updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId);
            case 41:
              _context41.next = 46;
              break;
            case 43:
              _context41.next = 45;
              return db.WhoElseMetaData.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: true,
                errorMessage: "Domain not found"
              });
            case 45:
              updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId);
            case 46:
              _context41.next = 53;
              break;
            case 48:
              _context41.prev = 48;
              _context41.t1 = _context41["catch"](2);
              _context41.next = 52;
              return db.WhoElseMetaData.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: true,
                errorMessage: JSON.stringify(_context41.t1)
              });
            case 52:
              updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId);
            case 53:
              _context41.prev = 53;
              done();
              return _context41.finish(53);
            case 56:
            case "end":
              return _context41.stop();
          }
        }, _callee38, null, [[2, 48, 53, 56]]);
      }));
      return function (_x65, _x66) {
        return _ref37.apply(this, arguments);
      };
    }()), queue.process('email-reported-similiar-emails-gsuite', /*#__PURE__*/function () {
      var _ref39 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee40(job, done) {
        var _job$data25, email, from, subject, reportedMailId, domainId, companyId, internetMessageId, domain, _groupsWithEmailAcces4, _yield$Credentials$ge4, fileName, groupsWithEmailAccess, users, userLength, workerPool, _loop4, i;
        return _regenerator["default"].wrap(function _callee40$(_context44) {
          while (1) switch (_context44.prev = _context44.next) {
            case 0:
              console.log(job.data);
              _job$data25 = job.data, email = _job$data25.email, from = _job$data25.from, subject = _job$data25.subject, reportedMailId = _job$data25.reportedMailId, domainId = _job$data25.domainId, companyId = _job$data25.companyId, internetMessageId = _job$data25.internetMessageId;
              _context44.prev = 2;
              _context44.next = 5;
              return db.Domain.findOne({
                _id: domainId,
                companyId: companyId,
                deletedAt: null
              });
            case 5:
              domain = _context44.sent;
              if (!domain) {
                _context44.next = 46;
                break;
              }
              if (!domain.isCredential) {
                _context44.next = 41;
                break;
              }
              _context44.next = 10;
              return _credentials["default"].getCredentials(companyId, domainId);
            case 10:
              _yield$Credentials$ge4 = _context44.sent;
              fileName = _yield$Credentials$ge4.fileName;
              _context44.next = 14;
              return db.Group.find({
                companyId: companyId,
                deletedAt: null,
                emailAccess: true
              }).select('_id');
            case 14:
              groupsWithEmailAccess = _context44.sent;
              groupsWithEmailAccess = (_groupsWithEmailAcces4 = groupsWithEmailAccess) === null || _groupsWithEmailAcces4 === void 0 ? void 0 : _groupsWithEmailAcces4.map(function (group) {
                return group._id;
              });
              _context44.next = 18;
              return db.User.find({
                domainId: domainId,
                companyId: companyId,
                isActive: true,
                groups: {
                  $in: groupsWithEmailAccess
                },
                deletedAt: null
              });
            case 18:
              users = _context44.sent;
              console.log('fount total user for similiar emails', users.length);
              if (!(users.length > 0)) {
                _context44.next = 36;
                break;
              }
              _context44.next = 23;
              return db.ReportedMail.updateOne({
                _id: reportedMailId,
                companyId: companyId
              }, {
                syncStartAt: new Date(),
                isSimilarEmailError: false,
                isSimiliarEmailProcessing: true,
                isSimiliarEmailErrorMessage: ""
              });
            case 23:
              userLength = users.length;
              workerPool = _workerpool["default"].get();
              console.time("total processing similiar email time ".concat(reportedMailId, "-").concat(domainId));
              subject = (0, _functions.cleanDictionaryAndSpecialChars)(subject);
              _loop4 = /*#__PURE__*/_regenerator["default"].mark(function _loop4() {
                var isLast;
                return _regenerator["default"].wrap(function _loop4$(_context43) {
                  while (1) switch (_context43.prev = _context43.next) {
                    case 0:
                      isLast = i + 1 == userLength;
                      console.time("processing done similiar emails ".concat(users[i]._id.toHexString(), "-").concat(domainId));
                      workerPool.similiarSearchGsuite({
                        index: i + 1,
                        fileName: fileName,
                        subject: subject,
                        isLast: isLast,
                        from: from,
                        reportedMailId: reportedMailId,
                        internetMessageId: internetMessageId,
                        domainId: domainId,
                        companyId: companyId,
                        to: email,
                        name: users[i].name,
                        email: users[i].email,
                        userId: users[i].userId,
                        emailUserId: users[i]._id.toHexString()
                      }).then(function (data) {
                        console.log({
                          data: data
                        });
                        queue.create('gsuite-similiar-emails-event', {
                          data: data
                        }).removeOnComplete(true).priority('high').save();
                        console.timeEnd("processing done similiar emails ".concat(data.emailUserId, "-").concat(domainId));
                      })["catch"]( /*#__PURE__*/function () {
                        var _ref40 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee39(err) {
                          return _regenerator["default"].wrap(function _callee39$(_context42) {
                            while (1) switch (_context42.prev = _context42.next) {
                              case 0:
                                if (!isLast) {
                                  _context42.next = 5;
                                  break;
                                }
                                console.log('gsuite------------', err);
                                _context42.next = 4;
                                return db.SimiliarEmailMetdata.updateOne({
                                  reportedMailId: reportedMailId,
                                  companyId: companyId,
                                  domainId: domainId
                                }, {
                                  isProcessing: false,
                                  isCompleted: true,
                                  isError: true,
                                  errorMessage: 'Error From Workerpool'
                                });
                              case 4:
                                updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
                              case 5:
                              case "end":
                                return _context42.stop();
                            }
                          }, _callee39);
                        }));
                        return function (_x70) {
                          return _ref40.apply(this, arguments);
                        };
                      }());
                    case 3:
                    case "end":
                      return _context43.stop();
                  }
                }, _loop4);
              });
              i = 0;
            case 29:
              if (!(i < userLength)) {
                _context44.next = 34;
                break;
              }
              return _context44.delegateYield(_loop4(), "t0", 31);
            case 31:
              i++;
              _context44.next = 29;
              break;
            case 34:
              _context44.next = 39;
              break;
            case 36:
              _context44.next = 38;
              return db.SimiliarEmailMetdata.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: true,
                errorMessage: "Domain Users not found"
              });
            case 38:
              updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
            case 39:
              _context44.next = 44;
              break;
            case 41:
              _context44.next = 43;
              return db.SimiliarEmailMetdata.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: true,
                errorMessage: "Domain Credentials not found"
              });
            case 43:
              updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
            case 44:
              _context44.next = 49;
              break;
            case 46:
              _context44.next = 48;
              return db.SimiliarEmailMetdata.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: true,
                errorMessage: "Domain not found"
              });
            case 48:
              updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
            case 49:
              _context44.next = 56;
              break;
            case 51:
              _context44.prev = 51;
              _context44.t1 = _context44["catch"](2);
              _context44.next = 55;
              return db.SimiliarEmailMetdata.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: true,
                errorMessage: JSON.stringify(_context44.t1)
              });
            case 55:
              updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
            case 56:
              _context44.prev = 56;
              done();
              return _context44.finish(56);
            case 59:
            case "end":
              return _context44.stop();
          }
        }, _callee40, null, [[2, 51, 56, 59]]);
      }));
      return function (_x68, _x69) {
        return _ref39.apply(this, arguments);
      };
    }()), queue.process('gsuite-similiar-emails-event', /*#__PURE__*/function () {
      var _ref41 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee41(job, done) {
        var _job$data$data, name, from, subject, reportedMailId, companyId, domainId, emailUserId, email, isLast, isMailFound, internetMessageId, threadId, messageId;
        return _regenerator["default"].wrap(function _callee41$(_context45) {
          while (1) switch (_context45.prev = _context45.next) {
            case 0:
              _job$data$data = job.data.data, name = _job$data$data.name, from = _job$data$data.from, subject = _job$data$data.subject, reportedMailId = _job$data$data.reportedMailId, companyId = _job$data$data.companyId, domainId = _job$data$data.domainId, emailUserId = _job$data$data.emailUserId, email = _job$data$data.email, isLast = _job$data$data.isLast, isMailFound = _job$data$data.isMailFound, internetMessageId = _job$data$data.internetMessageId;
              _context45.prev = 1;
              if (!isMailFound) {
                _context45.next = 7;
                break;
              }
              threadId = isMailFound.threadId;
              messageId = isMailFound.messageId;
              _context45.next = 7;
              return db.SimiliarEmail.create({
                reportedMailId: reportedMailId,
                from: from,
                subject: isMailFound.subject,
                domainId: domainId,
                companyId: companyId,
                messageId: messageId,
                threadId: threadId,
                internetMessageId: internetMessageId,
                name: name,
                to: email,
                whoelseMail: email,
                userId: emailUserId,
                isTrashed: isMailFound.isTrashed
              });
            case 7:
              if (!isLast) {
                _context45.next = 12;
                break;
              }
              _context45.next = 10;
              return db.SimiliarEmailMetdata.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: false,
                errorMessage: null
              });
            case 10:
              updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
              console.timeEnd("total processing similiar email time ".concat(reportedMailId, "-").concat(domainId));
            case 12:
              _context45.next = 20;
              break;
            case 14:
              _context45.prev = 14;
              _context45.t0 = _context45["catch"](1);
              _context45.next = 18;
              return db.SimiliarEmailMetdata.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: true,
                errorMessage: "gsuite-similiar-emails-event"
              });
            case 18:
              updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
              console.log(_context45.t0);
            case 20:
              _context45.prev = 20;
              done();
              return _context45.finish(20);
            case 23:
            case "end":
              return _context45.stop();
          }
        }, _callee41, null, [[1, 14, 20, 23]]);
      }));
      return function (_x71, _x72) {
        return _ref41.apply(this, arguments);
      };
    }()), queue.process('gsuite-who-else-event', /*#__PURE__*/function () {
      var _ref42 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee42(job, done) {
        var _job$data$data2, to, name, from, subject, reportedMailId, companyId, domainId, emailUserId, email, isLast, isMailFound, foundInTrash, internetMessageId, mailAction, threadId, messageId;
        return _regenerator["default"].wrap(function _callee42$(_context46) {
          while (1) switch (_context46.prev = _context46.next) {
            case 0:
              _context46.prev = 0;
              _job$data$data2 = job.data.data, to = _job$data$data2.to, name = _job$data$data2.name, from = _job$data$data2.from, subject = _job$data$data2.subject, reportedMailId = _job$data$data2.reportedMailId, companyId = _job$data$data2.companyId, domainId = _job$data$data2.domainId, emailUserId = _job$data$data2.emailUserId, email = _job$data$data2.email, isLast = _job$data$data2.isLast, isMailFound = _job$data$data2.isMailFound, foundInTrash = _job$data$data2.foundInTrash, internetMessageId = _job$data$data2.internetMessageId;
              mailAction = job.data.mailAction;
              if (!isMailFound) {
                _context46.next = 8;
                break;
              }
              threadId = isMailFound.threadId;
              messageId = isMailFound.messageId;
              _context46.next = 8;
              return db.WhoElse.create({
                reportedMailId: reportedMailId,
                from: from,
                subject: subject,
                domainId: domainId,
                companyId: companyId,
                messageId: messageId,
                threadId: threadId,
                internetMessageId: internetMessageId,
                name: name,
                to: email,
                whoelseMail: email,
                userId: emailUserId,
                isTrashed: isMailFound.isTrashed
              });
            case 8:
              if (!isLast) {
                _context46.next = 14;
                break;
              }
              _context46.next = 11;
              return db.WhoElseMetaData.updateOne({
                reportedMailId: reportedMailId,
                companyId: companyId,
                domainId: domainId
              }, {
                isProcessing: false,
                isCompleted: true,
                isError: false,
                errorMessage: null
              });
            case 11:
              updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId);
              if (mailAction) (0, _mailActions.callMailActionApi)(reportedMailId, mailAction);
              console.timeEnd("total processing whoelse time ".concat(reportedMailId, "-").concat(domainId));
            case 14:
              _context46.next = 19;
              break;
            case 16:
              _context46.prev = 16;
              _context46.t0 = _context46["catch"](0);
              console.log(_context46.t0);
            case 19:
              _context46.prev = 19;
              done();
              return _context46.finish(19);
            case 22:
            case "end":
              return _context46.stop();
          }
        }, _callee42, null, [[0, 16, 19, 22]]);
      }));
      return function (_x73, _x74) {
        return _ref42.apply(this, arguments);
      };
    }()), queue.process('process-advanced-search-outlook', /*#__PURE__*/function () {
      var _ref43 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee43(job, done) {
        var _job$data26, companyId, domainId, from, to, subject, fromDate, toDate, advanceSearchId, filter, _yield$Credentials$ge5, token, condition, users, userLength, workerPool, i, isLast, emailUserId;
        return _regenerator["default"].wrap(function _callee43$(_context47) {
          while (1) switch (_context47.prev = _context47.next) {
            case 0:
              _job$data26 = job.data, companyId = _job$data26.companyId, domainId = _job$data26.domainId, from = _job$data26.from, to = _job$data26.to, subject = _job$data26.subject, fromDate = _job$data26.fromDate, toDate = _job$data26.toDate, advanceSearchId = _job$data26.advanceSearchId, filter = _job$data26.filter;
              _context47.prev = 1;
              _context47.next = 4;
              return _credentials["default"].getCredentials(companyId, domainId);
            case 4:
              _yield$Credentials$ge5 = _context47.sent;
              token = _yield$Credentials$ge5.token;
              condition = {
                domainId: domainId,
                companyId: companyId,
                isActive: true,
                deletedAt: null
              };
              if (to && to.length) {
                condition['email'] = to;
              }
              _context47.next = 10;
              return db.User.find(condition);
            case 10:
              users = _context47.sent;
              if (!(users.length > 0)) {
                _context47.next = 18;
                break;
              }
              userLength = users.length;
              workerPool = _workerpool["default"].get();
              console.time("total processing advance search time");
              for (i = 0; i < userLength; i++) {
                isLast = i + 1 == userLength;
                console.time("processing done advance search ".concat(i + 1));
                emailUserId = users[i]._id.toHexString();
                workerPool.advancedSearchOutlook({
                  index: i + 1,
                  token: token.access_token,
                  subject: subject,
                  isLast: isLast,
                  from: from,
                  to: users[i].email,
                  advanceSearchId: advanceSearchId,
                  companyId: companyId,
                  fromDate: fromDate,
                  toDate: toDate,
                  filter: filter,
                  domainId: domainId,
                  emailUserId: emailUserId,
                  userId: users[i].userId
                }).then(function (data) {
                  queue.create('process-advanced-search-event-outlook', data).removeOnComplete(true).priority('high').save();
                  console.timeEnd("processing done advance search ".concat(data.index));
                })["catch"](function (err) {
                  console.log(err);
                });
              }
              _context47.next = 20;
              break;
            case 18:
              _context47.next = 20;
              return db.AdvanceSearch.updateOne({
                _id: advanceSearchId,
                companyId: companyId
              }, {
                isError: true,
                isProcessing: false,
                syncEndAt: new Date(),
                isErrorMessage: "Domain Users not found"
              });
            case 20:
              _context47.next = 27;
              break;
            case 22:
              _context47.prev = 22;
              _context47.t0 = _context47["catch"](1);
              console.log(_context47.t0);
              _context47.next = 27;
              return db.AdvanceSearch.updateOne({
                _id: advanceSearchId,
                companyId: companyId
              }, {
                isError: true,
                isProcessing: false,
                syncEndAt: new Date(),
                isErrorMessage: _context47.t0
              });
            case 27:
              _context47.prev = 27;
              done();
              return _context47.finish(27);
            case 30:
            case "end":
              return _context47.stop();
          }
        }, _callee43, null, [[1, 22, 27, 30]]);
      }));
      return function (_x75, _x76) {
        return _ref43.apply(this, arguments);
      };
    }());
    queue.process('process-advanced-search-event-outlook', /*#__PURE__*/function () {
      var _ref44 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee44(job, done) {
        var _job$data27, isMailFound, foundInTrash, advanceSearchId, emailUserId, companyId, domainId, isLast, to, data, i;
        return _regenerator["default"].wrap(function _callee44$(_context48) {
          while (1) switch (_context48.prev = _context48.next) {
            case 0:
              _context48.prev = 0;
              _job$data27 = job.data, isMailFound = _job$data27.isMailFound, foundInTrash = _job$data27.foundInTrash, advanceSearchId = _job$data27.advanceSearchId, emailUserId = _job$data27.emailUserId, companyId = _job$data27.companyId, domainId = _job$data27.domainId, isLast = _job$data27.isLast, to = _job$data27.to;
              if (!isMailFound) {
                _context48.next = 7;
                break;
              }
              data = [];
              for (i = 0; i < isMailFound.length; i++) {
                data.push({
                  userId: emailUserId,
                  from: isMailFound[i].from.emailAddress.address,
                  fromName: isMailFound[i].from.emailAddress.name,
                  isTrashed: foundInTrash,
                  messageId: isMailFound[i].id,
                  subject: isMailFound[i].subject,
                  body: isMailFound[i].body.content,
                  to: to,
                  cc: isMailFound[i].ccRecipients,
                  advanceSearchId: advanceSearchId,
                  companyId: companyId,
                  domainId: domainId,
                  mailRecievedTime: isMailFound[i].receivedDateTime
                });
              }
              _context48.next = 7;
              return db.AdvanceSearchEmail.insertMany(data);
            case 7:
              if (!isLast) {
                _context48.next = 11;
                break;
              }
              console.timeEnd("total processing advance search time");
              _context48.next = 11;
              return db.AdvanceSearch.updateOne({
                _id: advanceSearchId,
                companyId: companyId
              }, {
                isError: false,
                isProcessing: false,
                syncEndAt: new Date(),
                isErrorMessage: ""
              });
            case 11:
              _context48.next = 16;
              break;
            case 13:
              _context48.prev = 13;
              _context48.t0 = _context48["catch"](0);
              console.log(_context48.t0);
            case 16:
              _context48.prev = 16;
              done();
              return _context48.finish(16);
            case 19:
            case "end":
              return _context48.stop();
          }
        }, _callee44, null, [[0, 13, 16, 19]]);
      }));
      return function (_x77, _x78) {
        return _ref44.apply(this, arguments);
      };
    }());
    queue.process('process-advanced-search-gsuite', /*#__PURE__*/function () {
      var _ref45 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee45(job, done) {
        var _job$data28, companyId, domainId, from, to, subject, fromDate, toDate, advanceSearchId, filter, _yield$Credentials$ge6, fileName, condition, users, userLength, workerPool, i, isLast, emailUserId;
        return _regenerator["default"].wrap(function _callee45$(_context49) {
          while (1) switch (_context49.prev = _context49.next) {
            case 0:
              _job$data28 = job.data, companyId = _job$data28.companyId, domainId = _job$data28.domainId, from = _job$data28.from, to = _job$data28.to, subject = _job$data28.subject, fromDate = _job$data28.fromDate, toDate = _job$data28.toDate, advanceSearchId = _job$data28.advanceSearchId, filter = _job$data28.filter;
              _context49.prev = 1;
              _context49.next = 4;
              return _credentials["default"].getCredentials(companyId, domainId);
            case 4:
              _yield$Credentials$ge6 = _context49.sent;
              fileName = _yield$Credentials$ge6.fileName;
              condition = {
                domainId: domainId,
                companyId: companyId,
                isActive: true,
                deletedAt: null
              };
              if (to && to.length) {
                condition['email'] = to;
              }
              _context49.next = 10;
              return db.User.find(condition);
            case 10:
              users = _context49.sent;
              if (!(users.length > 0)) {
                _context49.next = 18;
                break;
              }
              userLength = users.length;
              workerPool = _workerpool["default"].get();
              console.time("total processing advance search time ".concat(advanceSearchId));
              for (i = 0; i < userLength; i++) {
                isLast = i + 1 == userLength;
                console.time("processing done advance search ".concat(i + 1));
                emailUserId = users[i]._id.toHexString();
                workerPool.advancedSearchGsuite({
                  index: i + 1,
                  fileName: fileName,
                  subject: subject,
                  isLast: isLast,
                  from: from,
                  to: users[i].email,
                  advanceSearchId: advanceSearchId,
                  companyId: companyId,
                  fromDate: fromDate,
                  toDate: toDate,
                  filter: filter,
                  domainId: domainId,
                  emailUserId: emailUserId,
                  userId: users[i].userId
                }).then(function (data) {
                  queue.create('process-advanced-search-event-gsuite', data).removeOnComplete(true).priority('high').save();
                  console.timeEnd("processing done advance search ".concat(data.index));
                })["catch"](function (err) {
                  console.log(err);
                });
              }
              _context49.next = 20;
              break;
            case 18:
              _context49.next = 20;
              return db.AdvanceSearch.updateOne({
                _id: advanceSearchId,
                companyId: companyId
              }, {
                isError: true,
                isProcessing: false,
                syncEndAt: new Date(),
                isErrorMessage: "Domain Users not found"
              });
            case 20:
              _context49.next = 27;
              break;
            case 22:
              _context49.prev = 22;
              _context49.t0 = _context49["catch"](1);
              console.log(_context49.t0);
              _context49.next = 27;
              return db.AdvanceSearch.updateOne({
                _id: advanceSearchId,
                companyId: companyId
              }, {
                isError: true,
                isProcessing: false,
                syncEndAt: new Date(),
                isErrorMessage: _context49.t0
              });
            case 27:
              _context49.prev = 27;
              done();
              return _context49.finish(27);
            case 30:
            case "end":
              return _context49.stop();
          }
        }, _callee45, null, [[1, 22, 27, 30]]);
      }));
      return function (_x79, _x80) {
        return _ref45.apply(this, arguments);
      };
    }());
    queue.process('process-advanced-search-event-gsuite', /*#__PURE__*/function () {
      var _ref46 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee46(job, done) {
        var _job$data29, isMailFound, advanceSearchId, emailUserId, companyId, domainId, isLast, data, i;
        return _regenerator["default"].wrap(function _callee46$(_context50) {
          while (1) switch (_context50.prev = _context50.next) {
            case 0:
              _context50.prev = 0;
              _job$data29 = job.data, isMailFound = _job$data29.isMailFound, advanceSearchId = _job$data29.advanceSearchId, emailUserId = _job$data29.emailUserId, companyId = _job$data29.companyId, domainId = _job$data29.domainId, isLast = _job$data29.isLast;
              if (!(isMailFound && isMailFound.length)) {
                _context50.next = 7;
                break;
              }
              data = [];
              for (i = 0; i < isMailFound.length; i++) {
                data.push({
                  userId: emailUserId,
                  from: isMailFound[i].from,
                  fromName: '',
                  messageId: isMailFound[i].messageId,
                  threadId: isMailFound[i].threadId,
                  subject: isMailFound[i].subject,
                  body: isMailFound[i].body,
                  to: isMailFound[i].to,
                  cc: isMailFound[i].cc,
                  advanceSearchId: advanceSearchId,
                  companyId: companyId,
                  domainId: domainId,
                  mailRecievedTime: isMailFound[i].date
                });
              }
              _context50.next = 7;
              return db.AdvanceSearchEmail.insertMany(data);
            case 7:
              if (!isLast) {
                _context50.next = 11;
                break;
              }
              console.timeEnd("total processing advance search time ".concat(advanceSearchId));
              _context50.next = 11;
              return db.AdvanceSearch.updateOne({
                _id: advanceSearchId,
                companyId: companyId
              }, {
                isError: false,
                isProcessing: false,
                syncEndAt: new Date(),
                isErrorMessage: ""
              });
            case 11:
              _context50.next = 16;
              break;
            case 13:
              _context50.prev = 13;
              _context50.t0 = _context50["catch"](0);
              console.log(_context50.t0);
            case 16:
              _context50.prev = 16;
              done();
              return _context50.finish(16);
            case 19:
            case "end":
              return _context50.stop();
          }
        }, _callee46, null, [[0, 13, 16, 19]]);
      }));
      return function (_x81, _x82) {
        return _ref46.apply(this, arguments);
      };
    }());
    queue.process('url-report', /*#__PURE__*/function () {
      var _ref47 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee47(job, done) {
        var _job$data30, data, urlId, companyId, scan_id, apikey;
        return _regenerator["default"].wrap(function _callee47$(_context51) {
          while (1) switch (_context51.prev = _context51.next) {
            case 0:
              console.log('processing url result.....');
              _job$data30 = job.data, data = _job$data30.data, urlId = _job$data30.urlId, companyId = _job$data30.companyId;
              _context51.prev = 2;
              scan_id = data.scan_id;
              _context51.next = 6;
              return _getVirusTotalkey["default"].getApiKey(companyId);
            case 6:
              apikey = _context51.sent;
              _resultUrlTotalvirus["default"].processScanResult({
                apikey: apikey,
                scan_id: scan_id
              }).then(function (data) {
                console.log(data);
                return db.Url.updateOne({
                  _id: urlId
                }, {
                  status: 'COMPLETED',
                  result: JSON.stringify(data),
                  score: data.positives / data.total * 100
                });
              }).then(function (r) {
                console.log('done url result.....');
              })["catch"](function (err) {
                console.log(err);
                return db.Url.updateOne({
                  _id: urlId
                }, {
                  status: 'FAILED',
                  details: err
                });
              });
              _context51.next = 14;
              break;
            case 10:
              _context51.prev = 10;
              _context51.t0 = _context51["catch"](2);
              console.log(_context51.t0);
              return _context51.abrupt("return", db.Url.updateOne({
                _id: urlId
              }, {
                status: 'FAILED',
                details: _context51.t0
              }));
            case 14:
              _context51.prev = 14;
              done();
              return _context51.finish(14);
            case 17:
            case "end":
              return _context51.stop();
          }
        }, _callee47, null, [[2, 10, 14, 17]]);
      }));
      return function (_x83, _x84) {
        return _ref47.apply(this, arguments);
      };
    }());
    queue.process('url-wa-report', /*#__PURE__*/function () {
      var _ref48 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee48(job, done) {
        var _job$data31, data, urlId, companyId, scan_id, apikey;
        return _regenerator["default"].wrap(function _callee48$(_context52) {
          while (1) switch (_context52.prev = _context52.next) {
            case 0:
              console.log('processing url result.....');
              _job$data31 = job.data, data = _job$data31.data, urlId = _job$data31.urlId, companyId = _job$data31.companyId;
              _context52.prev = 2;
              scan_id = data.scan_id;
              _context52.next = 6;
              return _getVirusTotalkey["default"].getApiKey(companyId);
            case 6:
              apikey = _context52.sent;
              _resultUrlTotalvirus["default"].processScanResult({
                apikey: apikey,
                scan_id: scan_id
              }).then(function (data) {
                console.log(data);
                return db.Url.updateOne({
                  _id: urlId
                }, {
                  status: 'COMPLETED',
                  result: JSON.stringify(data),
                  score: data.positives / data.total * 100
                });
              }).then(function (r) {
                console.log('done url result.....');
              })["catch"](function (err) {
                console.log(err);
                return db.Url.updateOne({
                  _id: urlId
                }, {
                  status: 'FAILED',
                  details: err
                });
              });
              _context52.next = 14;
              break;
            case 10:
              _context52.prev = 10;
              _context52.t0 = _context52["catch"](2);
              console.log(_context52.t0);
              return _context52.abrupt("return", db.Url.updateOne({
                _id: urlId
              }, {
                status: 'FAILED',
                details: _context52.t0
              }));
            case 14:
              _context52.prev = 14;
              done();
              return _context52.finish(14);
            case 17:
            case "end":
              return _context52.stop();
          }
        }, _callee48, null, [[2, 10, 14, 17]]);
      }));
      return function (_x85, _x86) {
        return _ref48.apply(this, arguments);
      };
    }());

    // queue.process('attachment-report', async (job, done) => {
    //     console.log('processing attachment result.....');
    //     const { data, attachmentId, companyId } = job.data;
    //     try{
    //         const { scan_id } = data;
    //         const apikey = await totalvirus.getApiKey(companyId);
    //         scanResultAttachment.processScanResult({
    //             apikey: apikey,
    //             scan_id: scan_id
    //         })
    //         .then(data => {
    //             console.log('Attachment report results',data)
    //             return db.Attachment.updateOne({
    //                 _id: attachmentId,
    //             }, {
    //                 status: 'COMPLETED',
    //                 result: data
    //             })
    //         })
    //         .then(r => {
    //             done();
    //             console.log('done attachment result.....');
    //         })
    //         .catch(err => {
    //             console.log(err);
    //             return db.Attachment.updateOne({
    //                 _id: attachmentId,
    //             }, {
    //                 status: 'FAILED',
    //                 details: JSON.stringify(err)
    //             })
    //         })
    //     } catch(err){
    //         return db.Attachment.updateOne({
    //             _id: attachmentId,
    //         }, {
    //             status: 'FAILED',
    //             details: JSON.stringify(err)
    //         })
    //     } finally {
    //         done();
    //     }
    // })

    queue.process('attachment-report', /*#__PURE__*/function () {
      var _ref49 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee51(job, done) {
        var _job$data32, data, attachmentId, companyId, scan_id, apikey;
        return _regenerator["default"].wrap(function _callee51$(_context55) {
          while (1) switch (_context55.prev = _context55.next) {
            case 0:
              console.log('processing attachment result.....');
              _job$data32 = job.data, data = _job$data32.data, attachmentId = _job$data32.attachmentId, companyId = _job$data32.companyId;
              console.log('job.data', job.data);
              _context55.prev = 3;
              scan_id = data.scan_id;
              _context55.next = 7;
              return _getVirusTotalkey["default"].getApiKey(companyId);
            case 7:
              apikey = _context55.sent;
              _resultAttachmentTotalvirus["default"].processScanResult({
                apikey: apikey,
                scan_id: scan_id
              }).then( /*#__PURE__*/function () {
                var _ref50 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee49(data) {
                  return _regenerator["default"].wrap(function _callee49$(_context53) {
                    while (1) switch (_context53.prev = _context53.next) {
                      case 0:
                        console.log('Attachment report results', data);
                        if (!(data.response_code == 1 && data.scans)) {
                          _context53.next = 7;
                          break;
                        }
                        _context53.next = 4;
                        return db.Attachment.updateOne({
                          _id: attachmentId
                        }, {
                          status: 'COMPLETED',
                          result: data,
                          score: data.positives / data.total * 100
                        });
                      case 4:
                        done();
                        _context53.next = 8;
                        break;
                      case 7:
                        return _context53.abrupt("return", done(new Error('ReAttempting')));
                      case 8:
                      case "end":
                        return _context53.stop();
                    }
                  }, _callee49);
                }));
                return function (_x89) {
                  return _ref50.apply(this, arguments);
                };
              }())["catch"]( /*#__PURE__*/function () {
                var _ref51 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee50(err) {
                  return _regenerator["default"].wrap(function _callee50$(_context54) {
                    while (1) switch (_context54.prev = _context54.next) {
                      case 0:
                        _context54.next = 2;
                        return db.Attachment.updateOne({
                          _id: attachmentId
                        }, {
                          status: 'IN PROGRESS',
                          details: JSON.stringify(err)
                        });
                      case 2:
                        return _context54.abrupt("return", done(new Error('ReAttempting')));
                      case 3:
                      case "end":
                        return _context54.stop();
                    }
                  }, _callee50);
                }));
                return function (_x90) {
                  return _ref51.apply(this, arguments);
                };
              }());
              _context55.next = 16;
              break;
            case 11:
              _context55.prev = 11;
              _context55.t0 = _context55["catch"](3);
              _context55.next = 15;
              return db.Attachment.updateOne({
                _id: attachmentId
              }, {
                status: 'FAILED',
                details: JSON.stringify(_context55.t0)
              });
            case 15:
              done();
            case 16:
            case "end":
              return _context55.stop();
          }
        }, _callee51, null, [[3, 11]]);
      }));
      return function (_x87, _x88) {
        return _ref49.apply(this, arguments);
      };
    }());
    queue.process('report-email-score', /*#__PURE__*/function () {
      var _ref52 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee52(job, done) {
        var _job$data33, reportedMailId, spamScore;
        return _regenerator["default"].wrap(function _callee52$(_context56) {
          while (1) switch (_context56.prev = _context56.next) {
            case 0:
              _context56.prev = 0;
              _job$data33 = job.data, reportedMailId = _job$data33.reportedMailId, spamScore = _job$data33.spamScore;
              _context56.next = 4;
              return db.ReportedMail.updateOne({
                _id: reportedMailId
              }, {
                $set: {
                  spamScore: spamScore
                }
              });
            case 4:
              _context56.next = 9;
              break;
            case 6:
              _context56.prev = 6;
              _context56.t0 = _context56["catch"](0);
              console.log(_context56.t0);
            case 9:
              _context56.prev = 9;
              done();
              return _context56.finish(9);
            case 12:
            case "end":
              return _context56.stop();
          }
        }, _callee52, null, [[0, 6, 9, 12]]);
      }));
      return function (_x91, _x92) {
        return _ref52.apply(this, arguments);
      };
    }());
    queue.process('report-email-score-exchange', /*#__PURE__*/function () {
      var _ref53 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee53(job, done) {
        var _job$data34, reportedMailId, spamScore;
        return _regenerator["default"].wrap(function _callee53$(_context57) {
          while (1) switch (_context57.prev = _context57.next) {
            case 0:
              _context57.prev = 0;
              _job$data34 = job.data, reportedMailId = _job$data34.reportedMailId, spamScore = _job$data34.spamScore; // console.time(`spamassession-${reportedMailId}`)
              // new Promise((resolve, reject) => {
              //     spamc.headers(headers, function (err, result) {
              //         if(err) reject(err);
              //         else resolve(result);
              //     })
              // })
              // .then( result => {
              //     console.timeEnd(`spamassession-${reportedMailId}`)
              return _context57.abrupt("return", db.ReportedMail.updateOne({
                _id: reportedMailId
              }, {
                spamScore: spamScore
              }));
            case 5:
              _context57.prev = 5;
              _context57.t0 = _context57["catch"](0);
              console.log(_context57.t0);
            case 8:
              _context57.prev = 8;
              done();
              return _context57.finish(8);
            case 11:
            case "end":
              return _context57.stop();
          }
        }, _callee53, null, [[0, 5, 8, 11]]);
      }));
      return function (_x93, _x94) {
        return _ref53.apply(this, arguments);
      };
    }());
    queue.process('process-who-else-trash-batches-outlook', /*#__PURE__*/function () {
      var _ref54 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee57(job, done) {
        var _job$data35, responses, emailReported, Trash, Recover, Delete, companyId, updates, _updates, _updates2;
        return _regenerator["default"].wrap(function _callee57$(_context61) {
          while (1) switch (_context61.prev = _context61.next) {
            case 0:
              _context61.prev = 0;
              _job$data35 = job.data, responses = _job$data35.responses, emailReported = _job$data35.emailReported, Trash = _job$data35.Trash, Recover = _job$data35.Recover, Delete = _job$data35.Delete, companyId = _job$data35.companyId;
              if (!Trash) {
                _context61.next = 8;
                break;
              }
              updates = responses.map( /*#__PURE__*/function () {
                var _ref55 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee54(response) {
                  var trash, isReporter;
                  return _regenerator["default"].wrap(function _callee54$(_context58) {
                    while (1) switch (_context58.prev = _context58.next) {
                      case 0:
                        _context58.prev = 0;
                        if (!(response.status >= 200 && response.status < 300)) {
                          _context58.next = 10;
                          break;
                        }
                        _context58.next = 4;
                        return db.WhoElse.findByIdAndUpdate(response.id, {
                          isTrashed: true,
                          messageId: response.body.id
                        });
                      case 4:
                        trash = _context58.sent;
                        console.log("\x1B[31mTrashed:\x1B[0m ".concat(trash.to));
                        isReporter = emailReported === null || emailReported === void 0 ? void 0 : emailReported.reporters.find(function (reporter) {
                          return reporter.email.toLowerCase() === trash.to.toLowerCase();
                        });
                        if (emailReported.to.toLowerCase() !== trash.to.toLowerCase() && !isReporter) _mailer["default"].sendResultMailToOtherReporters(trash.name, trash.to, trash.from, trash.subject, emailReported.mailRecievedTime, 'Trashed', companyId);else _mailer["default"].sendActionResultMail(trash.name, trash.to, trash.from, trash.subject, emailReported.mailRecievedTime, 'TRASHED', false, null, companyId);
                        _context58.next = 13;
                        break;
                      case 10:
                        console.log("Error Trashing Mail for ".concat(response.id));
                        _context58.next = 13;
                        return db.WhoElse.findByIdAndUpdate(response.id, {
                          isErrorWhileMoving: {
                            isError: true,
                            message: JSON.stringify(response.body)
                          }
                        });
                      case 13:
                        _context58.next = 18;
                        break;
                      case 15:
                        _context58.prev = 15;
                        _context58.t0 = _context58["catch"](0);
                        console.log("Error from record ".concat(response.id, " while trashing"), _context58.t0);
                      case 18:
                      case "end":
                        return _context58.stop();
                    }
                  }, _callee54, null, [[0, 15]]);
                }));
                return function (_x97) {
                  return _ref55.apply(this, arguments);
                };
              }());
              _context61.next = 6;
              return Promise.all(updates);
            case 6:
              _context61.next = 18;
              break;
            case 8:
              if (!Recover) {
                _context61.next = 14;
                break;
              }
              _updates = responses.map( /*#__PURE__*/function () {
                var _ref56 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee55(response) {
                  var recover, isReporter;
                  return _regenerator["default"].wrap(function _callee55$(_context59) {
                    while (1) switch (_context59.prev = _context59.next) {
                      case 0:
                        _context59.prev = 0;
                        if (!(response.status >= 200 && response.status < 300)) {
                          _context59.next = 10;
                          break;
                        }
                        _context59.next = 4;
                        return db.WhoElse.findByIdAndUpdate(response.id, {
                          isTrashed: false,
                          messageId: response.body.id
                        });
                      case 4:
                        recover = _context59.sent;
                        console.log("\x1B[32mRecovered:\x1B[0m ".concat(recover.to));
                        isReporter = emailReported === null || emailReported === void 0 ? void 0 : emailReported.reporters.find(function (reporter) {
                          return reporter.email.toLowerCase() === recover.to.toLowerCase();
                        });
                        if (emailReported.to.toLowerCase() !== recover.to.toLowerCase() && !isReporter) _mailer["default"].sendResultMailToOtherReporters(recover.name, recover.to, recover.from, recover.subject, emailReported.mailRecievedTime, 'Recovered', companyId);else _mailer["default"].sendActionResultMail(recover.name, recover.to, recover.from, recover.subject, emailReported.mailRecievedTime, 'RECOVERED', false, null, companyId);
                        _context59.next = 13;
                        break;
                      case 10:
                        console.log("Error Recovering Mail for ".concat(response.id));
                        _context59.next = 13;
                        return db.WhoElse.findByIdAndUpdate(response.id, {
                          isErrorWhileMoving: {
                            isError: true,
                            message: JSON.stringify(response.body)
                          }
                        });
                      case 13:
                        _context59.next = 18;
                        break;
                      case 15:
                        _context59.prev = 15;
                        _context59.t0 = _context59["catch"](0);
                        console.log("Error from record ".concat(response.id, " while recovering"), _context59.t0);
                      case 18:
                      case "end":
                        return _context59.stop();
                    }
                  }, _callee55, null, [[0, 15]]);
                }));
                return function (_x98) {
                  return _ref56.apply(this, arguments);
                };
              }());
              _context61.next = 12;
              return Promise.all(_updates);
            case 12:
              _context61.next = 18;
              break;
            case 14:
              if (!Delete) {
                _context61.next = 18;
                break;
              }
              _updates2 = responses.map( /*#__PURE__*/function () {
                var _ref57 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee56(response) {
                  var deleteRecord, isReporter;
                  return _regenerator["default"].wrap(function _callee56$(_context60) {
                    while (1) switch (_context60.prev = _context60.next) {
                      case 0:
                        _context60.prev = 0;
                        if (!(response.status >= 200 && response.status < 300)) {
                          _context60.next = 10;
                          break;
                        }
                        _context60.next = 4;
                        return db.WhoElse.findByIdAndUpdate(response.id, {
                          isDeleted: true
                        });
                      case 4:
                        deleteRecord = _context60.sent;
                        console.log("\x1B[31mDeleted:\x1B[0m ".concat(deleteRecord.to));
                        isReporter = emailReported === null || emailReported === void 0 ? void 0 : emailReported.reporters.find(function (reporter) {
                          return reporter.email.toLowerCase() === deleteRecord.to.toLowerCase();
                        });
                        if (emailReported.to.toLowerCase() !== deleteRecord.to.toLowerCase() && !isReporter) _mailer["default"].sendResultMailToOtherReporters(deleteRecord.name, deleteRecord.to, deleteRecord.from, deleteRecord.subject, emailReported.mailRecievedTime, 'Deleted', companyId);else _mailer["default"].sendActionResultMail(deleteRecord.name, deleteRecord.to, deleteRecord.from, deleteRecord.subject, emailReported.mailRecievedTime, 'DELETED', false, null, companyId);
                        _context60.next = 13;
                        break;
                      case 10:
                        console.log("Error Deleting Mail for ".concat(response.id));
                        _context60.next = 13;
                        return db.WhoElse.findByIdAndUpdate(response.id, {
                          isErrorWhileMoving: {
                            isError: true,
                            message: JSON.stringify(response.body)
                          }
                        });
                      case 13:
                        _context60.next = 18;
                        break;
                      case 15:
                        _context60.prev = 15;
                        _context60.t0 = _context60["catch"](0);
                        console.log("Error from record ".concat(response.id, " while deleting"), _context60.t0);
                      case 18:
                      case "end":
                        return _context60.stop();
                    }
                  }, _callee56, null, [[0, 15]]);
                }));
                return function (_x99) {
                  return _ref57.apply(this, arguments);
                };
              }());
              _context61.next = 18;
              return Promise.all(_updates2);
            case 18:
              _context61.next = 23;
              break;
            case 20:
              _context61.prev = 20;
              _context61.t0 = _context61["catch"](0);
              console.log(_context61.t0);
            case 23:
              _context61.prev = 23;
              done();
              return _context61.finish(23);
            case 26:
            case "end":
              return _context61.stop();
          }
        }, _callee57, null, [[0, 20, 23, 26]]);
      }));
      return function (_x95, _x96) {
        return _ref54.apply(this, arguments);
      };
    }());
    queue.process('process-image-ocr', /*#__PURE__*/function () {
      var _ref58 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee59(job, done) {
        var reportedMessage;
        return _regenerator["default"].wrap(function _callee59$(_context63) {
          while (1) switch (_context63.prev = _context63.next) {
            case 0:
              try {
                reportedMessage = job.data.reportedMessage;
                _imageToText["default"].imageToText(reportedMessage.fileName).then( /*#__PURE__*/function () {
                  var _ref59 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee58(result) {
                    var checkSpam;
                    return _regenerator["default"].wrap(function _callee58$(_context62) {
                      while (1) switch (_context62.prev = _context62.next) {
                        case 0:
                          if (!result) {
                            _context62.next = 10;
                            break;
                          }
                          console.log("result from ocrrrrrrrrrrrrr", result);
                          checkSpam = {
                            data: false
                          };
                          console.log("checkspam result------", checkSpam.data);
                          queue.create('email-reported-url', {
                            body: "".concat(result.split('\n').join(' ') + " " + result.split('\n').join('')),
                            reportedMailId: null,
                            whatsAppMessageId: reportedMessage._id
                          }).removeOnComplete(true).priority('high').save();

                          // let urls = await getUrls(result);
                          // console.log("urls in scanned image----",urls)
                          _context62.next = 7;
                          return db.whatsapp.updateOne({
                            _id: reportedMessage._id
                          }, {
                            message: result,
                            result: checkSpam ? checkSpam.data : null
                          });
                        case 7:
                          console.log("Successfully Updated Message!", checkSpam.data);
                          _context62.next = 11;
                          break;
                        case 10:
                          _sendWhatsappMessage["default"].sendMessage(reportedMessage.phoneNumberId, reportedMessage.ticketId, reportedMessage.phoneNumber, "Invalid Content", "No text found!", 'result').then(function (result) {
                            console.log("Sent Message to User ----->", result);
                          })["catch"](function (error) {
                            console.error("Error sending message to user", error.response.data);
                          });
                        case 11:
                          done();
                        case 12:
                        case "end":
                          return _context62.stop();
                      }
                    }, _callee58);
                  }));
                  return function (_x102) {
                    return _ref59.apply(this, arguments);
                  };
                }())["catch"](function (error) {
                  console.log("Error from process-image-ocr kue", error);
                  done();
                });
              } catch (err) {
                console.log(err);
                done();
              } finally {
                done();
              }
            case 1:
            case "end":
              return _context63.stop();
          }
        }, _callee59);
      }));
      return function (_x100, _x101) {
        return _ref58.apply(this, arguments);
      };
    }());
    queue.process('process-whatsapp-image', /*#__PURE__*/function () {
      var _ref60 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee60(job, done) {
        var _job$data36, reportedMessage, companyId, preferedLanguage, result, resultContent, _yield$whatsappResult, template, originalResponse, sender, overallResult, messageSummary, parsedResponse, urls;
        return _regenerator["default"].wrap(function _callee60$(_context64) {
          while (1) switch (_context64.prev = _context64.next) {
            case 0:
              _context64.prev = 0;
              _job$data36 = job.data, reportedMessage = _job$data36.reportedMessage, companyId = _job$data36.companyId, preferedLanguage = _job$data36.preferedLanguage;
              console.log('Processing WhatsApp image job');
              _context64.next = 5;
              return _processWhatsappMessage["default"].processMessage(reportedMessage.fileName, preferedLanguage);
            case 5:
              result = _context64.sent;
              resultContent = result.content;
              console.log('Processed content:', resultContent);
              _context64.next = 10;
              return (0, _functions.whatsappResultTemplate)(resultContent, reportedMessage.ticketId, preferedLanguage);
            case 10:
              _yield$whatsappResult = _context64.sent;
              template = _yield$whatsappResult.template;
              originalResponse = _yield$whatsappResult.originalResponse;
              sender = _yield$whatsappResult.sender;
              overallResult = _yield$whatsappResult.overallResult;
              messageSummary = _yield$whatsappResult.messageSummary;
              console.log("Original Response:", originalResponse);
              parsedResponse = (0, _functions.tryParseJSON)(originalResponse);
              if (!Array.isArray(parsedResponse)) {
                _context64.next = 23;
                break;
              }
              urls = parsedResponse[0].flatMap(function (message) {
                var _message$Links;
                return ((_message$Links = message.Links) === null || _message$Links === void 0 ? void 0 : _message$Links.map(function (url) {
                  return {
                    url: url,
                    deceptiveStatus: null,
                    result: null,
                    details: null,
                    scanId: null,
                    companyId: companyId,
                    whatsappMessageId: reportedMessage._id
                  };
                })) || [];
              });
              if (!urls.length) {
                _context64.next = 23;
                break;
              }
              _context64.next = 23;
              return db.Url.insertMany(urls);
            case 23:
              _context64.next = 25;
              return db.whatsapp.updateOne({
                _id: reportedMessage._id
              }, {
                $set: {
                  message: parsedResponse ? originalResponse : JSON.stringify(originalResponse),
                  sender: sender,
                  result: overallResult,
                  messageSummary: messageSummary
                }
              });
            case 25:
              _context64.next = 27;
              return (0, _whatsapp.sendWhatsappMessage)(reportedMessage.phoneNumberId, template, reportedMessage.phoneNumber, reportedMessage.messageId);
            case 27:
              _context64.next = 32;
              break;
            case 29:
              _context64.prev = 29;
              _context64.t0 = _context64["catch"](0);
              console.error('Error processing WhatsApp image job:', _context64.t0);
            case 32:
              _context64.prev = 32;
              console.log('Finished processing job');
              done();
              return _context64.finish(32);
            case 36:
            case "end":
              return _context64.stop();
          }
        }, _callee60, null, [[0, 29, 32, 36]]);
      }));
      return function (_x103, _x104) {
        return _ref60.apply(this, arguments);
      };
    }());
    queue.process('process-trash-request-reported-email', /*#__PURE__*/function () {
      var _ref61 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee62(job, done) {
        var _job$data37, companyId, email, domainId, internetMessageId, isReported, name, folderId;
        return _regenerator["default"].wrap(function _callee62$(_context66) {
          while (1) switch (_context66.prev = _context66.next) {
            case 0:
              try {
                _job$data37 = job.data, companyId = _job$data37.companyId, email = _job$data37.email, domainId = _job$data37.domainId, internetMessageId = _job$data37.internetMessageId, isReported = _job$data37.isReported, name = _job$data37.name, folderId = _job$data37.folderId;
                _moveReportedEmailOutlook["default"].processTrashWhoElse({
                  companyId: companyId,
                  email: email,
                  domainId: domainId,
                  internetMessageId: internetMessageId,
                  folderId: folderId
                }).then( /*#__PURE__*/function () {
                  var _ref62 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee61(folderId) {
                    return _regenerator["default"].wrap(function _callee61$(_context65) {
                      while (1) switch (_context65.prev = _context65.next) {
                        case 0:
                          _context65.next = 2;
                          return (0, _allowedFeatures["default"])(companyId, "TPIR-RN");
                        case 2:
                          if (!_context65.sent) {
                            _context65.next = 4;
                            break;
                          }
                          _mailer["default"].sendAlreadyReportedMail(name, email, companyId);
                        case 4:
                          _context65.next = 6;
                          return db.ReportedMail.updateOne({
                            _id: isReported._id
                          }, {
                            $push: {
                              reporters: {
                                email: email,
                                folderId: folderId
                              }
                            }
                          });
                        case 6:
                          done();
                        case 7:
                        case "end":
                          return _context65.stop();
                      }
                    }, _callee61);
                  }));
                  return function (_x107) {
                    return _ref62.apply(this, arguments);
                  };
                }())["catch"](function (error) {
                  console.log('Error when moving the already reported mail from kue', error);
                  done();
                });
              } catch (err) {
                console.log(err);
                done();
              } finally {
                done();
              }
            case 1:
            case "end":
              return _context66.stop();
          }
        }, _callee62);
      }));
      return function (_x105, _x106) {
        return _ref61.apply(this, arguments);
      };
    }());
    queue.process('cache-reported-mail', /*#__PURE__*/function () {
      var _ref63 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee63(job, done) {
        var reportedEmail;
        return _regenerator["default"].wrap(function _callee63$(_context67) {
          while (1) switch (_context67.prev = _context67.next) {
            case 0:
              try {
                reportedEmail = job.data.reportedEmail;
                (0, _functions.cacheReportedMail)(reportedEmail);
              } catch (err) {
                console.log(err);
                done();
              } finally {
                done();
              }
            case 1:
            case "end":
              return _context67.stop();
          }
        }, _callee63);
      }));
      return function (_x108, _x109) {
        return _ref63.apply(this, arguments);
      };
    }());
    queue.process('broadcast-reported-mails', 20, /*#__PURE__*/function () {
      var _ref64 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee64(job, done) {
        var _job$data38, mailIds, companyId;
        return _regenerator["default"].wrap(function _callee64$(_context68) {
          while (1) switch (_context68.prev = _context68.next) {
            case 0:
              _job$data38 = job.data, mailIds = _job$data38.mailIds, companyId = _job$data38.companyId;
              try {
                (0, _broadcastMail.processBroadcastMailsRequest)(mailIds, companyId);
                done();
              } catch (error) {
                console.error("Error in sending broadcast emails: ".concat(error));
                done(error);
              }
            case 2:
            case "end":
              return _context68.stop();
          }
        }, _callee64);
      }));
      return function (_x110, _x111) {
        return _ref64.apply(this, arguments);
      };
    }());
    queue.process('process-update-folderId-outlook', /*#__PURE__*/function () {
      var _ref65 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee65(job, done) {
        var _job$data39, whoElses, domainId, companyId, mailAction, emailReported, _yield$Credentials$ge7, token, requestObjectsForMessageId, updatedWhoElses, _iterator3, _step3, whoElse, arr, _iterator4, _step4, _loop5, requestObjectForMailAction, resp, i, batch;
        return _regenerator["default"].wrap(function _callee65$(_context70) {
          while (1) switch (_context70.prev = _context70.next) {
            case 0:
              _context70.prev = 0;
              _job$data39 = job.data, whoElses = _job$data39.whoElses, domainId = _job$data39.domainId, companyId = _job$data39.companyId, mailAction = _job$data39.mailAction, emailReported = _job$data39.emailReported; // console.log('----------------------------------------------->',job.data)
              _context70.next = 4;
              return _credentials["default"].getCredentials(companyId, domainId);
            case 4:
              _yield$Credentials$ge7 = _context70.sent;
              token = _yield$Credentials$ge7.token;
              _context70.next = 8;
              return createRequestObjects(whoElses);
            case 8:
              requestObjectsForMessageId = _context70.sent;
              _context70.next = 11;
              return Promise.allSettled(requestObjectsForMessageId.map(function (batch) {
                return update(batch, token, mailAction === 'Recovered');
              }));
            case 11:
              updatedWhoElses = [];
              _iterator3 = _createForOfIteratorHelper(whoElses);
              _context70.prev = 13;
              _iterator3.s();
            case 15:
              if ((_step3 = _iterator3.n()).done) {
                _context70.next = 37;
                break;
              }
              whoElse = _step3.value;
              arr = [];
              _iterator4 = _createForOfIteratorHelper(whoElse);
              _context70.prev = 19;
              _loop5 = /*#__PURE__*/_regenerator["default"].mark(function _loop5() {
                var currWhoElse, resFromDb, folderId, findFolderIdInReporters;
                return _regenerator["default"].wrap(function _loop5$(_context69) {
                  while (1) switch (_context69.prev = _context69.next) {
                    case 0:
                      currWhoElse = _step4.value;
                      _context69.next = 3;
                      return db.WhoElse.findOne({
                        _id: currWhoElse._id
                      });
                    case 3:
                      resFromDb = _context69.sent;
                      if (mailAction == 'Recovered') {
                        folderId = null;
                        if (emailReported.to === resFromDb.to) {
                          folderId = emailReported.reporterFolderId ? emailReported.reporterFolderId : 'inbox';
                        } else {
                          findFolderIdInReporters = emailReported.reporters.find(function (reporter) {
                            return reporter.email.toLowerCase() === resFromDb.to.toLowerCase();
                          });
                          if (findFolderIdInReporters) {
                            folderId = findFolderIdInReporters.folderId ? findFolderIdInReporters.folderId : 'inbox';
                          } else {
                            folderId = resFromDb.folderId ? resFromDb.folderId : 'inbox';
                          }
                        }
                        resFromDb = _objectSpread(_objectSpread({}, resFromDb.toObject()), {}, {
                          folderId: folderId
                        });
                      }
                      arr.push(resFromDb);
                    case 6:
                    case "end":
                      return _context69.stop();
                  }
                }, _loop5);
              });
              _iterator4.s();
            case 22:
              if ((_step4 = _iterator4.n()).done) {
                _context70.next = 26;
                break;
              }
              return _context70.delegateYield(_loop5(), "t0", 24);
            case 24:
              _context70.next = 22;
              break;
            case 26:
              _context70.next = 31;
              break;
            case 28:
              _context70.prev = 28;
              _context70.t1 = _context70["catch"](19);
              _iterator4.e(_context70.t1);
            case 31:
              _context70.prev = 31;
              _iterator4.f();
              return _context70.finish(31);
            case 34:
              updatedWhoElses.push(arr);
            case 35:
              _context70.next = 15;
              break;
            case 37:
              _context70.next = 42;
              break;
            case 39:
              _context70.prev = 39;
              _context70.t2 = _context70["catch"](13);
              _iterator3.e(_context70.t2);
            case 42:
              _context70.prev = 42;
              _iterator3.f();
              return _context70.finish(42);
            case 45:
              requestObjectForMailAction = createRequestObjectMailAction(updatedWhoElses, token, mailAction);
              _context70.next = 48;
              return Promise.allSettled(requestObjectForMailAction.map(function (batch) {
                return outlookBatchProcess(batch, token.access_token);
              }));
            case 48:
              resp = _context70.sent;
              for (i = 0; i < resp.length; i++) {
                batch = resp[i];
                console.log(batch);
                if (batch.status == 'fulfilled') {
                  queue.create('process-who-else-trash-batches-outlook', {
                    responses: batch.value,
                    emailReported: emailReported,
                    Trash: mailAction === 'Trashed',
                    Recover: mailAction === 'Recovered',
                    Delete: mailAction === 'Deleted',
                    companyId: companyId
                  }).removeOnComplete(true).priority('high').save();
                }
              }
              _context70.next = 56;
              break;
            case 52:
              _context70.prev = 52;
              _context70.t3 = _context70["catch"](0);
              console.log(_context70.t3);
              done();
            case 56:
              _context70.prev = 56;
              done();
              return _context70.finish(56);
            case 59:
            case "end":
              return _context70.stop();
          }
        }, _callee65, null, [[0, 52, 56, 59], [13, 39, 42, 45], [19, 28, 31, 34]]);
      }));
      return function (_x112, _x113) {
        return _ref65.apply(this, arguments);
      };
    }());
    queue.process('remove-Groups-Application', /*#__PURE__*/function () {
      var _ref66 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee66(job, done) {
        var _job$data40, groupIds, localCompanyId, groups, groupObjectIds;
        return _regenerator["default"].wrap(function _callee66$(_context71) {
          while (1) switch (_context71.prev = _context71.next) {
            case 0:
              _job$data40 = job.data, groupIds = _job$data40.groupIds, localCompanyId = _job$data40.localCompanyId;
              _context71.prev = 1;
              console.log("Deleting groups in database:", groupIds);
              _context71.next = 5;
              return db.Group.find({
                tacIdentityKey: {
                  $in: groupIds
                },
                companyId: localCompanyId
              });
            case 5:
              groups = _context71.sent;
              groupObjectIds = groups.map(function (group) {
                return group._id;
              });
              _context71.next = 9;
              return db.User.updateMany({
                companyId: localCompanyId,
                groups: {
                  $in: groupObjectIds
                }
              }, {
                $pull: {
                  groups: {
                    $in: groupObjectIds
                  }
                }
              });
            case 9:
              _context71.next = 11;
              return db.User.deleteMany({
                companyId: localCompanyId,
                groups: {
                  $size: 1
                },
                deletedAt: null
              });
            case 11:
              _context71.next = 13;
              return db.Group.deleteMany({
                _id: {
                  $in: groupObjectIds
                },
                companyId: localCompanyId,
                isDefaultGroup: false
              });
            case 13:
              console.log("Successfully deleted groups: ".concat(groupObjectIds));
              _context71.next = 20;
              break;
            case 16:
              _context71.prev = 16;
              _context71.t0 = _context71["catch"](1);
              console.error("Error during group deletion:", _context71.t0);
              return _context71.abrupt("return", done(_context71.t0));
            case 20:
              done();
            case 21:
            case "end":
              return _context71.stop();
          }
        }, _callee66, null, [[1, 16]]);
      }));
      return function (_x114, _x115) {
        return _ref66.apply(this, arguments);
      };
    }());
    queue.process('add-User-Queue', /*#__PURE__*/function () {
      var _ref67 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee67(job, done) {
        var _job$data41, tacCompanyId, tacIdentityKey, localCompanyId, localGroupId, limit, offset, isLastBatch, lastSyncId, response, users, syncData;
        return _regenerator["default"].wrap(function _callee67$(_context72) {
          while (1) switch (_context72.prev = _context72.next) {
            case 0:
              _job$data41 = job.data, tacCompanyId = _job$data41.tacCompanyId, tacIdentityKey = _job$data41.tacIdentityKey, localCompanyId = _job$data41.localCompanyId, localGroupId = _job$data41.localGroupId, limit = _job$data41.limit, offset = _job$data41.offset, isLastBatch = _job$data41.isLastBatch, lastSyncId = _job$data41.lastSyncId;
              _context72.prev = 1;
              _context72.next = 4;
              return _axios["default"].post("".concat(process.env.TAC_URL, "/api/sync-services/tpir/fetch-group-users"), {
                groupIdentityKey: tacIdentityKey,
                tacCompanyId: tacCompanyId,
                limit: limit,
                offset: offset
              }, _objectSpread({
                headers: {
                  'Content-Type': 'application/json',
                  'Authorization': "Bearer ".concat(_config["default"].adminCentral.api_key)
                },
                params: {
                  appName: "TPIR"
                }
              }, _config["default"].proxy.enableForTA && {
                httpsAgent: _config["default"].proxy.proxyAgent,
                httpAgent: _config["default"].proxy.proxyAgent
              }));
            case 4:
              response = _context72.sent;
              users = response.data.response;
              syncData = {
                users: users,
                companyId: localCompanyId,
                groupId: localGroupId,
                isLastBatch: isLastBatch,
                lastSyncId: lastSyncId
              };
              queue.create("add-users-tac", _objectSpread({}, syncData)).priority('normal').removeOnComplete(true).save();
              done();
              _context72.next = 15;
              break;
            case 11:
              _context72.prev = 11;
              _context72.t0 = _context72["catch"](1);
              // await t.rollback();
              console.log(_context72.t0.response.data);
              done(_context72.t0);
            case 15:
            case "end":
              return _context72.stop();
          }
        }, _callee67, null, [[1, 11]]);
      }));
      return function (_x116, _x117) {
        return _ref67.apply(this, arguments);
      };
    }());
    queue.process('asssign-group-user', /*#__PURE__*/function () {
      var _ref68 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee68(job, done) {
        var _job$data42, localGroupId, localCompanyId, tacCompanyId, memberCount, tacIdentityKey, lastSyncId, offset, limit, pages;
        return _regenerator["default"].wrap(function _callee68$(_context73) {
          while (1) switch (_context73.prev = _context73.next) {
            case 0:
              _job$data42 = job.data, localGroupId = _job$data42.localGroupId, localCompanyId = _job$data42.localCompanyId, tacCompanyId = _job$data42.tacCompanyId, memberCount = _job$data42.memberCount, tacIdentityKey = _job$data42.tacIdentityKey, lastSyncId = _job$data42.lastSyncId;
              offset = 0;
              limit = 1;
              pages = Math.ceil(memberCount / limit);
              console.log("The total number of users are", pages, job.data);
              while (pages--) {
                try {
                  queue.create('add-User-Queue', {
                    tacCompanyId: tacCompanyId,
                    tacIdentityKey: tacIdentityKey,
                    localCompanyId: localCompanyId,
                    localGroupId: localGroupId,
                    limit: limit,
                    offset: offset,
                    lastSyncId: lastSyncId,
                    isLastBatch: pages == 0
                  }).removeOnComplete(true).save();
                  offset += limit;
                } catch (error) {
                  console.log(error);
                  done(error);
                }
              }
              done();
            case 7:
            case "end":
              return _context73.stop();
          }
        }, _callee68);
      }));
      return function (_x118, _x119) {
        return _ref68.apply(this, arguments);
      };
    }());

    // queue.process('retry-syncing-users',async (job,done)=>{
    //     try {
    //         let {localGroupId, localCompanyId, memberCount, tacIdentityKey, licenseKey = '', lastSyncId }=job.data;
    //     let offset = 0;
    //     const limit = 1;
    //     let pages = Math.ceil(memberCount / limit);
    //     console.log("The total number of users are",pages, job.data)
    //     while(pages--){
    //         try{
    //             var response =await axios.get(`${process.env.TAC_URL}/api/sync-services/common/fetch-group-users`,
    //             {
    //                 headers: {
    //                     'Content-Type': 'application/json',
    //                     Authorization: `Bearer ${licenseKey}`
    //                 },
    //                 params:{
    //                     appName:"TPIR",
    //                     groupIdentityKey: tacIdentityKey,
    //                     limit:limit,
    //                     offset:offset
    //             }
    //             }
    //         )

    //         let users;

    //         users = response.data.response.groupUserDetails;

    //         let syncData = {
    //             users,
    //             companyId: localCompanyId,
    //             groupId: localGroupId,
    //             isLastBatch: pages == 0,
    //             lastSyncId
    //         }

    //         queue.create(`add-users-tac`, {...syncData})
    //         .priority('normal')
    //         .removeOnComplete(true)
    //         .save()    

    //         done();
    //         offset+=limit
    //         }
    //         catch(error){
    //             console.log(error);
    //             done(error);
    //         }
    //     }
    //     done();
    //     } catch (error) {
    //         console.log(error)
    //         done()
    //     }

    // })

    queue.process('retry-syncing-users', /*#__PURE__*/function () {
      var _ref69 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee69(job, done) {
        var _job$data43, localGroupId, localCompanyId, memberCount, tacIdentityKey, _job$data43$licenseKe, licenseKey, lastSyncId, limit, pages, offset, _loop6, page;
        return _regenerator["default"].wrap(function _callee69$(_context75) {
          while (1) switch (_context75.prev = _context75.next) {
            case 0:
              _job$data43 = job.data, localGroupId = _job$data43.localGroupId, localCompanyId = _job$data43.localCompanyId, memberCount = _job$data43.memberCount, tacIdentityKey = _job$data43.tacIdentityKey, _job$data43$licenseKe = _job$data43.licenseKey, licenseKey = _job$data43$licenseKe === void 0 ? '' : _job$data43$licenseKe, lastSyncId = _job$data43.lastSyncId;
              limit = 100; // fetch 100 users at a time
              pages = Math.ceil(memberCount / limit);
              offset = 0;
              _context75.prev = 4;
              _loop6 = /*#__PURE__*/_regenerator["default"].mark(function _loop6(page) {
                var _data$response;
                var _yield$axios$get, data, users;
                return _regenerator["default"].wrap(function _loop6$(_context74) {
                  while (1) switch (_context74.prev = _context74.next) {
                    case 0:
                      console.log("-----------PAGE--------------", page);
                      _context74.next = 3;
                      return _axios["default"].get("".concat(process.env.TAC_URL, "/api/sync-services/common/fetch-group-users"), _objectSpread({
                        headers: {
                          Authorization: "Bearer ".concat(licenseKey)
                        },
                        params: {
                          appName: 'TPIR',
                          groupIdentityKey: tacIdentityKey,
                          limit: limit,
                          offset: offset
                        }
                      }, _config["default"].proxy.enableForTA && {
                        httpsAgent: _config["default"].proxy.proxyAgent,
                        httpAgent: _config["default"].proxy.proxyAgent
                      }));
                    case 3:
                      _yield$axios$get = _context74.sent;
                      data = _yield$axios$get.data;
                      users = (data === null || data === void 0 ? void 0 : (_data$response = data.response) === null || _data$response === void 0 ? void 0 : _data$response.groupUserDetails) || []; // Wrap .save() so we know the job is really in Redis before moving on
                      _context74.next = 8;
                      return new Promise(function (res, rej) {
                        return queue.create('add-users-tac', {
                          users: users,
                          companyId: localCompanyId,
                          groupId: localGroupId,
                          isLastBatch: page === pages - 1,
                          lastSyncId: lastSyncId
                        }).priority('normal').removeOnComplete(true).save(function (err) {
                          return err ? rej(err) : res();
                        });
                      });
                    case 8:
                    case "end":
                      return _context74.stop();
                  }
                }, _loop6);
              });
              page = 0;
            case 7:
              if (!(page < pages)) {
                _context75.next = 12;
                break;
              }
              return _context75.delegateYield(_loop6(page), "t0", 9);
            case 9:
              page++, offset += limit;
              _context75.next = 7;
              break;
            case 12:
              done(); // ✅ EXACTLY ONCE, when everything’s finished
              _context75.next = 19;
              break;
            case 15:
              _context75.prev = 15;
              _context75.t1 = _context75["catch"](4);
              console.error(_context75.t1);
              done(_context75.t1); // ✅ EXACTLY ONCE, only on failure
            case 19:
            case "end":
              return _context75.stop();
          }
        }, _callee69, null, [[4, 15]]);
      }));
      return function (_x120, _x121) {
        return _ref69.apply(this, arguments);
      };
    }());
    queue.process('sync-users-csv', /*#__PURE__*/function () {
      var _ref70 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee71(job, done) {
        var _job$data44, users, domain, domainType, companyId, groupId, isLast, group, allUsersGroup, userLimit, userLimitMessenger, addedUsersCount, remainingUserCount, addedUsersSoFar, processedUsers, userUpdates, isAnyUserUploadedInCurrentGroup;
        return _regenerator["default"].wrap(function _callee71$(_context77) {
          while (1) switch (_context77.prev = _context77.next) {
            case 0:
              console.log("inside sync users csv==========");
              _job$data44 = job.data, users = _job$data44.users, domain = _job$data44.domain, domainType = _job$data44.domainType, companyId = _job$data44.companyId, groupId = _job$data44.groupId, isLast = _job$data44.isLast;
              _context77.prev = 2;
              _context77.next = 5;
              return db.Group.findOne({
                _id: groupId,
                companyId: companyId,
                deletedAt: null
              });
            case 5:
              group = _context77.sent;
              console.log({
                groupId: groupId,
                group: group
              });
              _context77.next = 9;
              return db.Group.findOne({
                groupName: "all-users-tpir",
                companyId: companyId,
                deletedAt: null,
                isDefaultGroup: true
              });
            case 9:
              allUsersGroup = _context77.sent;
              _context77.next = 12;
              return db.MetaData.findOne({
                companyId: companyId,
                name: "userLimit"
              });
            case 12:
              userLimit = _context77.sent.value;
              _context77.next = 15;
              return db.MetaData.findOne({
                companyId: companyId,
                name: "userLimitMessenger"
              });
            case 15:
              userLimitMessenger = _context77.sent.value;
              _context77.next = 18;
              return db.User.countDocuments({
                companyId: companyId,
                deletedAt: null
              });
            case 18:
              addedUsersCount = _context77.sent;
              remainingUserCount = parseInt(userLimit) + parseInt(userLimitMessenger) - addedUsersCount;
              addedUsersSoFar = 0;
              processedUsers = new Set(); // To keep track of already processed emails
              userUpdates = users.map( /*#__PURE__*/function () {
                var _ref71 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee70(user) {
                  var subDomainGroupFromDb, existingUser, canBeActivate, canBeActivateMessenger;
                  return _regenerator["default"].wrap(function _callee70$(_context76) {
                    while (1) switch (_context76.prev = _context76.next) {
                      case 0:
                        if (!processedUsers.has(user.email)) {
                          _context76.next = 2;
                          break;
                        }
                        return _context76.abrupt("return", "This user has already been processed ".concat(user.email));
                      case 2:
                        processedUsers.add(user.email);
                        _context76.next = 5;
                        return db.SubDomainGroup.findOne({
                          groupName: user.email.split("@")[1],
                          domainId: domain._id
                        });
                      case 5:
                        subDomainGroupFromDb = _context76.sent;
                        _context76.next = 8;
                        return db.User.findOne({
                          email: user.email,
                          companyId: companyId,
                          deletedAt: null
                        });
                      case 8:
                        existingUser = _context76.sent;
                        console.log({
                          addedUsersSoFar: addedUsersSoFar,
                          remainingUserCount: remainingUserCount,
                          existingUser: existingUser,
                          lim: addedUsersSoFar < remainingUserCount
                        });
                        canBeActivate = (allUsersGroup.emailAccess || group.emailAccess) && addedUsersSoFar < remainingUserCount;
                        canBeActivateMessenger = (allUsersGroup.messengerAccess || group.messengerAccess) && addedUsersSoFar < remainingUserCount;
                        console.log("users can activate--------", user.email, canBeActivate, canBeActivateMessenger);
                        if (!existingUser) {
                          _context76.next = 17;
                          break;
                        }
                        return _context76.abrupt("return", db.User.updateOne({
                          _id: existingUser._id
                        }, {
                          $set: {
                            name: user.name,
                            domainId: domain._id,
                            emailType: domainType,
                            phoneNumber: user.phoneNumber,
                            subDomainGroupId: subDomainGroupFromDb === null || subDomainGroupFromDb === void 0 ? void 0 : subDomainGroupFromDb._id,
                            deletedAt: null
                          },
                          $addToSet: {
                            groups: group._id
                          }
                        }));
                      case 17:
                        if (!(addedUsersSoFar < remainingUserCount)) {
                          _context76.next = 23;
                          break;
                        }
                        addedUsersSoFar++;
                        console.log("all users group id -------------------------", allUsersGroup._id);
                        return _context76.abrupt("return", db.User.create({
                          name: user.name,
                          email: user.email,
                          isActive: canBeActivate,
                          isActiveMessenger: canBeActivateMessenger,
                          domainId: domain._id,
                          groups: [group._id, allUsersGroup._id],
                          emailType: domainType,
                          phoneNumber: user.phoneNumber,
                          companyId: companyId,
                          subDomainGroupId: subDomainGroupFromDb === null || subDomainGroupFromDb === void 0 ? void 0 : subDomainGroupFromDb._id
                        }));
                      case 23:
                        return _context76.abrupt("return", "User Limit Exceeded!");
                      case 24:
                        ;
                      case 25:
                      case "end":
                        return _context76.stop();
                    }
                  }, _callee70);
                }));
                return function (_x124) {
                  return _ref71.apply(this, arguments);
                };
              }());
              _context77.next = 25;
              return Promise.all(userUpdates);
            case 25:
              done();
              _context77.next = 32;
              break;
            case 28:
              _context77.prev = 28;
              _context77.t0 = _context77["catch"](2);
              console.error("Error processing users:", _context77.t0);
              done(_context77.t0);
            case 32:
              _context77.prev = 32;
              if (!isLast) {
                _context77.next = 43;
                break;
              }
              _context77.next = 36;
              return (0, _updateSyncingStatusGroups.updateSyncingStatusOfGroups)(groupId, companyId);
            case 36:
              _context77.next = 38;
              return db.User.countDocuments({
                companyId: companyId,
                groups: {
                  $in: [groupId]
                }
              });
            case 38:
              isAnyUserUploadedInCurrentGroup = _context77.sent;
              console.log({
                isAnyUserUploadedInCurrentGroup: isAnyUserUploadedInCurrentGroup
              });
              if (isAnyUserUploadedInCurrentGroup) {
                _context77.next = 43;
                break;
              }
              _context77.next = 43;
              return db.Group.deleteOne({
                _id: groupId,
                isDefaultGroup: false,
                companyId: companyId
              });
            case 43:
              done();
              return _context77.finish(32);
            case 45:
            case "end":
              return _context77.stop();
          }
        }, _callee71, null, [[2, 28, 32, 45]]);
      }));
      return function (_x122, _x123) {
        return _ref70.apply(this, arguments);
      };
    }());
    queue.process('sync-tac-users-identityKey', /*#__PURE__*/function () {
      var _ref72 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee73(job, done) {
        var _job$data45, tacCompanyId, groupIdentityKey, appName, limit, offset, isLastBatch, companyId, processBatch, BATCH_SIZE, response, usersObj, _update3, entries, batches, i, _i, _batches, batch, _update4, upppppKUEUEUUE;
        return _regenerator["default"].wrap(function _callee73$(_context79) {
          while (1) switch (_context79.prev = _context79.next) {
            case 0:
              _job$data45 = job.data, tacCompanyId = _job$data45.tacCompanyId, groupIdentityKey = _job$data45.groupIdentityKey, appName = _job$data45.appName, limit = _job$data45.limit, offset = _job$data45.offset, isLastBatch = _job$data45.isLastBatch, companyId = _job$data45.companyId;
              _context79.prev = 1;
              processBatch = /*#__PURE__*/function () {
                var _ref73 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee72(batch) {
                  var bulkOps, result;
                  return _regenerator["default"].wrap(function _callee72$(_context78) {
                    while (1) switch (_context78.prev = _context78.next) {
                      case 0:
                        _context78.prev = 0;
                        bulkOps = batch.map(function (_ref74) {
                          var _ref75 = (0, _slicedToArray2["default"])(_ref74, 2),
                            email = _ref75[0],
                            identityKeys = _ref75[1];
                          return {
                            updateOne: {
                              filter: {
                                email: email,
                                companyId: companyId
                              },
                              update: {
                                $set: {
                                  tacIdentityKey: identityKeys.userIdentityKey
                                }
                              }
                            }
                          };
                        });
                        _context78.next = 4;
                        return db.User.bulkWrite(bulkOps);
                      case 4:
                        result = _context78.sent;
                        console.log("Processed batch of ".concat(batch.length, " updates successfully."));
                        console.log("Matched: ".concat(result.matchedCount, ", Modified: ").concat(result.modifiedCount));
                        _context78.next = 13;
                        break;
                      case 9:
                        _context78.prev = 9;
                        _context78.t0 = _context78["catch"](0);
                        console.error("Error updating batch:", _context78.t0);
                        throw _context78.t0;
                      case 13:
                      case "end":
                        return _context78.stop();
                    }
                  }, _callee72, null, [[0, 9]]);
                }));
                return function processBatch(_x127) {
                  return _ref73.apply(this, arguments);
                };
              }();
              BATCH_SIZE = 1000;
              _context79.next = 6;
              return _axios["default"].get("".concat(process.env.TAC_URL, "/api/sync-services/common/sync-group-users-identityKey"), _objectSpread({
                headers: {
                  'Content-Type': 'application/json',
                  'Authorization': "Bearer ".concat(_config["default"].adminCentral.api_key)
                },
                params: {
                  companyId: tacCompanyId,
                  groupIdentityKey: groupIdentityKey,
                  appName: appName,
                  limit: limit,
                  offset: offset
                }
              }, _config["default"].proxy.enableForTA && {
                httpsAgent: _config["default"].proxy.proxyAgent,
                httpAgent: _config["default"].proxy.proxyAgent
              }));
            case 6:
              response = _context79.sent;
              usersObj = response.data.response;
              if (!(Object.keys(usersObj).length === 0)) {
                _context79.next = 16;
                break;
              }
              console.log("No more data to process.");
              if (!isLastBatch) {
                _context79.next = 14;
                break;
              }
              _context79.next = 13;
              return db.Company.updateOne({
                _id: companyId
              }, {
                $set: {
                  isTacEnabled: true,
                  isTaConnectionInProgess: false
                }
              });
            case 13:
              _update3 = _context79.sent;
            case 14:
              done();
              return _context79.abrupt("return");
            case 16:
              entries = Object.entries(usersObj);
              batches = [];
              for (i = 0; i < entries.length; i += BATCH_SIZE) {
                batches.push(entries.slice(i, i + BATCH_SIZE));
              }
              _i = 0, _batches = batches;
            case 20:
              if (!(_i < _batches.length)) {
                _context79.next = 27;
                break;
              }
              batch = _batches[_i];
              _context79.next = 24;
              return processBatch(batch);
            case 24:
              _i++;
              _context79.next = 20;
              break;
            case 27:
              console.log({
                isLastBatch: isLastBatch,
                companyId: companyId
              });
              if (!isLastBatch) {
                _context79.next = 37;
                break;
              }
              _context79.next = 31;
              return db.Company.updateOne({
                _id: companyId
              }, {
                $set: {
                  isTacEnabled: true,
                  isTaConnectionInProgess: false
                }
              });
            case 31:
              _update4 = _context79.sent;
              _context79.next = 34;
              return db.Company.findOne({
                _id: companyId
              });
            case 34:
              upppppKUEUEUUE = _context79.sent;
              console.log({
                upppppKUEUEUUE: upppppKUEUEUUE
              });
              console.log('nfjksnfnsknfdkksf isme ghusa', _update4);
            case 37:
              console.log("All IdentityKeys for targets of group having groupIdentityKey: " + groupIdentityKey + " have been updated successfully.");
              done();
              _context79.next = 45;
              break;
            case 41:
              _context79.prev = 41;
              _context79.t0 = _context79["catch"](1);
              console.error("Error processing users:", _context79.t0);
              done(_context79.t0);
            case 45:
            case "end":
              return _context79.stop();
          }
        }, _callee73, null, [[1, 41]]);
      }));
      return function (_x125, _x126) {
        return _ref72.apply(this, arguments);
      };
    }());
    queue.process('add-users-tac', /*#__PURE__*/function () {
      var _ref76 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee74(job, done) {
        var _job$data46, users, companyId, groupId, isLastBatch, _job$data46$lastSyncI, lastSyncId, userLimit, userLimitMessenger, addedUsersCount, remainingUsersCount, allUsersGroup, currentGroup, addedUsersSoFar, _iterator5, _step5, _domain, user, firstname, lastname, email, IdentityKey, phoneNumber, userIdentityKey, domainName, domain, domainGroup, domainId, _domain2, existingUser, updateFields, updateQuery;
        return _regenerator["default"].wrap(function _callee74$(_context80) {
          while (1) switch (_context80.prev = _context80.next) {
            case 0:
              _job$data46 = job.data, users = _job$data46.users, companyId = _job$data46.companyId, groupId = _job$data46.groupId, isLastBatch = _job$data46.isLastBatch, _job$data46$lastSyncI = _job$data46.lastSyncId, lastSyncId = _job$data46$lastSyncI === void 0 ? '' : _job$data46$lastSyncI;
              console.log('JOB DATA ADD USERS TAC', job.data);
              _context80.prev = 2;
              _context80.t0 = parseInt;
              _context80.next = 6;
              return db.MetaData.findOne({
                companyId: companyId,
                name: "userLimit"
              });
            case 6:
              _context80.t1 = _context80.sent.value;
              userLimit = (0, _context80.t0)(_context80.t1);
              _context80.t2 = parseInt;
              _context80.next = 11;
              return db.MetaData.findOne({
                companyId: companyId,
                name: "userLimitMessenger"
              });
            case 11:
              _context80.t3 = _context80.sent.value;
              userLimitMessenger = (0, _context80.t2)(_context80.t3);
              _context80.next = 15;
              return db.User.countDocuments({
                companyId: companyId,
                deletedAt: null
              });
            case 15:
              addedUsersCount = _context80.sent;
              remainingUsersCount = Math.max(0, userLimit + userLimitMessenger - addedUsersCount);
              _context80.next = 19;
              return db.Group.findOne({
                groupName: "all-users-tpir",
                isDefaultGroup: true,
                companyId: companyId
              });
            case 19:
              allUsersGroup = _context80.sent;
              _context80.next = 22;
              return db.Group.findOne({
                _id: groupId,
                companyId: companyId,
                deletedAt: null
              });
            case 22:
              currentGroup = _context80.sent;
              addedUsersSoFar = 0;
              _iterator5 = _createForOfIteratorHelper(users);
              _context80.prev = 25;
              _iterator5.s();
            case 27:
              if ((_step5 = _iterator5.n()).done) {
                _context80.next = 71;
                break;
              }
              user = _step5.value;
              firstname = user.firstname, lastname = user.lastname, email = user.email, IdentityKey = user.IdentityKey, phoneNumber = user.phoneNumber, userIdentityKey = user.userIdentityKey;
              domainName = email.split('@')[1];
              console.log({
                domainName: domainName
              });
              _context80.next = 34;
              return db.Domain.findOne({
                domainName: domainName,
                companyId: companyId,
                deletedAt: null
              });
            case 34:
              domain = _context80.sent;
              if (domain) {
                _context80.next = 43;
                break;
              }
              _context80.next = 38;
              return db.SubDomainGroup.findOne({
                groupName: domainName,
                companyId: companyId,
                deletedAt: null
              });
            case 38:
              domainGroup = _context80.sent;
              if (!(domainGroup !== null && domainGroup !== void 0 && domainGroup.domainId)) {
                _context80.next = 43;
                break;
              }
              _context80.next = 42;
              return db.Domain.findOne({
                _id: domainGroup.domainId,
                companyId: companyId,
                deletedAt: null
              });
            case 42:
              domain = _context80.sent;
            case 43:
              domainId = ((_domain = domain) === null || _domain === void 0 ? void 0 : _domain._id) || null;
              if (!domainId) {
                _context80.next = 69;
                break;
              }
              _context80.next = 47;
              return db.User.findOne({
                email: email,
                companyId: companyId
              });
            case 47:
              existingUser = _context80.sent;
              console.log({
                existingUser: existingUser,
                addedUsersSoFar: addedUsersSoFar,
                remainingUsersCount: remainingUsersCount,
                email: email
              });
              updateFields = {};
              if (firstname || lastname) {
                updateFields.name = "".concat(firstname || '', " ").concat(lastname || '').trim();
              }
              if (email) {
                updateFields.email = email;
              }
              if (phoneNumber) {
                updateFields.phoneNumber = phoneNumber !== null && phoneNumber !== void 0 && phoneNumber.startsWith("+") ? phoneNumber === null || phoneNumber === void 0 ? void 0 : phoneNumber.slice(1) : phoneNumber;
                ;
              }
              if (domainId) {
                updateFields.domainId = domainId;
              }
              if (((_domain2 = domain) === null || _domain2 === void 0 ? void 0 : _domain2.domainType) === "Outlook") {
                updateFields.emailType = domain.domainTypeForOutlook === "EXCHANGE" ? "Exchange" : "Outlook";
              } else {
                updateFields.emailType = "Gsuite";
              }
              if (companyId) {
                updateFields.companyId = companyId;
              }
              if (IdentityKey || userIdentityKey) {
                if (IdentityKey) updateFields.tacIdentityKey = IdentityKey;
                if (userIdentityKey) updateFields.tacIdentityKey = userIdentityKey;
              }
              if (allUsersGroup.emailAccess || currentGroup.emailAccess) {
                updateFields.isActive = true;
              }
              if (allUsersGroup.messengerAccess || currentGroup.messengerAccess) {
                updateFields.isActiveMessenger = true;
              }
              updateQuery = {
                $set: updateFields,
                $addToSet: {
                  groups: {
                    $each: [allUsersGroup._id, groupId]
                  }
                }
              };
              if (!existingUser) {
                _context80.next = 65;
                break;
              }
              _context80.next = 63;
              return db.User.updateOne({
                email: email,
                domainId: domainId,
                companyId: companyId
              }, updateQuery);
            case 63:
              _context80.next = 69;
              break;
            case 65:
              if (!(addedUsersSoFar < remainingUsersCount)) {
                _context80.next = 69;
                break;
              }
              _context80.next = 68;
              return db.User.updateOne({
                email: email,
                domainId: domainId,
                companyId: companyId
              }, updateQuery, {
                upsert: true
              });
            case 68:
              addedUsersSoFar++;
            case 69:
              _context80.next = 27;
              break;
            case 71:
              _context80.next = 76;
              break;
            case 73:
              _context80.prev = 73;
              _context80.t4 = _context80["catch"](25);
              _iterator5.e(_context80.t4);
            case 76:
              _context80.prev = 76;
              _iterator5.f();
              return _context80.finish(76);
            case 79:
              if (!isLastBatch) {
                _context80.next = 84;
                break;
              }
              _context80.next = 82;
              return (0, _updateSyncingStatusGroups.updateSyncingStatusOfGroups)(groupId, companyId);
            case 82:
              _context80.next = 84;
              return db.Group.updateOne({
                _id: groupId,
                companyId: companyId,
                deletedAt: null
              }, {
                $set: {
                  lastSyncId: lastSyncId,
                  lastSyncIdMismatch: false
                }
              });
            case 84:
              done();
              _context80.next = 93;
              break;
            case 87:
              _context80.prev = 87;
              _context80.t5 = _context80["catch"](2);
              console.error("Error from adding users", _context80.t5);
              _context80.next = 92;
              return (0, _updateSyncingStatusGroups.updateSyncingStatusOfGroups)(groupId, companyId);
            case 92:
              done();
            case 93:
            case "end":
              return _context80.stop();
          }
        }, _callee74, null, [[2, 87], [25, 73, 76, 79]]);
      }));
      return function (_x128, _x129) {
        return _ref76.apply(this, arguments);
      };
    }());
    queue.process('update-bulk-users', /*#__PURE__*/function () {
      var _ref77 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee75(job, done) {
        var _job$data47, companyId, userDetails, userUpdates, adminUpdates, employeeUpdates;
        return _regenerator["default"].wrap(function _callee75$(_context81) {
          while (1) switch (_context81.prev = _context81.next) {
            case 0:
              _context81.prev = 0;
              _job$data47 = job.data, companyId = _job$data47.companyId, userDetails = _job$data47.userDetails;
              if (!(!userDetails || userDetails.length === 0)) {
                _context81.next = 4;
                break;
              }
              return _context81.abrupt("return", done());
            case 4:
              userUpdates = [];
              adminUpdates = [];
              employeeUpdates = [];
              userDetails.forEach(function (_ref78) {
                var tacIdentityKey = _ref78.tacIdentityKey,
                  firstname = _ref78.firstname,
                  lastname = _ref78.lastname,
                  phone = _ref78.phone;
                userUpdates.push({
                  updateOne: {
                    filter: {
                      companyId: companyId,
                      tacIdentityKey: tacIdentityKey
                    },
                    update: {
                      $set: {
                        tacIdentityKey: tacIdentityKey,
                        name: firstname + lastname,
                        phoneNumber: phone
                      }
                    }
                  }
                });
                adminUpdates.push({
                  updateOne: {
                    filter: {
                      companyId: companyId,
                      tacIdentityKey: tacIdentityKey
                    },
                    update: {
                      $set: {
                        tacIdentityKey: tacIdentityKey,
                        firstName: firstname,
                        lastName: lastname
                      }
                    }
                  }
                });
                employeeUpdates.push({
                  updateOne: {
                    filter: {
                      companyId: companyId,
                      tacIdentityKey: tacIdentityKey
                    },
                    update: {
                      $set: {
                        tacIdentityKey: tacIdentityKey,
                        firstName: firstname,
                        lastName: lastname
                      }
                    }
                  }
                });
              });
              _context81.next = 10;
              return Promise.all([userUpdates.length ? db.User.bulkWrite(userUpdates) : Promise.resolve(), adminUpdates.length ? db.Admin.bulkWrite(adminUpdates) : Promise.resolve(), employeeUpdates.length ? db.Employee.bulkWrite(employeeUpdates) : Promise.resolve()]);
            case 10:
              console.log('Bulk update successful');
              done();
              _context81.next = 18;
              break;
            case 14:
              _context81.prev = 14;
              _context81.t0 = _context81["catch"](0);
              console.error('Bulk update failed:', _context81.t0);
              done(_context81.t0);
            case 18:
            case "end":
              return _context81.stop();
          }
        }, _callee75, null, [[0, 14]]);
      }));
      return function (_x130, _x131) {
        return _ref77.apply(this, arguments);
      };
    }());
    /*
            queue.process('inject-banner-outlook', 10, async (job, done) => {
                console.log('Processing banner injection job for Outlook');
                const { userPrincipalName, messageId, companyId, domainId } = job.data;
                console.log({userPrincipalName, messageId, companyId, domainId})
                try {
                    const meta = await db.MetaData.findOne({ companyId, name: 'BannerMessage' });
                    if (!meta || !meta.value) return done();
                    const reported = await db.ReportedMail.findOne({ messageId }, 'isBannerInjected');
                    if (reported && reported.isBannerInjected) return done();
                    const { token } = await Credentials.getCredentials(companyId, domainId);
                    const access_token = token.access_token;
                    const bannerHtml = bannerTemplate(meta.value.trim());
                    console.log('Banner HTML:', bannerHtml);
                    const { data: msg } = await axios.get(
                        `https://graph.microsoft.com/v1.0/users/${encodeURIComponent(userPrincipalName)}/messages/${messageId}?$select=body`,
                        { headers: { Authorization: `Bearer ${access_token}` } }
                    );
                    const original = msg.body?.content || '';
    
                    if (original.startsWith(bannerHtml)) return done();
                    console.log('Injecting banner into email body');
                    console.log('final body:', bannerHtml + original);
                    await axios.patch(
                        `https://graph.microsoft.com/v1.0/users/${encodeURIComponent(userPrincipalName)}/messages/${messageId}`,
                        { body: { contentType: 'HTML', content: bannerHtml + original } },
                        { headers: { Authorization: `Bearer ${access_token}`, 'Content-Type': 'application/json' } }
                    );
                    console.log('Banner injected successfully');
                    await db.ReportedMail.updateOne({ messageId }, { $set: { isBannerInjected: true } });
                    done();
                } catch (err) {
                    if (err.response?.data?.error?.code === 'ErrorItemNotFound') {
                        console.warn(`Message ${messageId} no longer exists – skipping banner`);
                        return done();
                    }
                    console.error('Banner inject error', err.response?.data || err);
                    done(err);
                }
            });
            
    */
  }
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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