"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.htmlsanitize = void 0;
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _sanitizeHtml = _interopRequireDefault(require("sanitize-html"));
var sanitizeObj = function sanitizeObj(obj, ignore, req) {
  if (obj != null && ignore.indexOf(obj) == -1 && (0, _typeof2["default"])(obj) === "object") {
    for (var i = 0; i < Object.keys(obj).length; i++) {
      if (ignore.includes(Object.keys(obj)[i])) continue;
      obj[Object.keys(obj)[i]] = sanitizeObj(obj[Object.keys(obj)[i]], ignore, req);
    }
  } else if (obj != null && ignore.indexOf(obj) == -1 && typeof obj === "array") {
    for (var _i = 0; _i < obj.length; _i++) {
      obj[_i] = sanitizeObj(obj[_i], ignore, req);
    }
  } else if (obj != null && ignore.indexOf(obj) == -1 && typeof obj == "string" && obj != "") {
    // obj = req.sanitize(obj).trim();
    obj = (0, _sanitizeHtml["default"])(obj, {
      allowedTags: [],
      // Disallow all HTML tags
      allowedAttributes: {}
    }).trim();
  }
  return obj;
};
var htmlsanitize = function htmlsanitize() {
  var ignore = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  return function (req, res, next) {
    var data = [];
    if (req.body) {
      req.body = sanitizeObj(req.body, ignore, req);
    }
    if (req.params) {
      req.params = sanitizeObj(req.params, ignore, req);
    }
    if (req.query) {
      req.query = sanitizeObj(req.query, ignore, req);
    }
    next();
  };
};
exports.htmlsanitize = htmlsanitize;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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