"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sanitize = void 0;
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var sanitizeObj = function sanitizeObj(obj, ignore, req) {
  if (obj != null && ignore.indexOf(obj) == -1 && (0, _typeof2["default"])(obj) === 'object') {
    for (var i = 0; i < Object.keys(obj).length; i++) {
      if (Object.keys(obj)[i].includes(ignore)) continue;
      obj[Object.keys(obj)[i]] = sanitizeObj(obj[Object.keys(obj)[i]], ignore, req);
    }
  } else if (obj != null && ignore.indexOf(obj) == -1 && typeof obj === 'array') {
    for (var _i = 0; _i < obj.length; _i++) {
      obj[_i] = sanitizeObj(obj[_i], ignore, req);
    }
  } else if (obj != null && ignore.indexOf(obj) == -1 && typeof obj == 'string' && obj != '') {
    obj = req.sanitize(obj).trim();
  }
  return obj;
};
var sanitize = function sanitize() {
  var ignore = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  return function (req, res, next) {
    var data = [];
    if (req.body) {
      req.body = sanitizeObj(req.body, ignore, req);
    }
    if (req.params) {
      req.params = sanitizeObj(req.params, ignore, req);
    }
    if (req.query) {
      req.query = sanitizeObj(req.query, ignore, req);
    }
    next();
  };
};
exports.sanitize = sanitize;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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