"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.localStrategy = exports.jwtStrategy = exports.jwtLogoutStrategy = exports.checkTaConnectionStrategy = exports.checkStrategy = exports.checkLicenseStrategy = exports.checkCompanyValidityStrategy = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _passport = _interopRequireDefault(require("passport"));
var jwtStrategy = function jwtStrategy(req, res, next) {
  _passport["default"].authenticate('jwt', {
    session: false
  }, function (err, user, info) {
    if (err && err == 'session-expired') {
      res.clearCookie('logo');
      res.clearCookie('token');
      res.clearCookie('username');
    }
    if (err && err == 'user') {
      return next(new RequestError('UnAuthorized User', 401));
    }
    if (err && Object.keys(err).length) {
      return next(new RequestError(err, 401));
    }
    if (err) {
      return next(new RequestError('UnAuthorized User', 401));
    }
    if (!user) {
      return next(new RequestError('UnAuthorized User', 401));
    }
    req.user = user;
    next();
  })(req, res, next);
};
exports.jwtStrategy = jwtStrategy;
var jwtLogoutStrategy = function jwtLogoutStrategy(req, res, next) {
  _passport["default"].authenticate('jwt', {
    session: false
  }, function (err, user, info) {
    if (user) {
      req.user = user;
    } else {
      req.user = {};
    }
    next();
  })(req, res, next);
};
exports.jwtLogoutStrategy = jwtLogoutStrategy;
var localStrategy = function localStrategy(req, res, next) {
  _passport["default"].authenticate('User', {
    session: false
  }, function (err, user) {
    if (err && err == 'invalid-email') {
      return next(new RequestError('User email is not valid'));
    }
    if (err && err == 'invalid') {
      return next(new RequestError('User account is not verified'));
    }
    if (err && err == 'inactive') {
      return next(new RequestError('User account is not active'));
    }
    if (err && err == 'otp') {
      return next(new RequestError('Invalid otp'));
    }
    if (err && err == 'password') {
      return next(new RequestError('Invalid credentials'));
    }
    if (err && err == 'attempt') {
      return next(new RequestError('Too many invalid attempts. Please reset your password.'));
    }
    if (err && err == 'undefined-password') {
      return next(new RequestError('User not verified or password not set'));
    }
    if (err && err.startsWith('attempt:')) {
      return next(new RequestError('Invalid Credentials (' + err.split(':')[1] + ' Attempt(s) Left)'));
    }
    if (err) {
      return next(new RequestError(err));
    }
    if (!user) {
      return next(new RequestError('Invalid Credentials'));
    }
    req.user = user;
    next();
  })(req, res, next);
};
exports.localStrategy = localStrategy;
var checkStrategy = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, userLimit, userLimitMessenger, addedUsersCount, remainingUserLimit;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          if (req.user.isLicense) {
            _context.next = 2;
            break;
          }
          return _context.abrupt("return", next(new RequestError("Your license has expired. Please renew it.")));
        case 2:
          companyId = req.user.companyId;
          _context.next = 5;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'userLimit'
          });
        case 5:
          userLimit = _context.sent;
          _context.next = 8;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'userLimitMessenger'
          });
        case 8:
          userLimitMessenger = _context.sent;
          _context.next = 11;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null
          });
        case 11:
          addedUsersCount = _context.sent;
          remainingUserLimit = parseInt(userLimit === null || userLimit === void 0 ? void 0 : userLimit.value) + parseInt(userLimitMessenger === null || userLimitMessenger === void 0 ? void 0 : userLimitMessenger.value) - addedUsersCount;
          if (!(remainingUserLimit <= 0)) {
            _context.next = 15;
            break;
          }
          return _context.abrupt("return", next(new RequestError("User Limit Exceeded!", 429)));
        case 15:
          next();
        case 16:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return function checkStrategy(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
exports.checkStrategy = checkStrategy;
var checkCompanyValidityStrategy = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(req, res, next) {
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          if (req.user.isLicense) {
            _context2.next = 2;
            break;
          }
          return _context2.abrupt("return", next(new RequestError("Your license has expired. Please renew it.")));
        case 2:
          next();
        case 3:
        case "end":
          return _context2.stop();
      }
    }, _callee2);
  }));
  return function checkCompanyValidityStrategy(_x4, _x5, _x6) {
    return _ref2.apply(this, arguments);
  };
}();
exports.checkCompanyValidityStrategy = checkCompanyValidityStrategy;
var checkLicenseStrategy = /*#__PURE__*/function () {
  var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(req, res, next) {
    var companyId, userLimit, userLimitMessenger, addedUsersCount, remainingUserLimit;
    return _regenerator["default"].wrap(function _callee3$(_context3) {
      while (1) switch (_context3.prev = _context3.next) {
        case 0:
          if (req.user.isLicense) {
            _context3.next = 2;
            break;
          }
          return _context3.abrupt("return", next(new RequestError("Your license has expired. Please renew it.")));
        case 2:
          companyId = req.user.companyId;
          _context3.next = 5;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'userLimit'
          });
        case 5:
          userLimit = _context3.sent;
          _context3.next = 8;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'userLimitMessenger'
          });
        case 8:
          userLimitMessenger = _context3.sent;
          _context3.next = 11;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null
          });
        case 11:
          addedUsersCount = _context3.sent;
          remainingUserLimit = parseInt(userLimit === null || userLimit === void 0 ? void 0 : userLimit.value) + parseInt(userLimitMessenger === null || userLimitMessenger === void 0 ? void 0 : userLimitMessenger.value) - addedUsersCount;
          if (!(remainingUserLimit <= 0)) {
            _context3.next = 15;
            break;
          }
          return _context3.abrupt("return", next(new RequestError("User Limit Exceeded!", 429)));
        case 15:
          next();
        case 16:
        case "end":
          return _context3.stop();
      }
    }, _callee3);
  }));
  return function checkLicenseStrategy(_x7, _x8, _x9) {
    return _ref3.apply(this, arguments);
  };
}();
exports.checkLicenseStrategy = checkLicenseStrategy;
var checkTaConnectionStrategy = /*#__PURE__*/function () {
  var _ref4 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(req, res, next) {
    var company;
    return _regenerator["default"].wrap(function _callee4$(_context4) {
      while (1) switch (_context4.prev = _context4.next) {
        case 0:
          _context4.next = 2;
          return db.Company.findOne({
            _id: req.user.companyId,
            deletedAt: null
          });
        case 2:
          company = _context4.sent;
          if (!company.isTacEnabled) {
            _context4.next = 5;
            break;
          }
          return _context4.abrupt("return", next(new RequestError("Kindly continue this operation on TA!")));
        case 5:
          if (!company.isTaConnectionInProgess) {
            _context4.next = 9;
            break;
          }
          return _context4.abrupt("return", next(new RequestError("TA conncetion in progress please wait!")));
        case 9:
          next();
        case 10:
        case "end":
          return _context4.stop();
      }
    }, _callee4);
  }));
  return function checkTaConnectionStrategy(_x10, _x11, _x12) {
    return _ref4.apply(this, arguments);
  };
}();
exports.checkTaConnectionStrategy = checkTaConnectionStrategy;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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