"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateBody = void 0;
var validateBody = function validateBody(schema) {
  return function (req, res, next) {
    try {
      console.log(req.method != 'GET' && req.method != 'DELETE' ? req.body : req.query);
      var result = req.method != 'GET' && req.method != 'DELETE' ? schema.validate(req.body) : schema.validate(req.query);
      if (result.error) {
        var errors = [];
        for (var i = 0; i < result.error.details.length; i++) {
          errors.push(result.error.details[i].message);
        }
        next(new RequestError(errors, 400));
      }
      next();
    } catch (error) {
      console.log(error);
      next(error);
    }
  };
};
exports.validateBody = validateBody;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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