"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _mongoose = _interopRequireDefault(require("mongoose"));
var adminSchema = new _mongoose["default"].Schema({
  firstName: {
    type: String,
    required: true,
    trim: true
  },
  lastName: {
    type: String,
    trim: true
  },
  email: {
    type: String,
    required: true,
    unique: true,
    trim: true,
    set: function set(value) {
      return value.toLowerCase();
    }
  },
  password: {
    type: String,
    trim: true
  },
  phone: {
    type: String,
    trim: true
  },
  tacIdentityKey: {
    type: String,
    "default": null
  },
  isActive: {
    type: Boolean,
    "default": false
  },
  isVerify: {
    type: Boolean,
    "default": false
  },
  verfKey: {
    type: String,
    "default": null
  },
  verfKeyExpiry: {
    type: Date,
    "default": null
  },
  companyId: {
    type: _mongoose["default"].Schema.ObjectId,
    ref: 'Company'
  },
  attempt: {
    type: Number,
    "default": 0
  },
  security: {
    status: {
      type: Boolean,
      "default": false
    },
    otpType: {
      type: String,
      "default": 'MAIL'
    },
    otp: {
      type: String,
      "default": null
    },
    tOtpKey: {
      type: String,
      "default": null
    },
    otpExpiry: {
      type: Date,
      "default": null
    }
  },
  loggedIn: {
    type: Boolean,
    "default": false
  },
  deletedAt: {
    type: Date,
    "default": null
  }
}, {
  timestamps: true
});
adminSchema.pre('find', function (next) {
  if (this._conditions.email && typeof this._conditions.email === 'string') {
    this._conditions.email = this._conditions.email.toLowerCase();
  }
  next();
});
adminSchema.pre('findOne', function (next) {
  if (this._conditions.email && typeof this._conditions.email === 'string') {
    this._conditions.email = this._conditions.email.toLowerCase();
  }
  next();
});
adminSchema.pre('save', function (next) {
  if (this.email && typeof this.email === 'string') {
    this.email = this.email.toLowerCase();
  }
  next();
});
adminSchema.pre('updateOne', function (next) {
  if (this._update.email && typeof this._update.email === 'string') {
    this._update.email = this._update.email.toLowerCase();
  }
  next();
});
var _default = _mongoose["default"].model('Admin', adminSchema);
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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