"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _mongoose = _interopRequireDefault(require("mongoose"));
var advanceSearchSchema = new _mongoose["default"].Schema({
  from: {
    type: String
  },
  to: {
    type: String,
    "default": ''
  },
  subject: {
    type: String,
    "default": ''
  },
  fromDate: {
    type: Date
  },
  toDate: {
    type: Date
  },
  filter: {
    type: String,
    "default": ''
  },
  isError: {
    type: Boolean,
    "default": false
  },
  isErrorMessage: {
    type: String,
    "default": ''
  },
  isProcessing: {
    type: Boolean,
    "default": true
  },
  syncStartAt: Date,
  syncEndAt: Date,
  domainId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'Domain'
  },
  companyId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'Company'
  },
  deletedAt: {
    type: Date,
    "default": null
  }
}, {
  timestamps: true
});
advanceSearchSchema.index({
  from: 'text',
  to: 'text',
  subject: 'text'
});
var _default = _mongoose["default"].model('AdvanceSearch', advanceSearchSchema);
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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