"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _mongoose = _interopRequireDefault(require("mongoose"));
var advanceSearchEmailSchema = new _mongoose["default"].Schema({
  from: {
    type: String
  },
  fromName: {
    type: String,
    "default": ''
  },
  to: {
    type: Array,
    "default": []
  },
  cc: {
    type: Array,
    "default": []
  },
  mailRecievedTime: {
    type: Date
  },
  body: {
    type: String
  },
  subject: {
    type: String,
    "default": ''
  },
  messageId: {
    type: String
  },
  threadId: String,
  isTrashed: {
    type: Boolean,
    "default": false
  },
  userId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'User'
  },
  domainId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'Domain'
  },
  companyId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'Company'
  },
  advanceSearchId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'AdvanceSearch'
  },
  deletedAt: {
    type: Date,
    "default": null
  }
}, {
  timestamps: true
});
advanceSearchEmailSchema.index({
  from: 'text',
  to: 'text',
  subject: 'text'
});
var _default = _mongoose["default"].model('AdvanceSearchEmail', advanceSearchEmailSchema);
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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