"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _mongoose = _interopRequireDefault(require("mongoose"));
var attachmentSchema = new _mongoose["default"].Schema({
  attachmentId: {
    type: String,
    require: true
  },
  fileName: {
    type: String,
    trim: true
  },
  originalName: {
    type: String,
    trim: true
  },
  mimeType: {
    type: String,
    trim: true
  },
  attachmentType: {
    type: String,
    trim: true
  },
  status: {
    type: String,
    "enum": ['NOT SCANNED', 'IN PROGRESS', 'COMPLETED', 'FAILED'],
    "default": 'NOT SCANNED'
  },
  result: {
    type: _mongoose["default"].Schema.Types.Mixed,
    "default": null
  },
  details: {
    type: _mongoose["default"].Schema.Types.Mixed,
    "default": null
  },
  scanId: {
    type: String
  },
  score: {
    type: Number
  },
  reportedMailId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'ReportedMail'
  },
  companyId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'Company'
  },
  isInfected: {
    type: Boolean
  },
  viruses: {
    type: Array
  }
}, {
  timestamps: true
});
var _default = _mongoose["default"].model('Attachment', attachmentSchema);
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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