"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _mongoose = _interopRequireDefault(require("mongoose"));
var checkEmailScoreEventSchema = new _mongoose["default"].Schema({
  from: {
    type: String,
    trim: true,
    required: true
  },
  fromName: {
    type: String,
    trim: true
  },
  to: {
    type: String,
    trim: true,
    required: true
  },
  toName: {
    type: String,
    trim: true
  },
  otherTo: {
    type: Array
  },
  subject: {
    type: String,
    trim: true
  },
  score: {
    type: Number,
    "default": 0
  },
  mailId: {
    type: String,
    required: true
  },
  messageId: {
    type: String,
    required: true
  },
  mailRecievedTime: {
    type: Date
  },
  mailType: {
    type: String,
    trim: true
  },
  headerDetails: {
    type: Object
  },
  companyId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'Company'
  }
}, {
  timestamps: true
});
checkEmailScoreEventSchema.index({
  from: 'text',
  to: 'text',
  fromName: 'text',
  subject: 'text'
});
var _default = _mongoose["default"].model('CheckEmailScoreEvent', checkEmailScoreEventSchema);
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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