"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _fs = require("fs");
var _mongoose = _interopRequireDefault(require("mongoose"));
var domainSchema = new _mongoose["default"].Schema({
  domainName: {
    type: String,
    require: true,
    trim: true
  },
  txtRecord: {
    type: String,
    trim: true
  },
  isVerified: {
    type: Boolean,
    "default": false
  },
  companyId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'Company'
  },
  domainType: {
    type: String,
    "default": 'Outlook'
  },
  webhookEmail: {
    type: String,
    "default": null
  },
  isCredential: {
    type: Boolean,
    "default": false
  },
  credential: {
    type: Object
  },
  isSyncingUser: {
    type: Boolean,
    "default": false
  },
  isSyncingUserError: {
    type: Boolean,
    "default": false
  },
  isSyncingUserErrorFile: {
    type: String,
    "default": null
  },
  isScheduledSyncing: {
    isActive: {
      type: Boolean,
      "default": false
    },
    daysOfWeek: {
      type: [String],
      "default": []
    },
    timeZone: {
      type: String,
      "default": null
    },
    hour: {
      type: String,
      "default": null
    },
    minute: {
      type: String,
      "default": null
    },
    syncType: {
      type: String,
      "enum": ['All Users', 'Specific Groups'],
      "default": 'All Users'
    },
    groupIds: {
      type: [Object],
      "default": []
    },
    lastSync: {
      type: Date,
      "default": null
    },
    isUserSyncMirrored: {
      type: Boolean,
      "default": false
    }
  },
  domainTypeForOutlook: {
    type: String,
    "enum": ['OFFICE365', 'EXCHANGE', null, 'null'],
    "default": 'OFFICE365'
  },
  syncStartAt: Date,
  syncEndAt: Date,
  lastAllUsersSyncAt: {
    type: Date,
    "default": null
  },
  webhookAccessKey: {
    type: String,
    "default": null
  },
  deletedAt: {
    type: Date,
    "default": null
  }
}, {
  timestamps: true
});
domainSchema.pre('save', function (next) {
  if (this.domainName) {
    this.domainName = this.domainName.toLowerCase();
  }
  next();
});
var _default = _mongoose["default"].model('Domain', domainSchema);
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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