"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _mongoose = _interopRequireDefault(require("mongoose"));
var employeeSchema = new _mongoose["default"].Schema({
  firstName: {
    type: String,
    required: true,
    trim: true
  },
  lastName: {
    type: String,
    trim: true
  },
  email: {
    type: String,
    required: true,
    trim: true,
    set: function set(value) {
      return value.toLowerCase();
    } // Automatically set email to lowercase
  },

  password: {
    type: String,
    trim: true
  },
  phone: {
    type: String,
    trim: true
  },
  tacIdentityKey: {
    type: String,
    "default": null
  },
  isActive: {
    type: Boolean,
    "default": false
  },
  isVerify: {
    type: Boolean,
    "default": false
  },
  verfKey: {
    type: String,
    "default": null
  },
  verfKeyExpiry: {
    type: Date,
    "default": null
  },
  companyId: {
    type: _mongoose["default"].Schema.ObjectId,
    ref: 'Company'
  },
  attempt: {
    type: Number,
    "default": 0
  },
  security: {
    status: {
      type: Boolean,
      "default": false
    },
    otpType: {
      type: String,
      "default": 'MAIL'
    },
    otp: {
      type: String,
      "default": null
    },
    tOtpKey: {
      type: String,
      "default": null
    },
    otpExpiry: {
      type: Date,
      "default": null
    }
  },
  loggedIn: {
    type: Boolean,
    "default": false
  },
  deletedAt: {
    type: Date,
    "default": null
  }
}, {
  timestamps: true
});
employeeSchema.pre('find', function (next) {
  if (this._conditions.email && typeof this._conditions.email === 'string') {
    this._conditions.email = this._conditions.email.toLowerCase();
  }
  next();
});
employeeSchema.pre('findOne', function (next) {
  if (this._conditions.email && typeof this._conditions.email === 'string') {
    this._conditions.email = this._conditions.email.toLowerCase();
  }
  next();
});
employeeSchema.pre('save', function (next) {
  if (this.email && typeof this.email === 'string') {
    this.email = this.email.toLowerCase();
  }
  next();
});
employeeSchema.pre('updateOne', function (next) {
  if (this._update.email && typeof this._update.email === 'string') {
    this._update.email = this._update.email.toLowerCase();
  }
  next();
});
var _default = _mongoose["default"].model('Employee', employeeSchema);
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJlbXBsb3llZVNjaGVtYSIsIm1vbmdvb3NlIiwiU2NoZW1hIiwiZmlyc3ROYW1lIiwidHlwZSIsIlN0cmluZyIsInJlcXVpcmVkIiwidHJpbSIsImxhc3ROYW1lIiwiZW1haWwiLCJzZXQiLCJ2YWx1ZSIsInRvTG93ZXJDYXNlIiwicGFzc3dvcmQiLCJwaG9uZSIsInRhY0lkZW50aXR5S2V5IiwiaXNBY3RpdmUiLCJCb29sZWFuIiwiaXNWZXJpZnkiLCJ2ZXJmS2V5IiwidmVyZktleUV4cGlyeSIsIkRhdGUiLCJjb21wYW55SWQiLCJPYmplY3RJZCIsInJlZiIsImF0dGVtcHQiLCJOdW1iZXIiLCJzZWN1cml0eSIsInN0YXR1cyIsIm90cFR5cGUiLCJvdHAiLCJ0T3RwS2V5Iiwib3RwRXhwaXJ5IiwibG9nZ2VkSW4iLCJkZWxldGVkQXQiLCJ0aW1lc3RhbXBzIiwicHJlIiwibmV4dCIsIl9jb25kaXRpb25zIiwiX3VwZGF0ZSIsIm1vZGVsIl0sInNvdXJjZXMiOlsiLi4vLi4vc3JjL21vZGVscy9lbXBsb3llZS5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgbW9uZ29vc2UgZnJvbSAnbW9uZ29vc2UnO1xuXG5jb25zdCBlbXBsb3llZVNjaGVtYSA9IG5ldyBtb25nb29zZS5TY2hlbWEoe1xuXHRmaXJzdE5hbWU6IHtcblx0XHR0eXBlOiBTdHJpbmcsIHJlcXVpcmVkOiB0cnVlLCB0cmltOiB0cnVlXG5cdH0sXG5cdGxhc3ROYW1lOiB7XG5cdFx0dHlwZTogU3RyaW5nLCB0cmltOiB0cnVlXG5cdH0sXG5cdGVtYWlsOiB7XG5cdFx0dHlwZTogU3RyaW5nLCByZXF1aXJlZDogdHJ1ZSwgdHJpbTogdHJ1ZSxcblx0XHRzZXQ6ICh2YWx1ZSkgPT4gdmFsdWUudG9Mb3dlckNhc2UoKSAvLyBBdXRvbWF0aWNhbGx5IHNldCBlbWFpbCB0byBsb3dlcmNhc2Vcblx0fSxcblx0cGFzc3dvcmQ6IHtcblx0XHR0eXBlOiBTdHJpbmcsIHRyaW06IHRydWVcblx0fSxcblx0cGhvbmU6IHtcblx0XHR0eXBlOiBTdHJpbmcsIHRyaW06IHRydWVcblx0fSxcblx0dGFjSWRlbnRpdHlLZXk6IHsgdHlwZTogU3RyaW5nLCBkZWZhdWx0OiBudWxsIH0sXG5cdGlzQWN0aXZlOiB7IHR5cGU6IEJvb2xlYW4sIGRlZmF1bHQ6IGZhbHNlIH0sXG5cdGlzVmVyaWZ5OiB7IHR5cGU6IEJvb2xlYW4sIGRlZmF1bHQ6IGZhbHNlIH0sXG5cdHZlcmZLZXk6IHsgdHlwZTogU3RyaW5nLCBkZWZhdWx0OiBudWxsIH0sXG5cdHZlcmZLZXlFeHBpcnk6IHsgdHlwZTogRGF0ZSwgZGVmYXVsdDogbnVsbCB9LFxuXHRjb21wYW55SWQ6IHsgdHlwZTogbW9uZ29vc2UuU2NoZW1hLk9iamVjdElkLCByZWY6ICdDb21wYW55JyB9LFxuXHRhdHRlbXB0OiB7IHR5cGU6IE51bWJlciwgZGVmYXVsdDogMCB9LFxuXHRzZWN1cml0eToge1xuXHRcdHN0YXR1czoge1xuXHRcdFx0dHlwZTogQm9vbGVhbiwgZGVmYXVsdDogZmFsc2Vcblx0XHR9LFxuXHRcdG90cFR5cGU6IHtcblx0XHRcdHR5cGU6IFN0cmluZywgZGVmYXVsdDogJ01BSUwnXG5cdFx0fSxcblx0XHRvdHA6IHtcblx0XHRcdHR5cGU6IFN0cmluZywgZGVmYXVsdDogbnVsbFxuXHRcdH0sXG5cdFx0dE90cEtleToge1xuXHRcdFx0dHlwZTogU3RyaW5nLCBkZWZhdWx0OiBudWxsXG5cdFx0fSxcblx0XHRvdHBFeHBpcnk6IHtcblx0XHRcdHR5cGU6IERhdGUsIGRlZmF1bHQ6IG51bGxcblx0XHR9XG5cdH0sXHRcblx0bG9nZ2VkSW46IHt0eXBlOiBCb29sZWFuLCBkZWZhdWx0OiBmYWxzZX0sXG5cdGRlbGV0ZWRBdDogeyB0eXBlOiBEYXRlLCBkZWZhdWx0OiBudWxsIH1cbn0se1xuICAgIHRpbWVzdGFtcHM6IHRydWUsXG59KTtcblxuZW1wbG95ZWVTY2hlbWEucHJlKCdmaW5kJywgZnVuY3Rpb24gKG5leHQpIHtcblx0aWYgKHRoaXMuX2NvbmRpdGlvbnMuZW1haWwgJiYgdHlwZW9mIHRoaXMuX2NvbmRpdGlvbnMuZW1haWwgPT09ICdzdHJpbmcnKSB7XG5cdFx0dGhpcy5fY29uZGl0aW9ucy5lbWFpbCA9IHRoaXMuX2NvbmRpdGlvbnMuZW1haWwudG9Mb3dlckNhc2UoKTtcblx0fVxuXHRuZXh0KCk7XG59KTtcblxuZW1wbG95ZWVTY2hlbWEucHJlKCdmaW5kT25lJywgZnVuY3Rpb24gKG5leHQpIHtcblx0aWYgKHRoaXMuX2NvbmRpdGlvbnMuZW1haWwgJiYgdHlwZW9mIHRoaXMuX2NvbmRpdGlvbnMuZW1haWwgPT09ICdzdHJpbmcnKSB7XG5cdFx0dGhpcy5fY29uZGl0aW9ucy5lbWFpbCA9IHRoaXMuX2NvbmRpdGlvbnMuZW1haWwudG9Mb3dlckNhc2UoKTtcblx0fVxuXHRuZXh0KCk7XG59KTtcblxuZW1wbG95ZWVTY2hlbWEucHJlKCdzYXZlJywgZnVuY3Rpb24gKG5leHQpIHtcblx0aWYgKHRoaXMuZW1haWwgJiYgdHlwZW9mIHRoaXMuZW1haWwgPT09ICdzdHJpbmcnKSB7XG5cdFx0dGhpcy5lbWFpbCA9IHRoaXMuZW1haWwudG9Mb3dlckNhc2UoKTtcblx0fVxuXHRuZXh0KCk7XG59KTtcblxuZW1wbG95ZWVTY2hlbWEucHJlKCd1cGRhdGVPbmUnLCBmdW5jdGlvbiAobmV4dCkge1xuXHRpZiAodGhpcy5fdXBkYXRlLmVtYWlsICYmIHR5cGVvZiB0aGlzLl91cGRhdGUuZW1haWwgPT09ICdzdHJpbmcnKSB7XG5cdFx0dGhpcy5fdXBkYXRlLmVtYWlsID0gdGhpcy5fdXBkYXRlLmVtYWlsLnRvTG93ZXJDYXNlKCk7XG5cdH1cblx0bmV4dCgpO1xufSk7XG5cbmV4cG9ydCBkZWZhdWx0IG1vbmdvb3NlLm1vZGVsKCdFbXBsb3llZScsIGVtcGxveWVlU2NoZW1hKTtcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBO0FBRUEsSUFBTUEsY0FBYyxHQUFHLElBQUlDLG9CQUFRLENBQUNDLE1BQU0sQ0FBQztFQUMxQ0MsU0FBUyxFQUFFO0lBQ1ZDLElBQUksRUFBRUMsTUFBTTtJQUFFQyxRQUFRLEVBQUUsSUFBSTtJQUFFQyxJQUFJLEVBQUU7RUFDckMsQ0FBQztFQUNEQyxRQUFRLEVBQUU7SUFDVEosSUFBSSxFQUFFQyxNQUFNO0lBQUVFLElBQUksRUFBRTtFQUNyQixDQUFDO0VBQ0RFLEtBQUssRUFBRTtJQUNOTCxJQUFJLEVBQUVDLE1BQU07SUFBRUMsUUFBUSxFQUFFLElBQUk7SUFBRUMsSUFBSSxFQUFFLElBQUk7SUFDeENHLEdBQUcsRUFBRSxhQUFDQyxLQUFLO01BQUEsT0FBS0EsS0FBSyxDQUFDQyxXQUFXLEVBQUU7SUFBQSxFQUFDO0VBQ3JDLENBQUM7O0VBQ0RDLFFBQVEsRUFBRTtJQUNUVCxJQUFJLEVBQUVDLE1BQU07SUFBRUUsSUFBSSxFQUFFO0VBQ3JCLENBQUM7RUFDRE8sS0FBSyxFQUFFO0lBQ05WLElBQUksRUFBRUMsTUFBTTtJQUFFRSxJQUFJLEVBQUU7RUFDckIsQ0FBQztFQUNEUSxjQUFjLEVBQUU7SUFBRVgsSUFBSSxFQUFFQyxNQUFNO0lBQUUsV0FBUztFQUFLLENBQUM7RUFDL0NXLFFBQVEsRUFBRTtJQUFFWixJQUFJLEVBQUVhLE9BQU87SUFBRSxXQUFTO0VBQU0sQ0FBQztFQUMzQ0MsUUFBUSxFQUFFO0lBQUVkLElBQUksRUFBRWEsT0FBTztJQUFFLFdBQVM7RUFBTSxDQUFDO0VBQzNDRSxPQUFPLEVBQUU7SUFBRWYsSUFBSSxFQUFFQyxNQUFNO0lBQUUsV0FBUztFQUFLLENBQUM7RUFDeENlLGFBQWEsRUFBRTtJQUFFaEIsSUFBSSxFQUFFaUIsSUFBSTtJQUFFLFdBQVM7RUFBSyxDQUFDO0VBQzVDQyxTQUFTLEVBQUU7SUFBRWxCLElBQUksRUFBRUgsb0JBQVEsQ0FBQ0MsTUFBTSxDQUFDcUIsUUFBUTtJQUFFQyxHQUFHLEVBQUU7RUFBVSxDQUFDO0VBQzdEQyxPQUFPLEVBQUU7SUFBRXJCLElBQUksRUFBRXNCLE1BQU07SUFBRSxXQUFTO0VBQUUsQ0FBQztFQUNyQ0MsUUFBUSxFQUFFO0lBQ1RDLE1BQU0sRUFBRTtNQUNQeEIsSUFBSSxFQUFFYSxPQUFPO01BQUUsV0FBUztJQUN6QixDQUFDO0lBQ0RZLE9BQU8sRUFBRTtNQUNSekIsSUFBSSxFQUFFQyxNQUFNO01BQUUsV0FBUztJQUN4QixDQUFDO0lBQ0R5QixHQUFHLEVBQUU7TUFDSjFCLElBQUksRUFBRUMsTUFBTTtNQUFFLFdBQVM7SUFDeEIsQ0FBQztJQUNEMEIsT0FBTyxFQUFFO01BQ1IzQixJQUFJLEVBQUVDLE1BQU07TUFBRSxXQUFTO0lBQ3hCLENBQUM7SUFDRDJCLFNBQVMsRUFBRTtNQUNWNUIsSUFBSSxFQUFFaUIsSUFBSTtNQUFFLFdBQVM7SUFDdEI7RUFDRCxDQUFDO0VBQ0RZLFFBQVEsRUFBRTtJQUFDN0IsSUFBSSxFQUFFYSxPQUFPO0lBQUUsV0FBUztFQUFLLENBQUM7RUFDekNpQixTQUFTLEVBQUU7SUFBRTlCLElBQUksRUFBRWlCLElBQUk7SUFBRSxXQUFTO0VBQUs7QUFDeEMsQ0FBQyxFQUFDO0VBQ0VjLFVBQVUsRUFBRTtBQUNoQixDQUFDLENBQUM7QUFFRm5DLGNBQWMsQ0FBQ29DLEdBQUcsQ0FBQyxNQUFNLEVBQUUsVUFBVUMsSUFBSSxFQUFFO0VBQzFDLElBQUksSUFBSSxDQUFDQyxXQUFXLENBQUM3QixLQUFLLElBQUksT0FBTyxJQUFJLENBQUM2QixXQUFXLENBQUM3QixLQUFLLEtBQUssUUFBUSxFQUFFO0lBQ3pFLElBQUksQ0FBQzZCLFdBQVcsQ0FBQzdCLEtBQUssR0FBRyxJQUFJLENBQUM2QixXQUFXLENBQUM3QixLQUFLLENBQUNHLFdBQVcsRUFBRTtFQUM5RDtFQUNBeUIsSUFBSSxFQUFFO0FBQ1AsQ0FBQyxDQUFDO0FBRUZyQyxjQUFjLENBQUNvQyxHQUFHLENBQUMsU0FBUyxFQUFFLFVBQVVDLElBQUksRUFBRTtFQUM3QyxJQUFJLElBQUksQ0FBQ0MsV0FBVyxDQUFDN0IsS0FBSyxJQUFJLE9BQU8sSUFBSSxDQUFDNkIsV0FBVyxDQUFDN0IsS0FBSyxLQUFLLFFBQVEsRUFBRTtJQUN6RSxJQUFJLENBQUM2QixXQUFXLENBQUM3QixLQUFLLEdBQUcsSUFBSSxDQUFDNkIsV0FBVyxDQUFDN0IsS0FBSyxDQUFDRyxXQUFXLEVBQUU7RUFDOUQ7RUFDQXlCLElBQUksRUFBRTtBQUNQLENBQUMsQ0FBQztBQUVGckMsY0FBYyxDQUFDb0MsR0FBRyxDQUFDLE1BQU0sRUFBRSxVQUFVQyxJQUFJLEVBQUU7RUFDMUMsSUFBSSxJQUFJLENBQUM1QixLQUFLLElBQUksT0FBTyxJQUFJLENBQUNBLEtBQUssS0FBSyxRQUFRLEVBQUU7SUFDakQsSUFBSSxDQUFDQSxLQUFLLEdBQUcsSUFBSSxDQUFDQSxLQUFLLENBQUNHLFdBQVcsRUFBRTtFQUN0QztFQUNBeUIsSUFBSSxFQUFFO0FBQ1AsQ0FBQyxDQUFDO0FBRUZyQyxjQUFjLENBQUNvQyxHQUFHLENBQUMsV0FBVyxFQUFFLFVBQVVDLElBQUksRUFBRTtFQUMvQyxJQUFJLElBQUksQ0FBQ0UsT0FBTyxDQUFDOUIsS0FBSyxJQUFJLE9BQU8sSUFBSSxDQUFDOEIsT0FBTyxDQUFDOUIsS0FBSyxLQUFLLFFBQVEsRUFBRTtJQUNqRSxJQUFJLENBQUM4QixPQUFPLENBQUM5QixLQUFLLEdBQUcsSUFBSSxDQUFDOEIsT0FBTyxDQUFDOUIsS0FBSyxDQUFDRyxXQUFXLEVBQUU7RUFDdEQ7RUFDQXlCLElBQUksRUFBRTtBQUNQLENBQUMsQ0FBQztBQUFDLGVBRVlwQyxvQkFBUSxDQUFDdUMsS0FBSyxDQUFDLFVBQVUsRUFBRXhDLGNBQWMsQ0FBQztBQUFBIn0=