"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _mongoose = _interopRequireDefault(require("mongoose"));
var groupsSchema = new _mongoose["default"].Schema({
  groupName: {
    type: String,
    require: true,
    trim: true
  },
  tacIdentityKey: {
    type: String,
    "default": null
  },
  type: {
    type: String,
    "enum": ['Admin', 'Custom'],
    "default": "Custom"
  },
  groupId: {
    type: String,
    "default": null
  },
  domainId: {
    type: String,
    "default": null
  },
  companyId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'Company'
  },
  isDefaultGroup: {
    type: Boolean,
    "default": false
  },
  emailAccess: {
    type: Boolean,
    "default": false
  },
  messengerAccess: {
    type: Boolean,
    "default": false
  },
  isSyncingUsers: {
    type: Boolean,
    "default": false
  },
  lastSyncId: {
    type: String,
    "default": null
  },
  lastSyncIdMismatch: {
    type: Boolean,
    "default": false
  },
  isADSynced: {
    type: Boolean,
    "default": false
  },
  deletedAt: {
    type: Date,
    "default": null
  }
}, {
  timestamps: true
});
var _default = _mongoose["default"].model('Group', groupsSchema);
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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