"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _mongoose = _interopRequireDefault(require("mongoose"));
var _mongoose$Schema;
var reportedMailSchema = new _mongoose["default"].Schema((_mongoose$Schema = {
  from: {
    type: String,
    trim: true
  },
  fromName: {
    type: String,
    trim: true
  },
  to: {
    type: String,
    trim: true
  },
  toName: {
    type: String,
    trim: true
  },
  otherTo: {
    type: Array,
    "default": []
  },
  cc: {
    type: Array,
    "default": []
  },
  bcc: {
    type: Array,
    "default": []
  },
  subject: {
    type: String,
    trim: true
  },
  mailId: {
    type: String
  },
  messageId: {
    type: String
  },
  internetMessageId: {
    type: String
  },
  mailRecievedTime: {
    type: Date
  },
  mailType: {
    type: String,
    trim: true
  },
  fileName: {
    type: String,
    "default": null
  },
  header: {
    type: String
  },
  parsedHeader: {
    type: _mongoose["default"].Schema.Types.Mixed,
    "default": null
  },
  headerDetails: {
    type: Object
  },
  body: {
    type: String
  },
  syncStartAt: Date,
  syncEndAt: Date,
  spamScore: {
    type: Number,
    "default": 0
  },
  reporters: [{
    email: {
      type: String,
      trim: true
    },
    folderId: {
      type: String,
      trim: true
    }
  }],
  senderDomain: {
    type: String,
    "default": ''
  },
  senderDomainDeceptive: {
    type: Boolean,
    "default": false
  },
  dnsbl: {
    type: _mongoose["default"].Schema.Types.Mixed,
    "default": null
  },
  isRecoveredEmail: {
    type: String,
    "default": false
  },
  isTrashedEmail: {
    type: String,
    "default": false
  },
  isDeletedEmail: {
    type: String,
    "default": false
  },
  isWhoElseError: {
    type: String,
    "default": false
  },
  isWhoElseErrorMessage: {
    type: String,
    "default": ''
  },
  isWhoElseProcessing: {
    type: Boolean,
    "default": false
  },
  isWhoElseCompleted: {
    type: Boolean,
    "default": false
  },
  isMailActionProcessing: {
    type: String,
    "default": null
  },
  isSimilarEmailError: {
    type: String,
    "default": false
  },
  isSimiliarEmailErrorMessage: {
    type: String,
    "default": ''
  },
  isSimiliarEmailProcessing: {
    type: Boolean,
    "default": false
  },
  isSimiliarEmailCompleted: {
    type: Boolean,
    "default": false
  }
}, (0, _defineProperty2["default"])(_mongoose$Schema, "isMailActionProcessing", {
  type: String,
  "default": null
}), (0, _defineProperty2["default"])(_mongoose$Schema, "languages", {
  type: Array,
  "default": null
}), (0, _defineProperty2["default"])(_mongoose$Schema, "reporterFolderId", String), (0, _defineProperty2["default"])(_mongoose$Schema, "isLiteEnvReport", {
  type: Boolean,
  "default": false
}), (0, _defineProperty2["default"])(_mongoose$Schema, "userId", {
  type: _mongoose["default"].Schema.Types.ObjectId,
  ref: 'User'
}), (0, _defineProperty2["default"])(_mongoose$Schema, "domainId", {
  type: _mongoose["default"].Schema.Types.ObjectId,
  ref: 'Domain'
}), (0, _defineProperty2["default"])(_mongoose$Schema, "companyId", {
  type: _mongoose["default"].Schema.Types.ObjectId,
  ref: 'Company'
}), (0, _defineProperty2["default"])(_mongoose$Schema, "deletedAt", {
  type: Date,
  "default": null
}), (0, _defineProperty2["default"])(_mongoose$Schema, "isBroadcastMail", {
  type: Boolean,
  "default": false
}), (0, _defineProperty2["default"])(_mongoose$Schema, "isBannerInjected", {
  type: Boolean,
  "default": false
}), _mongoose$Schema), {
  timestamps: true
});
reportedMailSchema.index({
  to: 'text',
  from: 'text',
  subject: 'text'
});
reportedMailSchema.index({
  internetMessageId: 'text'
});
var _default = _mongoose["default"].model('ReportedMail', reportedMailSchema);
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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