"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _mongoose = _interopRequireDefault(require("mongoose"));
var similiarEmailsSchema = new _mongoose["default"].Schema({
  to: String,
  name: String,
  from: String,
  subject: String,
  messageId: String,
  internetMessageId: {
    type: String,
    required: true
  },
  threadId: String,
  isTrashed: {
    type: Boolean,
    "default": false
  },
  isDeleted: {
    type: Boolean,
    "default": false
  },
  isErrorWhileMoving: {
    type: Object,
    "default": {
      isError: false,
      message: ''
    }
  },
  folderId: String,
  userId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'User'
  },
  domainId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'Domain'
  },
  companyId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'Company'
  },
  reportedMailId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'ReportedMail'
  },
  deletedAt: {
    type: Date,
    "default": null
  }
}, {
  timestamps: true
});
similiarEmailsSchema.index({
  from: 'text',
  to: 'text'
});
similiarEmailsSchema.index({
  internetMessageId: 'text'
});
var _default = _mongoose["default"].model('SimiliarEmail', similiarEmailsSchema);
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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