"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _mongoose = _interopRequireDefault(require("mongoose"));
var urlSchema = new _mongoose["default"].Schema({
  url: {
    type: String,
    trim: true
  },
  deceptiveStatus: {
    type: String,
    "default": null
  },
  status: {
    type: String,
    "enum": ['NOT SCANNED', 'IN PROGRESS', 'COMPLETED', 'FAILED'],
    "default": 'NOT SCANNED'
  },
  domain: {
    type: Object
  },
  result: {
    type: _mongoose["default"].Schema.Types.Mixed,
    "default": null
  },
  details: {
    type: _mongoose["default"].Schema.Types.Mixed,
    "default": null
  },
  scanId: {
    type: String
  },
  score: {
    type: Number
  },
  companyId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'Company'
  },
  reportedMailId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'ReportedMail'
  },
  whatsappMessageId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'whatsapp'
  }
}, {
  timestamps: true
});
var _default = _mongoose["default"].model('Url', urlSchema);
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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