"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _mongoose = _interopRequireDefault(require("mongoose"));
var userSchema = new _mongoose["default"].Schema({
  name: {
    type: String,
    trim: true
  },
  email: {
    type: String,
    trim: true,
    "default": null,
    lowercase: true
  },
  tacIdentityKey: {
    type: String,
    trim: true,
    "default": null
  },
  userId: {
    type: String
  },
  groups: [{
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'Group'
  }],
  tacGroupId: {
    type: Number,
    "default": null
  },
  domainId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'Domain'
  },
  subDomainGroupId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'SubDomainGroup'
  },
  phoneNumber: {
    type: String
  },
  companyId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'Company'
  },
  isActive: {
    type: Boolean,
    "default": false
  },
  isActiveMessenger: {
    type: Boolean,
    "default": false
  },
  emailType: {
    type: String,
    "default": 'Outlook'
  },
  isADSynced: {
    type: Boolean,
    "default": false
  },
  lastAdSeenAt: {
    type: Date,
    "default": null
  },
  deletedAt: {
    type: Date,
    "default": null
  }
}, {
  timestamps: true
});
userSchema.pre('findOne', function (next) {
  if (this._conditions.email && typeof this._conditions.email === 'string') {
    this._conditions.email = this._conditions.email.toLowerCase();
  }
  next();
});

// Function to sanitize phoneNumber
var sanitizePhoneNumber = function sanitizePhoneNumber(phoneNumber) {
  return phoneNumber ? phoneNumber.replace(/\D/g, '') : phoneNumber;
};

// Remove special characters from phoneNumber before saving
userSchema.pre('save', function (next) {
  if (this.phoneNumber) {
    this.phoneNumber = sanitizePhoneNumber(this.phoneNumber);
  }
  next();
});

// Ensure phoneNumber is sanitized before updating
var updateMiddleware = function updateMiddleware(next) {
  if (this._update && this._update.$set && this._update.$set.phoneNumber) {
    this._update.$set.phoneNumber = sanitizePhoneNumber(this._update.$set.phoneNumber);
  }
  next();
};
userSchema.pre('updateOne', updateMiddleware);
userSchema.pre('updateMany', updateMiddleware);
userSchema.pre('findOneAndUpdate', updateMiddleware);
userSchema.pre('update', updateMiddleware);
userSchema.index({
  name: 'text',
  userId: 1
});
var _default = _mongoose["default"].model('User', userSchema);
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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