"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _mongoose = _interopRequireDefault(require("mongoose"));
var whoElseSchema = new _mongoose["default"].Schema({
  to: String,
  name: String,
  from: String,
  subject: String,
  whoelseMail: String,
  messageId: String,
  internetMessageId: {
    type: String,
    required: true
  },
  threadId: String,
  isTrashed: {
    type: Boolean,
    "default": false
  },
  isDeleted: {
    type: Boolean,
    "default": false
  },
  isErrorWhileMoving: {
    type: Object,
    "default": {
      isError: false,
      message: ''
    }
  },
  folderId: String,
  userId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'User'
  },
  domainId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'Domain'
  },
  companyId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'Company'
  },
  reportedMailId: {
    type: _mongoose["default"].Schema.Types.ObjectId,
    ref: 'ReportedMail'
  },
  deletedAt: {
    type: Date,
    "default": null
  }
}, {
  timestamps: true
});
whoElseSchema.index({
  from: 'text',
  to: 'text'
});
whoElseSchema.index({
  internetMessageId: 'text'
});
var _default = _mongoose["default"].model('WhoElse', whoElseSchema);
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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