"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogTransport = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _winstonTransport = _interopRequireDefault(require("winston-transport"));
var _s3Streamlogger = require("s3-streamlogger");
var _config = _interopRequireDefault(require("../config"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var LogTransport = /*#__PURE__*/function (_Transport) {
  (0, _inherits2["default"])(LogTransport, _Transport);
  var _super = _createSuper(LogTransport);
  function LogTransport(opts) {
    var _this;
    (0, _classCallCheck2["default"])(this, LogTransport);
    _this = _super.call(this, opts);
    _this.availableClientList = {};
    _this.options = opts;
    _this.filename = opts.filename ? _path["default"].basename(opts.filename) : 'winston.log';
    _this.dirname = opts.dirname || _path["default"].dirname(opts.filename);
    if (!_fs["default"].existsSync(_this.dirname)) _fs["default"].mkdirSync(_this.dirname, {
      recursive: true
    });
    if (!_this.isValidFileName(_this.filename) || !_this.isValidDirName(_this.dirname)) {
      throw new Error('Your path or filename contain an invalid character.');
    }
    _this.logStream = _this.generateStream();
    return _this;
  }
  (0, _createClass2["default"])(LogTransport, [{
    key: "isValidFileName",
    value: function isValidFileName(filename) {
      // eslint-disable-next-line no-control-regex
      return !/["<>|:*?\\/\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f]/g.test(filename);
    }
  }, {
    key: "isValidDirName",
    value: function isValidDirName(dirname) {
      // eslint-disable-next-line no-control-regex
      return !/["<>|\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f]/g.test(dirname);
    }
  }, {
    key: "generateStream",
    value: function generateStream(clientId) {
      var streamDir = this.dirname;
      if (clientId) streamDir = _path["default"].join(streamDir, clientId.toString());else streamDir = _path["default"].join(streamDir, 'main');
      return new _s3Streamlogger.S3StreamLogger({
        name_format: 'app-log-%Y-%m-%d-%H-%M.log',
        rotate_every: 60 * 60 * 1000 * 5,
        //5 hours
        upload_every: 1000,
        folder: streamDir,
        bucket: _config["default"].s3.logBucket,
        access_key_id: _config["default"].s3.accessKey,
        secret_access_key: _config["default"].s3.secretAccessKey
      });
    }
  }, {
    key: "getMaxSize",
    value: function getMaxSize(size) {
      if (size && typeof size === 'string') {
        var _s = size.toLowerCase().match(/^((?:0\.)?\d+)([k|m|g])$/);
        if (_s) {
          return size;
        }
      } else if (size && Number.isInteger(size)) {
        var sizeK = Math.round(size / 1024);
        return sizeK === 0 ? '1k' : sizeK + 'k';
      }
      return null;
    }
  }, {
    key: "close",
    value: function close() {
      if (this.logStream) {
        this.logStream.end();
      }
    }
  }, {
    key: "trackEvent",
    value: function () {
      var _trackEvent = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(tracker, event, user, companyIdIn) {
        var companyId;
        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              companyId = companyIdIn;
              if (user) companyId = user.companyId;

              //Validation
              if (!(!companyId || !event)) {
                _context.next = 4;
                break;
              }
              throw new Error('Invalid Event to track');
            case 4:
              //Tell Information about User
              if (user) tracker.people.set(user.id, {
                $first_name: user.firstName,
                $last_name: user.lastName,
                $created: user.createdAt,
                $email: user.email
              });

              //Create Tracking Event
              tracker.track(event, {
                distinct_id: companyId
              });
            case 6:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      function trackEvent(_x, _x2, _x3, _x4) {
        return _trackEvent.apply(this, arguments);
      }
      return trackEvent;
    }()
  }, {
    key: "log",
    value: function () {
      var _log = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(info, callback) {
        var logTime, logObj;
        return _regenerator["default"].wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              _context2.prev = 0;
              if (!info.track) info.track = true;
              logTime = new Date().toLocaleString();
              logObj = {
                timestamp: logTime,
                level: info.level,
                details: {
                  message: info.message
                }
              }; //Track Event
              if (!info.request) {
                _context2.next = 10;
                break;
              }
              logObj.route = info.request.url;
              logObj.ip = info.request.headers['x-forwarded-for'] || info.request.socket.remoteAddress;
              if (!info.track) {
                _context2.next = 10;
                break;
              }
              _context2.next = 10;
              return this.trackEvent(info.request.tracker, info.event, info.request.user, info.client ? info.client : null)["catch"](handleError(true));
            case 10:
              //Generate Customer specific log
              if (info.client) {
                if (!this.availableClientList[info.client]) {
                  this.availableClientList[info.client] = this.generateStream(info.client);
                }
                this.availableClientList[info.client].write("".concat(JSON.stringify(logObj), "\n"));
                logObj.companyId = info.client;
              }

              //Write to common logfile
              this.logStream.write("".concat(JSON.stringify(logObj), "\n"));
              callback();
              _context2.next = 19;
              break;
            case 15:
              _context2.prev = 15;
              _context2.t0 = _context2["catch"](0);
              console.log(_context2.t0);
              callback(_context2.t0);
            case 19:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this, [[0, 15]]);
      }));
      function log(_x5, _x6) {
        return _log.apply(this, arguments);
      }
      return log;
    }()
  }]);
  return LogTransport;
}(_winstonTransport["default"]);
exports.LogTransport = LogTransport;
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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