"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _uaParserJs = _interopRequireDefault(require("ua-parser-js"));
/* parse data for audit logs */
var validateAndParseData = function validateAndParseData(req, activity, newData, oldData) {
  return new Promise(function (resolve, reject) {
    try {
      var _req$user, _req$user2, _req$user3, _req$user4, _req$user5, _req$user6;
      var detail = {};
      detail.user_agent = req.headers['user-agent'];
      detail.systemDetail = (0, _uaParserJs["default"])(req.headers['user-agent']);
      detail.ip = req.headers["x-real-ip"] || req.ip;
      ;
      resolve({
        activity: activity,
        ip: detail.ip,
        newData: newData,
        oldData: oldData,
        firstName: (_req$user = req.user) === null || _req$user === void 0 ? void 0 : _req$user.firstName,
        lastName: (_req$user2 = req.user) === null || _req$user2 === void 0 ? void 0 : _req$user2.lastName,
        userType: (_req$user3 = req.user) === null || _req$user3 === void 0 ? void 0 : _req$user3.type,
        companyId: (_req$user4 = req.user) === null || _req$user4 === void 0 ? void 0 : _req$user4.companyId,
        metadata: JSON.stringify(detail),
        adminId: (req === null || req === void 0 ? void 0 : (_req$user5 = req.user) === null || _req$user5 === void 0 ? void 0 : _req$user5.type) == "root" ? req.user._id : null,
        employeeId: (req === null || req === void 0 ? void 0 : (_req$user6 = req.user) === null || _req$user6 === void 0 ? void 0 : _req$user6.type) == "employee" ? req.user._id : null
      });
    } catch (err) {
      reject(err);
    }
  });
};
var _default = {
  create: function create(req) {
    var activity = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
    var newName = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
    var oldName = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
    try {
      return validateAndParseData(req, activity, newName, oldName).then(function (data) {
        return db.AuditLog.create(data);
      })["catch"](function (err) {
        console.error(err);
      });
    } catch (err) {
      console.error();
    }
  }
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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